/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.run;

import fable.grainspotter.run.GrainSpotterException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InputFile {
    private HashMap<String, String> options;
    public String iniFileName = "";
    public String iniFilePath = "";
    public String gveFileName = "";
    public String gveFilePath = "";
    public String logFileName = "";
    public String logFilePath = "";
    private float deltaOmegaSpecs;
    private int minMeasurementCuts;
    private float minCompletenessCuts;
    private float ttUncertainties;
    private float omegaUncertainties;
    private float etaUncertainties;
    private float stepEuler;
    private float nSigmas;
    private int nHKLs;
    private float minfracg;
    private boolean positionFit = false;
    private int random;
    private int spaceGroup;
    private float minEtatSpecs;
    private float maxEtatSpecs;
    private Vector<float[]> dsRange = new Vector();
    private Vector<float[]> omegaRange = new Vector();
    private Vector<float[]> tthRange = new Vector();
    private Vector<float[]> etaRange = new Vector();
    private float cutsMinUniqueness;
    private boolean ignoreOptionDeltaOmegaSpec = true;
    private boolean ignoreOptionCuts = true;
    private boolean ignoreOptionEuler = true;
    private boolean ignoreOptionUncertainties = true;
    private boolean ignoreOptionNSigma = true;
    private boolean ignoreOptionHKL = true;
    private boolean ignoreOptionMinfracg = true;
    private boolean ignoreOptionRandom = true;
    private Logger logger;

    public InputFile() {
        this.logger = Logger.getLogger(InputFile.class);
    }

    public InputFile(String filename) throws GrainSpotterException {
        this.iniFileName = filename;
        this.options = new HashMap();
        this.setFile(filename);
        this.logger = Logger.getLogger(InputFile.class);
    }

    public void setFile(String filename) {
        int index = filename.lastIndexOf(File.separator);
        if (index >= 0) {
            this.iniFilePath = filename.substring(0, index);
            if (index + 1 < filename.length()) {
                this.iniFileName = filename.substring(index + 1);
            }
        }
    }

    public void setMinMeasurementCuts(int minMeasurementCuts) {
        this.minMeasurementCuts = minMeasurementCuts;
    }

    public void setMinCompletenessCuts(float minCompletenessCuts) {
        this.minCompletenessCuts = minCompletenessCuts;
    }

    public void setTtUncertainties(float ttUncertainties) {
        this.ttUncertainties = ttUncertainties;
    }

    public void setOmegaUncertainties(float omegaUncertainties) {
        this.omegaUncertainties = omegaUncertainties;
    }

    public void setEtaUncertainties(float etaUncertainties) {
        this.etaUncertainties = etaUncertainties;
    }

    public void setStepEuler(float stepEuler) {
        this.stepEuler = stepEuler;
    }

    public void setNSigmas(float sigmas) {
        this.nSigmas = sigmas;
    }

    public void setNHKLs(int ls) {
        this.nHKLs = ls;
    }

    public void setMinfracg(float minfracg) {
        this.minfracg = minfracg;
    }

    public void setRandom(int random) {
        this.random = random;
    }

    public void setSpaceGroup(int spaceGroup) {
        this.spaceGroup = spaceGroup;
    }

    public void setMinEtatSpecs(float minEtatSpecs) {
        this.minEtatSpecs = minEtatSpecs;
    }

    public void setPositionFit(boolean value) {
        this.positionFit = value;
    }

    public void addDsRange(float min, float max) {
        float[] f = new float[]{min, max};
        this.dsRange.add(f);
    }

    public void addOmegaRange(float min, float max) {
        float[] f = new float[]{min, max};
        this.omegaRange.add(f);
    }

    public void addTthRange(float min, float max) {
        float[] f = new float[]{min, max};
        this.tthRange.add(f);
    }

    public void addEtaRange(float min, float max) {
        float[] f = new float[]{min, max};
        this.etaRange.add(f);
    }

    public void setDeltaOmegaSpecs(float omegaSpecs) {
        this.deltaOmegaSpecs = omegaSpecs;
    }

    public void setEtaUncertanties(float uncertanties) {
        this.etaUncertainties = uncertanties;
    }

    public String getIniFileName() {
        return this.iniFileName;
    }

    public String getIniFilePath() {
        return this.iniFilePath;
    }

    public String getGveFileName() {
        return this.gveFileName;
    }

    public String getGveFilePath() {
        return this.gveFilePath;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public float getDeltaOmegaSpecs() {
        return this.deltaOmegaSpecs;
    }

    public int getMinMeasurementCuts() {
        return this.minMeasurementCuts;
    }

    public float getMinCompletenessCuts() {
        return this.minCompletenessCuts;
    }

    public float getTtUncertainties() {
        return this.ttUncertainties;
    }

    public float getOmegaUncertainties() {
        return this.omegaUncertainties;
    }

    public float getEtaUncertainties() {
        return this.etaUncertainties;
    }

    public float getStepEuler() {
        return this.stepEuler;
    }

    public float getNSigmas() {
        return this.nSigmas;
    }

    public int getNHKLs() {
        return this.nHKLs;
    }

    public float getMinfracg() {
        return this.minfracg;
    }

    public boolean isPositionFit() {
        return this.positionFit;
    }

    public int getRandom() {
        return this.random;
    }

    public int getSpaceGroup() {
        return this.spaceGroup;
    }

    public float getMinEtatSpecs() {
        return this.minEtatSpecs;
    }

    public float getMaxEtatSpecs() {
        return this.maxEtatSpecs;
    }

    public Vector<float[]> getDsRange() {
        return this.dsRange;
    }

    public Vector<float[]> getOmegaRange() {
        return this.omegaRange;
    }

    public Vector<float[]> getTthRange() {
        return this.tthRange;
    }

    public Vector<float[]> getEtaRange() {
        return this.etaRange;
    }

    private void writeNewRange(BufferedWriter writer, String label, Vector<float[]> range) throws IOException {
        int index = 0;
        while (index < range.size()) {
            if (range.get(index).length == 2) {
                writer.write(String.valueOf(label) + " " + range.get(index)[0] + " " + range.get(index)[1]);
                writer.newLine();
            }
            ++index;
        }
    }

    public void save() throws GrainSpotterException {
        String file = String.valueOf(this.iniFilePath) + File.separator + this.iniFileName;
        this.writeIniFile(file);
        this.setFile(file);
    }

    public void saveAs(String file) throws GrainSpotterException {
        this.writeIniFile(file);
        this.setFile(file);
    }

    private void writeIniFile(String file) throws GrainSpotterException {
        try {
            String gveFileName;
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write("spacegroup " + this.getSpaceGroup());
            writer.newLine();
            if (this.getTthRange() != null) {
                this.writeNewRange(writer, "tthrange", this.getTthRange());
            }
            if (this.getEtaRange() != null) {
                this.writeNewRange(writer, "etarange", this.getEtaRange());
            }
            if (this.omegaRange != null) {
                this.writeNewRange(writer, "omegarange", this.getOmegaRange());
            }
            if (!this.ignoreOptionDeltaOmegaSpec) {
                writer.write("domega " + this.getDeltaOmegaSpecs());
                writer.newLine();
            }
            if (this.getDsRange() != null) {
                this.writeNewRange(writer, "dsrange", this.getDsRange());
            }
            if ((gveFileName = this.getGveFileName()).equals(this.getIniFilePath())) {
                gveFileName = gveFileName.substring(gveFileName.lastIndexOf(File.separator) + 1);
            }
            String logFileName = this.getLogFileName();
            if (this.getLogFilePath().equals(this.getIniFilePath())) {
                logFileName = logFileName.substring(logFileName.lastIndexOf(File.separator) + 1);
            }
            writer.write("filespecs " + gveFileName + " " + logFileName);
            writer.newLine();
            if (!this.ignoreOptionCuts) {
                writer.write("cuts " + this.getMinMeasurementCuts() + " " + this.getMinCompletenessCuts() + " " + this.getMinMeasurementUniqueness());
                writer.newLine();
            }
            if (!this.ignoreOptionEuler) {
                writer.write("eulerstep " + this.getStepEuler());
                writer.newLine();
            }
            if (!this.ignoreOptionUncertainties) {
                writer.write("uncertainties " + this.getTtUncertainties() + " " + this.getEtaUncertainties() + " " + this.getOmegaUncertainties());
                writer.newLine();
            }
            if (!this.ignoreOptionNSigma) {
                writer.write("nsigmas " + this.getNSigmas());
                writer.newLine();
            }
            if (!this.ignoreOptionMinfracg) {
                writer.write("minfracg " + this.getMinfracg());
                writer.newLine();
            }
            if (!this.ignoreOptionHKL) {
                writer.write("Nhkls_in_indexing " + this.getNHKLs());
                writer.newLine();
            }
            if (!this.ignoreOptionRandom) {
                writer.write("random " + this.getRandom());
                writer.newLine();
            }
            if (this.isPositionFit()) {
                writer.write("positionfit");
                writer.newLine();
            }
            writer.close();
        }
        catch (FileNotFoundException e) {
            this.manageError("writeIniFile()", e.getMessage());
        }
        catch (IOException e) {
            this.manageError("writeIniFile()", e.getMessage());
        }
    }

    public void parseIniFile(String txt, boolean parseDynamic) throws GrainSpotterException {
        block13: {
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    File f = new File(txt);
                    reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                    while ((line = reader.readLine()) != null) {
                        String[] split = line.split("\\p{Space}");
                        if (split.length <= 0) continue;
                        String val = line.substring(split[0].length());
                        this.options.put(split[0], val);
                    }
                }
                catch (IOException e) {
                    this.manageError("parseIniFile()", e.getMessage());
                    if (reader == null) break block13;
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        this.manageError("parseIniFile()", ioe.getMessage());
                    }
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        this.manageError("parseIniFile()", ioe.getMessage());
                    }
                }
            }
        }
    }

    public void parseIniFile(String txt) throws GrainSpotterException {
        block27: {
            BufferedReader reader = null;
            String pattern_spaceGroup = "^spacegroup.*";
            String pattern_EtaSpec = "^etarange.*";
            String pattern_DOmega = "^domega.*";
            String pattern_OmegaSpecs = "^omegarange.*";
            String pattern_dataSpecs = "^filespecs.*";
            String pattern_cuts = "^cuts.*";
            String pattern_euler = "^eulerstep.*";
            String pattern_uncert = "^uncertainties.*";
            String pattern_nSigmas = "^nsigmas.*";
            String pattern_nHKLs = "^Nhkls_in_indexing.*";
            String pattern_tthRange = "^tthrange.*";
            String pattern_minFracg = "^minfracg.*";
            String pattern_dsRange = "^dsrange.*";
            String pattern_positionFit = "^positionfit.*";
            String pattern_random = "^random.*";
            try {
                try {
                    String line;
                    File f = new File(txt);
                    reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                    while ((line = reader.readLine()) != null) {
                        if (line.matches(pattern_spaceGroup)) {
                            this.extractSpaceGroup(line);
                            continue;
                        }
                        if (line.matches(pattern_EtaSpec)) {
                            this.extractEtaRange(line);
                            continue;
                        }
                        if (line.matches(pattern_DOmega)) {
                            this.extractDOmega(line);
                            this.ignoreOptionDeltaOmegaSpec = false;
                            continue;
                        }
                        if (line.matches(pattern_OmegaSpecs)) {
                            this.extractOmegaRange(line);
                            continue;
                        }
                        if (line.matches(pattern_dataSpecs)) {
                            this.extractDataSpecs(line);
                            continue;
                        }
                        if (line.matches(pattern_cuts)) {
                            this.extractCuts(line);
                            this.ignoreOptionCuts = false;
                            continue;
                        }
                        if (line.matches(pattern_euler)) {
                            this.extractStepEuler(line);
                            this.ignoreOptionEuler = false;
                            continue;
                        }
                        if (line.matches(pattern_uncert)) {
                            this.extractUncertanties(line);
                            this.ignoreOptionUncertainties = false;
                            continue;
                        }
                        if (line.matches(pattern_nSigmas)) {
                            this.extractNSigmas(line);
                            this.ignoreOptionNSigma = false;
                            continue;
                        }
                        if (line.matches(pattern_tthRange)) {
                            this.extractthRange(line);
                            continue;
                        }
                        if (line.matches(pattern_minFracg)) {
                            this.extractMinFracg(line);
                            this.ignoreOptionMinfracg = false;
                            continue;
                        }
                        if (line.matches(pattern_positionFit)) {
                            this.extractPositionFit(true);
                            continue;
                        }
                        if (line.matches(pattern_dsRange)) {
                            this.extractdsRange(line);
                            continue;
                        }
                        if (line.matches(pattern_nHKLs)) {
                            this.extractHKLS(line);
                            this.ignoreOptionHKL = false;
                            continue;
                        }
                        if (!line.matches(pattern_random)) continue;
                        this.extractRandom(line);
                        this.ignoreOptionRandom = false;
                    }
                }
                catch (IOException iOException) {
                    this.manageError("parseIniFile()", "Error while opening or reading ini file " + txt);
                    if (reader == null) break block27;
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        this.manageError("parseIniFile()", ioe.getMessage());
                    }
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        this.manageError("parseIniFile()", ioe.getMessage());
                    }
                }
            }
        }
    }

    private void manageError(String string, String string2) throws GrainSpotterException {
        this.logger.error((Object)string2);
        throw new GrainSpotterException(0, this.getClass().getName(), string, string2);
    }

    public void extractSpaceGroup(String line) {
        String[] split = line.split("\\p{Space}");
        if (split.length >= 2) {
            try {
                this.setSpaceGroup(Integer.valueOf(split[1]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractDataSpecs(String line) {
        String[] split = line.split("\\p{Space}");
        if (split.length >= 3) {
            this.setGveFileName(split[1]);
            this.setLogFileName(split[2]);
        }
    }

    public void setLogFileName(String string) {
        this.logFileName = string;
    }

    public void setGveFileName(String string) {
        this.gveFileName = string;
    }

    public void extractDOmega(String line) {
        String[] split = line.split("\\p{Space}");
        if (split.length >= 2) {
            try {
                this.setDeltaOmegaSpecs(Float.parseFloat(split[1]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractCuts(String line) {
        String[] split = line.split("\\p{Space}");
        if (split.length >= 3) {
            try {
                this.setMinMeasurementCuts(Integer.parseInt(split[1]));
                this.setMinCompletenessCuts(Float.parseFloat(split[2]));
                this.setMinMeasurementUniqueness(Float.parseFloat(split[3]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractStepEuler(String line) {
        String[] split = line.split("\\p{Space}");
        if (split.length >= 2) {
            try {
                this.setStepEuler(Float.parseFloat(split[1]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractUncertanties(String line) {
        String[] split = line.split("\\p{Space}");
        if (split.length >= 4) {
            try {
                this.setTtUncertainties(Float.parseFloat(split[1]));
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                this.setEtaUncertainties(Float.parseFloat(split[2]));
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                this.setOmegaUncertainties(Float.parseFloat(split[3]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractNSigmas(String line) {
        String[] split = line.split("\\p{Space}");
        if (split.length >= 2) {
            try {
                this.setNSigmas(Float.parseFloat(split[1]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractHKLS(String line) {
        String[] split = line.split("\\p{Space}");
        if (split.length >= 2) {
            try {
                this.setNHKLs(Integer.parseInt(split[1]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractthRange(String line) {
        String[] split = line.split("\\p{Space}");
        if (split.length >= 3) {
            try {
                this.addTthRange(Float.valueOf(split[1]).floatValue(), Float.valueOf(split[2]).floatValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractMinFracg(String line) {
        String[] split = line.split("\\p{Space}");
        if (split.length >= 2) {
            try {
                this.setMinfracg(Float.parseFloat(split[1]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractPositionFit(boolean value) {
        this.setPositionFit(value);
    }

    public void extractdsRange(String line) {
        String[] split = line.split("\\p{Space}");
        if (split.length >= 3) {
            try {
                this.addDsRange(Float.parseFloat(split[1]), Float.parseFloat(split[2]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractOmegaRange(String line) {
        String[] split = line.split("\\p{Space}");
        if (split.length >= 3) {
            try {
                this.addOmegaRange(Float.parseFloat(split[1]), Float.parseFloat(split[2]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractTthRange(String line) {
        String[] split = line.split("\\p{Space}");
        if (split.length >= 3) {
            try {
                this.addTthRange(Float.parseFloat(split[1]), Float.parseFloat(split[2]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractEtaRange(String line) {
        String[] split = line.split("\\p{Space}");
        if (split.length >= 3) {
            try {
                this.addEtaRange(Float.parseFloat(split[1]), Float.parseFloat(split[2]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void extractRandom(String line) {
        String[] split = line.split("\\p{Space}");
        if (split.length >= 2) {
            try {
                this.setRandom(Integer.parseInt(split[1]));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void set_deltaOmegaSpecs(String omegaSpecs) throws GrainSpotterException {
        try {
            this.setDeltaOmegaSpecs(Float.valueOf(omegaSpecs).floatValue());
        }
        catch (NumberFormatException e) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_deltaOmegaSpecs", e.getMessage());
        }
    }

    public void set_etaUncertanties(String str) throws GrainSpotterException {
        try {
            this.setEtaUncertanties(Float.valueOf(str).floatValue());
        }
        catch (NumberFormatException e) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_etaUncertanties", e.getMessage());
        }
    }

    public void setMaxEtatSpecs(float etatSpecs) throws GrainSpotterException {
        if (!(etatSpecs >= 0.0f) || !(etatSpecs <= 360.0f)) {
            throw new GrainSpotterException(GrainSpotterException.INVALIDE_VALUE, this.getClass().getName(), "set_maxEtatSpecs", "Max EtatSpecs out of range");
        }
        this.maxEtatSpecs = etatSpecs;
    }

    public HashMap<String, String> getOptions() {
        return this.options;
    }

    public float getMinMeasurementUniqueness() {
        return this.cutsMinUniqueness;
    }

    public void setMinMeasurementUniqueness(float f) {
        this.cutsMinUniqueness = f;
    }

    public void set_minCompletenessCuts(float completenessCuts) throws GrainSpotterException {
        if (!((double)completenessCuts >= 0.0) || !((double)completenessCuts <= 1.0)) {
            throw new GrainSpotterException(GrainSpotterException.INVALIDE_VALUE, this.getClass().getName(), "set_minCompletenessCuts", "min completness value out of range");
        }
        this.setMinCompletenessCuts(completenessCuts);
    }

    public void set_minEtatSpecs(float etatSpecs) throws GrainSpotterException {
        if (!(etatSpecs >= 0.0f) || !(etatSpecs <= 360.0f)) {
            throw new GrainSpotterException(GrainSpotterException.INVALIDE_VALUE, this.getClass().getName(), "set_minEtatSpecs", "min EtatSpecs out of range");
        }
        this.setMinEtatSpecs(etatSpecs);
    }

    public void set_minEtatSpecs(String str) throws GrainSpotterException {
        try {
            this.set_minEtatSpecs(Float.valueOf(str).floatValue());
        }
        catch (NumberFormatException e) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_minEtatSpecs", e.getMessage());
        }
    }

    public void setMinMeasurementUniqueness(String str) throws GrainSpotterException {
        try {
            this.setMinMeasurementUniqueness(Float.valueOf(str).floatValue());
        }
        catch (NumberFormatException e) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "setMinMeasurementUniqueness", e.getMessage());
        }
    }

    public void set_minMeasurementCuts(int measurementCuts) {
        this.setMinMeasurementCuts(measurementCuts);
    }

    public void set_minMeasurementCuts(String str) throws GrainSpotterException {
        try {
            this.set_minMeasurementCuts(Integer.valueOf(str));
        }
        catch (NumberFormatException e) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_minMeasurementCuts", e.getMessage());
        }
    }

    public void set_omegaUncertanties(float uncertanties) {
        this.setOmegaUncertainties(uncertanties);
    }

    public void set_omegaUncertanties(String str) throws GrainSpotterException {
        try {
            this.set_omegaUncertanties(Float.valueOf(str).floatValue());
        }
        catch (NumberFormatException e) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_omegaUncertanties", e.getMessage());
        }
    }

    public void set_spaceGroup(int group) throws GrainSpotterException {
        if (group < 1 || group > 230) {
            throw new GrainSpotterException(GrainSpotterException.INVALIDE_VALUE, this.getClass().getName(), "set_spaceGroup", "Invalid value for spaceGroup");
        }
        this.setSpaceGroup(group);
    }

    public void set_ttUncertanties(float uncertanties) {
        this.setTtUncertainties(uncertanties);
    }

    public void set_ttUncertanties(String str) throws GrainSpotterException {
        try {
            this.set_ttUncertanties(Float.valueOf(str).floatValue());
        }
        catch (NumberFormatException e) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_ttUncertanties", e.getMessage());
        }
    }

    public void set_stepEuler(float euler) {
        this.setStepEuler(euler);
    }

    public void set_stepEuler(String str) throws GrainSpotterException {
        try {
            this.set_stepEuler(Float.valueOf(str).floatValue());
        }
        catch (NumberFormatException e) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_stepEuler", e.getMessage());
        }
    }

    private void set_nHKLs(int ls) {
        this.setNHKLs(ls);
    }

    public void set_nHKLs(String str) throws GrainSpotterException {
        try {
            this.set_nHKLs(Integer.valueOf(str));
        }
        catch (NumberFormatException e) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_nHKLs", e.getMessage());
        }
    }

    public void set_nSigmas(float sigmas) {
        this.setNSigmas(sigmas);
    }

    public void set_nSigmas(String str) throws GrainSpotterException {
        try {
            this.set_nSigmas(Float.valueOf(str).floatValue());
        }
        catch (NumberFormatException e) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_nSigmas", e.getMessage());
        }
    }

    public void set_maxEtatSpecs(String str) throws GrainSpotterException {
        try {
            this.setMaxEtatSpecs(Float.valueOf(str).floatValue());
        }
        catch (NumberFormatException e) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_maxEtatSpecs", e.getMessage());
        }
    }

    public void set_minCompletenessCuts(String str) throws GrainSpotterException {
        try {
            this.set_minCompletenessCuts(Float.valueOf(str).floatValue());
        }
        catch (NumberFormatException e) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "set_minCompletenessCuts", e.getMessage());
        }
    }

    public void addOmegaRange(String min, String max) throws GrainSpotterException {
        try {
            this.addOmegaRange(Float.valueOf(min).floatValue(), Float.valueOf(max).floatValue());
        }
        catch (NumberFormatException n) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "addOmegaRange", n.getMessage());
        }
    }

    public void addEtaRange(String min, String max) throws GrainSpotterException {
        try {
            this.addEtaRange(Float.valueOf(min).floatValue(), Float.valueOf(max).floatValue());
        }
        catch (NumberFormatException n) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "addOmegaRange", n.getMessage());
        }
    }

    public void addtthRange(String min, String max) throws GrainSpotterException {
        try {
            this.addTthRange(Float.valueOf(min).floatValue(), Float.valueOf(max).floatValue());
        }
        catch (NumberFormatException n) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "addOmegaRange", n.getMessage());
        }
    }

    public void addDsRange(String min, String max) throws GrainSpotterException {
        try {
            this.addDsRange(Float.valueOf(min).floatValue(), Float.valueOf(max).floatValue());
        }
        catch (NumberFormatException n) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "addOmegaRange", n.getMessage());
        }
    }

    public void ignoreOptionDeltaOmegaSpecs(boolean b) {
        this.ignoreOptionDeltaOmegaSpec = b;
    }

    public void ignoreOptionCuts(boolean b) {
        this.ignoreOptionCuts = b;
    }

    public void ignoreOptionEuler(boolean b) {
        this.ignoreOptionEuler = b;
    }

    public void ignoreOptionUncertainties(boolean b) {
        this.ignoreOptionUncertainties = b;
    }

    public void ignoreOptionNSigma(boolean b) {
        this.ignoreOptionNSigma = b;
    }

    public void ignoreOptionHKL(boolean b) {
        this.ignoreOptionHKL = b;
    }

    public void ignoreOptionMinfracg(boolean b) {
        this.ignoreOptionMinfracg = b;
    }

    public void ignoreOptionRandom(boolean b) {
        this.ignoreOptionRandom = b;
    }

    public void setMinfracg(String text) throws GrainSpotterException {
        try {
            this.setMinfracg(Float.valueOf(text).floatValue());
        }
        catch (NumberFormatException n) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "setMinfracg", n.getMessage());
        }
    }

    public void setRandom(String text) throws GrainSpotterException {
        try {
            this.setRandom(Integer.valueOf(text));
        }
        catch (NumberFormatException n) {
            throw new GrainSpotterException(GrainSpotterException.NUMBERFORMAT_EXCEPTION, this.getClass().getName(), "addOmegaRange", n.getMessage());
        }
    }

    public boolean isIgnoreOptionDeltaOmegaSpec() {
        return this.ignoreOptionDeltaOmegaSpec;
    }

    public boolean isIgnoreOptionEuler() {
        return this.ignoreOptionEuler;
    }

    public boolean isIgnoreOptionUncertainties() {
        return this.ignoreOptionUncertainties;
    }

    public boolean isIgnoreOptionNSigma() {
        return this.ignoreOptionNSigma;
    }

    public boolean isIgnoreOptionHKL() {
        return this.ignoreOptionHKL;
    }

    public boolean isIgnoreOptionMinfracg() {
        return this.ignoreOptionMinfracg;
    }

    public boolean isIgnoreOptionRandom() {
        return this.ignoreOptionRandom;
    }

    public boolean isIgnoreOptionCuts() {
        return this.ignoreOptionCuts;
    }

    public void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }
}

