/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.run;

import fable.framework.toolbox.ToolBox;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.editors.GrainspotterIniInput;
import fable.grainspotter.rcp.Activator;
import fable.grainspotter.run.LogFile;
import fable.grainspotter.view.OutputView;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ErrorViewPart;

public class GrainSpotter {
    private GrainspotterIniInput input;
    private String grainspotterCommand = "GrainSpotter";
    private String grainspotterPath = ".";
    private GrainSpotterThread grainspotterThread;
    private Process grainspotterProcess;
    public ArrayList<double[]> gveXYZ = new ArrayList();
    private static GrainSpotter grainspotter;
    public ArrayList<int[]> grainGvectors = new ArrayList();
    private Runtime runtime;
    private String pathSeparator = System.getProperty("file.separator");
    ArrayList<IPropertyChangeListener> myListeners = new ArrayList();
    protected IProgressMonitor grainspotterMonitor;
    private String gvectorFile;
    IPropertyChangeListener preferencesListener;
    private LogFile logFile;

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.myListeners.remove(listener);
    }

    private GrainSpotter() {
        this.grainspotterThread = new GrainSpotterThread();
        this.preferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("pref_cmd_grainspotter")) {
                    GrainSpotter.this.setGrainspotterCommand(Activator.getDefault().getPreferenceStore().getString("pref_cmd_grainspotter"));
                }
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferencesListener);
        this.setGrainspotterCommand(Activator.getDefault().getPreferenceStore().getString("pref_cmd_grainspotter"));
    }

    public void dispose() {
        if (grainspotter != null) {
            this.myListeners.removeAll(this.myListeners);
        }
        if (Activator.getDefault() != null && Activator.getDefault().getPreferenceStore() != null && grainspotter != null) {
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferencesListener);
            grainspotter = null;
        }
    }

    public void run() {
        this.fireStateChange("running");
        Job job = new Job("Running GrainSpotter " + this.input.getInputFile().iniFileName){

            protected IStatus run(IProgressMonitor monitor) {
                GrainSpotter.this.grainspotterMonitor = monitor;
                GrainSpotter.this.grainspotterMonitor.beginTask("Running GrainSpotter " + ((GrainSpotter)GrainSpotter.this).input.getInputFile().iniFileName + " ... ", 100);
                GrainSpotter.this.grainspotterMonitor.subTask("Building lookuptables");
                GrainSpotter.this.grainspotterMonitor.worked(1);
                GrainSpotter.this.grainspotterThread.run();
                GrainSpotter.this.grainspotterMonitor.done();
                GrainSpotter.this.fireStateChange("running");
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public void stop() {
        this.fireStateChange("stopped");
        this.grainspotterProcess.destroy();
        final Cursor arrowCursor = new Cursor((Device)Display.getDefault(), 0);
        if (!Display.getDefault().isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    activeWindow.getShell().setCursor(arrowCursor);
                }
            });
        }
    }

    public void fireStateChange(String _change) {
        for (IPropertyChangeListener element : this.myListeners) {
            element.propertyChange(new PropertyChangeEvent((Object)this, "grainspotter", null, (Object)_change));
        }
    }

    public boolean gsCommandCanRun() {
        Runtime runtime = Runtime.getRuntime();
        try {
            runtime.exec(this.grainspotterCommand);
        }
        catch (IOException iOException) {
            FableMessageConsole.console.displayError("Failed to execute the GrainSpotter command = " + this.grainspotterCommand + " !");
            FableMessageConsole.console.displayError("Check the path is correct and you have the right (execute) permissions");
            return false;
        }
        return true;
    }

    public String[] makeGSBatchCommand() {
        String[] gsRunCommand = new String[3];
        String os = System.getProperty("os.name");
        File gsCommandFile = new File(this.grainspotterCommand);
        if (!gsCommandFile.exists()) {
            FableMessageConsole.console.displayError("The GrainSpotter command = " + this.grainspotterCommand + ", does not exist !");
            FableMessageConsole.console.displayError("Check the path is correct and the command exists (hint: use Edit -> Preferences to select the grainspotter command");
            return null;
        }
        try {
            if (os.toLowerCase().contains("windows")) {
                BufferedWriter gsBatch = new BufferedWriter(new FileWriter(String.valueOf(this.input.getInputFile().iniFilePath) + "/gs.bat"));
                if (this.input.getInputFile().iniFilePath.length() >= 2) {
                    gsBatch.write(this.input.getInputFile().iniFilePath.substring(0, 2));
                }
                gsBatch.newLine();
                gsBatch.write("cd \"" + this.input.getInputFile().iniFilePath + "\"");
                gsBatch.newLine();
                gsBatch.write("\"" + this.grainspotterCommand + "\" " + this.input.getInputFile().iniFileName);
                gsBatch.close();
                gsRunCommand[0] = "cmd.exe";
                gsRunCommand[1] = "/C";
                gsRunCommand[2] = String.valueOf(this.input.getInputFile().iniFilePath) + "/gs.bat";
            } else {
                BufferedWriter gsBatch = new BufferedWriter(new FileWriter(String.valueOf(this.input.getInputFile().iniFilePath) + "/gs.bash"));
                gsBatch.write("cd \"" + this.input.getInputFile().iniFilePath + "\"");
                gsBatch.newLine();
                gsBatch.write("\"" + this.grainspotterCommand + "\" " + this.input.getInputFile().iniFileName);
                gsBatch.close();
                gsRunCommand[0] = "/bin/bash";
                gsRunCommand[1] = String.valueOf(this.input.getInputFile().iniFilePath) + "/gs.bash";
                gsRunCommand[2] = " ";
            }
        }
        catch (IOException iOException) {
            FableMessageConsole.console.displayError("Failed to create grainspotter batch file in directory : " + this.input.getInputFile().iniFilePath);
            FableMessageConsole.console.displayError("Check the path is correct and you have the right (write) permissions");
            return null;
        }
        return gsRunCommand;
    }

    public String getGrainspotterCommand() {
        return this.grainspotterCommand;
    }

    public void setGrainspotterCommand(String grainspotterCommand) {
        this.grainspotterCommand = grainspotterCommand;
    }

    public void setgVectorFile(String fileName) {
        this.gvectorFile = fileName;
        this.fireNewGveFileToParse();
    }

    private void fireNewGveFileToParse() {
        for (IPropertyChangeListener element : this.myListeners) {
            element.propertyChange(new PropertyChangeEvent((Object)this, "new gve file", null, (Object)this.getGveFilePath()));
        }
    }

    public String getGrainspotterPath() {
        return this.grainspotterPath;
    }

    public void setGrainspotterPath(String grainspotterPath) {
        this.grainspotterPath = grainspotterPath;
    }

    public String getIniFilePath() {
        return this.input.getInputFile().iniFilePath;
    }

    public void setIniFilePath(String iniFilePath) {
        this.input.getInputFile().iniFilePath = iniFilePath;
        if (this.input.getInputFile().gveFilePath.equals("")) {
            this.setGveFilePath(iniFilePath);
        }
        if (this.input.getInputFile().logFilePath.equals("")) {
            this.setLogFilePath(iniFilePath);
        }
    }

    public String getGveFilePath() {
        return this.input.getInputFile().gveFilePath;
    }

    public void setGveFilePath(String gveFilePath) {
        this.input.getInputFile().gveFilePath = gveFilePath;
    }

    public String getLogFilePath() {
        return this.input.getInputFile().logFilePath;
    }

    public void setLogFilePath(String logFilePath) {
        this.input.getInputFile().logFilePath = logFilePath;
        this.setLogFile(new LogFile(logFilePath));
    }

    private void fireLogFileHasBeenSet() {
        for (IPropertyChangeListener element : this.myListeners) {
            element.propertyChange(new PropertyChangeEvent((Object)this, "new log file", null, (Object)this.getLogFile()));
        }
    }

    public String getIniFileName() {
        return String.valueOf(this.input.getInputFile().iniFilePath) + this.pathSeparator + this.input.getInputFile().iniFileName;
    }

    public void setIniFileName(String _iniFileName) {
        if (_iniFileName.indexOf(this.pathSeparator) >= 0) {
            this.input.getInputFile().iniFilePath = _iniFileName.substring(_iniFileName.lastIndexOf(this.pathSeparator) + 1);
            this.input.getInputFile().iniFilePath = _iniFileName.substring(0, _iniFileName.lastIndexOf(this.pathSeparator) + 1);
        } else {
            this.input.getInputFile().iniFileName = _iniFileName;
        }
    }

    public void setLogFileName(String _logFileName) {
        if (_logFileName.indexOf(this.pathSeparator) >= 0) {
            this.input.getInputFile().logFileName = _logFileName.substring(_logFileName.lastIndexOf(this.pathSeparator) + 1);
            this.input.getInputFile().logFilePath = _logFileName.substring(0, _logFileName.lastIndexOf(this.pathSeparator));
        } else {
            this.input.getInputFile().logFilePath = this.input.getInputFile().iniFilePath;
            this.input.getInputFile().logFileName = _logFileName;
        }
    }

    public String getLogFileName() {
        if (this.input.getInputFile().logFilePath.equals("")) {
            this.setLogFilePath(this.input.getInputFile().iniFilePath);
        }
        return String.valueOf(this.input.getInputFile().logFilePath) + this.pathSeparator + this.input.getInputFile().logFileName;
    }

    public static GrainSpotter getInstance() {
        if (grainspotter == null) {
            grainspotter = new GrainSpotter();
        }
        return grainspotter;
    }

    public GrainspotterIniInput getInput() {
        return this.input;
    }

    public void setInput(IEditorInput input2) {
        this.input = (GrainspotterIniInput)input2;
    }

    public void setLogFile(LogFile f) {
        this.logFile = f;
        this.fireLogFileHasBeenSet();
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    public ArrayList<double[]> getGveXYZ() {
        return this.gveXYZ;
    }

    public void setGveXYZ(ArrayList<double[]> gveXYZ) {
        this.gveXYZ = gveXYZ;
    }

    class GrainSpotterThread
    implements Runnable {
        String outputMessage;
        private StreamReaderThread outThread;
        private StreamReaderThread errThread;

        GrainSpotterThread() {
        }

        @Override
        public void run() {
            boolean grainspotterRan;
            block7: {
                grainspotterRan = false;
                try {
                    String[] gsRunCommand;
                    GrainSpotter.this.runtime = Runtime.getRuntime();
                    if (GrainSpotter.this.gsCommandCanRun() && (gsRunCommand = GrainSpotter.this.makeGSBatchCommand()) != null) {
                        GrainSpotter.this.grainspotterProcess = GrainSpotter.this.runtime.exec(gsRunCommand);
                        this.outThread = new StreamReaderThread(GrainSpotter.this.grainspotterProcess.getInputStream());
                        this.errThread = new StreamReaderThread(GrainSpotter.this.grainspotterProcess.getErrorStream());
                        this.outThread.start();
                        this.errThread.start();
                        GrainSpotter.this.grainspotterProcess.waitFor();
                        grainspotterRan = true;
                        this.outThread.join();
                        this.errThread.join();
                    }
                    this.outThread.setStopped(true);
                    this.errThread.setStopped(true);
                    GrainSpotter.this.fireStateChange("stopped");
                }
                catch (IOException e) {
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayError(e.getMessage());
                    }
                }
                catch (InterruptedException e) {
                    if (FableMessageConsole.console == null) break block7;
                    FableMessageConsole.console.displayError(e.getMessage());
                }
            }
            if (!Display.getDefault().isDisposed() && grainspotterRan) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Object viewPart = null;
                        try {
                            IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            IWorkbenchPage activePage = activeWindow.getActivePage();
                            activePage.showView("fable.grainspotter.view.outputview");
                        }
                        catch (PartInitException e) {
                            FableMessageConsole.console.displayError("Exception occurred showing OutputView: " + (Object)((Object)e) + "\n" + e.getMessage());
                            e.printStackTrace();
                        }
                        if (viewPart instanceof ErrorViewPart) {
                            FableMessageConsole.console.displayError("Error showing OutputView");
                            return;
                        }
                        String tryFileToLoad = GrainSpotter.this.input.getInputFile().getLogFileName();
                        if (!ToolBox.checkIfFileExists((String)tryFileToLoad)) {
                            String fileSeparator = System.getProperty("file.separator");
                            int index = tryFileToLoad.lastIndexOf(fileSeparator);
                            if (index > 0 && index < tryFileToLoad.length()) {
                                tryFileToLoad = tryFileToLoad.substring(index);
                            }
                            tryFileToLoad = String.valueOf(GrainSpotter.this.input.getInputFile().getIniFilePath()) + fileSeparator + tryFileToLoad;
                        }
                        OutputView.view.loadLogFile(tryFileToLoad);
                        if (((GrainSpotterThread)GrainSpotterThread.this).GrainSpotter.this.grainGvectors.size() <= 0) {
                            FableMessageConsole.console.displayError("No grains found in log file (hint: check the input parameters are right e.g. space group)");
                        }
                    }
                });
            }
            if (!Display.getDefault().isDisposed()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Cursor arrowCursor = new Cursor((Device)Display.getDefault(), 0);
                        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        activeWindow.getShell().setCursor(arrowCursor);
                    }
                });
            }
        }
    }

    public class StreamReaderThread
    extends Thread {
        String outputMessage;
        InputStream inStream;
        private boolean stopped = false;

        public StreamReaderThread(InputStream in) {
            this.inStream = in;
        }

        @Override
        public void run() {
            BufferedReader outputread = new BufferedReader(new InputStreamReader(this.inStream));
            try {
                int percentage = 0;
                int workdone = 0;
                int ngrains_found = 0;
                while ((this.outputMessage = outputread.readLine()) != null) {
                    if (this.outputMessage.indexOf("ngrain") != -1) {
                        ++ngrains_found;
                    }
                    if (this.outputMessage.indexOf("completed") != -1 && GrainSpotter.this.grainspotterMonitor != null) {
                        int percentageIndex = this.outputMessage.indexOf("%");
                        String percentageString = this.outputMessage.charAt(percentageIndex - 2) == ' ' ? this.outputMessage.substring(percentageIndex - 1, percentageIndex) : this.outputMessage.substring(percentageIndex - 2, percentageIndex);
                        percentage = Integer.parseInt(percentageString);
                        GrainSpotter.this.grainspotterMonitor.subTask("Looking for grains - " + ngrains_found + " grains found so far");
                        GrainSpotter.this.grainspotterMonitor.worked(percentage - workdone);
                        workdone = percentage;
                    }
                    if (Display.getDefault().isDisposed()) continue;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            FableMessageConsole.console.displayOut(StreamReaderThread.this.outputMessage);
                        }
                    });
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public void setStopped(boolean stopped) {
            this.stopped = stopped;
        }
    }
}

