/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.actions;

import fable.framework.views.FableMessageConsole;
import fable.grainspotter.editors.GrainspotterInputEditor;
import fable.grainspotter.internal.IVarKeys;
import fable.grainspotter.view.Grains3DView;
import fable.grainspotter.view.OutputView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenLogFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow _window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    private String ID = "fable.grainspotter.actions.RunAction";

    public void init(IWorkbenchWindow arg0) {
        this._window = arg0;
    }

    public OpenLogFileAction() {
        this.setToolTipText("Open log file (.log)");
        this.setText("Open log file (.log)");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
        this.setId(this.ID);
    }

    public void run(IAction arg0) {
        if (this._window != null) {
            this.openLogFileView();
        }
    }

    public void run() {
        if (this._window != null) {
            this.openLogFileView();
        }
    }

    private void openLogFileView() {
        block13: {
            try {
                IWorkbenchPage activePage;
                IWorkbenchWindow activeWindow;
                block12: {
                    try {
                        if (this._window != null) {
                            this._window.getWorkbench().showPerspective("fable.grainspotter.perspective.grainspotterperspective", this._window);
                        }
                    }
                    catch (PartInitException partInitException) {
                        if (FableMessageConsole.console == null) break block12;
                        FableMessageConsole.console.displayError("Grainspotter perspective can not be displayed.");
                    }
                }
                FileDialog fileDlg = new FileDialog(new Shell(), 4096);
                fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_LOG);
                fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_LOG);
                fileDlg.setFilterPath(GrainspotterInputEditor.getInitialDirLog());
                fileDlg.setText("Select an existing log file or enter a new file name");
                String file = fileDlg.open();
                if (file == null) break block13;
                if (!file.endsWith(".log")) {
                    file = String.valueOf(file) + ".log";
                }
                try {
                    activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    activePage = activeWindow.getActivePage();
                    activePage.showView("fable.grainspotter.view.outputview");
                    OutputView.view.loadLogFile(file);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                try {
                    activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    activePage = activeWindow.getActivePage();
                    activePage.showView("fable.grainspotter.grains3dview");
                    int grains = OutputView.view.grainSpotter.grainGvectors.size();
                    Grains3DView.setGrains(grains);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                try {
                    activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    activePage = activeWindow.getActivePage();
                    activePage.showView("fable.grainspotter.view.outputview");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this._window.getShell(), (String)"Error", (String)("Error opening log file:" + e.getMessage()));
            }
        }
    }

    public void selectionChanged(IAction arg0, ISelection arg1) {
    }

    public void dispose() {
    }
}

