'''OpenGL extension SGIS.sharpen_texture

Overview (from the spec)
	
	This extension introduces texture magnification filters that sharpen
	the resulting image by extrapolating from the level 1 image to the
	level 0 image.  Sharpening can be enabled for all color channels, for
	the alpha channel only, or for the red, green, and blue channels only.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/SGIS/sharpen_texture.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_SGIS_sharpen_texture'
GL_LINEAR_SHARPEN_SGIS = constant.Constant( 'GL_LINEAR_SHARPEN_SGIS', 0x80AD )
GL_LINEAR_SHARPEN_ALPHA_SGIS = constant.Constant( 'GL_LINEAR_SHARPEN_ALPHA_SGIS', 0x80AE )
GL_LINEAR_SHARPEN_COLOR_SGIS = constant.Constant( 'GL_LINEAR_SHARPEN_COLOR_SGIS', 0x80AF )
GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS = constant.Constant( 'GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS', 0x80B0 )
glSharpenTexFuncSGIS = platform.createExtensionFunction( 
	'glSharpenTexFuncSGIS', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLsizei, arrays.GLfloatArray,),
	doc = 'glSharpenTexFuncSGIS( GLenum(target), GLsizei(n), GLfloatArray(points) ) -> None',
	argNames = ('target', 'n', 'points',),
)

glGetSharpenTexFuncSGIS = platform.createExtensionFunction( 
	'glGetSharpenTexFuncSGIS', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLfloatArray,),
	doc = 'glGetSharpenTexFuncSGIS( GLenum(target), GLfloatArray(points) ) -> None',
	argNames = ('target', 'points',),
)


def glInitSharpenTextureSGIS():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
