package fable.framework.xmlparser.object;

/**
 * This class defines exception for xml parser.
 * 
 * @author SUCHET
 * 
 */
public class XmlParserException extends Exception {

	/**
	 * This is a unique id for this exception.
	 */
	private int id; // a unique id
	/**
	 * This is the name of the class that is responsible of launching an exception.
	 */
	private String classname; // the name of the class
	/**
	 * This is the name of method where the excpetion is launched.
	 */
	private String method; // the name of the method
	/**
	 * This is a message that explained what kind of exception arrived.
	 */
	private String message; // a detailed message

	/**
	 * @param id an id for this exception. Not well defined fo instance.
	 * @param classname the name of the class that launches the exception.
	 * @param method the name of the method where the exception is launched.
	 * @param message a text explaining the exception.
	 */
	public XmlParserException(int id, String classname, String method,
			String message) {
		super();
		this.setId(id);
		this.setClassname(classname);
		this.setMethod(method);
		this.message = message;

	}

	@Override
	public String getMessage() {

		return message;
	}

	public void setMethod(String method) {
		this.method = method;
	}

	public String getMethod() {
		return method;
	}

	public void setClassname(String classname) {
		this.classname = classname;
	}

	public String getClassname() {
		return classname;
	}

	public void setId(int id) {
		this.id = id;
	}

	public int getId() {
		return id;
	}

}
