/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.FabioFile;
import fable.framework.toolbox.FabioFileException;
import fable.framework.toolbox.Sample;
import fable.framework.toolbox.SampleException;
import fable.imageviewer.rcp.Activator;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public class HeaderPlotView
extends ViewPart
implements IPropertyChangeListener,
IJLChartListener {
    private static final long serialVersionUID = 1L;
    public static HeaderPlotView view;
    public static final String ID = "fable.imageviewer.views.HeaderPlotView";
    HashMap<String, JLDataView> dataToPlot = new HashMap();
    private Logger logger;
    SampleController controller;
    private static Composite swtAwtComponent;
    private static Frame chartFrame;
    private static JApplet chartContainer;
    private JLChart chart;
    private HashMap<Sample, HashMap<JLAxis, ArrayList<JLDataView>>> sampleAndItsData = new HashMap();
    private JLDataView currentdataview;
    private String chartName;
    private String syAxisLabel;
    private String sxAxisLabel;
    static int iDataColor;
    Combo sampleCombo;
    Combo xKeysCombo;
    Combo yKeysCombo;
    Combo y1dataviews;
    Combo y2dataviews;
    public Button plotDiff;
    public Button resetButton;
    public Button removeDataViewY1;
    public Button removeDataViewY2;
    Group grpPlot;
    int currentXIndex = 0;
    int currentYIndex = 0;
    Button y1Button;
    Button y2Button;
    double[] currentXData;
    double[] currentYData;
    private Sample currentSample;
    int[] dataMarkers = new int[]{2, 9, 8, 4, 1, 5};
    static int iDataMarker;
    Color[] dataColors = new Color[]{Color.RED, Color.BLUE, Color.CYAN, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.YELLOW};
    ImageDescriptor img = Activator.imageDescriptorFromPlugin((String)"fable.imageviewer", (String)"images/subtractplot.gif");
    ImageDescriptor imgchartDataviewOptions = Activator.imageDescriptorFromPlugin((String)"fable.imageviewer", (String)"images/graphView.gif");
    Image imagePlotsubtract;
    Image imagePlotsubtractY2;
    Image imageDataViewOptions1;
    Image imageDataViewOptions2;
    ImageDescriptor imgadd = Activator.imageDescriptorFromPlugin((String)"fable.imageviewer", (String)"images/addplot.gif");
    Image imagePlotadd;
    ImageDescriptor imgClear = Activator.imageDescriptorFromPlugin((String)"fable.imageviewer", (String)"images/delete.gif");
    Image imagePlotclear;

    static {
        iDataColor = 0;
        iDataMarker = 0;
    }

    public void createPartControl(Composite parent) {
        Vector vsample;
        view = this;
        this.createHeaderPlot(parent, "Header keys", "X", "Y");
        this.controller = SampleController.getController();
        this.controller.addPropertyChangeListener((IPropertyChangeListener)this);
        this.currentSample = this.controller.getCurrentsample();
        if (this.currentSample != null) {
            this.populateListsKeys();
        }
        if ((vsample = this.controller.getSamples()) != null && vsample.size() > 0) {
            for (Sample s : vsample) {
                this.sampleAndItsData.put(s, null);
            }
        }
        this.populateCombosample();
        this.enableGroupDataViews();
    }

    private void createHeaderPlot(Composite parent, String name, String xLabel, String yLabel) {
        this.chartName = name;
        this.syAxisLabel = yLabel;
        this.sxAxisLabel = xLabel;
        parent.setLayoutData((Object)new GridData());
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true, 1, 6));
        HeaderPlotView.createChartFrame(parent);
        this.createChart();
        this.createOptionsGroup(parent);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() != null) {
                    String value = (String)event.getNewValue();
                    if (event.getProperty().equals("xLabelPreference")) {
                        if (value != null && !value.equals("")) {
                            HeaderPlotView.this.setSxAxisLabel(value);
                        }
                    } else if (event.getProperty().equals("xLabelPreference") && value != null && !value.equals("")) {
                        HeaderPlotView.this.setSyAxisLabel(value);
                    }
                }
            }
        });
    }

    public void createChart() {
        this.chart = new JLChart();
        this.chart.setToolTipText("Zoom: Ctrl + select zone with mouse ");
        this.chart.setHeader(this.chartName);
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.getY1Axis().setName(this.syAxisLabel);
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.getY1Axis().setGridVisible(true);
        this.chart.getY1Axis().setSubGridVisible(true);
        this.chart.getY2Axis().setName(this.syAxisLabel);
        this.chart.getY2Axis().setAutoScale(true);
        this.chart.getY2Axis().setGridVisible(true);
        this.chart.getY2Axis().setSubGridVisible(true);
        this.chart.getXAxis().setName(this.sxAxisLabel);
        this.chart.getXAxis().setGridVisible(true);
        this.chart.getXAxis().setSubGridVisible(true);
        this.chart.getXAxis().setAnnotation(2);
        this.chart.getXAxis().setAutoScale(true);
        chartContainer.add((Component)this.chart);
        this.chart.setJLChartListener((IJLChartListener)this);
    }

    private static void createChartFrame(Composite parent) {
        swtAwtComponent = new Composite(parent, 0x1040000);
        GridData gdlist = new GridData(4, 4, true, true);
        gdlist.verticalSpan = 6;
        gdlist.horizontalSpan = 2;
        swtAwtComponent.setLayout((Layout)new GridLayout());
        swtAwtComponent.setLayoutData((Object)gdlist);
        chartFrame = SWT_AWT.new_Frame((Composite)swtAwtComponent);
        chartContainer = new JApplet();
        chartFrame.add(chartContainer);
    }

    private void createOptionsGroup(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        Composite mainComposite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)mainComposite);
        scrolledComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        mainComposite.setLayoutData((Object)new GridData());
        mainComposite.pack();
        Group groupChartOptions = new Group(mainComposite, 0);
        groupChartOptions.setLayout((Layout)new GridLayout(5, false));
        GridData gridChartOpt = new GridData(4, 4, true, false);
        gridChartOpt.verticalSpan = 1;
        gridChartOpt.horizontalSpan = 1;
        groupChartOptions.setLayoutData((Object)gridChartOpt);
        groupChartOptions.setText("Samples");
        new Label((Composite)groupChartOptions, 0).setText("Samples");
        this.sampleCombo = new Combo((Composite)groupChartOptions, 8);
        this.sampleCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)this.sampleCombo.getLayoutData()).horizontalSpan = 4;
        this.sampleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Combo cbo = (Combo)e.widget;
                String text = cbo.getText();
                if (text != null) {
                    HeaderPlotView.this.currentSample = (Sample)cbo.getData(text);
                }
                HeaderPlotView.this.populateJLDataViews(HeaderPlotView.this.currentSample);
                HeaderPlotView.this.populateListsKeys();
            }
        });
        this.createListsKeys_X((Composite)groupChartOptions);
        this.createListsKeys_Y((Composite)groupChartOptions);
        this.plotDiff = new Button((Composite)groupChartOptions, 32);
        this.plotDiff.setText("Difference");
        this.plotDiff.setToolTipText("plot of the difference between the adjacent values");
        this.plotDiff.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        ((GridData)this.plotDiff.getLayoutData()).horizontalSpan = 1;
        this.plotDiff.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HeaderPlotView.this.repaint();
            }
        });
        this.grpPlot = new Group(mainComposite, 0);
        this.grpPlot.setText("Data");
        this.grpPlot.setLayout((Layout)new GridLayout(5, false));
        GridData gdPlot = new GridData(4, 0x1000000, true, false);
        this.grpPlot.setLayoutData((Object)gdPlot);
        this.y1Button = new Button((Composite)this.grpPlot, 8);
        this.imagePlotadd = this.imgadd.createImage();
        this.y1Button.setImage(this.imagePlotadd);
        this.y1Button.setToolTipText("add next plot to Y1 axis");
        this.y1Button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (HeaderPlotView.this.imagePlotadd != null && !HeaderPlotView.this.imagePlotadd.isDisposed()) {
                    HeaderPlotView.this.imagePlotadd.dispose();
                }
            }
        });
        this.y1Button.setSelection(true);
        this.y1Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HeaderPlotView.this.currentSample == null) {
                    HeaderPlotView.this.currentSample = HeaderPlotView.this.getSelectedSample();
                }
                HeaderPlotView.this.addDataView(HeaderPlotView.this.currentSample, HeaderPlotView.this.y1dataviews, HeaderPlotView.this.chart.getY1Axis());
                HeaderPlotView.this.repaint();
            }
        });
        this.y1dataviews = new Combo((Composite)this.grpPlot, 8);
        GridData gdDataviews = new GridData(4, 0x1000000, true, false);
        gdDataviews.horizontalSpan = 1;
        this.y1dataviews.setLayoutData((Object)gdDataviews);
        this.removeDataViewY1 = new Button((Composite)this.grpPlot, 8);
        this.removeDataViewY1.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.imagePlotsubtract = this.img.createImage();
        this.removeDataViewY1.setToolTipText("Remove from plot");
        this.removeDataViewY1.setImage(this.imagePlotsubtract);
        this.removeDataViewY1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = HeaderPlotView.this.y1dataviews.getSelectionIndex();
                HeaderPlotView.this.currentSample = HeaderPlotView.this.getSelectedSample();
                ArrayList dataviews = HeaderPlotView.this.getJLdataView(HeaderPlotView.this.currentSample, HeaderPlotView.this.chart.getY1Axis());
                if (dataviews != null && index >= 0) {
                    HeaderPlotView.this.removeDataViewFromChart(HeaderPlotView.this.chart.getY1Axis(), (JLDataView)dataviews.get(index));
                    dataviews.remove(index);
                    HeaderPlotView.this.y1dataviews.remove(index);
                    if (iDataMarker > 0) {
                        --iDataMarker;
                    }
                    if (iDataColor > 0) {
                        --iDataColor;
                    }
                }
                if (index < HeaderPlotView.this.y1dataviews.getItemCount()) {
                    HeaderPlotView.this.y1dataviews.select(index);
                } else if (HeaderPlotView.this.y1dataviews.getItemCount() > 0) {
                    HeaderPlotView.this.y1dataviews.select(0);
                }
            }
        });
        this.removeDataViewY1.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (HeaderPlotView.this.imagePlotsubtract != null && !HeaderPlotView.this.imagePlotsubtract.isDisposed()) {
                    HeaderPlotView.this.imagePlotsubtract.dispose();
                }
            }
        });
        Button dataViewOption1 = new Button((Composite)this.grpPlot, 8);
        this.imageDataViewOptions1 = this.imgchartDataviewOptions.createImage();
        dataViewOption1.setToolTipText("Show data view options");
        GridData gdDatabutton1 = new GridData(16384, 0x1000000, true, false);
        gdDatabutton1.horizontalSpan = 2;
        dataViewOption1.setLayoutData((Object)gdDatabutton1);
        dataViewOption1.setImage(this.imageDataViewOptions1);
        dataViewOption1.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (HeaderPlotView.this.imageDataViewOptions1 != null && !HeaderPlotView.this.imageDataViewOptions1.isDisposed()) {
                    HeaderPlotView.this.imageDataViewOptions1.dispose();
                }
            }
        });
        dataViewOption1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = HeaderPlotView.this.y1dataviews.getSelectionIndex();
                HeaderPlotView.this.currentSample = HeaderPlotView.this.getSelectedSample();
                ArrayList dataviews = HeaderPlotView.this.getJLdataView(HeaderPlotView.this.currentSample, HeaderPlotView.this.chart.getY1Axis());
                if (dataviews != null && index >= 0) {
                    final JLDataView dataview = (JLDataView)dataviews.get(index);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HeaderPlotView.this.chart.showDataOptionDialog(dataview);
                        }
                    });
                }
            }
        });
        this.y2Button = new Button((Composite)this.grpPlot, 8);
        this.y2Button.setImage(this.imagePlotadd);
        this.y2Button.setToolTipText("add next plot to Y2 axis");
        this.y2Button.setSelection(false);
        this.y2Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HeaderPlotView.this.currentSample == null) {
                    HeaderPlotView.this.currentSample = HeaderPlotView.this.getSelectedSample();
                }
                HeaderPlotView.this.addDataView(HeaderPlotView.this.currentSample, HeaderPlotView.this.y2dataviews, HeaderPlotView.this.chart.getY2Axis());
                HeaderPlotView.this.repaint();
            }
        });
        this.y2Button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (HeaderPlotView.this.imagePlotadd != null && !HeaderPlotView.this.imagePlotadd.isDisposed()) {
                    HeaderPlotView.this.imagePlotadd.dispose();
                }
            }
        });
        GridData gdDataviews2 = new GridData(4, 0x1000000, true, false);
        gdDataviews2.horizontalSpan = 1;
        this.y2dataviews = new Combo((Composite)this.grpPlot, 8);
        this.y2dataviews.setLayoutData((Object)gdDataviews2);
        this.removeDataViewY2 = new Button((Composite)this.grpPlot, 8);
        this.removeDataViewY2.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.imagePlotsubtractY2 = this.img.createImage();
        this.removeDataViewY2.setToolTipText("Remove from plot");
        this.removeDataViewY2.setImage(this.imagePlotsubtract);
        this.removeDataViewY2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = HeaderPlotView.this.y2dataviews.getSelectionIndex();
                HeaderPlotView.this.currentSample = HeaderPlotView.this.getSelectedSample();
                ArrayList dataviews = HeaderPlotView.this.getJLdataView(HeaderPlotView.this.currentSample, HeaderPlotView.this.chart.getY2Axis());
                if (dataviews != null && index >= 0) {
                    HeaderPlotView.this.removeDataViewFromChart(HeaderPlotView.this.chart.getY2Axis(), (JLDataView)dataviews.get(index));
                    dataviews.remove(index);
                    HeaderPlotView.this.y2dataviews.remove(index);
                    if (iDataMarker > 0) {
                        --iDataMarker;
                    }
                    if (iDataColor > 0) {
                        --iDataColor;
                    }
                }
                if (index < HeaderPlotView.this.y2dataviews.getItemCount()) {
                    HeaderPlotView.this.y2dataviews.select(index);
                } else if (HeaderPlotView.this.y2dataviews.getItemCount() > 0) {
                    HeaderPlotView.this.y2dataviews.select(0);
                }
            }
        });
        this.removeDataViewY2.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (HeaderPlotView.this.imagePlotsubtractY2 != null && !HeaderPlotView.this.imagePlotsubtractY2.isDisposed()) {
                    HeaderPlotView.this.imagePlotsubtractY2.dispose();
                }
            }
        });
        Button dataViewOption2 = new Button((Composite)this.grpPlot, 8);
        dataViewOption2.setToolTipText("Show data view options");
        this.imageDataViewOptions2 = this.imgchartDataviewOptions.createImage();
        dataViewOption2.setImage(this.imageDataViewOptions1);
        dataViewOption2.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (HeaderPlotView.this.imageDataViewOptions2 != null && !HeaderPlotView.this.imageDataViewOptions2.isDisposed()) {
                    HeaderPlotView.this.imageDataViewOptions2.dispose();
                }
            }
        });
        dataViewOption2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        dataViewOption2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = HeaderPlotView.this.y2dataviews.getSelectionIndex();
                HeaderPlotView.this.currentSample = HeaderPlotView.this.getSelectedSample();
                ArrayList dataviews = HeaderPlotView.this.getJLdataView(HeaderPlotView.this.currentSample, HeaderPlotView.this.chart.getY2Axis());
                if (dataviews != null && index >= 0) {
                    final JLDataView dataview = (JLDataView)dataviews.get(index);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HeaderPlotView.this.chart.showDataOptionDialog(dataview);
                        }
                    });
                }
            }
        });
        this.resetButton = new Button((Composite)this.grpPlot, 8);
        GridData gd = new GridData(131072, 0x1000000, false, false);
        gd.verticalSpan = 1;
        this.resetButton.setLayoutData((Object)gd);
        this.imagePlotclear = this.imgClear.createImage();
        this.resetButton.setImage(this.imagePlotclear);
        this.resetButton.setToolTipText("Clear plot");
        this.resetButton.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HeaderPlotView.this.clearAllPlots();
            }
        });
        this.resetButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (HeaderPlotView.this.imagePlotclear != null && !HeaderPlotView.this.imagePlotclear.isDisposed()) {
                    HeaderPlotView.this.imagePlotclear.dispose();
                }
            }
        });
        scrolledComposite.setMinHeight(Display.getDefault().getPrimaryMonitor().getBounds().height);
        scrolledComposite.setMinWidth(Display.getDefault().getPrimaryMonitor().getBounds().width);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setMinSize(mainComposite.computeSize(-1, -1));
    }

    private void createListsKeys_X(Composite parent) {
        new Label(parent, 0).setText("X axis");
        this.xKeysCombo = new Combo(parent, 2560);
        GridData gdlist = new GridData(16384, 2, true, false);
        this.xKeysCombo.setLayoutData((Object)gdlist);
        this.xKeysCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] sel = ((Combo)e.widget).getItems();
                HeaderPlotView.this.currentXIndex = ((Combo)e.widget).getSelectionIndex();
                if (HeaderPlotView.this.currentXIndex < 0) {
                    HeaderPlotView.this.currentXIndex = 0;
                }
                HeaderPlotView.this.sxAxisLabel = sel[HeaderPlotView.this.currentXIndex];
                HeaderPlotView.this.chart.getXAxis().setName(HeaderPlotView.this.sxAxisLabel);
            }
        });
    }

    private void createListsKeys_Y(Composite parent) {
        new Label(parent, 0).setText("Y axis");
        this.yKeysCombo = new Combo(parent, 2560);
        GridData gdlist = new GridData(16384, 2, true, false);
        this.yKeysCombo.setLayoutData((Object)gdlist);
        this.yKeysCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] sel = ((Combo)e.widget).getItems();
                HeaderPlotView.this.currentYIndex = ((Combo)e.widget).getSelectionIndex();
                if (HeaderPlotView.this.currentYIndex < 0) {
                    HeaderPlotView.this.currentYIndex = 1;
                }
                HeaderPlotView.this.syAxisLabel = sel[HeaderPlotView.this.currentYIndex];
            }
        });
    }

    public void setFocus() {
    }

    public void dispose() {
        this.controller.removePropertyChangeListener((IPropertyChangeListener)this);
        iDataMarker = 0;
        iDataColor = 0;
        super.dispose();
    }

    private Sample getSelectedSample() {
        String text = this.sampleCombo.getText();
        return (Sample)this.sampleCombo.getData(text);
    }

    public void setData(Sample sample, JLDataView dataview) {
        try {
            double[] listX = sample.getHeaderValues(this.sxAxisLabel);
            double[] listY = this.plotDiff.getSelection() ? sample.getHeaderValuesDiff(this.syAxisLabel) : sample.getHeaderValues(this.syAxisLabel);
            if (listX != null && listY != null) {
                dataview.setXDataSorted(false);
                dataview.setData(listX, listY);
            }
        }
        catch (SampleException e) {
            e.printStackTrace();
        }
    }

    public void setSyAxisLabel(String syAxisLabel) {
        if (syAxisLabel != null) {
            this.syAxisLabel = syAxisLabel;
            this.selectLabelinYCombo(syAxisLabel);
        }
    }

    public void setSxAxisLabel(String sxAxisLabel) {
        if (sxAxisLabel != null) {
            this.sxAxisLabel = sxAxisLabel;
            this.selectLabelinXCombo(sxAxisLabel);
        }
    }

    public void populateListsKeys() {
        this.xKeysCombo.removeAll();
        this.yKeysCombo.removeAll();
        if (this.currentSample != null) {
            try {
                String[] titles = this.currentSample.getKeys();
                int i = 0;
                while (titles != null && i < titles.length) {
                    String key = titles[i];
                    this.xKeysCombo.add(key);
                    this.yKeysCombo.add(key);
                    ++i;
                }
                this.yKeysCombo.setEnabled(this.yKeysCombo.getItemCount() > 0);
                this.xKeysCombo.setEnabled(this.yKeysCombo.getItemCount() > 0);
                if (this.currentXIndex > this.xKeysCombo.getItemCount()) {
                    this.currentXIndex = 0;
                }
                if (this.currentYIndex > this.yKeysCombo.getItemCount()) {
                    this.currentYIndex = 0;
                }
                if (this.xKeysCombo.getItemCount() > 0) {
                    this.xKeysCombo.select(this.currentXIndex);
                    this.sxAxisLabel = this.xKeysCombo.getItem(this.currentXIndex);
                }
                if (this.yKeysCombo.getItemCount() > 0) {
                    this.yKeysCombo.select(this.currentYIndex);
                    this.syAxisLabel = this.yKeysCombo.getItem(this.currentYIndex);
                }
            }
            catch (SampleException e) {
                this.logger.error((Object)e.getMessage());
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Header plot view", (String)"Fable is unable to load keys for current file");
            }
        }
    }

    private ArrayList<JLDataView> getJLdataView(Sample sample, JLAxis axis) {
        HashMap<JLAxis, ArrayList<JLDataView>> jldataAndAxis = this.sampleAndItsData.get(sample);
        ArrayList<JLDataView> dataview = null;
        if (jldataAndAxis != null) {
            dataview = jldataAndAxis.get(axis);
        }
        return dataview;
    }

    public void clearAllPlots() {
        ArrayList<JLDataView> arrayY2;
        this.chart.removeAll();
        this.currentSample = this.getSelectedSample();
        ArrayList<JLDataView> arrayY1 = this.getJLdataView(this.currentSample, this.chart.getY1Axis());
        if (arrayY1 != null) {
            Iterator<JLDataView> it = arrayY1.iterator();
            while (it.hasNext()) {
                this.chart.getY1Axis().removeDataView(it.next());
            }
            arrayY1.removeAll(arrayY1);
        }
        if ((arrayY2 = this.getJLdataView(this.currentSample, this.chart.getY2Axis())) != null) {
            Iterator<JLDataView> it = arrayY2.iterator();
            while (it.hasNext()) {
                this.chart.getY2Axis().removeDataView(it.next());
            }
            arrayY2.removeAll(arrayY2);
        }
        this.repaint();
        iDataColor = 0;
        iDataMarker = 0;
        this.y1dataviews.removeAll();
        this.y2dataviews.removeAll();
        this.populateJLDataViews(this.currentSample);
    }

    public void addDataView(Sample sample, Combo jlcombo, JLAxis axis) {
        if (!Display.getCurrent().isDisposed() && sample != null) {
            ArrayList<Object> jlDataList;
            JLDataView dataview = new JLDataView();
            dataview.setXDataSorted(false);
            if (this.plotDiff.getSelection()) {
                dataview.setName("Diff: " + sample.get_name() + " :" + this.syAxisLabel + " =f(" + this.sxAxisLabel + ")");
            } else {
                dataview.setName(String.valueOf(sample.get_name()) + " :" + this.syAxisLabel + " =f(" + this.sxAxisLabel + ")");
            }
            axis.setName(this.syAxisLabel);
            this.chart.getXAxis().setName(this.sxAxisLabel);
            this.currentdataview = dataview;
            HashMap<Object, ArrayList<Object>> axisAndData = this.sampleAndItsData.get(sample);
            if (axisAndData == null) {
                axisAndData = new HashMap();
            }
            if ((jlDataList = axisAndData.get(axis)) == null) {
                jlDataList = new ArrayList();
            }
            int indexData = jlDataList.size();
            jlDataList.add(dataview);
            axisAndData.put(axis, jlDataList);
            this.sampleAndItsData.put(sample, axisAndData);
            dataview.setMarkerSize(7);
            dataview.setLineWidth(0);
            dataview.setMarkerColor(this.dataColors[iDataColor]);
            dataview.setMarker(this.dataMarkers[iDataMarker]);
            iDataColor = iDataColor + 1 < this.dataColors.length - 1 ? ++iDataColor : 0;
            iDataMarker = iDataMarker + 1 < this.dataMarkers.length - 1 ? ++iDataMarker : 0;
            axis.addDataView(dataview);
            jlcombo.add(dataview.getName());
            jlcombo.select(indexData);
            this.setData(sample, dataview);
            this.repaint();
        }
    }

    private void removeDataViewFromChart(JLAxis axis, JLDataView dataview) {
        axis.removeDataView(dataview);
        this.repaint();
    }

    public void removeDataViews(Sample s) {
        this.removeJLDataViews(s);
        this.sampleAndItsData.remove(s);
        this.populateCombosample();
        String name = this.sampleCombo.getText();
        if (name != null) {
            this.currentSample = (Sample)this.sampleCombo.getData(name);
            this.populateJLDataViews(this.currentSample);
        }
        this.populateListsKeys();
        this.repaint();
    }

    private void populateCombosample() {
        Set<Sample> sampleAndViews = this.sampleAndItsData.keySet();
        Iterator<Sample> sampleIterator = sampleAndViews.iterator();
        this.sampleCombo.removeAll();
        while (sampleIterator.hasNext()) {
            Sample sampleKey = sampleIterator.next();
            this.sampleCombo.add(sampleKey.get_name());
            this.sampleCombo.setData(sampleKey.get_name(), (Object)sampleKey);
        }
        this.sampleCombo.select(0);
        this.sampleCombo.setEnabled(this.sampleCombo.getItemCount() > 0);
    }

    private void populateJLDataViews(Sample s) {
        this.y1dataviews.removeAll();
        this.y2dataviews.removeAll();
        HashMap<JLAxis, ArrayList<JLDataView>> jldataAndAxis = this.sampleAndItsData.get(s);
        if (jldataAndAxis != null) {
            Set<JLAxis> key_Axis = jldataAndAxis.keySet();
            for (JLAxis axis : key_Axis) {
                String name;
                int j;
                ArrayList<JLDataView> dataview;
                if (axis.equals(this.chart.getY1Axis())) {
                    dataview = jldataAndAxis.get(axis);
                    j = 0;
                    while (dataview != null && j < dataview.size()) {
                        name = dataview.get(j).getName();
                        this.y1dataviews.add(name);
                        ++j;
                    }
                    continue;
                }
                dataview = jldataAndAxis.get(axis);
                j = 0;
                while (dataview != null && j < dataview.size()) {
                    name = dataview.get(j).getName();
                    this.y2dataviews.add(name);
                    ++j;
                }
            }
        }
        if (this.y1dataviews.getItemCount() > 0) {
            this.y1dataviews.select(0);
        }
        if (this.y2dataviews.getItemCount() > 0) {
            this.y2dataviews.select(0);
        }
    }

    private void removeJLDataViews(Sample s) {
        boolean bfound = false;
        Set<Sample> sampleAndViews = this.sampleAndItsData.keySet();
        Iterator<Sample> sampleIterator = sampleAndViews.iterator();
        while (sampleIterator.hasNext() && !bfound) {
            Sample sampleKey = sampleIterator.next();
            if (!sampleKey.equals(s)) continue;
            bfound = true;
            HashMap<JLAxis, ArrayList<JLDataView>> jldataAndAxis = this.sampleAndItsData.get(sampleKey);
            if (jldataAndAxis == null) continue;
            Set<JLAxis> key_Axis = jldataAndAxis.keySet();
            for (JLAxis axis : key_Axis) {
                ArrayList<JLDataView> dataview = jldataAndAxis.get(axis);
                int j = 0;
                while (dataview != null && j < dataview.size()) {
                    axis.removeDataView(dataview.get(j));
                    ++j;
                }
            }
        }
    }

    public void repaint() {
        Dimension chartSize = chartContainer.getSize();
        this.chart.setSize(chartSize);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                chartContainer.repaint();
            }
        });
    }

    private void selectLabelinXCombo(String label) {
        boolean found = false;
        int i = 0;
        i = 0;
        while (this.xKeysCombo != null && !found && i < this.xKeysCombo.getItemCount()) {
            if (this.xKeysCombo.getItems()[i].equals(label)) {
                found = true;
                this.xKeysCombo.select(i);
                this.currentXIndex = i;
                this.xKeysCombo.notifyListeners(13, new Event());
            }
            ++i;
        }
    }

    private void selectLabelinYCombo(String label) {
        boolean found = false;
        int i = 0;
        i = 0;
        while (this.yKeysCombo != null && !found && i < this.yKeysCombo.getItemCount()) {
            if (this.yKeysCombo.getItems()[i].equals(label)) {
                found = true;
                this.yKeysCombo.select(i);
                this.currentYIndex = i;
                this.yKeysCombo.notifyListeners(13, new Event());
            }
            ++i;
        }
    }

    public JLChart getChart() {
        return this.chart;
    }

    public JApplet getChartContainer() {
        return chartContainer;
    }

    public void plotHeaderValues(final String key, final Sample s) throws SampleException {
        final Job job = new Job("Loading file header"){

            protected IStatus run(final IProgressMonitor monitor) {
                monitor.beginTask("Wait while getting values for " + key + " in sample " + s.get_name(), s.getFilteredfiles().size());
                if (s.HasFile()) {
                    int i = 0;
                    Iterator it = s.getFilteredfiles().iterator();
                    while (it.hasNext()) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        final FabioFile f = (FabioFile)it.next();
                        try {
                            if (i >= s.getHeaderValues(key).length) continue;
                            final int j = i++;
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        double[] fillValues = s.getHeaderValues(key);
                                        fillValues[j] = Double.valueOf(f.getValue(key));
                                    }
                                    catch (SampleException e1) {
                                        e1.printStackTrace();
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        monitor.setCanceled(true);
                                    }
                                    catch (FabioFileException fabioFileException) {
                                        monitor.setCanceled(true);
                                    }
                                }
                            });
                            monitor.worked(1);
                        }
                        catch (SampleException e) {
                            e.printStackTrace();
                        }
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        if (s.HasFile()) {
            int size = s.getFilteredfiles().size();
            double[] values = s.getHeaderValues(key);
            job.setUser(true);
            if (values == null || values.length != size) {
                values = new double[size];
                s.addHeaderValues(key, values);
                new Thread(){

                    @Override
                    public void run() {
                        job.schedule();
                        while (job.getResult() == null) {
                            view.showBusy(true);
                        }
                        view.showBusy(false);
                    }
                }.start();
            }
        }
    }

    public String[] clickOnChart(JLChartEvent e) {
        String[] ret = new String[]{String.valueOf(this.sxAxisLabel) + "=" + e.getTransformedXValue(), String.valueOf(this.syAxisLabel) + "=" + e.getTransformedYValue()};
        return ret;
    }

    private void enableGroupDataViews() {
        Control[] children = this.grpPlot.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(this.sampleCombo.getItemCount() > 0);
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getProperty().equals("currentSample")) {
            this.currentSample = this.controller.getCurrentsample();
            this.populateListsKeys();
            this.populateJLDataViews(this.currentSample);
            String[] listSamples = this.sampleCombo.getItems();
            this.sampleCombo.setEnabled(this.sampleCombo.getItemCount() > 0);
            boolean bfound = false;
            int i = 0;
            while (listSamples != null && !bfound && i < listSamples.length) {
                if (listSamples[i].equals(this.currentSample.get_name())) {
                    this.sampleCombo.select(i);
                    bfound = true;
                }
                ++i;
            }
        } else if (evt.getProperty().equals("newSample")) {
            final Sample s = (Sample)evt.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    HeaderPlotView.this.sampleAndItsData.put(s, null);
                    HeaderPlotView.this.populateCombosample();
                    HeaderPlotView.this.populateJLDataViews(s);
                    HeaderPlotView.this.populateListsKeys();
                    HeaderPlotView.this.enableGroupDataViews();
                }
            });
        } else if (evt.getProperty().equals("RemoveSample")) {
            Sample s = (Sample)evt.getNewValue();
            this.removeDataViews(s);
            this.enableGroupDataViews();
        } else if (evt.getProperty().equals("updatePlot")) {
            this.setData(this.currentSample, this.currentdataview);
            this.repaint();
        } else if (evt.getProperty().equals("CurrentFile")) {
            this.populateListsKeys();
        }
    }
}

