/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.internal;

import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class PaletteUtils {
    public static PaletteData makeGrayScalePalette() {
        RGB[] grayscale = new RGB[256];
        int i = 0;
        while (i < 256) {
            grayscale[i] = new RGB(i, i, i);
            ++i;
        }
        return new PaletteData(grayscale);
    }

    public static PaletteData makeColorPalette() {
        RGB[] color = new RGB[256];
        color[0] = new RGB(0, 0, 0);
        int i = 1;
        int j = 0;
        while (j < 3) {
            int k = 1;
            while (k <= 85) {
                color[i] = j == 0 ? new RGB(0, 0, k * 3) : (j == 1 ? new RGB(0, k * 3, 3) : new RGB(k * 3, 0, 0));
                ++i;
                ++k;
            }
            ++j;
        }
        return new PaletteData(color);
    }

    public static PaletteData makeRainbow1Palette() {
        RGB[] rainbow = new RGB[256];
        RGB[] colorVal = new RGB[]{new RGB(200, 0, 250), new RGB(40, 40, 255), new RGB(40, 255, 40), new RGB(250, 250, 0), new RGB(255, 0, 0)};
        double[] colorPos = new double[]{0.0, 0.25, 0.5, 0.75, 1.0};
        int nb = 256;
        int colId = 0;
        int i = 0;
        while (i < nb) {
            double r = (double)i / (double)nb;
            if (colId < colorPos.length - 2 && r >= colorPos[colId + 1]) {
                ++colId;
            }
            double r1 = colorVal[colId].red;
            double g1 = colorVal[colId].green;
            double b1 = colorVal[colId].blue;
            double r2 = colorVal[colId + 1].red;
            double g2 = colorVal[colId + 1].green;
            double b2 = colorVal[colId + 1].blue;
            double rr = (r - colorPos[colId]) / (colorPos[colId + 1] - colorPos[colId]);
            if (rr < 0.0) {
                rr = 0.0;
            }
            if (rr > 1.0) {
                rr = 1.0;
            }
            rainbow[i] = new RGB((int)(r1 + (r2 - r1) * rr), (int)(g1 + (g2 - g1) * rr), (int)(b1 + (b2 - b1) * rr));
            ++i;
        }
        return new PaletteData(rainbow);
    }

    public static PaletteData makeRainbow2Palette() {
        RGB[] rainbow = new RGB[256];
        double nGroups = 5.0;
        double nMembers = 45.0;
        double nTotal = nGroups * nMembers;
        double high = 1.0;
        double medium = 0.375;
        int nColors = 256;
        int index = 0;
        while (index < 256) {
            int blue;
            int green;
            double b;
            double g;
            double r;
            double h = (double)index / (double)nColors;
            double hx = h * nTotal;
            double deltax = (high - medium) / nMembers;
            int gh = (int)Math.floor(hx / nMembers);
            int ih = (int)Math.floor(hx);
            switch (gh) {
                case 0: {
                    r = medium;
                    g = medium + ((double)ih - (double)gh * nMembers) * deltax;
                    b = high;
                    break;
                }
                case 1: {
                    r = medium;
                    g = high;
                    b = high - ((double)ih - (double)gh * nMembers) * deltax;
                    break;
                }
                case 2: {
                    r = medium + ((double)ih - (double)gh * nMembers) * deltax;
                    g = high;
                    b = medium;
                    break;
                }
                case 3: {
                    r = high;
                    g = high - ((double)ih - (double)gh * nMembers) * deltax;
                    b = medium;
                    break;
                }
                case 4: {
                    r = high;
                    g = medium;
                    b = medium + ((double)ih - (double)gh * nMembers) * deltax;
                    break;
                }
                default: {
                    r = high;
                    g = medium;
                    b = high;
                }
            }
            int red = (int)(r * 255.0 + 0.5);
            if (red > 255) {
                red = 255;
            }
            if ((green = (int)(g * 255.0 + 0.5)) > 255) {
                green = 255;
            }
            if ((blue = (int)(b * 255.0 + 0.5)) > 255) {
                blue = 255;
            }
            rainbow[index] = new RGB(red, green, blue);
            ++index;
        }
        return new PaletteData(rainbow);
    }
}

