/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.views;

import fable.framework.toolbox.ComboValueAndText;
import fable.framework.toolbox.FabioFile;
import fable.framework.toolbox.FabioFileException;
import fable.framework.toolbox.FileText;
import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.IntegerText;
import fable.framework.toolbox.LookAndFeel;
import fable.framework.toolbox.Sample;
import fable.framework.toolbox.StringText;
import fable.framework.toolbox.TypedText;
import fable.preprocessor.Activator;
import fable.preprocessor.actions.OnOfflineAction;
import fable.preprocessor.actions.RunAction;
import fable.preprocessor.console.PreprocessorConsole;
import fable.preprocessor.process.IPreprocessorListener;
import fable.preprocessor.process.Preprocessor;
import fable.preprocessor.process.PreprocessorEvent;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.part.ViewPart;

public class SpdView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID = "fable.spd.view";
    public static SpdView thisView = null;
    private static IStatusLineManager statusManager;
    private Preprocessor spdProcessor = Preprocessor.getDefault();
    private String selectedMode = "";
    private DeviceProxy beamline;
    private Thread updateThread;
    private String sampleName = "searching ...";
    private String experiment = "searching ...";
    private String onLineDirectory = "";
    private boolean dataRetrieve = false;
    private boolean bSizeHasBeenChecked = true;
    private PreprocessListener listenPreprocessorChanges = new PreprocessListener();
    private Shell shell;
    private Display display;
    private Composite spdComposite;
    private Composite applyCorrection;
    private Cursor waitCursor;
    private Cursor normalCursor;
    private Cursor currentCursor;
    public PreprocessorConsole console = null;
    private Button chkLock;
    private Button btnReset;
    private Group grp_ExtensionFilter;
    private Group grpspd_dark;
    private Group grpFlood_spd;
    private Group grpDistortion;
    private Group grpOther;
    private Group grpspd_ext;
    private Group grp_zip;
    private Group grpType;
    private String sSampleDirectory;
    private Button btnApplyDark;
    private Button btnApplyFlood;
    private Button btnApplyDist;
    private Button chkTypeEdf;
    private Button chkTypeBruker;
    private Button chkTypeOther;
    private StringText txtTypeOther;
    private Button compressOriginalFiles;
    private Button compressCorrectedFiles;
    private Button browseZip;
    private FileText zipProgram;
    private String preprocessorErrormessage;
    private StringText corExt;
    private Button btnCorExtDefault;
    private Button btnCorExtNew;
    private Group grpSpdDarkopt;
    private FileText darkFile;
    private Button btnDarkFileBrowse;
    private FloatText darkConst;
    private StringText darkExt;
    private Combo cboSaveDark;
    private Button radioDarkInEdf;
    private Button radioDarkFromFile;
    private Button radioNoDarkFile;
    private Button radioDistInEdf;
    private Button radioDistFromFile;
    private Button radioNoDistFile;
    private Button radioFloodInEdf;
    private Button radioFloodFromFile;
    private Button radioNoFloodFile;
    private Button btn_float;
    private Button btn_integer;
    private FloatText inpConst;
    private FloatText inpExp;
    private FloatText inpFactor;
    private IntegerText dvo;
    private FileText floodFile;
    private Button btnFloodFileBrowse;
    private FileText distortionFile;
    private Button btnDistFileBrowse;
    private Combo cboDoDist;
    private Text otherSpdOption;
    private Button btnValidate;
    public static boolean ViewLocked;
    private ArrayList<IPropertyChangeListener> array = new ArrayList();
    private IPropertyChangeListener preferencesListener;
    private ImageDescriptor imagePause = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/stop.gif");
    private ImageDescriptor imagePlay = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/e_forward.gif");
    private ImageDescriptor imageReset = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/revert.gif");
    private ImageDescriptor imageLocked = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/lock.gif");
    private ImageDescriptor imageUnLocked = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/unlock.gif");
    private String alphanumOnly = "[\\p{Punct}&&[^_]]";
    private String alphanumSlashes = "[\\p{Punct}&&[^_/]]";
    private final int numcolumns = 7;
    private final int horizontalSpan = 4;
    private boolean bFloodFileSizeOk = true;
    private boolean bDarkSizeOk = true;

    public void createPartControl(Composite parent) {
        this.initVariables(parent);
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        this.spdComposite = new Composite((Composite)sc, 20);
        sc.setContent((Control)this.spdComposite);
        GridLayout grdLayout = new GridLayout();
        grdLayout.numColumns = 2;
        grdLayout.makeColumnsEqualWidth = true;
        GridData gridDataGlobal = new GridData(16, 20, false, false);
        this.spdComposite.setLayout((Layout)grdLayout);
        this.spdComposite.setLayoutData((Object)gridDataGlobal);
        this.spdComposite.pack();
        this.createGroupApply();
        this.createGroupDark();
        this.createGroupFlood();
        this.createGroupDistortion();
        this.createGroupCorExt();
        this.createGroupExtensionFilter();
        this.createGroupOther();
        this.createZip();
        if (System.getProperty("os.name").toLowerCase().contains("linux") && System.getProperty("os.arch").contains("64")) {
            this.createTypeIntOrFloat();
        }
        this.createGroupLock(this.spdComposite);
        this.addGroupButton(this.spdComposite);
        this.initFieldsAfterPartControl();
        sc.setMinHeight(this.display.getPrimaryMonitor().getBounds().height);
        sc.setMinWidth(this.display.getPrimaryMonitor().getBounds().width);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        sc.setMinSize(this.spdComposite.computeSize(-1, -1));
    }

    private void createGroupCorExt() {
        this.grpspd_ext = LookAndFeel.getGroup((Composite)this.spdComposite, (String)"Corrected image file extension", (int)3, (int)1);
        this.grpspd_ext.setToolTipText("cor_ext : corrected image file extension");
        this.btnCorExtDefault = new Button((Composite)this.grpspd_ext, 16);
        this.btnCorExtDefault.setText("default .cor");
        this.btnCorExtDefault.setSelection(true);
        this.btnCorExtDefault.setLayoutData((Object)new GridData(4, 2, false, true));
        this.btnCorExtNew = new Button((Composite)this.grpspd_ext, 16);
        this.btnCorExtNew.setText("other");
        this.btnCorExtDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpdView.this.fireCurrentCorrectedExtensionHasChanged();
            }
        });
        this.btnCorExtNew.setLayoutData((Object)new GridData(4, 2, false, true));
        this.btnCorExtNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean bselect = ((Button)e.getSource()).getSelection();
                SpdView.this.enableFieldOtherCorrection(bselect);
                SpdView.this.fireCurrentCorrectedExtensionHasChanged();
            }
        });
        this.corExt = new StringText((Composite)this.grpspd_ext, 0, "", this.alphanumOnly, "You don't need to add punctuation");
        this.corExt.setName("correction extension");
        this.corExt.setLayoutData((Object)new GridData(4, 2, true, false));
        this.corExt.set_toolTipText("Corrected image file extension ; this extension is added to the file extension.");
        this.corExt.getTextField().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SpdView.this.fireCurrentCorrectedExtensionHasChanged();
            }
        });
        if (this.btnCorExtNew.getSelection()) {
            this.corExt.setBackground(Display.getDefault().getSystemColor(1));
        } else {
            this.corExt.setBackground(Display.getDefault().getSystemColor(22));
        }
    }

    protected void fireCurrentCorrectedExtensionHasChanged() {
        String val = ".";
        val = this.btnCorExtDefault.getSelection() ? String.valueOf(val) + "cor" : String.valueOf(val) + (this.corExt.getText().equals("") ? "cor" : this.corExt.getText());
        if (this.compressOriginalFiles.getSelection()) {
            val = String.valueOf(val) + ".gz";
        }
        this.spdProcessor.fireCurrentCorrectedExtensionHasChanged(val);
    }

    private void createTypeIntOrFloat() {
        this.grpType = LookAndFeel.getGroup((Composite)this.spdComposite, (String)"Output file type", (int)4, (int)2);
        this.grpType.setToolTipText("Writes output files with selected type.\n\nWith 16-bit unsigned integer dvo must \nbe added later to the stored data  values to retrieve the correct values. \nThe dvo value is written as \nan integer value after the header keyDataValueOffset (default 0). \n\n Available on Linux operating system, 64bit architecture.");
        this.btn_integer = new Button((Composite)this.grpType, 16);
        this.btn_integer.setText("Unsigned integer");
        this.btn_integer.setData((Object)"Unsigned16");
        this.btn_float = new Button((Composite)this.grpType, 16);
        this.btn_float.setText("Float");
        this.btn_float.setData((Object)"FloatIEEE32");
        new Label((Composite)this.grpType, 0).setText("Data value offset");
        this.dvo = new IntegerText((Composite)this.grpType, 0);
        this.dvo.setName("dvo");
        this.dvo.setToolTipText("dvo option. must be added later to the stored data values to retrieve the correct values");
    }

    private void createZip() {
        this.grp_zip = LookAndFeel.getGroup((Composite)this.spdComposite, (String)"Compress data and corrected files", (int)4, (int)1);
        this.grp_zip.setToolTipText("Compress data and corrected files after processing. Please compress data with gzip, file format available for fabio");
        Composite c = new Composite((Composite)this.grp_zip, 4);
        c.setLayout((Layout)new GridLayout(4, false));
        GridData gdOther = new GridData(1808, 128, true, true, 4, 15);
        c.setLayoutData((Object)gdOther);
        this.compressCorrectedFiles = new Button(c, 32);
        this.compressCorrectedFiles.setText("Compress corrected files(gzip)");
        this.compressCorrectedFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpdView.this.zipProgram.setEnabled(((Button)e.widget).getSelection() || SpdView.this.compressOriginalFiles.getSelection());
                SpdView.this.zipProgram.set_isRequiredField(((Button)e.widget).getSelection() || SpdView.this.compressOriginalFiles.getSelection());
                SpdView.this.zipProgram.showrequired();
                if (!SpdView.this.compressCorrectedFiles.getSelection() && !SpdView.this.compressOriginalFiles.getSelection()) {
                    SpdView.this.zipProgram.set_bValide(true);
                }
                SpdView.this.fireCurrentCorrectedExtensionHasChanged();
            }
        });
        this.compressOriginalFiles = new Button(c, 32);
        this.compressOriginalFiles.setText("Compress original files(gzip)");
        this.compressOriginalFiles.setToolTipText("This option allow preprocessor to compress original files after preprocessing.\n WARNING spd program is not abled to read such compressed files.");
        this.compressOriginalFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpdView.this.zipProgram.setEnabled(((Button)e.widget).getSelection() || SpdView.this.compressCorrectedFiles.getSelection());
                SpdView.this.zipProgram.set_isRequiredField(((Button)e.widget).getSelection() || SpdView.this.compressCorrectedFiles.getSelection());
                SpdView.this.zipProgram.showrequired();
                if (!SpdView.this.compressCorrectedFiles.getSelection() && !SpdView.this.compressOriginalFiles.getSelection()) {
                    SpdView.this.zipProgram.set_bValide(true);
                }
                if (SpdView.this.compressOriginalFiles.getSelection()) {
                    SpdView.this.console.displayOut("WARNING : After compression, spd is not able to process these original files.");
                }
            }
        });
        this.zipProgram = new FileText(c, 0);
        this.zipProgram.setName("Zip command");
        this.zipProgram.setLayoutData((Object)new GridData(4, 2, true, false));
        this.browseZip = new Button(c, 8);
        this.browseZip.setText("Browse...");
        this.browseZip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(((Button)e.widget).getParent().getShell(), 64);
                if (SpdView.this.zipProgram.getText() != null && !SpdView.this.zipProgram.getText().equals("")) {
                    dlg.setFilterPath(SpdView.this.zipProgram.getText());
                } else if (SpdView.this.sSampleDirectory != null) {
                    dlg.setFilterPath(SpdView.this.sSampleDirectory);
                }
                String sFile = dlg.open();
                if (sFile != null) {
                    SpdView.this.zipProgram.set_Text(sFile);
                }
            }
        });
    }

    private void createGroupExtensionFilter() {
        this.grp_ExtensionFilter = LookAndFeel.getGroup((Composite)this.spdComposite, (String)"Source file extension to save an online input data to a file (src_ext)", (int)4, (int)1);
        this.grp_ExtensionFilter.setToolTipText("Select extension file to process");
        this.chkTypeEdf = new Button((Composite)this.grp_ExtensionFilter, 16);
        this.chkTypeEdf.setText("edf");
        this.chkTypeEdf.setLayoutData((Object)new GridData(4, 2, false, false));
        this.chkTypeBruker = new Button((Composite)this.grp_ExtensionFilter, 16);
        this.chkTypeBruker.setText("bruker");
        this.chkTypeBruker.setLayoutData((Object)new GridData(4, 2, false, false));
        this.chkTypeOther = new Button((Composite)this.grp_ExtensionFilter, 16);
        this.chkTypeOther.setLayoutData((Object)new GridData(4, 2, false, false));
        this.chkTypeOther.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean bselect = ((Button)e.getSource()).getSelection();
                SpdView.this.enableFieldOther_src_ext(bselect);
            }
        });
        this.chkTypeOther.setSelection(true);
        this.chkTypeOther.setText("other");
        this.txtTypeOther = new StringText((Composite)this.grp_ExtensionFilter, 4, " ", "\\p{Punct}", "No punctuation is allowed");
        this.txtTypeOther.setName("other input file extension");
        this.txtTypeOther.setLayoutData((Object)new GridData(4, 2, true, false));
        this.txtTypeOther.setToolTipText("Source image file extension (default None i. e. no input file image is saved)");
        if (this.chkTypeOther.getSelection()) {
            this.txtTypeOther.setBackground(Display.getDefault().getSystemColor(1));
        } else {
            this.txtTypeOther.setBackground(Display.getDefault().getSystemColor(22));
        }
        this.txtTypeOther.setEnabled(this.chkTypeOther.getSelection());
        this.txtTypeOther.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SpdView.this.txtTypeOther.set_Text(((Text)e.getSource()).getText().replaceAll("\\p{Space}", ""));
            }
        });
    }

    private void enableFieldOther_src_ext(boolean bselect) {
        this.txtTypeOther.setEnabled(bselect);
        if (bselect) {
            this.txtTypeOther.setBackground(Display.getDefault().getSystemColor(1));
        } else {
            this.txtTypeOther.setBackground(Display.getDefault().getSystemColor(22));
        }
    }

    private void enableFieldOtherCorrection(boolean bselect) {
        this.corExt.setEnabled(bselect);
        this.corExt.set_isRequiredField(bselect);
        this.corExt.showrequired();
        this.corExt.setFocus();
        if (bselect) {
            this.corExt.setBackground(Display.getDefault().getSystemColor(1));
        } else {
            this.corExt.setBackground(Display.getDefault().getSystemColor(22));
        }
    }

    private void createGroupApply() {
        this.applyCorrection = new Composite(this.spdComposite, 0);
        GridLayout grdApply = new GridLayout();
        grdApply.numColumns = 4;
        grdApply.makeColumnsEqualWidth = true;
        this.applyCorrection.setLayout((Layout)grdApply);
        this.applyCorrection.setLayoutData((Object)new GridData(16, 20, false, false));
        Label lblApply = new Label(this.applyCorrection, 0);
        lblApply.setText("Apply:");
        this.btnApplyDark = new Button(this.applyCorrection, 32);
        this.btnApplyDark.setText("Dark");
        this.btnApplyDark.setToolTipText("do_dark. If set, then the dark image correction is performed if there is a source for it (file, dark_const or dark_id)");
        this.btnApplyDark.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpdView.this.sendcontrolToDarkGroup();
                SpdView.this.checkDarkSize();
            }
        });
        this.btnApplyFlood = new Button(this.applyCorrection, 32);
        this.btnApplyFlood.setText("Flood");
        this.btnApplyFlood.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpdView.this.sendControlToFloodGroup();
                SpdView.this.checkFloodFile();
            }
        });
        this.btnApplyDist = new Button(this.applyCorrection, 32);
        this.btnApplyDist.setText("Distortion ");
        this.btnApplyDist.setToolTipText("do_distortion");
        this.btnApplyDist.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((Button)e.getSource()).getSelection();
                SpdView.this.sendControlToDistGroup();
            }
        });
    }

    private void createGroupDark() {
        this.grpspd_dark = LookAndFeel.getGroup((Composite)this.spdComposite, (String)"Dark correction", (int)3, (int)2);
        Group grpSelectDarkFileOption = LookAndFeel.getGroup((Composite)this.grpspd_dark, (String)"File", (int)5, (int)3);
        grpSelectDarkFileOption.setToolTipText("dark_file");
        this.radioNoDarkFile = new Button((Composite)grpSelectDarkFileOption, 16);
        this.radioNoDarkFile.setText("None");
        this.radioNoDarkFile.setLayoutData((Object)new GridData(1, 2, false, true));
        this.radioDarkInEdf = new Button((Composite)grpSelectDarkFileOption, 16);
        this.radioDarkInEdf.setText("From header");
        this.radioDarkInEdf.setLayoutData((Object)new GridData(1, 2, false, true));
        this.radioDarkInEdf.setToolTipText("dark_file=[darkFileName]; add verbose=2 in other options to get file name while spd is processing");
        this.radioDarkFromFile = new Button((Composite)grpSelectDarkFileOption, 16);
        this.radioDarkFromFile.setText("File");
        this.radioDarkFromFile.setLayoutData((Object)new GridData(1, 2, false, true));
        this.darkFile = new FileText((Composite)grpSelectDarkFileOption, 0, "");
        this.darkFile.setName("Dark file");
        this.darkFile.set_toolTipText("dark image file name");
        GridData gd5 = new GridData(4, 2, true, true);
        this.darkFile.setLayoutData((Object)gd5);
        this.darkFile.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    SpdView.this.sendcontrolToDarkGroup();
                    SpdView.this.checkDarkSize();
                }
            }
        });
        this.darkFile.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SpdView.this.sendcontrolToDarkGroup();
            }
        });
        this.btnDarkFileBrowse = new Button((Composite)grpSelectDarkFileOption, 8);
        this.btnDarkFileBrowse.setText("Browse...");
        this.btnDarkFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDlg = new FileDialog(SpdView.this.shell, 0);
                String[] ESRFExtFilterName = new String[]{"edf files  (*.edf)", "All Files (*.*)"};
                String[] ESRFExtFilter = new String[]{"*.edf", "*.*"};
                fileDlg.setFilterExtensions(ESRFExtFilter);
                fileDlg.setFilterNames(ESRFExtFilterName);
                fileDlg.setText("Choose dark file...");
                if (SpdView.this.darkFile.getText() != null && !SpdView.this.darkFile.getText().equals("")) {
                    fileDlg.setFilterPath(SpdView.this.darkFile.getText());
                } else if (SpdView.this.sSampleDirectory != null) {
                    fileDlg.setFilterPath(SpdView.this.sSampleDirectory);
                }
                String file = fileDlg.open();
                if (file != null) {
                    SpdView.this.darkFile.set_Text(file);
                    SpdView.this.sendcontrolToDarkGroup();
                    SpdView.this.checkDarkSize();
                }
            }
        });
        this.radioDarkInEdf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpdView.this.sendcontrolToDarkGroup();
                SpdView.this.checkDarkSize();
            }
        });
        this.radioDarkFromFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpdView.this.sendcontrolToDarkGroup();
                SpdView.this.checkDarkSize();
            }
        });
        this.radioNoDarkFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpdView.this.sendcontrolToDarkGroup();
                SpdView.this.checkDarkSize();
            }
        });
        this.darkConst = new FloatText((Composite)this.grpspd_dark, 16384, "Dark const");
        this.darkConst.setName("dark constant");
        this.darkConst.set_toolTipText("dark_const: subtract constant dark image value. Can be specified in addition to dark_file or dark_id.");
        this.darkConst.setLayoutData((Object)new GridData(16384, 2, false, true));
        this.darkConst.set_Text(String.valueOf(0));
        this.darkConst.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                SpdView.this.sendcontrolToDarkGroup();
            }
        });
        this.grpSpdDarkopt = LookAndFeel.getGroup((Composite)this.grpspd_dark, (String)"Factors applied to source and dark image. ", (int)7, (int)3);
        Label formula = new Label((Composite)this.grpSpdDarkopt, 0);
        formula.setText("Formula is :  corrected  = (source^inp_exp - dark^inp_exp) inp_factor + inp_const");
        formula.setLayoutData((Object)new GridData(16384, 2, false, true, 7, 1));
        this.grpSpdDarkopt.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.inpConst = new FloatText((Composite)this.grpSpdDarkopt, 4, "Constant (inp_const)");
        this.inpConst.setName("inp Constant");
        this.inpConst.set_toolTipText("inp_const: add input image constant.");
        this.inpConst.set_Text(String.valueOf(0));
        this.inpExp = new FloatText((Composite)this.grpSpdDarkopt, 4, "Exponent (inp_exp)");
        this.inpExp.setName("Exponent to input image");
        this.inpExp.set_Text(String.valueOf(1));
        this.inpExp.set_toolTipText("inp_exp: apply exponent to input image.");
        this.inpFactor = new FloatText((Composite)this.grpSpdDarkopt, 4, "Factor (inp_factor)");
        this.inpFactor.setName("Multiply with input image factor for dark options");
        this.inpFactor.set_Text(String.valueOf(1));
        this.inpFactor.set_toolTipText("inp_factor: multiply with input image factor.");
        Label lblSaveDark = new Label((Composite)this.grpspd_dark, 0);
        lblSaveDark.setText("Save dark image memory to file (.dark)? ");
        this.cboSaveDark = new Combo((Composite)this.grpspd_dark, 12);
        this.cboSaveDark.add("No");
        this.cboSaveDark.add("Always");
        this.cboSaveDark.add("If new image");
        this.cboSaveDark.setToolTipText("Save dark image memory to file.Only if input source image is also saved (src_ext not empty)");
        this.darkExt = new StringText((Composite)this.grpspd_dark, 4, "Dark image extension ", this.alphanumOnly, "no punctuation allowed");
        this.darkExt.setName("Dark image extension");
        this.darkExt.setLayoutData((Object)new GridData(36, 2, true, false));
        this.darkExt.set_toolTipText("dark image file extension  (default none). Used to save an online dark image to a file. Default is None, no output file is written");
    }

    private void createGroupFlood() {
        this.grpFlood_spd = LookAndFeel.getGroup((Composite)this.spdComposite, (String)"Flood", (int)5, (int)2);
        this.radioNoFloodFile = new Button((Composite)this.grpFlood_spd, 16);
        this.radioNoFloodFile.setLayoutData((Object)new GridData(4, 2, false, true));
        this.radioNoFloodFile.setText("None");
        this.radioNoFloodFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpdView.this.sendControlToFloodGroup();
                SpdView.this.checkFloodFile();
            }
        });
        this.radioFloodInEdf = new Button((Composite)this.grpFlood_spd, 16);
        this.radioFloodInEdf.setLayoutData((Object)new GridData(4, 2, false, true));
        this.radioFloodInEdf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpdView.this.sendControlToFloodGroup();
                SpdView.this.checkFloodFile();
            }
        });
        this.radioFloodInEdf.setText("From header");
        this.radioFloodFromFile = new Button((Composite)this.grpFlood_spd, 16);
        this.radioFloodFromFile.setLayoutData((Object)new GridData(4, 2, false, true));
        this.radioFloodFromFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpdView.this.sendControlToFloodGroup();
                SpdView.this.checkFloodFile();
            }
        });
        this.radioFloodFromFile.setText("File");
        this.floodFile = new FileText((Composite)this.grpFlood_spd, 4, "");
        this.floodFile.setName("flood file");
        this.floodFile.set_toolTipText("flood field image file name");
        this.floodFile.setLayoutData((Object)new GridData(4, 2, true, true));
        this.btnFloodFileBrowse = new Button((Composite)this.grpFlood_spd, 8);
        this.btnFloodFileBrowse.setText("Browse...");
        this.btnFloodFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDlg = new FileDialog(SpdView.this.shell, 0);
                String[] ESRFExtFilterName = new String[]{"edf files (*.edf)", ".cor", "All Files (*.*)"};
                String[] ESRFExtFilter = new String[]{"*.edf", "*.cor", "*.*"};
                fileDlg.setFilterExtensions(ESRFExtFilter);
                fileDlg.setFilterNames(ESRFExtFilterName);
                fileDlg.setText("Choose flood file...");
                if (SpdView.this.floodFile.getText() != null && !SpdView.this.floodFile.getText().equals("")) {
                    fileDlg.setFilterPath(SpdView.this.floodFile.getText());
                } else if (SpdView.this.sSampleDirectory != null) {
                    fileDlg.setFilterPath(SpdView.this.sSampleDirectory);
                }
                String file = fileDlg.open();
                if (file != null) {
                    SpdView.this.floodFile.set_Text(file);
                    SpdView.this.checkFloodFile();
                }
            }
        });
    }

    private void createGroupDistortion() {
        this.grpDistortion = LookAndFeel.getGroup((Composite)this.spdComposite, (String)"Spatial distortion", (int)2, (int)3);
        Group grpSelectFloodFileOption = LookAndFeel.getGroup((Composite)this.grpDistortion, (String)"File", (int)5, (int)2);
        grpSelectFloodFileOption.setToolTipText("distortion_file");
        Label lblDodistortion = new Label((Composite)this.grpDistortion, 0);
        lblDodistortion.setText("Do spatial distortion after");
        this.cboDoDist = new Combo((Composite)this.grpDistortion, 12);
        this.cboDoDist.setLayoutData((Object)new GridData(4, 2, false, false));
        this.cboDoDist.add("dark");
        this.cboDoDist.add("flood");
        this.cboDoDist.add("normalisation");
        GridData gdcboDist = new GridData(4);
        gdcboDist.horizontalSpan = 1;
        gdcboDist.grabExcessHorizontalSpace = false;
        this.cboDoDist.setLayoutData((Object)gdcboDist);
        this.radioNoDistFile = new Button((Composite)grpSelectFloodFileOption, 16);
        this.radioNoDistFile.setText("None");
        this.radioNoDistFile.setLayoutData((Object)new GridData(5, 2, false, true));
        this.radioDistInEdf = new Button((Composite)grpSelectFloodFileOption, 16);
        this.radioDistInEdf.setText("From header");
        this.radioDistInEdf.setLayoutData((Object)new GridData(4, 2, false, true));
        this.radioDistFromFile = new Button((Composite)grpSelectFloodFileOption, 16);
        this.radioDistFromFile.setText("File");
        this.radioDistFromFile.setLayoutData((Object)new GridData(4, 2, false, true));
        this.distortionFile = new FileText((Composite)grpSelectFloodFileOption, 4, "");
        this.distortionFile.setName("Distortion file");
        this.distortionFile.setLayoutData((Object)new GridData(4, 2, true, true));
        this.distortionFile.set_toolTipText("distortion file");
        this.btnDistFileBrowse = new Button((Composite)grpSelectFloodFileOption, 8);
        this.btnDistFileBrowse.setText("Browse...");
        this.btnDistFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDlg = new FileDialog(SpdView.this.shell, 0);
                String[] ESRFExtFilterName = new String[]{"Distortion files (*.spd)", "Spline files (*.spline)", "All Files (*.*)"};
                String[] ESRFExtFilter = new String[]{"*.spd", "*.spline", "*.*"};
                fileDlg.setFilterExtensions(ESRFExtFilter);
                fileDlg.setFilterNames(ESRFExtFilterName);
                fileDlg.setText("Choose distortion file...");
                if (SpdView.this.distortionFile.getText() != null && !SpdView.this.distortionFile.getText().equals("")) {
                    fileDlg.setFilterPath(SpdView.this.distortionFile.getText());
                } else if (SpdView.this.sSampleDirectory != null) {
                    fileDlg.setFilterPath(SpdView.this.sSampleDirectory);
                }
                String file = fileDlg.open();
                if (file != null) {
                    SpdView.this.distortionFile.set_Text(file);
                }
            }
        });
        this.radioDistInEdf.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SpdView.this.sendControlToDistGroup();
            }

            public void widgetSelected(SelectionEvent e) {
                SpdView.this.sendControlToFloodGroup();
            }
        });
        this.radioDistFromFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SpdView.this.sendControlToDistGroup();
            }

            public void widgetSelected(SelectionEvent e) {
                SpdView.this.sendControlToDistGroup();
            }
        });
        this.radioNoDistFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SpdView.this.sendControlToFloodGroup();
            }

            public void widgetSelected(SelectionEvent e) {
                SpdView.this.sendControlToFloodGroup();
            }
        });
    }

    private void createGroupOther() {
        this.grpOther = LookAndFeel.getGroup((Composite)this.spdComposite, (String)"Add other spd options", (int)1, (int)1);
        this.otherSpdOption = new Text((Composite)this.grpOther, 2818);
        GridData gdOther = new GridData(1808);
        gdOther.verticalSpan = 15;
        this.otherSpdOption.setLayoutData((Object)gdOther);
        this.otherSpdOption.setToolTipText("Add other spd options here");
    }

    private void initFieldsAfterPartControl() {
        this.cboDoDist.select(1);
        this.cboSaveDark.select(2);
        this.setPreferencesValues();
    }

    private void sendcontrolToDarkGroup() {
        boolean bSelected = this.btnApplyDark.getSelection();
        this.setEnableGroup((Composite)this.grpspd_dark, bSelected);
        this.enableFileSelection(this.btnDarkFileBrowse, (Composite)this.darkFile, this.display, this.radioDarkFromFile.getSelection());
        if (bSelected && (this.darkFile.getText().equals("") || this.darkFile.getText().matches("\\p{Space}+?") && (this.darkConst.getText().equals("") || this.darkConst.getText().matches("\\p{Space}+|0"))) && this.radioDarkFromFile.getSelection()) {
            this.darkFile.set_isRequiredField(bSelected);
            this.darkConst.set_isRequiredField(bSelected);
            this.darkFile.showrequired();
            this.btnDarkFileBrowse.setFocus();
            if (this.darkConst.getText().matches("\\p{Space}") || this.darkConst.getText().equals("")) {
                this.darkConst.showrequired();
            } else if (this.darkConst.getText().equals("0")) {
                this.darkConst.setMinValue(0.0f, false);
                this.darkConst.showError();
            }
        } else {
            this.darkFile.showrequired();
            this.darkConst.set_isRequiredField(false);
            this.darkConst.set_bValide(true);
            this.darkConst.showError();
            this.darkConst.setMinValue(0.0f, true);
        }
    }

    private void sendControlToFloodGroup() {
        boolean bapply = this.btnApplyFlood.getSelection();
        this.setEnableGroup((Composite)this.grpFlood_spd, bapply);
        this.enableFileSelection(this.btnFloodFileBrowse, (Composite)this.floodFile, this.display, bapply && this.radioFloodFromFile.getSelection());
        this.floodFile.set_isRequiredField(bapply && this.radioFloodFromFile.getSelection());
        this.floodFile.showrequired();
        this.btnFloodFileBrowse.setFocus();
    }

    private void sendControlToDistGroup() {
        boolean bapply = this.btnApplyDist.getSelection();
        this.setEnableGroup((Composite)this.grpDistortion, bapply);
        this.enableFileSelection(this.btnDistFileBrowse, (Composite)this.distortionFile, this.display, bapply && this.radioDistFromFile.getSelection());
        this.setApplyDist(bapply);
        this.distortionFile.set_isRequiredField(bapply && this.radioDistFromFile.getSelection());
        this.distortionFile.showrequired();
        this.btnDistFileBrowse.setFocus();
    }

    public void setPreferencesValues() {
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        this.setApplyDark(prefs.getBoolean("pref_auto_dark"));
        this.setApplyDist(prefs.getBoolean("pref_auto_dist"));
        this.setApplyFlood(prefs.getBoolean("pref_auto_flood"));
        this.setTxtFileDark(prefs.getString("pref_dark_file"));
        this.set_dark_ext(prefs.getString("pref_dark_file"));
        this.setTxtFileDist(prefs.getString("pref_dist_file"));
        this.setTxtFileFlood(prefs.getString("pref_flood_file"));
        this.set_command(prefs.getString("pref_cmd_spd"));
        this.setSelectedMode(prefs.getString("pref_mode"));
        this.setCommandMode(prefs);
        this.setOtherSpdOption(prefs.getString("pref_spd_otherOptions"));
        this.setPrefCorrectionExtension(prefs.getString("pref_ext_COR_SELECT"), prefs.getString("pref_ext_COR"));
        this.set_DarkFile_mode(prefs.getString("pref_dark_getFileMode"));
        this.set_DistFile_mode(prefs.getString("pref_dist_getFileMode"));
        this.set_FloodFile_mode(prefs.getString("pref_flood_getFileMode"));
        this.sendcontrolToDarkGroup();
        this.sendControlToDistGroup();
        this.sendControlToFloodGroup();
        this.compressCorrectedFiles.setSelection(prefs.getBoolean("pref_zipCorrected"));
        this.compressCorrectedFiles.notifyListeners(13, new Event());
        this.compressOriginalFiles.setSelection(prefs.getBoolean("pref_zipOriginal"));
        this.compressOriginalFiles.notifyListeners(13, new Event());
        this.zipProgram.set_Text(prefs.getString("pref_zip_program"));
        if (this.btn_float != null) {
            this.btn_float.setSelection(prefs.getString("pref_type").equals("type_float"));
        }
        if (this.btn_integer != null) {
            this.btn_integer.setSelection(prefs.getString("pref_type").equals("type_int"));
        }
        if (this.dvo != null) {
            this.dvo.set_Text(prefs.getString("pref_dvo"));
        }
    }

    private void setCommandMode(Preferences prefs) {
        this.spdProcessor.setSpdMode(prefs.getString("pref_spd_server"));
    }

    private void setPrefCorrectionExtension(String type, String name) {
        boolean bDefault = type.equals("Default");
        this.btnCorExtDefault.setSelection(bDefault);
        this.btnCorExtNew.setSelection(!bDefault);
        this.corExt.set_Text(name);
        this.enableFieldOtherCorrection(!bDefault);
    }

    private ComboValueAndText[] createVerbose() {
        ComboValueAndText[] cb = new ComboValueAndText[]{new ComboValueAndText("Low", "-1"), new ComboValueAndText("Medium", "0"), new ComboValueAndText("High", "1"), new ComboValueAndText("Very high", "2")};
        return cb;
    }

    private void addGroupButton(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gd = new GridLayout();
        gd.numColumns = 2;
        gd.makeColumnsEqualWidth = false;
        container.setLayout((Layout)gd);
        GridData gdGrpButton = new GridData(131072, 0x1000000, false, true);
        gdGrpButton.horizontalSpan = 2;
        container.setLayoutData((Object)gdGrpButton);
        this.btnReset = new Button(container, 8);
        final Image image = this.imageReset.createImage();
        Image imageScaled = new Image((Device)this.display, image.getImageData().scaledTo((int)((double)image.getBounds().width * 1.2), (int)((double)image.getBounds().height * 1.2)));
        this.btnReset.setImage(imageScaled);
        this.btnReset.setToolTipText("Restore defaults values");
        this.btnReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpdView.this.ResetAll();
            }
        });
        this.btnReset.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                image.dispose();
            }
        });
        this.btnValidate = new Button(container, 8);
        this.setImagebtnLaunch(this.spdProcessor.isM_bStatusProcessing());
        this.btnValidate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpdView.this.LaunchPreprocessor();
            }
        });
        this.btnValidate.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                SpdView.this.shell.setCursor(SpdView.this.normalCursor);
            }

            public void mouseExit(MouseEvent e) {
                SpdView.this.shell.setCursor(SpdView.this.currentCursor);
            }

            public void mouseHover(MouseEvent e) {
            }
        });
    }

    private void initVariables(Composite parent) {
        thisView = this;
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.preprocessor.actions.RunAction", (IAction)new RunAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.preprocessor.actions.OnOfflineAction", (IAction)new OnOfflineAction());
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{new PreprocessorConsole()});
        this.console = PreprocessorConsole.thisConsole;
        this.display = Display.getCurrent();
        thisView.setContentDescription("Choose spd options for preprocessor here");
        thisView.setTitleToolTip("Spd view");
        this.shell = parent.getShell();
        this.waitCursor = new Cursor((Device)this.display, 1);
        this.currentCursor = this.normalCursor = new Cursor((Device)this.display, 0);
        this.spdProcessor.addPropertyChangeListener(this);
        this.spdProcessor.addPreprocessorListener(this.listenPreprocessorChanges);
        this.preferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("pref_zip_program")) {
                    SpdView.this.zipProgram.set_Text(Activator.getDefault().getPreferenceStore().getString("pref_zip_program"));
                }
            }
        };
    }

    public void setFocus() {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("ProcessingView_directory")) {
            this.sSampleDirectory = (String)event.getNewValue();
        } else if (event.getProperty().equals("ProcessingView_sample")) {
            this.sampleName = (String)event.getNewValue();
        } else if (event.getProperty().equals("ProcessingView_experiment")) {
            this.experiment = (String)event.getNewValue();
            this.bSizeHasBeenChecked = false;
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        statusManager = site.getActionBars().getStatusLineManager();
    }

    public void showFileSelection(Button btn, Composite cpm, boolean benable) {
        cpm.setVisible(benable);
        btn.setVisible(benable);
    }

    public void enableFileSelection(Button btn, Composite cpm, Display disp, boolean benable) {
        cpm.setEnabled(benable);
        btn.setEnabled(benable);
        if (benable) {
            cpm.setBackground(disp.getSystemColor(1));
        } else {
            cpm.setBackground(disp.getSystemColor(22));
        }
    }

    private void createGroupLock(Composite container) {
        this.chkLock = new Button(container, 32);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.chkLock.setLayoutData((Object)gd);
        this.chkLock.setToolTipText("Allow view to be locked");
        this.chkLock.setText("Lock view");
        ViewLocked = this.chkLock.getSelection();
        this.chkLock.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpdView.this.LockAll(((Button)e.getSource()).getSelection());
            }
        });
        this.chkLock.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
            }
        });
        this.chkLock.addListener(2, new Listener(){

            public void handleEvent(Event e) {
                SpdView.this.LockAll(SpdView.this.spdProcessor.isM_bStatusProcessing());
            }
        });
    }

    private void ResetAll() {
        this.currentCursor = this.normalCursor;
        this.setPreferencesValues();
    }

    public void LaunchPreprocessor() {
        boolean bok = true;
        if (!this.spdProcessor.isM_bStatusProcessing()) {
            if (this.spdProcessor.getSpdMode() != "server" && (this.spdProcessor.get_Command() == null || this.spdProcessor.get_Command().trim().equals(""))) {
                this.console.activate();
                this.console.displayIn("Please select preprocessor program in spd preferences window");
            } else if (this.spdProcessor.isOffLine() && !this.checkSelectedFiles()) {
                this.console.displayIn(this.getPreprocessorErrorMessage());
            } else if (!this.checkFields(this.spdComposite, true)) {
                this.console.activate();
                this.console.displayIn("Please check options fields. There are wrong values.");
            } else {
                if (!this.isBSizeIsOk()) {
                    bok = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Check size info message", (String)"One or several sample files don't have \nthe same size and won' t be processed.\nDo you want to continue ?");
                }
                if (this.setOptions() && bok) {
                    this.spdProcessor.setM_bStatusProcessing(true);
                    this.LockAll(true);
                    this.spdProcessor.run();
                }
            }
        } else {
            this.spdProcessor.stop();
            this.spdProcessor.setM_bStatusProcessing(false);
        }
    }

    public boolean setOptions() {
        boolean breturn = true;
        if (this.btnCorExtDefault.getSelection()) {
            this.spdProcessor.set_cor_ext("cor");
        } else if (this.btnCorExtNew.getSelection()) {
            this.spdProcessor.set_cor_ext(this.corExt.getText());
        }
        if (this.chkTypeBruker.getSelection()) {
            this.spdProcessor.set_src_ext("\\d+");
        } else if (this.chkTypeEdf.getSelection()) {
            this.spdProcessor.set_src_ext("edf");
        } else if (this.chkTypeOther.getSelection()) {
            this.spdProcessor.set_src_ext(this.txtTypeOther.getText());
        } else {
            this.spdProcessor.set_src_ext("");
        }
        this.spdProcessor.set_inp_const(this.inpConst.getText());
        this.spdProcessor.set_dark_ext(this.darkExt.getText());
        this.spdProcessor.set_save_dark(String.valueOf(this.cboSaveDark.getSelectionIndex()));
        this.spdProcessor.set_inp_factor(this.inpFactor.getText());
        this.spdProcessor.set_inp_exp(this.inpExp.getText());
        this.spdProcessor.set_dark_const(this.darkConst.getText());
        this.spdProcessor.setOtherOptions(this.otherSpdOption.getText());
        int action = this.getCboDoDist();
        this.spdProcessor.setDistortionAction(action);
        this.spdProcessor.setM_applyDarkCorrection(this.btnApplyDark.getSelection());
        this.spdProcessor.setM_applyDistCorrection(this.btnApplyDist.getSelection());
        this.spdProcessor.setM_applyFloodCorrection(this.btnApplyFlood.getSelection());
        if (this.btnApplyDark.getSelection()) {
            if (this.radioDarkFromFile.getSelection()) {
                this.spdProcessor.setM_darkFile(this.darkFile.getText());
            } else if (this.radioDarkInEdf.getSelection()) {
                this.spdProcessor.setM_darkFile("[DarkFileName]");
            } else {
                this.spdProcessor.setM_darkFile("");
            }
        }
        if (this.btnApplyDist.getSelection()) {
            if (this.radioDistInEdf.getSelection()) {
                this.spdProcessor.setM_distFile("[DistortionFileName]");
            } else if (this.radioDistFromFile.getSelection()) {
                this.spdProcessor.setM_distFile(this.distortionFile.getText());
            } else {
                this.spdProcessor.setM_distFile("");
            }
        }
        if (this.btnApplyFlood.getSelection()) {
            if (this.radioFloodInEdf.getSelection()) {
                this.spdProcessor.setM_floodFile("[FloodFileName]");
            } else if (this.radioFloodFromFile.getSelection()) {
                this.spdProcessor.setM_floodFile(this.floodFile.getText());
            } else {
                this.spdProcessor.setM_floodFile("");
            }
        }
        this.spdProcessor.setOtherOptions(this.otherSpdOption.getText());
        this.spdProcessor.setCompress(this.compressOriginalFiles.getSelection(), this.compressCorrectedFiles.getSelection(), this.zipProgram.getText());
        if (this.btn_float != null && this.btn_integer != null) {
            if (this.btn_float.getSelection()) {
                this.spdProcessor.setCorrectionType((String)this.btn_float.getData());
            } else {
                this.spdProcessor.setCorrectionType((String)this.btn_integer.getData());
            }
        }
        if (this.dvo != null) {
            this.spdProcessor.setDataValueOffset(this.dvo.getText());
        }
        return breturn;
    }

    private boolean checkDarkSize() {
        boolean breturn = true;
        if (this.radioDarkFromFile.getSelection() && this.btnApplyDark.getSelection() && !this.darkFile.getText().equals("")) {
            try {
                FabioFile dark = new FabioFile(this.darkFile.getText());
                breturn = this.spdProcessor.checkSize(dark);
            }
            catch (FabioFileException e) {
                Activator.log("Error in checkSize while creating dark file", 4, (Exception)((Object)e));
                this.console.activate();
                this.console.displayIn("Error in checkSize while creating dark file:" + e.getMessage());
            }
        } else {
            this.resetFlag();
        }
        this.bDarkSizeOk = breturn;
        return breturn;
    }

    private boolean checkFloodFile() {
        boolean breturn = true;
        if (this.radioFloodFromFile.getSelection() && this.btnApplyFlood.getSelection() && !this.floodFile.getText().equals("")) {
            try {
                FabioFile flood = new FabioFile(this.floodFile.getText());
                breturn = this.spdProcessor.checkSize(flood);
            }
            catch (FabioFileException e) {
                Activator.log("Error in checkSize() while creating flood file", 4, (Exception)((Object)e));
                this.console.activate();
                this.console.displayIn("Error checkSize while creating flood file:" + e.getMessage());
            }
        } else {
            this.resetFlag();
        }
        this.bFloodFileSizeOk = breturn;
        return breturn;
    }

    private boolean checkSize() {
        boolean breturn = true;
        breturn = this.checkDarkSize();
        if (breturn) {
            breturn = this.checkFloodFile();
        }
        return breturn;
    }

    private void resetFlag() {
        boolean bok = true;
        Vector<Sample> spls = this.spdProcessor.get_Samples();
        boolean reset = false;
        if (!this.btnApplyDark.getSelection() || !this.radioDarkFromFile.getSelection() || this.darkFile.getText().equals("")) {
            reset = true;
        }
        if (reset) {
            reset = !this.btnApplyFlood.getSelection() || !this.radioFloodFromFile.getSelection() || this.floodFile.getText().equals("");
        }
        int n = 0;
        while (reset && spls != null && n < spls.size() && bok) {
            Sample sp = spls.elementAt(n);
            if (sp != null && sp.HasFile()) {
                int indice = 0;
                while (indice < sp.getFabioFiles().size()) {
                    ((FabioFile)sp.getFabioFiles().elementAt(indice)).setFlag(true);
                    ++indice;
                }
            }
            ++n;
        }
        if (reset) {
            this.spdProcessor.fireShowFlag();
        }
    }

    private void EnableGrpExt() {
        this.grpspd_ext.setEnabled(true);
        this.btnCorExtNew.setEnabled(true);
        this.btnCorExtDefault.setEnabled(true);
        this.enableFieldOtherCorrection(this.btnCorExtNew.getSelection());
    }

    private void EnableGrpSrc() {
        this.grp_ExtensionFilter.setEnabled(true);
        this.chkTypeBruker.setEnabled(true);
        this.chkTypeEdf.setEnabled(true);
        this.chkTypeOther.setEnabled(true);
        this.enableFieldOther_src_ext(this.chkTypeOther.getSelection());
    }

    public void LockAll(boolean bLock) {
        this.setEnableGroup(this.applyCorrection, !bLock);
        this.setEnableGroup((Composite)this.grpOther, !bLock);
        if (bLock) {
            this.setDisableGroup((Composite)this.grpspd_ext);
            this.setDisableGroup((Composite)this.grp_ExtensionFilter);
            this.setDisableGroup((Composite)this.grpDistortion);
            this.setDisableGroup((Composite)this.grpFlood_spd);
            this.setDisableGroup((Composite)this.grpspd_dark);
            this.setDisableGroup((Composite)this.grpOther);
        } else {
            this.sendcontrolToDarkGroup();
            this.sendControlToFloodGroup();
            this.sendControlToDistGroup();
            this.EnableGrpExt();
            this.EnableGrpSrc();
        }
        ViewLocked = bLock;
        if (bLock) {
            statusManager.setMessage(this.imageLocked.createImage(), "Locked");
            if (this.spdProcessor.isM_bStatusProcessing()) {
                this.chkLock.setSelection(true);
                this.chkLock.setEnabled(false);
            } else {
                this.chkLock.setEnabled(true);
            }
            this.btnReset.setEnabled(false);
        } else {
            this.btnReset.setEnabled(true);
            statusManager.setMessage(this.imageUnLocked.createImage(), "Not locked");
            this.chkLock.setEnabled(true);
            this.chkLock.setSelection(false);
        }
        statusManager.update(true);
    }

    private void setImagebtnLaunch(boolean bisrunning) {
        Image imgplay = this.imagePlay.createImage();
        Image imgPause = this.imagePause.createImage();
        final Image imgplayScaled = new Image((Device)this.display, imgplay.getImageData().scaledTo((int)((double)imgplay.getBounds().width * 1.2), (int)((double)imgplay.getBounds().height * 1.2)));
        final Image imgPauseScaled = new Image((Device)this.display, imgPause.getImageData().scaledTo((int)((double)imgPause.getBounds().width * 1.2), (int)((double)imgPause.getBounds().height * 1.2)));
        if (!bisrunning) {
            this.btnValidate.setImage(imgplayScaled);
            this.btnValidate.setToolTipText("Start processing files");
        } else {
            this.btnValidate.setImage(imgPauseScaled);
            this.btnValidate.setToolTipText("Stop processing files");
        }
        this.btnValidate.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                imgPauseScaled.dispose();
                imgplayScaled.dispose();
            }
        });
    }

    public boolean checkFields(Composite parent, boolean bok) {
        Control[] element = parent.getChildren();
        int i = 0;
        while (i < element.length && bok) {
            if (element[i] instanceof Composite) {
                if (element[i] instanceof TypedText) {
                    TypedText text = (TypedText)element[i];
                    boolean bl = bok = text.is_bValide() && bok;
                    if (bok) {
                        if (text.is_isRequiredField()) {
                            boolean bl2 = bok = !text.getText().trim().equals("");
                            if (!bok) {
                                this.setPreprocessorErrorMessage("Field " + text.toString() + "is required.");
                            }
                        }
                    } else {
                        this.setPreprocessorErrorMessage("Field " + text.toString() + "is not valid." + text.getErrorMessage());
                    }
                } else {
                    bok = this.checkFields((Composite)element[i], bok);
                }
            }
            ++i;
        }
        return bok;
    }

    public boolean checkSelectedFiles() {
        boolean bok = false;
        if (this.spdProcessor.get_Samples() == null || this.spdProcessor.get_Samples().size() == 0) {
            bok = false;
        } else {
            Vector<Sample> s = this.spdProcessor.get_Samples();
            int i = 0;
            while (!bok && i < s.size()) {
                if (s.elementAt(i).HasFile()) {
                    bok = true;
                }
                ++i;
            }
        }
        if (!bok) {
            this.setPreprocessorErrorMessage("Please select files to process");
            this.spdProcessor.fireShowRequiredFields();
        }
        return bok;
    }

    public String getPreprocessorErrorMessage() {
        return this.preprocessorErrormessage;
    }

    public void setPreprocessorErrorMessage(String messageError) {
        this.preprocessorErrormessage = messageError;
    }

    private void createUpdateExperimentThread() {
        this.updateThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!SpdView.this.display.isDisposed()) {
                    SpdView.this.dataRetrieve = SpdView.this.retrieveExperimentData();
                    if (!SpdView.this.display.isDisposed()) {
                        SpdView.this.display.syncExec(new Runnable(){

                            public void run() {
                                if (!SpdView.this.display.isDisposed()) {
                                    SpdView.this.spdProcessor.setSample(new Sample(SpdView.this.experiment, SpdView.this.sampleName, SpdView.this.getSampleDirectory()));
                                }
                            }
                        });
                    }
                    if (!SpdView.this.spdProcessor.getM_mode().equals("ON")) {
                        try {
                            System.out.println("Search for on line experiment has been stopped");
                            Activator.log("Search for on line experiment has been stopped");
                            36 var1_1 = this;
                            synchronized (var1_1) {
                                this.wait();
                            }
                        }
                        catch (InterruptedException e) {
                            System.out.println("An InterruptedException has been thrown while trying to stand by update Thread :" + e.getMessage());
                            Activator.log("An InterruptedException has been thrown while trying to stand by update Thread :" + e.getMessage());
                            e.printStackTrace();
                        }
                        catch (Exception i) {
                            i.printStackTrace();
                            System.out.println("An exception has been thrown while trying to stand by update Thread :" + i.getMessage());
                            Activator.log("An exception has been thrown while trying to stand by update Thread :" + i.getMessage());
                        }
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        Activator.log("Error while thread sleeping ", 4, e);
                        SpdView.this.console.activate();
                        SpdView.this.console.displayIn("Error while 'experiment retreive data' thread sleeping");
                    }
                }
            }
        };
    }

    private boolean importBeamlineServer() {
        boolean bok = true;
        if (this.beamline == null) {
            try {
                this.beamline = new DeviceProxy("taco:id11/beamline/1");
                this.beamline.set_rpc_protocol(1);
                bok = true;
            }
            catch (DevFailed e) {
                Activator.log("Error new Device Proxy", 4, (Exception)((Object)e));
                this.console.activate();
                this.console.displayIn("ERROR accessing device Proxy :" + e.getMessage());
                bok = false;
            }
        }
        return bok;
    }

    private String getSampleDirectory() {
        String sampleDirectory = null;
        sampleDirectory = this.onLineDirectory;
        return sampleDirectory;
    }

    private void startUpdatExperimentDataThread() {
        if (this.updateThread == null) {
            this.createUpdateExperimentThread();
            this.updateThread.start();
        } else {
            this.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart() {
        try {
            Thread thread = this.updateThread;
            synchronized (thread) {
                this.updateThread.notifyAll();
            }
        }
        catch (Exception i) {
            System.out.println("An exception has been thrown while trying to wake up updateThread: " + i.getMessage());
            Activator.log("An exception has been thrown while trying to wake up updateThread: " + i.getMessage(), 4, i);
        }
    }

    private boolean retrieveExperimentData() {
        boolean bok = this.importBeamlineServer();
        if (bok) {
            String[] out_arr;
            DeviceData myData;
            String[] s_arr;
            DeviceData in;
            try {
                in = new DeviceData();
                s_arr = new String[]{"directory", "%"};
                in.insert(s_arr);
                myData = this.beamline.command_inout("DbQuerySettings", in);
                out_arr = myData.extractStringArray();
                this.onLineDirectory = out_arr[0];
            }
            catch (DevFailed e) {
                Activator.log("Error accessing database to retrieve current directory", 4, (Exception)((Object)e));
                this.console.activate();
                this.console.displayIn("Error accessing database to retrieve current directory");
                bok = false;
            }
            try {
                in = new DeviceData();
                s_arr = new String[]{"experiment", "%"};
                in.insert(s_arr);
                myData = this.beamline.command_inout("DbQuerySettings", in);
                out_arr = myData.extractStringArray();
                this.experiment = out_arr[0];
            }
            catch (DevFailed e) {
                Activator.log("Error accessing database to retrieve current experiment", 4, (Exception)((Object)e));
                this.console.activate();
                this.console.displayIn("Error accessing database to retrieve current experiment");
                bok = false;
            }
            try {
                in = new DeviceData();
                s_arr = new String[]{"sample", "%"};
                in.insert(s_arr);
                myData = this.beamline.command_inout("DbQuerySettings", in);
                out_arr = myData.extractStringArray();
                this.sampleName = out_arr[0];
            }
            catch (DevFailed e) {
                Activator.log("Error accessing database to retrieve current sample", 4, (Exception)((Object)e));
                this.console.activate();
                this.console.displayIn("Error accessing database to retrieve current sample");
                bok = false;
            }
        }
        return bok;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.array.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.array.remove(listener);
    }

    public void setTxtFileDark(String string) {
        this.darkFile.set_Text(string);
    }

    public void setTxtFileDist(String string) {
        this.distortionFile.set_Text(string);
    }

    public void setOtherSpdOption(String other) {
        this.otherSpdOption.setText(other);
    }

    private void setTxtFileFlood(String string) {
        this.floodFile.set_Text(string);
    }

    public boolean isLocked() {
        return this.chkLock.getSelection();
    }

    public void setSelectedMode(String sMode) {
        this.selectedMode = sMode;
        this.spdProcessor.setM_mode(sMode);
    }

    public void set_dark_ext(String dark_ext) {
        this.spdProcessor.set_dark_ext(dark_ext);
    }

    public void set_command(String str) {
        this.spdProcessor.setCommand(str);
    }

    public void set_DarkFile_mode(String mode) {
        this.radioNoDarkFile.setSelection(mode.equals("darkfileNoneRadio"));
        this.radioDarkFromFile.setSelection(mode.equals("darkFromFileRadio"));
        this.radioDarkInEdf.setSelection(mode.equals("darkHeaderRadio"));
        this.darkFile.setEnabled(mode.equals("darkFromFileRadio"));
        this.darkFile.set_isRequiredField(mode.equals("darkFromFileRadio"));
        this.darkFile.showrequired();
    }

    public void set_FloodFile_mode(String mode) {
        this.radioNoFloodFile.setSelection(mode.equals("floodfileNoneRadio"));
        this.radioFloodFromFile.setSelection(mode.equals("floodFromFileRadio"));
        this.radioFloodInEdf.setSelection(mode.equals("floodHeaderRadio"));
        this.floodFile.setEnabled(mode.equals("floodFromFileRadio"));
        this.floodFile.set_isRequiredField(mode.equals("floodFromFileRadio"));
        this.floodFile.showrequired();
    }

    public void set_DistFile_mode(String mode) {
        this.radioNoDistFile.setSelection(mode.equals("distfileNoneRadio"));
        this.radioDistFromFile.setSelection(mode.equals("distFromFileRadio"));
        this.radioDistInEdf.setSelection(mode.equals("distHeaderRadio"));
        this.darkFile.setEnabled(mode.equals("distFromFileRadio"));
        this.distortionFile.set_isRequiredField(mode.equals("distFromFileRadio"));
        this.distortionFile.showrequired();
    }

    public void setEnableGroup(Composite parent, boolean benable) {
        Control[] element = parent.getChildren();
        parent.setEnabled(benable);
        int i = 0;
        while (i < element.length) {
            if (element[i] instanceof Composite) {
                if (element[i] instanceof Group) {
                    this.setEnableGroup((Composite)element[i], benable);
                } else if (benable) {
                    element[i].setBackground(this.display.getSystemColor(1));
                } else {
                    element[i].setBackground(this.display.getSystemColor(22));
                }
            } else {
                element[i].setEnabled(benable);
            }
            ++i;
        }
    }

    public void setDisableGroup(Composite parent) {
        Control[] element = parent.getChildren();
        boolean benable = false;
        parent.setEnabled(benable);
        int i = 0;
        while (i < element.length) {
            if (element[i] instanceof Composite) {
                if (element[i] instanceof Group) {
                    this.setDisableGroup((Composite)element[i]);
                } else {
                    if (element[i] instanceof TypedText) {
                        ((TypedText)element[i]).set_isRequiredField(false);
                        ((TypedText)element[i]).showrequired();
                        ((TypedText)element[i]).set_bValide(true);
                        ((TypedText)element[i]).showError();
                    }
                    element[i].setBackground(this.display.getSystemColor(22));
                }
            } else {
                element[i].setEnabled(benable);
            }
            ++i;
        }
    }

    public Preprocessor getSpdProcessor() {
        return this.spdProcessor;
    }

    public String getSelectedMode() {
        return this.selectedMode;
    }

    public String getSampleName() {
        return this.sampleName;
    }

    public String getExperiment() {
        return this.experiment;
    }

    public String getOnLineDirectory() {
        return this.onLineDirectory;
    }

    public boolean isDataRetrieve() {
        return this.dataRetrieve;
    }

    public boolean isBSizeHasBeenChecked() {
        return this.bSizeHasBeenChecked;
    }

    public boolean isBSizeIsOk() {
        return this.bFloodFileSizeOk && this.bDarkSizeOk;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Composite getSpdComposite() {
        return this.spdComposite;
    }

    public Composite getApplyC() {
        return this.applyCorrection;
    }

    public Cursor getNormalCursor() {
        return this.normalCursor;
    }

    public Cursor getCurrentCursor() {
        return this.currentCursor;
    }

    public PreprocessorConsole getConsole() {
        return this.console;
    }

    public Button getChkLock() {
        return this.chkLock;
    }

    public Button getBtnReset() {
        return this.btnReset;
    }

    public String getSSampleDirectory() {
        return this.sSampleDirectory;
    }

    public Boolean getBtnApplyDark() {
        return this.btnApplyDark.getSelection();
    }

    public Boolean getBtnApplyFlood() {
        return this.btnApplyFlood.getSelection();
    }

    public Boolean getBtnApplyDist() {
        return this.btnApplyDist.getSelection();
    }

    public Boolean getChkTypeEdf() {
        return this.chkTypeEdf.getSelection();
    }

    public Boolean getChkTypeBruker() {
        return this.chkTypeBruker.getSelection();
    }

    public Boolean getChkTypeOther() {
        return this.chkTypeOther.getSelection();
    }

    public boolean getZip() {
        return this.compressOriginalFiles.getSelection();
    }

    public String getZipProgram() {
        return this.zipProgram.getText();
    }

    public String getTxtTypeOther() {
        return this.txtTypeOther.getText();
    }

    public String getCorExt() {
        return this.corExt.getText();
    }

    public boolean getCorExtDefault() {
        return this.btnCorExtDefault.getSelection();
    }

    public boolean getCorExtNew() {
        return this.btnCorExtNew.getSelection();
    }

    public String getDarkFile() {
        return this.darkFile.getText();
    }

    public FloatText getDarkConst() {
        return this.darkConst;
    }

    public StringText getDarkExt() {
        return this.darkExt;
    }

    public int getCboSaveDark() {
        return this.cboSaveDark.getSelectionIndex();
    }

    public Button getRadioDarkInEdf() {
        return this.radioDarkInEdf;
    }

    public Button getRadioDarkFromFile() {
        return this.radioDarkFromFile;
    }

    public boolean getRadioNoDarkFile() {
        return this.radioNoDarkFile.getSelection();
    }

    public boolean getRadioDistInEdf() {
        return this.radioDistInEdf.getSelection();
    }

    public boolean getRadioDistFromFile() {
        return this.radioDistFromFile.getSelection();
    }

    public boolean getRadioNoDistFile() {
        return this.radioNoDistFile.getSelection();
    }

    public boolean getRadioFloodInEdf() {
        return this.radioFloodInEdf.getSelection();
    }

    public boolean getRadioFloodFromFile() {
        return this.radioFloodFromFile.getSelection();
    }

    public boolean getRadioNoFloodFile() {
        return this.radioNoFloodFile.getSelection();
    }

    public boolean getOptionfloat() {
        return this.btn_float.getSelection();
    }

    public boolean getBtn_integer() {
        return this.btn_integer.getSelection();
    }

    public Float getInpConst() {
        return Float.valueOf(this.inpConst.getText());
    }

    public Float getInpExp() {
        return Float.valueOf(this.inpExp.getText());
    }

    public Float getInpFactor() {
        return Float.valueOf(this.inpFactor.getText());
    }

    public Integer getDvo() {
        return Integer.valueOf(this.dvo.getText());
    }

    public String getFloodFile() {
        return this.floodFile.getText();
    }

    public String getDistortionFile() {
        return this.distortionFile.getText();
    }

    public int getCboDoDist() {
        int action = 0;
        int selection = this.cboDoDist.getSelectionIndex();
        switch (selection) {
            case 0: {
                action = 1;
                break;
            }
            case 1: {
                action = 2;
                break;
            }
            case 2: {
                action = 3;
                break;
            }
        }
        return action;
    }

    public String getOtherSpdOption() {
        return this.otherSpdOption.getText();
    }

    public Button getBtnValidate() {
        return this.btnValidate;
    }

    public IPropertyChangeListener getPreferencesListener() {
        return this.preferencesListener;
    }

    public ImageDescriptor getImagePause() {
        return this.imagePause;
    }

    public ImageDescriptor getImagePlay() {
        return this.imagePlay;
    }

    public ImageDescriptor getImageReset() {
        return this.imageReset;
    }

    public ImageDescriptor getImageLocked() {
        return this.imageLocked;
    }

    public ImageDescriptor getImageUnLocked() {
        return this.imageUnLocked;
    }

    public void setSampleName(String name) {
        this.sampleName = name;
    }

    public void setExperiment(String exp) {
        this.experiment = exp;
    }

    public void setOnLineDirectory(String directory) {
        this.onLineDirectory = directory;
    }

    public void setDataRetrieve(boolean dtRetrieve) {
        this.dataRetrieve = dtRetrieve;
    }

    public void setBSizeHasBeenChecked(boolean sizeHasBeenChecked) {
        this.bSizeHasBeenChecked = sizeHasBeenChecked;
    }

    public void setDisplay(Display dis) {
        this.display = dis;
    }

    public void setApplyC(Composite applyC) {
        this.applyCorrection = applyC;
    }

    public void setNormalCursor(Cursor normal) {
        this.normalCursor = normal;
    }

    public void setCurrentCursor(Cursor current) {
        this.currentCursor = current;
    }

    public void setConsole(PreprocessorConsole myConsole) {
        this.console = myConsole;
    }

    public void setSSampleDirectory(String sampleDirectory) {
        this.sSampleDirectory = sampleDirectory;
    }

    public void setApplyDark(boolean selection) {
        this.btnApplyDark.setSelection(selection);
    }

    public void setApplyFlood(boolean selection) {
        this.btnApplyFlood.setSelection(selection);
    }

    public void setApplyDist(boolean selection) {
        this.btnApplyDist.setSelection(selection);
    }

    public void setChkTypeEdf(boolean selection) {
        this.chkTypeEdf.setSelection(selection);
    }

    public void setChkTypeBruker(boolean selection) {
        this.chkTypeBruker.setSelection(selection);
    }

    public void setChkTypeOther(boolean selection) {
        this.chkTypeOther.setSelection(selection);
    }

    public void setCompressOriginalFiles(boolean selected) {
        this.compressOriginalFiles.setSelection(selected);
    }

    public void setCompressCorrectedFiles(boolean selected) {
        this.compressCorrectedFiles.setSelection(selected);
    }

    public void setZipProgram(String prg) {
        this.zipProgram.set_Text(prg);
    }

    public void setTxtTypeOther(String other) {
        this.txtTypeOther.set_Text(other);
    }

    public void setCorExt(String txt) {
        this.corExt.set_Text(txt);
    }

    public void setBtnCorExtDefault(boolean selected) {
        this.btnCorExtDefault.setSelection(selected);
    }

    public void setBtnCorExtNew(boolean selected) {
        this.btnCorExtNew.setSelection(selected);
    }

    public void setDarkFile(String dark) {
        this.darkFile.set_Text(dark);
    }

    public void setDarkConst(Float optionConst) {
        this.darkConst.set_Text(String.valueOf(optionConst));
    }

    public void setDarkExt(String txt) {
        this.darkExt.set_Text(txt);
    }

    public void setCboSaveDark(int index) {
        this.cboSaveDark.select(index);
    }

    public void setRadioDarkInEdf(boolean selected) {
        this.radioDarkInEdf.setSelection(selected);
    }

    public void setRadioDarkFromFile(boolean selected) {
        this.radioDarkFromFile.setSelection(selected);
    }

    public void setRadioNoDarkFile(boolean selected) {
        this.radioNoDarkFile.setSelection(selected);
    }

    public void setRadioDistInEdf(boolean selected) {
        this.radioDistInEdf.setSelection(selected);
    }

    public void setRadioDistFromFile(boolean selected) {
        this.radioDistFromFile.setSelection(selected);
    }

    public void setRadioNoDistFile(boolean selected) {
        this.radioNoDistFile.setSelection(selected);
    }

    public void setRadioFloodInEdf(boolean selected) {
        this.radioFloodInEdf.setSelection(selected);
    }

    public void setRadioFloodFromFile(boolean selected) {
        this.radioFloodFromFile.setSelection(selected);
    }

    public void setRadioNoFloodFile(boolean selected) {
        this.radioNoFloodFile.setSelection(selected);
    }

    public void setOptionFloat(boolean selected) {
        this.btn_float.setSelection(selected);
    }

    public void setOptionInteger(boolean selected) {
        this.btn_integer.setSelection(selected);
    }

    public void setInpConst(Float inp_Const) {
        this.inpConst.set_Text(String.valueOf(inp_Const));
    }

    public void setInpExp(Float inp_Exp) {
        this.inpExp.set_Text(String.valueOf(inp_Exp));
    }

    public void setInpFactor(Float inp_factor) {
        this.inpFactor.set_Text(String.valueOf(inp_factor));
    }

    public void setDvo(Integer value) {
        this.dvo.set_Text(String.valueOf(value));
    }

    public void setFloodFile(String file) {
        this.floodFile.set_Text(file);
    }

    public void setDistortionFile(String file) {
        this.distortionFile.set_Text(file);
    }

    public void setCboDoDist(int index) {
        this.cboDoDist.select(index);
    }

    public void setPreferencesListener(IPropertyChangeListener prefListener) {
        this.preferencesListener = prefListener;
    }

    public static String getID() {
        return ID;
    }

    public void dispose() {
        this.spdProcessor.removePreprocessorListener(this.listenPreprocessorChanges);
        this.spdProcessor.removePropertyChangeListener(this);
    }

    class PreprocessListener
    implements IPreprocessorListener {
        PreprocessListener() {
        }

        public void preprocessorChanged(PreprocessorEvent pe) {
            RunAction runAction = new RunAction();
            if (((Preprocessor)pe.getSource()).isM_bStatusProcessing()) {
                SpdView.this.currentCursor = SpdView.this.waitCursor;
                runAction.setText("Stop");
            } else {
                SpdView.this.currentCursor = SpdView.this.normalCursor;
                runAction.setText("Run");
            }
            if (!SpdView.this.display.isDisposed()) {
                SpdView.this.display.syncExec(new Runnable(){

                    public void run() {
                        SpdView.this.setImagebtnLaunch(SpdView.this.spdProcessor.isM_bStatusProcessing());
                        SpdView.this.shell.setCursor(SpdView.this.currentCursor);
                        SpdView.this.LockAll(SpdView.this.spdProcessor.isM_bStatusProcessing());
                    }
                });
            }
        }

        public void preprocessorModeChange(PreprocessorEvent pe) {
            SpdView.this.selectedMode = ((Preprocessor)pe.getSource()).getM_mode();
            if (SpdView.this.selectedMode.equals("ON")) {
                SpdView.this.startUpdatExperimentDataThread();
            }
            ((Preprocessor)pe.getSource()).getM_mode().equals("OFF");
        }

        public void preprocessorNewMessage(PreprocessorEvent pe) {
        }

        public void preprocessorStateChange(PreprocessorEvent pe) {
        }

        public void preprocessorNewSample(PreprocessorEvent pe) {
            SpdView.this.checkSize();
        }
    }
}

