/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.console;

import fable.preprocessor.Activator;
import fable.preprocessor.process.IPreprocessorListener;
import fable.preprocessor.process.Preprocessor;
import fable.preprocessor.process.PreprocessorEvent;
import java.util.Date;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class PreprocessorConsole
extends MessageConsole {
    private MessageConsoleStream outMessageStream;
    private MessageConsoleStream inMessageStream;
    public static PreprocessorConsole thisConsole = null;
    public static final String ID = "fable.preprocessor.toolBox.preprocessorConsole";
    private static ImageDescriptor imageDescription = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/menu/preprocessor16x16.gif");
    static final int MAX_LENGTH = 70;
    private ListenerPreprocessor preprocessorListener;
    private Preprocessor myPreprocessor;

    public PreprocessorConsole() {
        super("Preprocessor messages", imageDescription);
        thisConsole = this;
        this.outMessageStream = this.newMessageStream();
        this.outMessageStream.setColor(Display.getCurrent().getSystemColor(10));
        this.inMessageStream = this.newMessageStream();
        this.inMessageStream.setColor(Display.getCurrent().getSystemColor(4));
        this.preprocessorListener = new ListenerPreprocessor();
        this.myPreprocessor = Preprocessor.getDefault();
        this.myPreprocessor.addPreprocessorListener(this.preprocessorListener);
    }

    public void displayIn(String message) {
        Date now = new Date();
        this.inMessageStream.println(String.valueOf(now.toString()) + " " + message);
    }

    public void displayOut(String message) {
        Date now = new Date();
        now.toString().length();
        message.length();
        String[] arrayOfWordsInMessage = message.split("\\p{Blank}");
        int i = 0;
        int nLen = 0;
        boolean bFirstLine = true;
        while (i < arrayOfWordsInMessage.length) {
            String myMessage = "";
            nLen = 0;
            while (nLen < 70 && i < arrayOfWordsInMessage.length) {
                myMessage = String.valueOf(myMessage) + " " + arrayOfWordsInMessage[i];
                ++i;
                nLen = myMessage.length();
            }
            if (bFirstLine) {
                this.outMessageStream.println(String.valueOf(now.toString()) + " " + myMessage);
                bFirstLine = false;
                continue;
            }
            this.outMessageStream.println("                  " + myMessage);
        }
    }

    class ListenerPreprocessor
    implements IPreprocessorListener {
        ListenerPreprocessor() {
        }

        public void preprocessorChanged(PreprocessorEvent pe) {
        }

        public void preprocessorModeChange(PreprocessorEvent pe) {
            if (((Preprocessor)pe.getSource()).getLogMessage().getM_Type() == 0) {
                PreprocessorConsole.this.displayIn(((Preprocessor)pe.getSource()).getLogMessage().getM_Message());
            } else {
                PreprocessorConsole.this.displayOut(((Preprocessor)pe.getSource()).getLogMessage().getM_Message());
            }
        }

        public void preprocessorNewMessage(PreprocessorEvent pe) {
            if (((Preprocessor)pe.getSource()).getLogMessage().getM_Type() == 0) {
                PreprocessorConsole.this.displayIn(((Preprocessor)pe.getSource()).getLogMessage().getM_Message());
            } else {
                PreprocessorConsole.this.displayOut(((Preprocessor)pe.getSource()).getLogMessage().getM_Message());
            }
        }

        public void preprocessorStateChange(PreprocessorEvent pe) {
        }

        public void preprocessorNewSample(PreprocessorEvent pe) {
        }
    }
}

