/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.actions;

import fable.preprocessor.Activator;
import fable.preprocessor.process.IPreprocessorListener;
import fable.preprocessor.process.Preprocessor;
import fable.preprocessor.process.PreprocessorEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class OnOfflineAction
extends Action
implements IWorkbenchWindowActionDelegate,
ISelectionListener {
    public static final String ID = "fable.preprocessor.actions.OnOfflineAction";
    private static boolean online;
    ListenerPreprocessorChange_ToolBar ListenPreprocessorChanges = new ListenerPreprocessorChange_ToolBar();
    private IWorkbenchWindow window;

    public OnOfflineAction() {
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setToolTipText("Switch to Online mode");
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/connected.gif"));
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (this.window != null) {
            this.window.getSelectionService().addSelectionListener((ISelectionListener)this);
        }
    }

    public void run() {
        this.runCommand();
    }

    private void runCommand() {
        if (online) {
            this.setToolTipText("Switch to Online mode");
            Preprocessor.getDefault().setM_mode("OFF");
            this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/offlineMode.gif"));
            online = false;
        } else {
            this.setToolTipText("Switch to Offline mode");
            Preprocessor.getDefault().setM_mode("ON");
            this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/connected.gif"));
            online = true;
        }
    }

    private void switchMode(boolean bModeOnLine) {
        if (bModeOnLine) {
            this.setToolTipText("Switch to Online mode");
            this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/onLineMode.gif"));
            online = false;
        } else {
            this.setToolTipText("Switch to Offline mode");
            this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/offlineMode.gif"));
            online = true;
        }
    }

    public void dispose() {
        Preprocessor.getDefault().removePreprocessorListener(this.ListenPreprocessorChanges);
        if (this.window != null) {
            this.window.getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
    }

    public void init(IWorkbenchWindow arg0) {
        online = false;
        Preprocessor.getDefault().addPreprocessorListener(this.ListenPreprocessorChanges);
    }

    public void run(IAction arg0) {
        this.runCommand();
    }

    public void selectionChanged(IAction arg0, ISelection arg1) {
        if (arg0.getId().equals(ID)) {
            if (arg0.isChecked()) {
                arg0.setText("Off");
                arg0.setToolTipText("Switch to online mode.");
                arg0.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/disconnected.gif"));
            } else {
                arg0.setText("On");
                arg0.setToolTipText("Switch to offline mode.");
                arg0.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/connected.gif"));
            }
        }
    }

    public void setWindow(IWorkbenchWindow window) {
        this.window = window;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    class ListenerPreprocessorChange_ToolBar
    implements IPreprocessorListener {
        ListenerPreprocessorChange_ToolBar() {
        }

        public void preprocessorModeChange(PreprocessorEvent pe) {
            OnOfflineAction.this.switchMode(!((Preprocessor)pe.getSource()).getM_mode().equals("ON"));
        }

        public void preprocessorChanged(PreprocessorEvent pe) {
        }

        public void preprocessorNewMessage(PreprocessorEvent pe) {
        }

        public void preprocessorStateChange(PreprocessorEvent pe) {
        }

        public void preprocessorNewSample(PreprocessorEvent pe) {
        }
    }
}

