/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.view;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.Sample;
import fable.framework.toolbox.ToolBox;
import fable.framework.toolbox.TypedText;
import fable.framework.views.FableMessageConsole;
import fable.framework.writer.Xmlwriter;
import fable.framework.writer.XmlwriterException;
import fable.framework.xmlparser.object.XmlParserException;
import fable.framework.xmlparser.object.Xmloption;
import fable.framework.xmlparser.views.Options;
import fable.peaksearch.Activator;
import fable.peaksearch.actions.LoadXmlOption;
import fable.peaksearch.actions.RunAction;
import fable.peaksearch.actions.SaveXmlOptions;
import fable.peaksearch.object.Peaksearch;
import fable.peaksearch.object.PeaksearchException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeaksearchView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID = "fable.peaksearch.view.PeaksearchView";
    private FableMessageConsole console;
    public static PeaksearchView view;
    private IPropertyChangeListener preferencesListener;
    private Peaksearch peaksearch;
    private Options guiOptionsBuilder;
    private Composite parentView;
    private Logger logger = FableLogger.getLogger(PeaksearchView.class);
    private Sample currentDirectory;
    private Action setDefaultvalues;
    private Action loadOptions;
    private Action saveOptions;
    private ImageDescriptor imageDefault = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/revert.gif");
    private ImageDescriptor imageLoad = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/loadOptions.gif");
    private ImageDescriptor saveImgDesc = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/saveoptions.gif");
    private SampleController controller = SampleController.getController();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.preferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("pref_ini_peaksearch")) {
                    try {
                        String iniFileName = Activator.getDefault().getPreferenceStore().getString("pref_ini_peaksearch");
                        PeaksearchView.this.peaksearch.loadIniFile(iniFileName);
                        Vector<Xmloption> v_options = PeaksearchView.this.peaksearch.getOptions();
                        int i = 0;
                        while (i < v_options.size()) {
                            Xmloption xmloption = v_options.elementAt(i);
                            PeaksearchView.this.guiOptionsBuilder.updateFields(null, (String)xmloption.getNode().get("option"), (String)xmloption.getNode().get("default"));
                            ++i;
                        }
                    }
                    catch (PeaksearchException e) {
                        PeaksearchView.this.logger.error((Object)e.getMessage());
                    }
                }
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferencesListener);
    }

    public void createPartControl(Composite parent) {
        block5: {
            view = this;
            this.controller.addPropertyChangeListener((IPropertyChangeListener)this);
            this.parentView = parent;
            this.getViewSite().getActionBars().setGlobalActionHandler("fable.peaksearch.actions.RunAction", (IAction)new RunAction());
            this.console = new FableMessageConsole("Peaksearch console");
            IOConsoleOutputStream stream = this.console.newOutputStream();
            System.setOut(new PrintStream((OutputStream)stream, true));
            System.setErr(new PrintStream((OutputStream)stream));
            try {
                this.peaksearch = Peaksearch.getPeaksearch();
                this.peaksearch.setSamples(this.controller.getSamples());
            }
            catch (PeaksearchException e) {
                this.console.displayIn(e.getMessage());
            }
            catch (JepException e) {
                this.console.displayIn(e.getMessage());
            }
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
            this.console.displayOut("Welcome to Peaksearch " + ToolBox.getPluginVersion((String)"fable.peaksearch"));
            this.peaksearch.addPropertyChangeListener(this);
            try {
                this.guiOptionsBuilder = new Options(parent, this.peaksearch.getOptions());
                this.guiOptionsBuilder.addListener((IPropertyChangeListener)this);
            }
            catch (XmlParserException e) {
                if (this.console == null) break block5;
                this.console.displayIn("Peaksearch is not able to load its preferred  file to build option view.");
                this.logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.makeActions();
        this.contributeToActionBars();
    }

    public void setFocus() {
        if (this.controller != null) {
            this.currentDirectory = this.controller.getCurrentsample();
            if (this.currentDirectory != null) {
                this.updateGuiWithCurrentSelection();
            }
        }
    }

    public void initFields() {
    }

    public void dispose() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferencesListener);
        this.controller.removePropertyChangeListener((IPropertyChangeListener)this);
        this.peaksearch.removePropertyrChangeListener(this);
        super.dispose();
    }

    private void makeActions() {
        this.setDefaultvalues = new Action(){

            public void run() {
                PeaksearchView.this.guiOptionsBuilder.resetFields();
            }
        };
        this.setDefaultvalues.setText("Restore default values");
        this.setDefaultvalues.setToolTipText("Restore default values");
        this.setDefaultvalues.setImageDescriptor(this.imageDefault);
        this.saveOptions = new SaveXmlOptions();
        this.saveOptions.setText("Save current options");
        this.saveOptions.setToolTipText("Save current options");
        this.saveOptions.setImageDescriptor(this.saveImgDesc);
        this.loadOptions = new LoadXmlOption();
        this.loadOptions.setText("Load options");
        this.loadOptions.setToolTipText("Load your options by selecting a file (.xml)");
        this.loadOptions.setImageDescriptor(this.imageLoad);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.saveOptions);
        manager.add((IAction)this.loadOptions);
        manager.add((IAction)this.setDefaultvalues);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.saveOptions);
        manager.add((IAction)this.loadOptions);
        manager.add((IAction)this.setDefaultvalues);
    }

    public void propertyChange(PropertyChangeEvent event) {
        block14: {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block17: {
                                String val;
                                String property_label;
                                block22: {
                                    block21: {
                                        block20: {
                                            block19: {
                                                block18: {
                                                    block16: {
                                                        block15: {
                                                            block13: {
                                                                if (!event.getProperty().equals("start")) break block13;
                                                                if (this.validateView()) {
                                                                    this.peaksearch.run();
                                                                    this.logger.info((Object)"PeakSearch running test from PeakSearchView");
                                                                    this.console.displayOut("PeakSearch is running");
                                                                } else {
                                                                    this.logger.warn((Object)"PeakSearch is not valid");
                                                                }
                                                                break block14;
                                                            }
                                                            if (!event.getProperty().equals("quit")) break block15;
                                                            if (!this.peaksearch.isRunning()) break block14;
                                                            this.peaksearch.forceQuit();
                                                            break block14;
                                                        }
                                                        if (!event.getProperty().equals("stop")) break block16;
                                                        if (this.peaksearch.hasBeenCanceled()) {
                                                            this.logger.info((Object)"PeakSearch has been cancelled.");
                                                            this.console.displayOut("Peaksearch has been cancelled.");
                                                            this.guiOptionsBuilder.stop();
                                                        } else {
                                                            this.guiOptionsBuilder.stop();
                                                            this.logger.info((Object)"PeakSearch has finished.");
                                                            this.console.displayInfo("PeakSearch has finished.");
                                                            this.console.displayInfo("For each peaks searching, one filtered Peak file (.flt) per threshold and one 2d Peak file (.spt) per threshold have been created in the image directory or in your Outfile directory (see you options).");
                                                            this.console.displayInfo("You can either calibrate filtered Peak file in Transformation, or plots spots in menu peaksearch/open 3D Peak file(.flt), or displays 2d peaks on images in menu peaksearch/open 2D Peak file(.spt).");
                                                        }
                                                        break block14;
                                                    }
                                                    if (!event.getProperty().equals("fieldChanged")) break block17;
                                                    if (this.currentDirectory == null) break block14;
                                                    property_label = (String)event.getOldValue();
                                                    val = (String)event.getNewValue();
                                                    if (!property_label.equals("first")) break block18;
                                                    try {
                                                        int nval = Integer.valueOf(val);
                                                        this.currentDirectory.setFirst(nval);
                                                    }
                                                    catch (NumberFormatException numberFormatException) {}
                                                    break block14;
                                                }
                                                if (!property_label.equals("last")) break block19;
                                                try {
                                                    int nval = Integer.valueOf(val);
                                                    this.currentDirectory.setlast(Integer.valueOf(nval).intValue());
                                                }
                                                catch (NumberFormatException numberFormatException) {}
                                                break block14;
                                            }
                                            if (!property_label.equals("stem")) break block20;
                                            this.currentDirectory.set_name(val);
                                            break block14;
                                        }
                                        if (!property_label.equals("format")) break block21;
                                        this.currentDirectory.setFileFormat(val);
                                        break block14;
                                    }
                                    if (!property_label.equals("ndigits")) break block22;
                                    this.currentDirectory.setNDigits(val);
                                    break block14;
                                }
                                if (!property_label.equals("outfile")) break block14;
                                this.currentDirectory.setPeaksearchOutfile(val);
                                break block14;
                            }
                            if (!event.getProperty().equals("currentSample")) break block23;
                            this.currentDirectory = this.controller.getCurrentsample();
                            if (this.currentDirectory != null) {
                                this.updateGuiWithCurrentSelection();
                            } else {
                                this.guiOptionsBuilder.setCurrentPath("");
                                this.guiOptionsBuilder.updateFields("stem", null);
                                this.guiOptionsBuilder.updateFields("first", null);
                                this.guiOptionsBuilder.updateFields("last", null);
                                this.guiOptionsBuilder.updateFields("format", null);
                                this.guiOptionsBuilder.updateFields("ndigits", null);
                                this.guiOptionsBuilder.updateFields("outfile", null);
                            }
                            break block14;
                        }
                        if (!event.getProperty().equals("setOptions")) break block24;
                        this.guiOptionsBuilder.setOptions();
                        break block14;
                    }
                    if (!event.getProperty().equals("unvalidate")) break block25;
                    this.peaksearch.firePeakSearchStops();
                    TypedText field = (TypedText)event.getNewValue();
                    this.console.displayIn("Please check options :" + ((Xmloption)field.getData()).getOption());
                    break block14;
                }
                if (!event.getProperty().equals("load_ini")) break block26;
                Vector<Xmloption> v_options = this.peaksearch.getOptions();
                int i = 0;
                while (i < v_options.size()) {
                    Xmloption xmloption = v_options.elementAt(i);
                    this.guiOptionsBuilder.loadOptions(null, xmloption);
                    ++i;
                }
                break block14;
            }
            if (!event.getProperty().equals("save_ini")) break block14;
            try {
                this.guiOptionsBuilder.storeDefaultOptions();
                new Xmlwriter("root", "option", (String)event.getNewValue(), this.peaksearch.getOptions());
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Peaksearch ini file", (String)"Load fields value in default tag");
            }
            catch (XmlwriterException e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)e.getMessage());
            }
        }
    }

    private void updateGuiWithCurrentSelection() {
        this.guiOptionsBuilder.updateFields(null, "stem", this.currentDirectory != null ? this.currentDirectory.getStem() : null);
        this.guiOptionsBuilder.setCurrentPath(this.currentDirectory.get_directoryPath());
        this.guiOptionsBuilder.updateFields(null, "first", this.currentDirectory != null ? String.valueOf(this.currentDirectory.getFirst()) : null);
        this.guiOptionsBuilder.updateFields(null, "last", this.currentDirectory != null ? String.valueOf(this.currentDirectory.getLast()) : null);
        this.guiOptionsBuilder.updateFields(null, "format", this.currentDirectory != null ? this.currentDirectory.getFileFormat() : null);
        this.guiOptionsBuilder.updateFields("ndigits", this.currentDirectory != null ? this.currentDirectory.getNDigits() : null);
        String defaultOutFile = this.guiOptionsBuilder.getdefaultValue("outfile");
        if (this.currentDirectory.getPeaksearchoutStem().equals("")) {
            this.currentDirectory.setPeaksearchOutfile(defaultOutFile);
        } else {
            this.guiOptionsBuilder.updateFields("outfile", this.currentDirectory != null ? this.currentDirectory.getPeaksearchoutStem() : defaultOutFile);
        }
    }

    public boolean validateView() {
        return this.guiOptionsBuilder.launch();
    }

    public void iniFields(String iniFile) throws PeaksearchException {
        this.peaksearch.loadIniFile(iniFile);
    }

    public Vector<Xmloption> getValues() {
        return this.guiOptionsBuilder.getOptions();
    }

    public TypedText getUnValidField() {
        return this.guiOptionsBuilder.getCurrentNonValidField();
    }

    public Vector<Xmloption> getOptions() {
        return this.guiOptionsBuilder.getOptions();
    }
}

