/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.actions;

import fable.framework.toolbox.ToolBox;
import fable.peaksearch.object.Peaksearch;
import fable.peaksearch.object.PeaksearchException;
import jep.JepException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class LoadXmlOption
extends Action
implements IWorkbenchWindowActionDelegate {
    private static final String ID = "fable.peaksearch.actions.LoadXmlOption";
    String[] filterName = new String[]{".xml", "All(*.*)"};
    String[] filterExt = new String[]{"*.xml", "*.*;*"};
    Shell shell;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.shell = window.getShell();
        this.loadDeafultOption();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run() {
        this.shell = Display.getDefault().getActiveShell();
        this.loadDeafultOption();
    }

    private void loadDeafultOption() {
        FileDialog load = new FileDialog(this.shell, 64);
        load.setFilterNames(this.filterName);
        load.setFilterExtensions(this.filterExt);
        try {
            String xml;
            IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWindow != null) {
                if (ToolBox.isSmallPerspectiveSet()) {
                    activeWindow.getWorkbench().showPerspective("fable.peaksearch.perspective.smallScreen", activeWindow);
                } else {
                    activeWindow.getWorkbench().showPerspective("fable.peaksearch.perspective", activeWindow);
                }
            }
            if ((xml = load.open()) != null) {
                Peaksearch.getPeaksearch(xml).loadIniFile(xml);
                MessageDialog.openInformation((Shell)this.shell, (String)"Peaksearch ini file", (String)"Your option file for peaksearch has been loaded");
            }
        }
        catch (PeaksearchException e) {
            MessageDialog.openError((Shell)this.shell, (String)"Peaksearch error message", (String)e.getMessage());
        }
        catch (JepException e) {
            MessageDialog.openError((Shell)this.shell, (String)"Peaksearch error message", (String)e.getMessage());
        }
        catch (WorkbenchException workbenchException) {
            MessageDialog.openError((Shell)this.shell, (String)"Peaksearch error message", (String)"Perspective for peaksearch can not be opened");
        }
    }

    public static String getID() {
        return ID;
    }
}

