/*
 * Decompiled with CFR 0.152.
 */
package fable.transformation.views;

import fable.framework.toolbox.FileText;
import fable.transformation.Activator;
import fable.transformation.actions.AddUnitCellPeaksAction;
import fable.transformation.actions.ComputeHistProbAction;
import fable.transformation.actions.ComputeTthEtaAction;
import fable.transformation.actions.ComputegveAction;
import fable.transformtion.object.Transform;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class ParamView
extends ViewPart
implements IPropertyChangeListener,
ISaveablePart {
    public static final String ID = "fable.transformation.views.paramview";
    Transform transform;
    private IMemento memento = null;
    public String currentPathParam;
    Button buttonSave;
    Button buttonApply;
    Button buttonReset;
    private Composite mainComposite;
    private IPropertyChangeListener preferencesListener;
    FileText fileParameters;
    Group global;
    private Action saveAction;
    private Action applyParameters;
    private ImageDescriptor apply_imageDescr = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"./images/check.gif");
    private ImageDescriptor save_imageDescr = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"./images/saveoptions.gif");
    private ImageDescriptor revert_imageDescr = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"./images/undo.gif");
    protected boolean dirty = false;
    final Image temp1 = this.revert_imageDescr.createImage();
    final Image temp2 = this.apply_imageDescr.createImage();
    final Image image_save = this.save_imageDescr.createImage();
    final Image image_apply = new Image((Device)Display.getCurrent(), this.temp2.getImageData().scaledTo(16, 16));
    final Image image_revert = new Image((Device)Display.getCurrent(), this.temp1.getImageData().scaledTo(16, 16));

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString("PARS_FILE_PATH", this.currentPathParam);
    }

    public void createPartControl(Composite parent) {
        this.preferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("pref_parameters_file")) {
                    ParamView.this.loadfileParameter(Activator.getDefault().getPreferenceStore().getString("pref_parameters_file"));
                    ParamView.this.fileParameters.set_Text(ParamView.this.transform.getParamFileName());
                }
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferencesListener);
        ScrolledComposite sc = new ScrolledComposite(parent, 512);
        this.mainComposite = new Composite((Composite)sc, 20);
        this.mainComposite.setLayout((Layout)new FillLayout());
        this.global = new Group(this.mainComposite, 20);
        this.global.setLayout((Layout)new GridLayout(3, false));
        this.global.setLayoutData((Object)new GridData(20, 16, true, false));
        this.global.setText("Parameters");
        this.transform = Transform.getTransformer();
        this.transform.editParameters();
        this.transform.addPropertyChangeListener(this);
        if (this.memento != null) {
            this.currentPathParam = this.memento.getString("PARS_FILE_PATH");
        }
        this.fileParameters = new FileText((Composite)this.global, 0, "Parameters file");
        this.fileParameters.set_Text(this.transform.getParamFileName());
        this.fileParameters.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fileParameters.setToolTipText("Load parameters file for calibration");
        Button btn_browse = new Button((Composite)this.global, 8);
        btn_browse.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        btn_browse.setText("Browse...");
        this.fileParameters.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    String txt = ParamView.this.fileParameters.getText();
                    ParamView.this.currentPathParam = txt.substring(0, txt.lastIndexOf(System.getProperty("file.separator")));
                    System.out.println(ParamView.this.currentPathParam);
                    ParamView.this.loadfileParameter(txt);
                }
            }
        });
        btn_browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(((Button)e.widget).getParent().getShell(), 64);
                dlg.setFilterPath(ParamView.this.currentPathParam);
                dlg.setFilterNames(new String[]{"*.par, *.pars, *.prm", "All Files (*.*)"});
                dlg.setFilterExtensions(new String[]{"*.par;*.pars;*.prm", "*.*"});
                String sFile = dlg.open();
                if (sFile != null) {
                    ParamView.this.fileParameters.set_Text(sFile);
                    ParamView.this.currentPathParam = dlg.getFilterPath();
                    ParamView.this.loadfileParameter(sFile);
                }
            }
        });
        if (this.transform.getpars() != null) {
            TreeMap<String, Object> map = new TreeMap<String, Object>(this.transform.getpars());
            Set entryS = map.entrySet();
            for (Map.Entry e : entryS) {
                String key = (String)e.getKey();
                Label label = new Label((Composite)this.global, 0);
                String help = this.transform.getparsHelp().get((String)e.getKey());
                label.setToolTipText(help);
                label.setText((String)e.getKey());
                Text txt = new Text((Composite)this.global, 2048);
                GridData gdText = new GridData(4, 0x1000000, true, false);
                gdText.horizontalSpan = 1;
                txt.setLayoutData((Object)gdText);
                txt.setData((Object)key);
                txt.setData(key, e.getValue());
                txt.setData("restore", e.getValue());
                txt.setText(e.getValue().toString());
                txt.setToolTipText(help);
                txt.addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                        if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                            ParamView.this.applyParameters();
                        }
                    }

                    public void keyReleased(KeyEvent e) {
                        ParamView.this.firePropertyChange(257);
                    }
                });
                if (this.transform.getPossVary().get(key) != null) {
                    Button btnCheck = new Button((Composite)this.global, 32);
                    btnCheck.setToolTipText("Possible vary for : " + key);
                    btnCheck.setSelection(this.transform.getPossVary().get(key).booleanValue());
                    btnCheck.setData((Object)((String)e.getKey()));
                    btnCheck.setData("restore", (Object)this.transform.getPossVary().get(key));
                    continue;
                }
                new Label((Composite)this.global, 0);
            }
        }
        GridData gd1 = new GridData(128);
        GridData gd2 = new GridData(32);
        this.buttonReset = new Button((Composite)this.global, 8);
        this.buttonReset.setLayoutData((Object)gd2);
        this.buttonReset.setToolTipText("Restore initials values and vary");
        this.buttonReset.setImage(this.image_revert);
        this.buttonReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParamView.this.restoreValues();
            }
        });
        this.buttonReset.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ParamView.this.image_revert != null && !ParamView.this.image_revert.isDisposed()) {
                    ParamView.this.image_revert.dispose();
                }
            }
        });
        this.buttonSave = new Button((Composite)this.global, 8);
        this.buttonSave.setLayoutData((Object)gd1);
        this.buttonSave.setImage(this.image_save);
        this.buttonSave.setToolTipText("save parameters in a file");
        this.buttonSave.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ParamView.this.image_save != null && !ParamView.this.image_save.isDisposed()) {
                    ParamView.this.image_save.dispose();
                }
            }
        });
        this.buttonSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParamView.this.saveParameters();
            }
        });
        this.buttonApply = new Button((Composite)this.global, 8);
        this.buttonApply.setLayoutData((Object)gd1);
        this.buttonApply.setToolTipText("Apply");
        this.buttonApply.setImage(this.image_apply);
        this.buttonApply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParamView.this.applyParameters();
            }
        });
        this.buttonApply.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ParamView.this.image_apply != null && !ParamView.this.image_apply.isDisposed()) {
                    ParamView.this.image_apply.dispose();
                }
            }
        });
        sc.setContent((Control)this.mainComposite);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        sc.setMinSize(this.global.computeSize(0, -1));
        this.makeActions();
        this.contributeToActionBars();
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputeTthEtaAction", (IAction)new ComputeTthEtaAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.AddUnitCellPeaksAction", (IAction)new AddUnitCellPeaksAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputeHistProbAction", (IAction)new ComputeHistProbAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputegveAction", (IAction)new ComputegveAction());
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.saveAction);
        manager.add((IAction)this.applyParameters);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.applyParameters);
        manager.add((IAction)this.saveAction);
    }

    private void makeActions() {
        this.saveAction = new Action(){

            public void run() {
                ParamView.this.saveParameters();
            }
        };
        this.applyParameters = new Action(){

            public void run() {
                ParamView.this.applyParameters();
            }
        };
        this.saveAction.setText("Save parameters");
        this.saveAction.setToolTipText("Save parameters in a file (*.par, *.pars, *.prm)");
        this.saveAction.setImageDescriptor(this.save_imageDescr);
        this.applyParameters.setText("Apply parameters.");
        this.applyParameters.setToolTipText("Apply parameters and display changes in the view");
        this.applyParameters.setImageDescriptor(this.apply_imageDescr);
    }

    private void loadfileParameter(String sFile) {
        if (this.fileParameters.is_bValide()) {
            this.transform.loadFileParameters(sFile);
            this.transform.editParameters();
        }
    }

    public void setFocus() {
    }

    public boolean applyParameters() {
        boolean bok = false;
        Vector<String> vars = new Vector<String>(1);
        Control[] element = this.global.getChildren();
        if (Transform.getTransformer().getpars() != null) {
            HashMap<String, Object> map = this.transform.getpars();
            int i = 0;
            while (i < element.length) {
                Button btn;
                if (element[i] instanceof Text) {
                    Text txt = (Text)element[i];
                    if (txt.getData() != null) {
                        map.put((String)txt.getData(), new String(txt.getText()));
                    }
                } else if (element[i] instanceof Button && (btn = (Button)element[i]).getData() != null && btn.getSelection()) {
                    vars.add((String)btn.getData());
                }
                ++i;
            }
            bok = Transform.getTransformer().set_parameters(vars.toArray(), map);
        }
        return bok;
    }

    private void restoreValues() {
        Control[] element = this.global.getChildren();
        boolean found = false;
        if (Transform.getTransformer().getpars() != null) {
            TreeMap<String, Object> map = new TreeMap<String, Object>(this.transform.getpars());
            Set entryS = map.entrySet();
            Iterator it = entryS.iterator();
            while (it.hasNext()) {
                found = false;
                Map.Entry e = it.next();
                int i = 0;
                while (!found && i < element.length) {
                    Button btn;
                    if (element[i] instanceof Text) {
                        Text txt = (Text)element[i];
                        if (txt.getData((String)e.getKey()) != null) {
                            found = true;
                            txt.setText(txt.getData("restore").toString());
                        }
                    } else if (element[i] instanceof Button && ((btn = (Button)element[i]).getStyle() & 0x20) == 32) {
                        btn.setSelection(((Boolean)btn.getData("restore")).booleanValue());
                    }
                    ++i;
                }
            }
        }
    }

    private void updateFields() {
        if (!this.global.isDisposed()) {
            Control[] element = this.global.getChildren();
            boolean found = false;
            if (Transform.getTransformer().getpars() != null) {
                TreeMap<String, Object> map = new TreeMap<String, Object>(this.transform.getpars());
                Set entryS = map.entrySet();
                Iterator it = entryS.iterator();
                while (it.hasNext()) {
                    found = false;
                    Map.Entry e = it.next();
                    int i = 0;
                    while (!found && i < element.length) {
                        String key;
                        Text txt;
                        if (element[i] instanceof Text && (txt = (Text)element[i]).getData(key = (String)e.getKey()) != null) {
                            found = true;
                            txt.setData((Object)key);
                            txt.setData(key, e.getValue());
                            txt.setData("restore", e.getValue());
                            txt.setText(e.getValue().toString());
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public void saveParameters() {
        if (this.applyParameters()) {
            FileDialog fileDlg = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
            String[] filterExt = new String[]{"*.par", "*.*"};
            String[] filterNames = new String[]{"parameter files (*.par)", "All Files (*.*)"};
            fileDlg.setFilterExtensions(filterExt);
            fileDlg.setFilterNames(filterNames);
            fileDlg.setText("Save parameters in an existing ini file or enter a new file name");
            String file = fileDlg.open();
            if (file != null) {
                file = String.valueOf(fileDlg.getFilterPath()) + System.getProperty("file.separator") + fileDlg.getFileName();
                Transform.getTransformer().saveParameters(file);
                this.fileParameters.set_Text(file);
            }
        } else {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Save parameters error", (String)"Fable transform application couldn't get values in field and/or update transform.py");
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.saveParameters();
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
        this.saveParameters();
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public void dispose() {
        if (this.temp1 != null && !this.temp1.isDisposed()) {
            this.temp1.dispose();
        }
        if (this.temp2 != null && !this.temp2.isDisposed()) {
            this.temp2.dispose();
        }
        if (this.image_save != null && !this.image_save.isDisposed()) {
            this.image_save.dispose();
        }
        if (this.image_apply != null && !this.image_apply.isDisposed()) {
            this.image_apply.dispose();
        }
        if (this.image_revert != null && !this.image_revert.isDisposed()) {
            this.image_revert.dispose();
        }
        this.transform.removePropertyChangeListener(this);
    }

    public void removePropertyListener(IPropertyListener l) {
        super.removePropertyListener(l);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("refresh")) {
            this.updateFields();
            this.fileParameters.set_Text(this.transform.getParamFileName());
        } else if (event.getProperty().equals("currentProjectPath")) {
            this.currentPathParam = (String)event.getNewValue();
        }
    }
}

