/*
 * Decompiled with CFR 0.152.
 */
package fable.polyxsim.views;

import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.IntegerText;
import fable.framework.toolbox.LookAndFeel;
import fable.framework.toolbox.StringText;
import fable.framework.ui.views.JmolView;
import fable.framework.views.FableMessageConsole;
import fable.polyxsim.internal.IVarKeys;
import fable.polyxsim.internal.PolyXSim;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.ViewPart;

public class PolyXSimInputView
extends ViewPart {
    public static final String ID = "fable.polyxsim.views.polyxsiminputview";
    private static Composite parent;
    private static Shell shell;
    public static PolyXSimInputView view;
    private static FloatText wavelengthFloatText;
    private static FloatText fluxFloatText;
    private static FloatText polarisationFactorFloatText;
    private static FloatText polarisationDirectionFloatText;
    private static FloatText beamCenterZFloatText;
    private static FloatText beamCenterYFloatText;
    private static FloatText pixelSizeZFloatText;
    private static FloatText pixelSizeYFloatText;
    private static FloatText detSizeYFloatText;
    private static FloatText detSizeZFloatText;
    private static FloatText samp2DetFloatText;
    private static FloatText detTiltXFloatText;
    private static FloatText detTiltYFloatText;
    private static FloatText detTiltZFloatText;
    private static Combo o11Combo;
    private static Combo o12Combo;
    private static Combo o21Combo;
    private static Combo o22Combo;
    private static Combo omegaDirectionCombo;
    private static FloatText wedgeFloatText;
    private static FloatText omegaMinFloatText;
    private static FloatText omegaMaxFloatText;
    private static FloatText omegaStepFloatText;
    private static FloatText grainNumFloatText;
    private static FloatText[] phaseGrainSizeFloatText;
    private static FloatText[] phaseGrainMinSizeFloatText;
    private static FloatText[] phaseGrainMaxSizeFloatText;
    private static Button grainOrientationButton;
    private static Button grainPositionButton;
    private static FloatText sampleXFloatText;
    private static FloatText sampleYFloatText;
    private static FloatText sampleZFloatText;
    private static FloatText[] unitCellAFloatText;
    private static FloatText[] unitCellBFloatText;
    private static FloatText[] unitCellCFloatText;
    private static FloatText[] unitCellAlphaFloatText;
    private static FloatText[] unitCellBetaFloatText;
    private static FloatText[] unitCellGammaFloatText;
    private static StringText[] structureFileText;
    private static Button[] structureFileViewButton;
    private static StringText inputFileFileText;
    private static Button imageFlagButton;
    private static StringText imageStemFileText;
    private static Combo fileFormatCombo;
    private static Button addNoiseButton;
    private static FloatText backgroundCountsFloatText;
    private static Button psfButton;
    private static Button outputFltButton;
    private static Button outputGveButton;
    private static Button outputUbiButton;
    private static Button outputParButton;
    private static Text inputFileText;
    private TabFolder tabFolder;
    private TabItem[] tabItem = new TabItem[6];
    private static Composite[] container;
    private ScrolledComposite[] scrolledComposite = new ScrolledComposite[6];
    static Button outputFileBrowseButton;
    GridLayout gridLayout;
    private static Combo intensityCombo;
    private static Button lorentzFactorButton;
    private static Button polarisationButton;
    private static Combo peakTypeCombo;
    private static FloatText gaussianPeakPixelsFloatText;
    private static FloatText gaussianPeakDegreesFloatText;
    private static Combo odfTypeCombo;
    private static StringText odfFileStringText;
    private static FloatText mosaicityFloatText;
    private FloatText sampleHeightFloatText;
    private FloatText sampleDiameterFloatText;
    private static String[] structureFiles;
    private static Float[] unitCell;
    private Button addPhaseButton;
    private Button deletePhaseButton;
    private static Group grainSizeGroup;
    private static Combo sampleShapeCombo;
    private static Combo[] phaseDistributionCombo;
    private static IntegerText phasesNumIntegerText;
    private static int numPhases;
    private static Group structureFileGroup;
    private static Group unitCellGroup;
    private static Button structureFileButton;
    private static Button structureCellButton;
    private static String inputFileDirectory;
    private static Button[] structureFileBrowseButton;
    private static IntegerText[] phaseNumGrainsIntegerText;
    private static Label[] phaseLabel;
    private static Integer[] phaseGrains;
    private static Integer[] phases;
    private static Float[] phaseGrainSize;
    private static Float[] phaseGrainMinSize;
    private static Float[] phaseGrainMaxSize;
    static final int FILES_TAB = 0;
    static final int CRYSTAL_TAB = 1;
    static final int SAMPLE_TAB = 2;
    static final int REFLECTIONS_TAB = 3;
    static final int INSTRUMENTAL_TAB = 4;
    static final int DETECTOR_TAB = 5;

    static {
        structureFileText = null;
        structureFileViewButton = null;
        container = new Composite[6];
        structureFiles = null;
        unitCell = null;
        phaseDistributionCombo = null;
        numPhases = 1;
        phaseLabel = null;
        phaseGrains = null;
        phases = null;
        phaseGrainSize = null;
        phaseGrainMinSize = null;
        phaseGrainMaxSize = null;
    }

    public void createPartControl(Composite _parent) {
        parent = _parent;
        shell = parent.getShell();
        view = this;
        GridLayout oneColGridLayout = new GridLayout();
        oneColGridLayout.numColumns = 1;
        oneColGridLayout.makeColumnsEqualWidth = true;
        GridLayout twoColGridLayout = new GridLayout();
        twoColGridLayout.numColumns = 2;
        twoColGridLayout.makeColumnsEqualWidth = true;
        this.tabFolder = new TabFolder(parent, 2560);
        this.tabFolder.setLayout((Layout)oneColGridLayout);
        int i = 0;
        while (i < container.length) {
            this.scrolledComposite[i] = new ScrolledComposite((Composite)this.tabFolder, 2816);
            PolyXSimInputView.container[i] = new Composite((Composite)this.scrolledComposite[i], 20);
            container[i].setLayout((Layout)oneColGridLayout);
            container[i].setLayoutData((Object)new GridData(4, 4, true, true));
            this.scrolledComposite[i].setContent((Control)container[i]);
            this.scrolledComposite[i].setMinSize(800, 500);
            this.scrolledComposite[i].setExpandHorizontal(true);
            this.scrolledComposite[i].setExpandVertical(true);
            ++i;
        }
        i = 0;
        while (i < this.tabItem.length) {
            this.tabItem[i] = new TabItem(this.tabFolder, 20);
            this.tabItem[i].setControl((Control)this.scrolledComposite[i]);
            ++i;
        }
        this.createFileTab();
        this.createCrystalPhasesTab();
        this.createSampleTab();
        this.createReflectionsTab();
        this.createInstrumentalTab();
        this.createDetectorTab();
        this.setHelpContextIDs();
    }

    private void createFileTab() {
        this.tabItem[0].setText("Files");
        Group outputFileGroup = LookAndFeel.getGroup((Composite)container[0], (String)"Output", (int)6, (int)1);
        GridLayout outputFileGroupLayout = new GridLayout();
        outputFileGroupLayout.numColumns = 6;
        outputFileGroupLayout.makeColumnsEqualWidth = true;
        outputFileGroup.setLayout((Layout)outputFileGroupLayout);
        imageFlagButton = new Button((Composite)outputFileGroup, 32);
        imageFlagButton.setText("Images in format");
        imageFlagButton.setToolTipText("Generate images during simulation");
        imageFlagButton.setLayoutData((Object)new GridData(4, 4, false, true));
        fileFormatCombo = new Combo((Composite)outputFileGroup, 8);
        fileFormatCombo.setLayoutData((Object)new GridData(16, 16, false, false));
        fileFormatCombo.setToolTipText("Image file format");
        fileFormatCombo.add("tif");
        fileFormatCombo.add("tif16bit");
        fileFormatCombo.add("edf");
        fileFormatCombo.setText("tif");
        outputFltButton = new Button((Composite)outputFileGroup, 32);
        outputFltButton.setText("Filtered peaks");
        outputFltButton.setToolTipText("Filtered peaks .flt file");
        outputFltButton.setLayoutData((Object)new GridData(4, 16, true, true));
        outputGveButton = new Button((Composite)outputFileGroup, 32);
        outputGveButton.setText("Scattering vectors");
        outputGveButton.setToolTipText("Scattering vectors .gve file");
        outputGveButton.setLayoutData((Object)new GridData(4, 16, true, true));
        outputUbiButton = new Button((Composite)outputFileGroup, 32);
        outputUbiButton.setText("Grain orientation");
        outputUbiButton.setToolTipText("Grain orientation .ubi file");
        outputUbiButton.setLayoutData((Object)new GridData(4, 16, true, true));
        outputParButton = new Button((Composite)outputFileGroup, 32);
        outputParButton.setText("Parameters");
        outputParButton.setToolTipText("ImageD11 parameters .par file");
        outputParButton.setLayoutData((Object)new GridData(4, 16, true, true));
        imageStemFileText = new StringText((Composite)outputFileGroup, 0, "File stem");
        GridData imageStemGridData = new GridData(4, 16, true, true);
        imageStemGridData.horizontalSpan = 5;
        imageStemFileText.setLayoutData((Object)imageStemGridData);
        Button imageStemBrowseButton = new Button((Composite)outputFileGroup, 8);
        imageStemBrowseButton.setText("Browse");
        imageStemBrowseButton.setToolTipText("Select or enter the image stem directory file");
        imageStemBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4096);
                directoryDialog.setText("Select an existing directory or enter a new directory name");
                String file = directoryDialog.open();
                if (file != null) {
                    imageStemFileText.set_Text(file);
                }
            }
        });
        Group inputFileGroup = LookAndFeel.getGroup((Composite)container[0], (String)"Input", (int)3, (int)1);
        inputFileFileText = new StringText((Composite)inputFileGroup, 0, "Input file");
        inputFileFileText.set_isRequiredField(true);
        inputFileFileText.setLayoutData((Object)new GridData(4, 4, true, true));
        Button inputFileBrowseButton = new Button((Composite)inputFileGroup, 8);
        inputFileBrowseButton.setText("Browse");
        inputFileBrowseButton.setToolTipText("Select or enter an input parameter file");
        inputFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDlg = new FileDialog(new Shell(), 0);
                fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_INPUT);
                fileDlg.setFilterNames(IVarKeys.FILTER_EXTS_INPUT);
                fileDlg.setText("Select an existing Farfield Simulation input file or enter a new file name");
                String file = fileDlg.open();
                if (file != null) {
                    FableMessageConsole.console.displayOut("read farfield simulation input file " + file);
                    PolyXSimInputView.loadInputFile(file);
                    PolyXSim.loadInputFile(file);
                    PolyXSimInputView.getInputValues();
                }
            }
        });
        outputFileBrowseButton = new Button((Composite)inputFileGroup, 8);
        outputFileBrowseButton.setText("Save as");
        outputFileBrowseButton.setToolTipText("Select or enter an output parameter file");
        outputFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDlg = new FileDialog(new Shell(), 0);
                fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_INPUT);
                fileDlg.setFilterNames(IVarKeys.FILTER_EXTS_INPUT);
                fileDlg.setText("Select an existing Farfield Simulation input file");
                String file = fileDlg.open();
                if (file != null) {
                    FableMessageConsole.console.displayOut("write farfield simulation input file " + file);
                    PolyXSimInputView.this.writeInputFile(file);
                }
            }
        });
        outputFileBrowseButton.setEnabled(false);
        GridData inputFileGridData = new GridData(4, 4, true, true);
        inputFileText = new Text(container[0], 2882);
        inputFileText.setText("Input file contents will be displayed here ...");
        inputFileText.setLayoutData((Object)inputFileGridData);
        inputFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                outputFileBrowseButton.setEnabled(true);
            }
        });
    }

    public void createCrystalPhasesTab() {
        this.tabItem[1].setText("Crystal Phases");
        Group grainGroup = LookAndFeel.getGroup((Composite)container[1], (String)"Structure phases", (int)3, (int)1);
        this.gridLayout = (GridLayout)grainGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        phasesNumIntegerText = new IntegerText((Composite)grainGroup, 8, "Number of phases in sample");
        phasesNumIntegerText.setToolTipText("Number of structure phases");
        phasesNumIntegerText.set_isRequiredField(true);
        phasesNumIntegerText.setLayoutData((Object)new GridData(4, 16, true, true));
        phasesNumIntegerText.setEnabled(false);
        this.addPhaseButton = new Button((Composite)grainGroup, 8);
        this.addPhaseButton.setText("Add phase");
        this.addPhaseButton.setToolTipText("Add new phase");
        this.addPhaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                numPhases = numPhases + 1;
                phasesNumIntegerText.set_Text(Integer.toString(numPhases));
                PolyXSimInputView.this.deletePhaseButton.setEnabled(true);
                PolyXSimInputView.createPhaseGrains();
                PolyXSimInputView.createStructureFileGroup();
                int i = 0;
                while (i < PolyXSim.getNumPhases()) {
                    if (PolyXSim.getStructureFile(i) != null) {
                        structureFileText[i].set_Text(PolyXSim.getStructureFile(i));
                    }
                    ++i;
                }
                PolyXSimInputView.createUnitCellGroup();
            }
        });
        this.deletePhaseButton = new Button((Composite)grainGroup, 8);
        this.deletePhaseButton.setText("Delete phase");
        this.deletePhaseButton.setToolTipText("Delete last phase");
        this.deletePhaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (numPhases > 1) {
                    numPhases = numPhases - 1;
                    phasesNumIntegerText.set_Text(Integer.toString(numPhases));
                    PolyXSimInputView.createStructureFileGroup();
                    PolyXSimInputView.createUnitCellGroup();
                    PolyXSimInputView.createPhaseGrains();
                    if (numPhases <= 1) {
                        PolyXSimInputView.this.deletePhaseButton.setEnabled(false);
                    }
                }
            }
        });
        structureFileButton = new Button((Composite)grainGroup, 16);
        structureFileButton.setText("Read structure from file (cif or pdb)");
        structureCellButton = new Button((Composite)grainGroup, 16);
        structureCellButton.setText("Choose space group and specify unit cell");
        structureFileGroup = LookAndFeel.getGroup((Composite)container[1], (String)"Structure file(s)", (int)3, (int)1);
        structureCellButton.setSelection(false);
        structureFileButton.setSelection(true);
        new Label((Composite)grainGroup, 0);
        this.gridLayout = (GridLayout)structureFileGroup.getLayout();
        structureFiles = new String[numPhases];
        PolyXSimInputView.createStructureFileGroup();
        structureFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (structureFileButton.getSelection()) {
                    PolyXSimInputView.this.setEnableGroup(structureFileGroup, true);
                    PolyXSimInputView.this.setEnableGroup(unitCellGroup, false);
                } else {
                    PolyXSimInputView.this.setEnableGroup(structureFileGroup, false);
                    PolyXSimInputView.this.setEnableGroup(unitCellGroup, true);
                }
                PolyXSimInputView.createStructureFileGroup();
                PolyXSimInputView.createUnitCellGroup();
            }
        });
        unitCellGroup = LookAndFeel.getGroup((Composite)container[1], (String)"Unit cell(s)", (int)6, (int)1);
        this.gridLayout = (GridLayout)unitCellGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        unitCell = new Float[numPhases];
        PolyXSimInputView.createUnitCellGroup();
        structureCellButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (structureCellButton.getSelection()) {
                    PolyXSimInputView.this.setEnableGroup(structureFileGroup, false);
                    PolyXSimInputView.this.setEnableGroup(unitCellGroup, true);
                } else {
                    PolyXSimInputView.this.setEnableGroup(structureFileGroup, true);
                    PolyXSimInputView.this.setEnableGroup(unitCellGroup, false);
                }
                PolyXSimInputView.createStructureFileGroup();
                PolyXSimInputView.createUnitCellGroup();
            }
        });
        this.setEnableGroup(structureFileGroup, true);
        this.setEnableGroup(unitCellGroup, false);
    }

    private static void createStructureFileGroup() {
        int i;
        if (structureFileText != null) {
            structureFiles = new String[numPhases];
            i = 0;
            while (i < structureFileText.length) {
                if (i < structureFiles.length) {
                    PolyXSimInputView.structureFiles[i] = structureFileText[i].getText();
                }
                structureFileText[i].dispose();
                structureFileViewButton[i].dispose();
                structureFileBrowseButton[i].dispose();
                ++i;
            }
            structureFileText = null;
            structureFileViewButton = null;
            structureFileViewButton = null;
        }
        if (structureFileButton.getSelection()) {
            structureFileText = new StringText[numPhases];
            structureFileViewButton = new Button[numPhases];
            structureFileBrowseButton = new Button[numPhases];
            i = 0;
            while (i < numPhases) {
                PolyXSimInputView.structureFileText[i] = new StringText((Composite)structureFileGroup, 0, "Structure file for phase " + i);
                if (i < structureFiles.length && structureFiles[i] != null) {
                    structureFileText[i].set_Text(structureFiles[i]);
                }
                structureFileText[i].setLayoutData((Object)new GridData(4, 16, true, true));
                PolyXSimInputView.structureFileBrowseButton[i] = new Button((Composite)structureFileGroup, 8);
                structureFileBrowseButton[i].setText("Browse");
                structureFileBrowseButton[i].setToolTipText("Browse structure file");
                structureFileBrowseButton[i].setData((Object)i);
                structureFileBrowseButton[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Integer iStructureFile = (Integer)event.widget.getData();
                        FileDialog fileDialog = new FileDialog(shell, 4096);
                        fileDialog.setText("Select an existing structure file");
                        String file = fileDialog.open();
                        if (file != null) {
                            structureFiles[iStructureFile.intValue()] = file;
                            structureFileText[iStructureFile].set_Text(file);
                        }
                    }
                });
                PolyXSimInputView.structureFileViewButton[i] = new Button((Composite)structureFileGroup, 8);
                structureFileViewButton[i].setText("View");
                structureFileViewButton[i].setToolTipText("View 3D structure");
                structureFileViewButton[i].setData((Object)i);
                structureFileViewButton[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Integer iStructureFile = (Integer)event.widget.getData();
                        String structureFile = structureFileText[iStructureFile].getText();
                        PolyXSimInputView.openJmolView(structureFile);
                    }
                });
                ++i;
            }
        }
        structureFileGroup.pack();
        container[1].pack();
    }

    private static void createUnitCellGroup() {
        int i;
        if (unitCellAFloatText != null) {
            unitCell = new Float[numPhases * 6];
            i = 0;
            while (i < unitCellAFloatText.length) {
                if ((i + 1) * 6 <= unitCell.length) {
                    PolyXSimInputView.unitCell[i * 6] = unitCellAFloatText[i].getValue();
                    PolyXSimInputView.unitCell[i * 6 + 1] = unitCellBFloatText[i].getValue();
                    PolyXSimInputView.unitCell[i * 6 + 2] = unitCellCFloatText[i].getValue();
                    PolyXSimInputView.unitCell[i * 6 + 3] = unitCellAlphaFloatText[i].getValue();
                    PolyXSimInputView.unitCell[i * 6 + 4] = unitCellBetaFloatText[i].getValue();
                    PolyXSimInputView.unitCell[i * 6 + 5] = unitCellGammaFloatText[i].getValue();
                }
                unitCellAFloatText[i].dispose();
                unitCellBFloatText[i].dispose();
                unitCellCFloatText[i].dispose();
                unitCellAlphaFloatText[i].dispose();
                unitCellBetaFloatText[i].dispose();
                unitCellGammaFloatText[i].dispose();
                ++i;
            }
            unitCellAFloatText = null;
            unitCellBFloatText = null;
            unitCellCFloatText = null;
            unitCellAlphaFloatText = null;
            unitCellBetaFloatText = null;
            unitCellGammaFloatText = null;
        }
        if (structureCellButton.getSelection()) {
            unitCellAFloatText = new FloatText[numPhases];
            unitCellBFloatText = new FloatText[numPhases];
            unitCellCFloatText = new FloatText[numPhases];
            unitCellAlphaFloatText = new FloatText[numPhases];
            unitCellBetaFloatText = new FloatText[numPhases];
            unitCellGammaFloatText = new FloatText[numPhases];
            i = 0;
            while (i < numPhases) {
                PolyXSimInputView.unitCellAFloatText[i] = new FloatText((Composite)unitCellGroup, 0, "a (\u212b)");
                unitCellAFloatText[i].set_isRequiredField(true);
                unitCellAFloatText[i].setToolTipText("Unit cell a axis in Angstroms");
                unitCellAFloatText[i].setLayoutData((Object)new GridData(4, 16, true, true));
                PolyXSimInputView.unitCellBFloatText[i] = new FloatText((Composite)unitCellGroup, 0, "b (\u212b)");
                unitCellBFloatText[i].set_isRequiredField(true);
                unitCellBFloatText[i].setToolTipText("Unit cell b axis in Angstroms");
                unitCellBFloatText[i].setLayoutData((Object)new GridData(4, 16, true, true));
                PolyXSimInputView.unitCellCFloatText[i] = new FloatText((Composite)unitCellGroup, 0, "c (\u212b)");
                unitCellCFloatText[i].set_isRequiredField(true);
                unitCellCFloatText[i].setToolTipText("Unit cell c axis in Angstroms");
                unitCellCFloatText[i].setLayoutData((Object)new GridData(4, 16, true, true));
                PolyXSimInputView.unitCellAlphaFloatText[i] = new FloatText((Composite)unitCellGroup, 0, "\u03b1 (\u00b0)");
                unitCellAlphaFloatText[i].set_isRequiredField(true);
                unitCellAlphaFloatText[i].setToolTipText("Unit cell alpha angle in degrees");
                unitCellAlphaFloatText[i].setLayoutData((Object)new GridData(4, 16, true, true));
                PolyXSimInputView.unitCellBetaFloatText[i] = new FloatText((Composite)unitCellGroup, 0, "\u03b2 (\u00b0)");
                unitCellBetaFloatText[i].set_isRequiredField(true);
                unitCellBetaFloatText[i].setToolTipText("Unit cell beta angle in degrees");
                unitCellBetaFloatText[i].setLayoutData((Object)new GridData(4, 16, true, true));
                PolyXSimInputView.unitCellGammaFloatText[i] = new FloatText((Composite)unitCellGroup, 0, "\u03b3 (\u00b0)");
                unitCellGammaFloatText[i].set_isRequiredField(true);
                unitCellGammaFloatText[i].setToolTipText("Unit cell gamma angle in degrees");
                unitCellGammaFloatText[i].setLayoutData((Object)new GridData(4, 16, true, true));
                if ((i + 1) * 6 <= unitCell.length) {
                    if (unitCell[i * 6] != null) {
                        unitCellAFloatText[i].set_Text(Float.toString(unitCell[i * 6].floatValue()));
                    }
                    if (unitCell[i * 6 + 1] != null) {
                        unitCellBFloatText[i].set_Text(Float.toString(unitCell[i * 6 + 1].floatValue()));
                    }
                    if (unitCell[i * 6 + 2] != null) {
                        unitCellCFloatText[i].set_Text(Float.toString(unitCell[i * 6 + 2].floatValue()));
                    }
                    if (unitCell[i * 6 + 3] != null) {
                        unitCellAlphaFloatText[i].set_Text(Float.toString(unitCell[i * 6 + 3].floatValue()));
                    }
                    if (unitCell[i * 6 + 4] != null) {
                        unitCellBetaFloatText[i].set_Text(Float.toString(unitCell[i * 6 + 4].floatValue()));
                    }
                    if (unitCell[i * 6 + 5] != null) {
                        unitCellGammaFloatText[i].set_Text(Float.toString(unitCell[i * 6 + 5].floatValue()));
                    }
                }
                ++i;
            }
        }
        unitCellGroup.pack();
        container[1].pack();
    }

    public void createSampleTab() {
        this.tabItem[2].setText("Sample");
        Group sampleGroup = LookAndFeel.getGroup((Composite)container[2], (String)"Sample", (int)2, (int)1);
        this.gridLayout = (GridLayout)sampleGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        Composite sampleShapeComposite = new Composite((Composite)sampleGroup, 0);
        sampleShapeComposite.setLayout((Layout)new GridLayout());
        this.gridLayout = (GridLayout)sampleShapeComposite.getLayout();
        this.gridLayout.numColumns = 2;
        this.gridLayout.makeColumnsEqualWidth = true;
        sampleShapeComposite.setLayoutData((Object)new GridData(4, 16, true, false));
        Label sampleShapeLabel = new Label(sampleShapeComposite, 0);
        sampleShapeLabel.setLayoutData((Object)new GridData(16, 16, true, false));
        sampleShapeLabel.setText("Sample shape");
        sampleShapeCombo = new Combo(sampleShapeComposite, 8);
        sampleShapeCombo.setLayoutData((Object)new GridData(16, 0x1000000, true, false));
        sampleShapeCombo.add("cylinder");
        sampleShapeCombo.add("box");
        new Label((Composite)sampleGroup, 0);
        final Group sampleBoxGroup = LookAndFeel.getGroup((Composite)sampleGroup, (String)"Box dimensions", (int)3, (int)1);
        this.gridLayout = (GridLayout)sampleGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        sampleXFloatText = new FloatText((Composite)sampleBoxGroup, 0, "X (mm)");
        sampleXFloatText.set_isRequiredField(true);
        sampleXFloatText.setToolTipText("X sample size in mm");
        sampleXFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        sampleYFloatText = new FloatText((Composite)sampleBoxGroup, 0, "Y (mm)");
        sampleYFloatText.set_isRequiredField(true);
        sampleYFloatText.setToolTipText("Y sample size in mm");
        sampleYFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        sampleZFloatText = new FloatText((Composite)sampleBoxGroup, 0, "Z (mm)");
        sampleZFloatText.set_isRequiredField(true);
        sampleZFloatText.setToolTipText("Z sample size in mm");
        sampleZFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        final Group sampleCylinderGroup = LookAndFeel.getGroup((Composite)sampleGroup, (String)"Cylinder dimensions", (int)2, (int)1);
        this.gridLayout = (GridLayout)sampleGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        this.sampleHeightFloatText = new FloatText((Composite)sampleCylinderGroup, 0, "Diameter (mm)");
        this.sampleHeightFloatText.set_isRequiredField(true);
        this.sampleHeightFloatText.setToolTipText("Sample diameter in mm");
        this.sampleHeightFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        this.sampleDiameterFloatText = new FloatText((Composite)sampleCylinderGroup, 0, "Height (mm)");
        this.sampleDiameterFloatText.set_isRequiredField(true);
        this.sampleDiameterFloatText.setToolTipText("Sample height in mm");
        this.sampleDiameterFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        sampleShapeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String shape = sampleShapeCombo.getText();
                if (shape.equalsIgnoreCase("cylinder")) {
                    PolyXSimInputView.this.setEnableGroup(sampleBoxGroup, false);
                    PolyXSimInputView.this.setEnableGroup(sampleCylinderGroup, true);
                } else {
                    PolyXSimInputView.this.setEnableGroup(sampleBoxGroup, true);
                    PolyXSimInputView.this.setEnableGroup(sampleCylinderGroup, false);
                }
            }
        });
        sampleShapeCombo.setText("box");
        Group grainGroup = LookAndFeel.getGroup((Composite)container[2], (String)"Grains", (int)3, (int)1);
        this.gridLayout = (GridLayout)grainGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        grainNumFloatText = new FloatText((Composite)grainGroup, 0, "Total number of grains");
        grainNumFloatText.setToolTipText("Total number of grains");
        grainNumFloatText.set_isRequiredField(true);
        grainNumFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        new Label((Composite)grainGroup, 0);
        new Label((Composite)grainGroup, 0);
        grainSizeGroup = LookAndFeel.getGroup((Composite)grainGroup, (String)"Size(s)", (int)6, (int)1);
        GridData grainSizeGridData = new GridData(4, 16, true, true);
        grainSizeGridData.horizontalSpan = 4;
        grainSizeGroup.setLayoutData((Object)grainSizeGridData);
        grainPositionButton = new Button((Composite)grainSizeGroup, 32);
        grainPositionButton.setText("Generate size(s)");
        grainPositionButton.setToolTipText("Generate grain positions");
        Label dummyLabel6 = new Label((Composite)grainSizeGroup, 0);
        GridData dummyLabel6GridData = new GridData(16, 16, true, false);
        dummyLabel6GridData.horizontalSpan = 5;
        dummyLabel6.setLayoutData((Object)dummyLabel6GridData);
        PolyXSimInputView.createPhaseGrains();
        Group grainOrientationGroup = LookAndFeel.getGroup((Composite)grainGroup, (String)"Orientation(s)", (int)10, (int)1);
        this.gridLayout = (GridLayout)grainOrientationGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        grainOrientationButton = new Button((Composite)grainOrientationGroup, 32);
        grainOrientationButton.setText("Generate");
        grainOrientationButton.setToolTipText("Generate grain orientations");
        Label dummyLabel5 = new Label((Composite)grainOrientationGroup, 0);
        GridData dummyLabel5GridData = new GridData(16, 16, true, false);
        dummyLabel5GridData.horizontalSpan = 9;
        dummyLabel5.setLayoutData((Object)dummyLabel5GridData);
    }

    private static void createPhaseGrains() {
        int i;
        if (phaseLabel != null) {
            i = 0;
            while (i < phaseLabel.length) {
                phaseLabel[i].dispose();
                phaseNumGrainsIntegerText[i].dispose();
                phaseDistributionCombo[i].dispose();
                phaseGrainSizeFloatText[i].dispose();
                phaseGrainMinSizeFloatText[i].dispose();
                phaseGrainMaxSizeFloatText[i].dispose();
                ++i;
            }
        }
        phaseLabel = new Label[numPhases];
        phaseNumGrainsIntegerText = new IntegerText[numPhases];
        phaseDistributionCombo = new Combo[numPhases];
        phaseGrainSizeFloatText = new FloatText[numPhases];
        phaseGrainMinSizeFloatText = new FloatText[numPhases];
        phaseGrainMaxSizeFloatText = new FloatText[numPhases];
        i = 0;
        while (i < numPhases) {
            PolyXSimInputView.phaseLabel[i] = new Label((Composite)grainSizeGroup, 0);
            phaseLabel[i].setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            phaseLabel[i].setText("Phase " + i);
            PolyXSimInputView.phaseNumGrainsIntegerText[i] = new IntegerText((Composite)grainSizeGroup, 0, "Grains");
            phaseNumGrainsIntegerText[i].setToolTipText("Number of grains in this phase");
            phaseNumGrainsIntegerText[i].set_isRequiredField(true);
            phaseNumGrainsIntegerText[i].setLayoutData((Object)new GridData(4, 16, true, true));
            PolyXSimInputView.phaseDistributionCombo[i] = new Combo((Composite)grainSizeGroup, 8);
            phaseDistributionCombo[i].setLayoutData((Object)new GridData(16, 0x1000000, true, true));
            phaseDistributionCombo[i].add("fixed");
            phaseDistributionCombo[i].add("lognormal");
            phaseDistributionCombo[i].setText("lognormal");
            phaseDistributionCombo[i].setToolTipText("Grain size distribution");
            PolyXSimInputView.phaseGrainSizeFloatText[i] = new FloatText((Composite)grainSizeGroup, 0, "Median");
            phaseGrainSizeFloatText[i].setToolTipText("Median grain size for log normal distribution");
            phaseGrainSizeFloatText[i].set_isRequiredField(true);
            phaseGrainSizeFloatText[i].setLayoutData((Object)new GridData(4, 16, true, true));
            PolyXSimInputView.phaseGrainMinSizeFloatText[i] = new FloatText((Composite)grainSizeGroup, 0, "Min");
            phaseGrainMinSizeFloatText[i].setToolTipText("Minimum grain cutoff size");
            phaseGrainMinSizeFloatText[i].set_isRequiredField(true);
            phaseGrainMinSizeFloatText[i].setLayoutData((Object)new GridData(4, 16, true, true));
            PolyXSimInputView.phaseGrainMaxSizeFloatText[i] = new FloatText((Composite)grainSizeGroup, 0, "Max");
            phaseGrainMaxSizeFloatText[i].setToolTipText("Maximum grain cutoff size");
            phaseGrainMaxSizeFloatText[i].set_isRequiredField(true);
            phaseGrainMaxSizeFloatText[i].setLayoutData((Object)new GridData(4, 16, true, true));
            ++i;
        }
        grainSizeGroup.pack();
        container[2].pack();
    }

    public void createReflectionsTab() {
        this.tabItem[3].setText("Reflections");
        Group reflectionGroup = LookAndFeel.getGroup((Composite)container[3], (String)"Reflection intensities", (int)4, (int)1);
        this.gridLayout = (GridLayout)reflectionGroup.getLayout();
        this.gridLayout.numColumns = 4;
        this.gridLayout.makeColumnsEqualWidth = true;
        reflectionGroup.setLayout((Layout)this.gridLayout);
        Label intensityLabel = new Label((Composite)reflectionGroup, 0x1000000);
        intensityLabel.setText("Intensity");
        intensityLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        intensityCombo = new Combo((Composite)reflectionGroup, 8);
        intensityCombo.setLayoutData((Object)new GridData(16, 16, true, false));
        intensityCombo.add("constant");
        intensityCombo.add("structure factors");
        intensityCombo.setText("structure factors");
        lorentzFactorButton = new Button((Composite)reflectionGroup, 32);
        lorentzFactorButton.setText("Apply Lorentz factor");
        lorentzFactorButton.setLayoutData((Object)new GridData(16, 16, true, false));
        polarisationButton = new Button((Composite)reflectionGroup, 32);
        polarisationButton.setText("Apply beam polarisation");
        polarisationButton.setLayoutData((Object)new GridData(16, 16, true, false));
        Group diffractionPeaksGroup = LookAndFeel.getGroup((Composite)container[3], (String)"Diffraction peaks", (int)2, (int)1);
        this.gridLayout = (GridLayout)diffractionPeaksGroup.getLayout();
        this.gridLayout.numColumns = 2;
        this.gridLayout.makeColumnsEqualWidth = true;
        diffractionPeaksGroup.setLayout((Layout)this.gridLayout);
        Label peakTypeLabel = new Label((Composite)diffractionPeaksGroup, 0x1000000);
        peakTypeLabel.setText("Peak type");
        peakTypeLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        peakTypeCombo = new Combo((Composite)diffractionPeaksGroup, 8);
        peakTypeCombo.setLayoutData((Object)new GridData(16, 16, true, false));
        peakTypeCombo.add("spike 2x2 square");
        peakTypeCombo.add("Gaussian");
        peakTypeCombo.add("ODF");
        peakTypeCombo.setText("spike 2x2 square");
        Group guassianPeakGroup = LookAndFeel.getGroup((Composite)diffractionPeaksGroup, (String)"Gaussian peak parameters", (int)2, (int)1);
        guassianPeakGroup.setLayoutData((Object)new GridData(16, 16, true, false));
        gaussianPeakPixelsFloatText = new FloatText((Composite)guassianPeakGroup, 0, "FWHM (pixels)");
        gaussianPeakPixelsFloatText.set_isRequiredField(true);
        gaussianPeakPixelsFloatText.setToolTipText("Guassian peak spread in pixels");
        gaussianPeakPixelsFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        gaussianPeakDegreesFloatText = new FloatText((Composite)guassianPeakGroup, 0, "FWHM (degrees)");
        gaussianPeakDegreesFloatText.set_isRequiredField(true);
        gaussianPeakDegreesFloatText.setToolTipText("Guassian peak spread in degrees");
        gaussianPeakDegreesFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Group odfPeakGroup = LookAndFeel.getGroup((Composite)diffractionPeaksGroup, (String)"Orientation distribution function", (int)3, (int)1);
        odfPeakGroup.setLayoutData((Object)new GridData(16, 16, true, false));
        odfTypeCombo = new Combo((Composite)odfPeakGroup, 8);
        odfTypeCombo.setLayoutData((Object)new GridData(16, 16, true, true));
        odfTypeCombo.add("isotropic Gaussian");
        odfTypeCombo.add("grid from file");
        odfTypeCombo.setText("isotropic Gaussian");
        odfFileStringText = new StringText((Composite)odfPeakGroup, 0, "ODF file");
        odfFileStringText.set_isRequiredField(true);
        odfFileStringText.setToolTipText("ODF file grid");
        odfFileStringText.setLayoutData((Object)new GridData(4, 16, true, true));
        mosaicityFloatText = new FloatText((Composite)odfPeakGroup, 0, "Mosaicity (degrees)");
        mosaicityFloatText.set_isRequiredField(true);
        mosaicityFloatText.setToolTipText("Mosaicity in degrees");
        mosaicityFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
    }

    public void createInstrumentalTab() {
        this.tabItem[4].setText("Instrumental");
        Group beamGroup = LookAndFeel.getGroup((Composite)container[4], (String)"Beam", (int)4, (int)1);
        Label wavelengthLabel = new Label((Composite)beamGroup, 0);
        wavelengthLabel.setText("Wavelength (angstrom)");
        wavelengthFloatText = new FloatText((Composite)beamGroup, 0, "");
        wavelengthFloatText.set_isRequiredField(true);
        wavelengthFloatText.setToolTipText("wavelength in Angstrom");
        wavelengthFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Label fluxLabel = new Label((Composite)beamGroup, 0);
        fluxLabel.setText("Flux (ph/s/mm2)");
        fluxFloatText = new FloatText((Composite)beamGroup, 0, "");
        fluxFloatText.set_isRequiredField(true);
        fluxFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Label polarisationFactorLabel = new Label((Composite)beamGroup, 0);
        polarisationFactorLabel.setText("Polarisation factor (percent)");
        polarisationFactorFloatText = new FloatText((Composite)beamGroup, 0, "");
        polarisationFactorFloatText.set_isRequiredField(true);
        polarisationFactorFloatText.setToolTipText("polarisation factor in percent");
        polarisationFactorFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Label polarisationDirectionLabel = new Label((Composite)beamGroup, 0);
        polarisationDirectionLabel.setText("Polarisation direction (degrees)");
        polarisationDirectionFloatText = new FloatText((Composite)beamGroup, 0, "");
        polarisationDirectionFloatText.set_isRequiredField(true);
        polarisationDirectionFloatText.setToolTipText("polarisation direction in degrees");
        polarisationDirectionFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Group beamCenterGroup = LookAndFeel.getGroup((Composite)container[4], (String)"Beam center on detector", (int)4, (int)1);
        Label beamCenterYLabel = new Label((Composite)beamCenterGroup, 0);
        beamCenterYLabel.setText("Y beam (pixels)");
        beamCenterYFloatText = new FloatText((Composite)beamCenterGroup, 0, "");
        beamCenterYFloatText.set_isRequiredField(true);
        beamCenterYFloatText.setToolTipText("Y beamcenter in pixel coordinates");
        beamCenterYFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Label beamCenterZLabel = new Label((Composite)beamCenterGroup, 0);
        beamCenterZLabel.setText("Z beam (pixels)");
        beamCenterZFloatText = new FloatText((Composite)beamCenterGroup, 0, "");
        beamCenterZFloatText.set_isRequiredField(true);
        beamCenterZFloatText.setToolTipText("Z beamcenter in pixel coordinates");
        beamCenterZFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Group omegaGroup = LookAndFeel.getGroup((Composite)container[4], (String)"Rotation axis", (int)3, (int)2);
        GridLayout gridLayout = (GridLayout)omegaGroup.getLayout();
        gridLayout.makeColumnsEqualWidth = true;
        Label omegaDirectionLabel = new Label((Composite)omegaGroup, 0x1000000);
        omegaDirectionLabel.setText("Direction (+/-)");
        omegaDirectionLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        omegaDirectionCombo = new Combo((Composite)omegaGroup, 8);
        omegaDirectionCombo.setLayoutData((Object)new GridData(16, 16, true, true));
        omegaDirectionCombo.add("cw");
        omegaDirectionCombo.add("ccw");
        omegaDirectionCombo.setText("cw");
        wedgeFloatText = new FloatText((Composite)omegaGroup, 0, "Wedge (degrees)");
        wedgeFloatText.set_isRequiredField(true);
        wedgeFloatText.setToolTipText("angle between beam and rotation axis minus 90 in degrees");
        wedgeFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        omegaMinFloatText = new FloatText((Composite)omegaGroup, 0, "Start (degrees)");
        omegaMinFloatText.set_isRequiredField(true);
        omegaMinFloatText.setToolTipText("minimum rotation angle in degrees");
        omegaMinFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        omegaMaxFloatText = new FloatText((Composite)omegaGroup, 0, "End (degrees)");
        omegaMaxFloatText.set_isRequiredField(true);
        omegaMaxFloatText.setToolTipText("maximum rotation angle in degrees");
        omegaMaxFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        omegaStepFloatText = new FloatText((Composite)omegaGroup, 0, "Step (degrees)");
        omegaStepFloatText.set_isRequiredField(true);
        omegaStepFloatText.setToolTipText("rotation angle step size in degrees");
        omegaStepFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
    }

    public void createDetectorTab() {
        this.tabItem[5].setText("Detector");
        Composite detectorDistanceComposite = new Composite(container[5], 0);
        GridLayout detectorDistanceLayout = new GridLayout();
        detectorDistanceLayout.numColumns = 2;
        detectorDistanceLayout.makeColumnsEqualWidth = true;
        detectorDistanceComposite.setLayout((Layout)detectorDistanceLayout);
        detectorDistanceComposite.setLayoutData((Object)new GridData(4, 16, true, false));
        samp2DetFloatText = new FloatText(detectorDistanceComposite, 16384, "Sample to detector distance (mm)");
        samp2DetFloatText.set_isRequiredField(true);
        samp2DetFloatText.setToolTipText("sample-detector distance in mm");
        samp2DetFloatText.setLayoutData((Object)new GridData(16, 16, true, false));
        new Label(detectorDistanceComposite, 0x1000000);
        Composite detectorSizeComposite = new Composite(container[5], 0);
        detectorSizeComposite.setLayout((Layout)detectorDistanceLayout);
        detectorSizeComposite.setLayoutData((Object)new GridData(4, 16, true, false));
        Group detectorSizeGroup = LookAndFeel.getGroup((Composite)detectorSizeComposite, (String)"Detector size", (int)4, (int)1);
        this.gridLayout = (GridLayout)detectorSizeGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        Label detSizeYLabel = new Label((Composite)detectorSizeGroup, 0);
        detSizeYLabel.setText("Y size (pixels)");
        detSizeYFloatText = new FloatText((Composite)detectorSizeGroup, 0, "");
        detSizeYFloatText.set_isRequiredField(true);
        detSizeYFloatText.setToolTipText("Y detector size in pixels");
        detSizeYFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Label detSizeZLabel = new Label((Composite)detectorSizeGroup, 0);
        detSizeZLabel.setText("Z size (pixels)");
        detSizeZFloatText = new FloatText((Composite)detectorSizeGroup, 0, "");
        detSizeZFloatText.set_isRequiredField(true);
        detSizeZFloatText.setToolTipText("Z detector size in pixels");
        detSizeZFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Group pixelSizeGroup = LookAndFeel.getGroup((Composite)detectorSizeComposite, (String)"Pixel size", (int)4, (int)1);
        this.gridLayout = (GridLayout)pixelSizeGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        Label pixelSizeYLabel = new Label((Composite)pixelSizeGroup, 0);
        pixelSizeYLabel.setText("Y pixel (mm)");
        pixelSizeYFloatText = new FloatText((Composite)pixelSizeGroup, 0, "");
        pixelSizeYFloatText.set_isRequiredField(true);
        pixelSizeYFloatText.setToolTipText("Y pixel size in mm");
        pixelSizeYFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Label pixelSizeZLabel = new Label((Composite)pixelSizeGroup, 0);
        pixelSizeZLabel.setText("Z pixel (mm)");
        pixelSizeZFloatText = new FloatText((Composite)pixelSizeGroup, 0, "");
        pixelSizeZFloatText.set_isRequiredField(true);
        pixelSizeZFloatText.setToolTipText("Z pixel size in mm");
        pixelSizeZFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Group detectorTiltGroup = LookAndFeel.getGroup((Composite)container[5], (String)"Detector tilt", (int)6, (int)1);
        this.gridLayout = (GridLayout)detectorTiltGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        Label detTiltXLabel = new Label((Composite)detectorTiltGroup, 0);
        detTiltXLabel.setText("X tilt (radians)");
        detTiltXFloatText = new FloatText((Composite)detectorTiltGroup, 0, "");
        detTiltXFloatText.set_isRequiredField(true);
        detTiltXFloatText.setToolTipText("detector tilt counterclockwise around lab x axis in radians");
        detTiltXFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Label detTiltYLabel = new Label((Composite)detectorTiltGroup, 0);
        detTiltYLabel.setText("Y tilt (radians)");
        detTiltYFloatText = new FloatText((Composite)detectorTiltGroup, 0, "");
        detTiltYFloatText.set_isRequiredField(true);
        detTiltYFloatText.setToolTipText("detector tilt counterclockwise around lab y axis in radians");
        detTiltYFloatText.setLayoutData((Object)new GridData(4, 16, true, false));
        Label detTiltZLabel = new Label((Composite)detectorTiltGroup, 0);
        detTiltZLabel.setText("Z tilt (radians)");
        detTiltZFloatText = new FloatText((Composite)detectorTiltGroup, 0, "");
        detTiltZFloatText.set_isRequiredField(true);
        detTiltZFloatText.setToolTipText("Detector tilt counterclockwise around lab z axis in radians");
        detTiltZFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Group detectorOrientationGroup = LookAndFeel.getGroup((Composite)container[5], (String)"Detector orientation", (int)8, (int)1);
        this.gridLayout = (GridLayout)detectorOrientationGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        Label o11Label = new Label((Composite)detectorOrientationGroup, 0);
        o11Label.setText("o11");
        o11Combo = this.createOrientationCombo(detectorOrientationGroup);
        Label o12Label = new Label((Composite)detectorOrientationGroup, 0);
        o12Label.setText("o12");
        o12Combo = this.createOrientationCombo(detectorOrientationGroup);
        Label o21Label = new Label((Composite)detectorOrientationGroup, 0);
        o21Label.setText("o21");
        o21Combo = this.createOrientationCombo(detectorOrientationGroup);
        Label o22Label = new Label((Composite)detectorOrientationGroup, 0);
        o22Label.setText("o22");
        o22Combo = this.createOrientationCombo(detectorOrientationGroup);
        Group detectorDefectsGroup = LookAndFeel.getGroup((Composite)container[5], (String)"Detector defects", (int)3, (int)1);
        this.gridLayout = (GridLayout)detectorDefectsGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        addNoiseButton = new Button((Composite)detectorDefectsGroup, 32);
        addNoiseButton.setText("Noise");
        addNoiseButton.setToolTipText("Add Poissonian to images during simulation");
        addNoiseButton.setLayoutData((Object)new GridData(4, 4, false, true));
        new Label((Composite)detectorDefectsGroup, 0);
        new Label((Composite)detectorDefectsGroup, 0);
        addNoiseButton = new Button((Composite)detectorDefectsGroup, 32);
        addNoiseButton.setText("Background");
        addNoiseButton.setToolTipText("Add background to images during simulation");
        addNoiseButton.setLayoutData((Object)new GridData(4, 4, false, true));
        backgroundCountsFloatText = new FloatText((Composite)detectorDefectsGroup, 0, "Counts");
        backgroundCountsFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        new Label((Composite)detectorDefectsGroup, 0);
        psfButton = new Button((Composite)detectorDefectsGroup, 32);
        psfButton.setText("Point spread");
        psfButton.setToolTipText("Add point spread function to images during simulation");
        psfButton.setLayoutData((Object)new GridData(4, 4, false, true));
        FloatText peakFwhmFloatText = new FloatText((Composite)detectorDefectsGroup, 0, "FWHM (pixels)");
        peakFwhmFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        new Label((Composite)detectorDefectsGroup, 0);
        Button spatialDistortionButton = new Button((Composite)detectorDefectsGroup, 32);
        spatialDistortionButton.setText("Spatial distortion");
        spatialDistortionButton.setToolTipText("Add spatial distortion to images during simulation");
        spatialDistortionButton.setLayoutData((Object)new GridData(4, 4, false, true));
        StringText spatialDistortionStringText = new StringText((Composite)detectorDefectsGroup, 0, "Spline file");
        spatialDistortionStringText.setLayoutData((Object)new GridData(4, 16, true, true));
        Button spatialDistortionBrowseButton = new Button((Composite)detectorDefectsGroup, 0);
        spatialDistortionBrowseButton.setText("Browse");
        spatialDistortionBrowseButton.setLayoutData((Object)new GridData(4, 16, true, false));
    }

    private Combo createOrientationCombo(Group oComboGroup) {
        Combo oCombo = new Combo((Composite)oComboGroup, 8);
        oCombo.setLayoutData((Object)new GridData(16, 16, true, true));
        oCombo.add("1");
        oCombo.add("0");
        oCombo.add("-1");
        oCombo.setText("0");
        return oCombo;
    }

    public void setPreferencesValues() {
    }

    public void setFocus() {
    }

    public static void getInputValues() {
        wavelengthFloatText.set_Text(Float.toString(PolyXSim.getWavelength()));
        fluxFloatText.set_Text(Float.toString(PolyXSim.getFlux().floatValue()));
        polarisationFactorFloatText.set_Text(Float.toString(PolyXSim.getPolarisationFactor()));
        polarisationDirectionFloatText.set_Text(Float.toString(PolyXSim.getPolarisationDirection()));
        beamCenterYFloatText.set_Text(Float.toString(PolyXSim.getDetyCenter().floatValue()));
        beamCenterZFloatText.set_Text(Float.toString(PolyXSim.getDetzCenter().floatValue()));
        pixelSizeYFloatText.set_Text(Float.toString(PolyXSim.getYSize().floatValue()));
        pixelSizeZFloatText.set_Text(Float.toString(PolyXSim.getZSize().floatValue()));
        detSizeYFloatText.set_Text(Float.toString(PolyXSim.getDetySize().floatValue()));
        detSizeZFloatText.set_Text(Float.toString(PolyXSim.getDetzSize().floatValue()));
        samp2DetFloatText.set_Text(Float.toString(PolyXSim.getDistance().floatValue()));
        detTiltXFloatText.set_Text(Float.toString(PolyXSim.getDetTiltX().floatValue()));
        detTiltYFloatText.set_Text(Float.toString(PolyXSim.getDetTiltY().floatValue()));
        detTiltZFloatText.set_Text(Float.toString(PolyXSim.getDetTiltZ().floatValue()));
        Integer[] detOrientation = PolyXSim.getDetOrientation();
        if (detOrientation[0] != null) {
            o11Combo.setText(detOrientation[0].toString());
        }
        if (detOrientation[1] != null) {
            o12Combo.setText(detOrientation[1].toString());
        }
        if (detOrientation[2] != null) {
            o21Combo.setText(detOrientation[2].toString());
        }
        if (detOrientation[3] != null) {
            o22Combo.setText(detOrientation[3].toString());
        }
        wedgeFloatText.set_Text(Float.toString(PolyXSim.getWedge()));
        omegaMinFloatText.set_Text(Float.toString(PolyXSim.getOmegaStart().floatValue()));
        omegaMaxFloatText.set_Text(Float.toString(PolyXSim.getOmegaEnd().floatValue()));
        omegaStepFloatText.set_Text(Float.toString(PolyXSim.getOmegaStep().floatValue()));
        int omegaSign = PolyXSim.getOmegaSign();
        if (omegaSign == -1) {
            omegaDirectionCombo.select(1);
        } else {
            omegaDirectionCombo.select(0);
        }
        grainNumFloatText.set_Text(Integer.toString(PolyXSim.getNoGrains()));
        int grainOrientation = PolyXSim.getGenGrainOrientation();
        grainOrientationButton.setSelection(grainOrientation == 1);
        int grainPosition = PolyXSim.getGenGrainPosition();
        grainPositionButton.setSelection(grainPosition == 1);
        Float[] sampleXyz = PolyXSim.getSampleXyz();
        if (sampleXyz != null) {
            if (sampleXyz[0] != null) {
                sampleXFloatText.set_Text(Float.toString(sampleXyz[0].floatValue()));
            }
            if (sampleXyz[1] != null) {
                sampleYFloatText.set_Text(Float.toString(sampleXyz[1].floatValue()));
            }
            if (sampleXyz[2] != null) {
                sampleZFloatText.set_Text(Float.toString(sampleXyz[2].floatValue()));
            }
        }
        numPhases = PolyXSim.getNumPhases();
        phasesNumIntegerText.set_Text(Integer.toString(numPhases));
        phases = PolyXSim.getPhases();
        phaseGrains = PolyXSim.getPhaseGrains();
        phaseGrainSize = PolyXSim.getPhaseGrainSize();
        phaseGrainMinSize = PolyXSim.getPhaseGrainMinSize();
        phaseGrainMaxSize = PolyXSim.getPhaseGrainMaxSize();
        PolyXSimInputView.createPhaseGrains();
        PolyXSimInputView.createStructureFileGroup();
        PolyXSimInputView.createUnitCellGroup();
        unitCell = new Float[numPhases * 6];
        int i = 0;
        while (i < PolyXSim.getNumPhases()) {
            PolyXSimInputView.unitCell[i * 6] = PolyXSim.getUnitCellA()[i];
            PolyXSimInputView.unitCell[i * 6 + 1] = PolyXSim.getUnitCellB()[i];
            PolyXSimInputView.unitCell[i * 6 + 2] = PolyXSim.getUnitCellC()[i];
            PolyXSimInputView.unitCell[i * 6 + 3] = PolyXSim.getUnitCellAlpha()[i];
            PolyXSimInputView.unitCell[i * 6 + 4] = PolyXSim.getUnitCellBeta()[i];
            PolyXSimInputView.unitCell[i * 6 + 5] = PolyXSim.getUnitCellGamma()[i];
            if (structureCellButton.getSelection()) {
                if (PolyXSim.getUnitCellA() != null && PolyXSim.getUnitCellA()[i] != null) {
                    unitCellAFloatText[i].set_Text(Float.toString(PolyXSim.getUnitCellA()[i].floatValue()));
                }
                if (PolyXSim.getUnitCellB() != null && PolyXSim.getUnitCellB()[i] != null) {
                    unitCellBFloatText[i].set_Text(Float.toString(PolyXSim.getUnitCellB()[i].floatValue()));
                }
                if (PolyXSim.getUnitCellC() != null && PolyXSim.getUnitCellC()[i] != null) {
                    unitCellCFloatText[i].set_Text(Float.toString(PolyXSim.getUnitCellC()[i].floatValue()));
                }
                if (PolyXSim.getUnitCellAlpha() != null && PolyXSim.getUnitCellAlpha()[i] != null) {
                    unitCellAlphaFloatText[i].set_Text(Float.toString(PolyXSim.getUnitCellAlpha()[i].floatValue()));
                }
                if (PolyXSim.getUnitCellBeta() != null && PolyXSim.getUnitCellBeta()[i] != null) {
                    unitCellBetaFloatText[i].set_Text(Float.toString(PolyXSim.getUnitCellBeta()[i].floatValue()));
                }
                if (PolyXSim.getUnitCellGamma() != null && PolyXSim.getUnitCellGamma()[i] != null) {
                    unitCellGammaFloatText[i].set_Text(Float.toString(PolyXSim.getUnitCellGamma()[i].floatValue()));
                }
            }
            if (PolyXSim.getStructureFile(i) != null) {
                PolyXSimInputView.structureFiles[i] = PolyXSim.getStructureFile(i);
                if (structureFileButton.getSelection()) {
                    structureFileText[i].set_Text(PolyXSim.getStructureFile(i));
                }
            }
            if (phases[i] != null) {
                phaseLabel[i].setText("Phase " + phases[i]);
            }
            if (phaseGrains[i] != null) {
                phaseNumGrainsIntegerText[i].set_Text(Integer.toString(phaseGrains[i]));
            }
            if (phaseGrainSize[i] != null) {
                if (phaseGrainSize[i].floatValue() < 0.0f) {
                    phaseDistributionCombo[i].setText("fixed");
                } else {
                    phaseDistributionCombo[i].setText("lognormal");
                }
            }
            phaseGrainSizeFloatText[i].set_Text(Float.toString(Math.abs(phaseGrainSize[i].floatValue())));
            if (phaseGrainMinSize[i] != null) {
                phaseGrainMinSizeFloatText[i].set_Text(Float.toString(phaseGrainMinSize[i].floatValue()));
            }
            if (phaseGrainMaxSize[i] != null) {
                phaseGrainMaxSizeFloatText[i].set_Text(Float.toString(phaseGrainMaxSize[i].floatValue()));
            }
            ++i;
        }
        int makeImages = PolyXSim.getMakeImages();
        imageFlagButton.setSelection(makeImages == 1);
        String fileFormat = PolyXSim.getFormat();
        if (fileFormat.indexOf("edf") >= 0) {
            fileFormatCombo.setText("edf");
        } else if (fileFormat.indexOf("tif16") >= 0) {
            fileFormatCombo.setText("tif16bit");
        } else {
            fileFormatCombo.setText("tif");
        }
        String dirName = PolyXSim.getOutputDirectory();
        dirName = String.valueOf(dirName) + File.separator + PolyXSim.getPrefix();
        imageStemFileText.set_Text(dirName);
        inputFileFileText.set_Text(PolyXSim.getFileName());
        int noise = PolyXSim.getNoise();
        addNoiseButton.setSelection(noise == 1);
        int psf = PolyXSim.getPsf();
        psfButton.setSelection(psf == 1);
        peakTypeCombo.select(PolyXSim.getPeakShape().intValue());
        backgroundCountsFloatText.set_Text(Integer.toString(PolyXSim.getBackground()));
        outputFltButton.setSelection(PolyXSim.getOutputFlt());
        outputGveButton.setSelection(PolyXSim.getOutputGve());
        outputUbiButton.setSelection(PolyXSim.getOutputUbi());
        outputParButton.setSelection(PolyXSim.getOutputPar());
        mosaicityFloatText.set_Text(Float.toString(PolyXSim.getMosaicity()));
        polarisationDirectionFloatText.set_Text(Float.toString(PolyXSim.getPolarisationDirection()));
        polarisationButton.setSelection(PolyXSim.getPolarisation());
        lorentzFactorButton.setSelection(PolyXSim.getLorentzFactor());
        Float[] peakParameters = PolyXSim.getPeakParameters();
        if (peakParameters[0] != null) {
            gaussianPeakPixelsFloatText.set_Text(peakParameters[0].toString());
        }
        if (peakParameters[1] != null) {
            gaussianPeakDegreesFloatText.set_Text(peakParameters[1].toString());
        }
    }

    private static void openJmolView(String structureFile) {
        String os = System.getProperty("os.name");
        if (os.toLowerCase().contains("windows")) {
            if (structureFile.indexOf(":") == -1) {
                structureFile = String.valueOf(inputFileDirectory) + File.separator + structureFile;
            }
        } else if (!structureFile.startsWith(File.separator)) {
            structureFile = String.valueOf(inputFileDirectory) + File.separator + structureFile;
        }
        if (structureFile != null && new File(structureFile).exists()) {
            try {
                JmolView jmolView = null;
                jmolView = (JmolView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.framework.ui.views.JmolView", Integer.toString(JmolView.viewCount), 1);
                if (jmolView != null) {
                    jmolView.openFile(structureFile);
                }
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setInputValues() {
        PolyXSim.setWavelength(wavelengthFloatText.getValue().floatValue());
        PolyXSim.setFlux(fluxFloatText.getValue().floatValue());
        PolyXSim.setPolarisation(polarisationButton.getSelection());
        PolyXSim.setLorentzFactor(lorentzFactorButton.getSelection());
        PolyXSim.setPolarisationFactor(polarisationFactorFloatText.getValue().floatValue());
        PolyXSim.setPolarisationDirection(polarisationDirectionFloatText.getValue().floatValue());
        PolyXSim.setDetyCenter(beamCenterYFloatText.getValue().floatValue());
        PolyXSim.setDetzCenter(beamCenterZFloatText.getValue().floatValue());
        PolyXSim.setYSize(pixelSizeYFloatText.getValue().floatValue());
        PolyXSim.setZSize(pixelSizeZFloatText.getValue().floatValue());
        PolyXSim.setDetySize(detSizeYFloatText.getValue().floatValue());
        PolyXSim.setDetzSize(detSizeZFloatText.getValue().floatValue());
        PolyXSim.setDistance(samp2DetFloatText.getValue().floatValue());
        PolyXSim.setDetTiltX(detTiltXFloatText.getValue().floatValue());
        PolyXSim.setDetTiltY(detTiltYFloatText.getValue().floatValue());
        PolyXSim.setDetTiltZ(detTiltZFloatText.getValue().floatValue());
        Integer[] detOrientation = new Integer[]{Integer.valueOf(o11Combo.getText()), Integer.valueOf(o12Combo.getText()), Integer.valueOf(o21Combo.getText()), Integer.valueOf(o22Combo.getText())};
        PolyXSim.setDetOrientation(detOrientation);
        PolyXSim.setOmegaStart(omegaMinFloatText.getValue().floatValue());
        PolyXSim.setOmegaEnd(omegaMaxFloatText.getValue().floatValue());
        PolyXSim.setOmegaStep(omegaStepFloatText.getValue().floatValue());
        PolyXSim.setNoGrains(grainNumFloatText.getValue().intValue());
        int genGrains = 0;
        if (grainOrientationButton.getSelection()) {
            genGrains = 1;
        }
        PolyXSim.setGenGrainOrientation(genGrains);
        if (grainPositionButton.getSelection()) {
            genGrains = 1;
        }
        PolyXSim.setGenGrainPosition(genGrains);
        Float[] sampleXyz = new Float[]{sampleXFloatText.getValue(), sampleYFloatText.getValue(), sampleZFloatText.getValue()};
        PolyXSim.setSampleXyz(sampleXyz);
        PolyXSim.setNumPhases(numPhases);
        if (structureCellButton.getSelection()) {
            Float[] unitCellA = new Float[numPhases];
            Float[] unitCellB = new Float[numPhases];
            Float[] unitCellC = new Float[numPhases];
            Float[] unitCellAlpha = new Float[numPhases];
            Float[] unitCellBeta = new Float[numPhases];
            Float[] unitCellGamma = new Float[numPhases];
            int i = 0;
            while (i < numPhases) {
                if (unitCellAFloatText[i].getValue() != null) {
                    unitCellA[i] = unitCellAFloatText[i].getValue();
                }
                if (unitCellBFloatText[i].getValue() != null) {
                    unitCellB[i] = unitCellBFloatText[i].getValue();
                }
                if (unitCellCFloatText[i].getValue() != null) {
                    unitCellC[i] = unitCellCFloatText[i].getValue();
                }
                if (unitCellAlphaFloatText[i].getValue() != null) {
                    unitCellAlpha[i] = unitCellAlphaFloatText[i].getValue();
                }
                if (unitCellBetaFloatText[i].getValue() != null) {
                    unitCellBeta[i] = unitCellBetaFloatText[i].getValue();
                }
                if (unitCellGammaFloatText[i].getValue() != null) {
                    unitCellGamma[i] = unitCellGammaFloatText[i].getValue();
                }
                ++i;
            }
            PolyXSim.setUnitCellA(unitCellA);
            PolyXSim.setUnitCellB(unitCellB);
            PolyXSim.setUnitCellC(unitCellC);
            PolyXSim.setUnitCellAlpha(unitCellAlpha);
            PolyXSim.setUnitCellBeta(unitCellBeta);
            PolyXSim.setUnitCellGamma(unitCellGamma);
        } else {
            int i = 0;
            while (i < numPhases) {
                if (structureFileText[i].getValue() != null) {
                    PolyXSim.setStructureFile(structureFileText[i].getValue(), i);
                }
                ++i;
            }
        }
        Float[] medGrainSize = new Float[numPhases];
        Float[] minGrainSize = new Float[numPhases];
        Float[] maxGrainSize = new Float[numPhases];
        int i = 0;
        while (i < numPhases) {
            if (structureFileText[i].getValue() != null) {
                PolyXSim.setStructureFile(structureFileText[i].getValue(), i);
            }
            if (phaseGrainSizeFloatText[i].getValue() != null) {
                medGrainSize[i] = phaseDistributionCombo[i].getText().equals("fixed") ? Float.valueOf(-Math.abs(phaseGrainSizeFloatText[i].getValue().floatValue())) : Float.valueOf(Math.abs(phaseGrainSizeFloatText[i].getValue().floatValue()));
            }
            if (phaseGrainMinSizeFloatText[i].getValue() != null) {
                minGrainSize[i] = phaseGrainMinSizeFloatText[i].getValue();
            }
            if (phaseGrainMaxSizeFloatText[i].getValue() != null) {
                maxGrainSize[i] = phaseGrainMaxSizeFloatText[i].getValue();
            }
            ++i;
        }
        PolyXSim.setPhaseGrainSize(medGrainSize);
        PolyXSim.setPhaseGrainMinSize(minGrainSize);
        PolyXSim.setPhaseGrainMaxSize(maxGrainSize);
        int makeImages = 0;
        if (imageFlagButton.getSelection()) {
            makeImages = 1;
        }
        PolyXSim.setMakeImages(makeImages);
        String fileFormat = fileFormatCombo.getText();
        PolyXSim.setFormat("." + fileFormat);
        String dirName = "";
        String fileStem = imageStemFileText.getText();
        if (fileStem.lastIndexOf(File.separatorChar) != -1) {
            dirName = fileStem.substring(0, fileStem.lastIndexOf(File.separatorChar));
            fileStem = fileStem.substring(fileStem.lastIndexOf(File.separatorChar) + 1);
        }
        PolyXSim.setOutputDirectory(dirName);
        PolyXSim.setPrefix(fileStem);
        int noise = 0;
        if (addNoiseButton.getSelection()) {
            noise = 1;
        }
        PolyXSim.setNoise(noise);
        int psf = 0;
        if (psfButton.getSelection()) {
            psf = 1;
        }
        PolyXSim.setPsf(psf);
        PolyXSim.setPeakShape(peakTypeCombo.getSelectionIndex());
        Float[] peakParameters = new Float[]{gaussianPeakPixelsFloatText.getValue(), gaussianPeakDegreesFloatText.getValue()};
        PolyXSim.setPeakParameters(peakParameters);
        backgroundCountsFloatText.set_Text(Integer.toString(PolyXSim.getBackground()));
        PolyXSim.setBackground(backgroundCountsFloatText.getValue().intValue());
        PolyXSim.setOutputFlt(outputFltButton.getSelection());
        PolyXSim.setOutputGve(outputGveButton.getSelection());
        PolyXSim.setOutputUbi(outputUbiButton.getSelection());
        PolyXSim.setOutputPar(outputParButton.getSelection());
        PolyXSim.setFormat("." + fileFormatCombo.getText());
        PolyXSim.setWedge(wedgeFloatText.getValue().floatValue());
        PolyXSim.setMosaicity(mosaicityFloatText.getValue().floatValue());
    }

    public static void loadInputFile(String inputFileName) {
        StringBuffer contents;
        block19: {
            inputFileDirectory = inputFileName.substring(0, inputFileName.lastIndexOf(File.separatorChar));
            PolyXSim.setInputFileDirectory(inputFileDirectory);
            File file = new File(inputFileName);
            contents = new StringBuffer();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                String text = null;
                while ((text = reader.readLine()) != null) {
                    contents.append(text).append("\r\n");
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    break block19;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                break block19;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    break block19;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        inputFileText.setText(contents.toString());
        outputFileBrowseButton.setEnabled(false);
        inputFileText.pack();
        container[0].pack();
    }

    private void writeInputFile(String file) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(inputFileText.getText());
            out.close();
        }
        catch (IOException iOException) {}
    }

    private void setEnableGroup(Group group, boolean enable) {
        Control[] children = group.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(enable);
            ++i;
        }
        group.setEnabled(enable);
    }

    private void setHelpContextIDs() {
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp(this.tabItem[0].getControl(), "fable.polyxsim.files_tab");
    }
}

