/*
 * Decompiled with CFR 0.152.
 */
package fable.polyxsim.actions;

import fable.framework.views.FableMessageConsole;
import fable.polyxsim.internal.IVarKeys;
import fable.polyxsim.internal.PolyXSim;
import fable.polyxsim.rcp.Activator;
import fable.polyxsim.views.PolyXSimInputView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class OpenInputFileAction
implements IWorkbenchWindowActionDelegate {
    public void run(IAction action) {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null) {
            try {
                activeWindow.getWorkbench().showPerspective("fable.polyxsim.perspective", activeWindow);
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("fable.polyxsim.views.polyxsiminputview");
                FileDialog fileDialog = new FileDialog(new Shell(), 0);
                fileDialog.setFilterExtensions(IVarKeys.FILTER_EXTS_INPUT);
                fileDialog.setFilterNames(IVarKeys.FILTER_EXTS_INPUT);
                String initialDirectory = Activator.getInitialDirectory();
                fileDialog.setFilterPath(initialDirectory);
                fileDialog.setText("Select an existing PolyXSim input file or enter a new file name");
                String file = fileDialog.open();
                if (file != null) {
                    initialDirectory = fileDialog.getFilterPath();
                    Activator.setInitialDirectory(initialDirectory);
                    FableMessageConsole.console.displayOut("read polyxsim input file " + file);
                    PolyXSimInputView.loadInputFile(file);
                    PolyXSim.loadInputFile(file);
                    PolyXSimInputView.getInputValues();
                }
            }
            catch (Exception exception) {
                MessageDialog.openError((Shell)activeWindow.getShell(), (String)"Error", (String)"Error opening loading PolyXSim input file and opening view");
            }
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

