/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.view;

import fable.grainspotter.modelviewer.GrainInfoModel;
import fable.grainspotter.modelviewer.GrainSyntaxModel;
import fable.grainspotter.modelviewer.GrainUBIMatrixModel;
import fable.grainspotter.modelviewer.GrainUMatrixModel;
import fable.grainspotter.providers.GrainspotterContentProvider;
import fable.grainspotter.providers.GrainspotterLabelProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.part.ViewPart;

public class View
extends ViewPart {
    public static final String ID = "test.grainspotter.outputview.view";
    private TreeViewer viewer;
    private GrainSyntaxModel grains;
    private GrainSyntaxModel currentGrain;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 783);
        this.viewer.getTree().setLinesVisible(true);
        TreeColumn col = new TreeColumn(this.viewer.getTree(), 0x1000000);
        this.viewer.getTree().setHeaderVisible(true);
        col.setText("Text");
        col.setWidth(400);
        TreeColumn col2 = new TreeColumn(this.viewer.getTree(), 0x1000000);
        col2.setText("Values");
        col2.setWidth(100);
        this.viewer.setContentProvider((IContentProvider)new GrainspotterContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new GrainspotterLabelProvider());
        this.viewer.setInput((Object)this.getInput());
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void loadLogFile(String logFileName) {
        File f = new File("C:\\Test_files\\testGrainspotter.log");
        if (!f.exists()) {
            System.out.println("file doesn't exist");
        } else {
            try {
                String line;
                int nLines = 0;
                int nGrain = 0;
                int grainLine = 0;
                int[] gVectors = new int[10000];
                int[] h = new int[10000];
                int[] k = new int[10000];
                int[] l = new int[10000];
                double[] tth_meas = new double[10000];
                double[] tth_pred = new double[10000];
                double[] dtth = new double[10000];
                double[] omega_meas = new double[10000];
                double[] omega_pred = new double[10000];
                double[] domega = new double[10000];
                double[] eta_meas = new double[10000];
                double[] eta_pred = new double[10000];
                double[] deta = new double[10000];
                double[] ia = new double[10000];
                boolean foundGrain = false;
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                GrainUMatrixModel umatrix = null;
                GrainInfoModel infosModel = null;
                while ((line = reader.readLine()) != null) {
                    String[] outTokens = line.split("\\s+");
                    if (++nLines != 1 && nLines <= 23) continue;
                    if (line.length() > 0 || nLines - grainLine < 17) {
                        if (line.length() > 0 && line.charAt(0) != '#') {
                            int i = 0;
                            while (i < outTokens.length) {
                                ++i;
                            }
                        }
                        if (foundGrain) {
                            try {
                                if (nLines - grainLine >= 17) {
                                    int index = nLines - grainLine - 17;
                                    gVectors[index] = Integer.valueOf(outTokens[2]);
                                    h[index] = Integer.valueOf(outTokens[3]);
                                    k[index] = Integer.valueOf(outTokens[4]);
                                    l[index] = Integer.valueOf(outTokens[5]);
                                    tth_meas[index] = Double.valueOf(outTokens[6]);
                                    tth_pred[index] = Double.valueOf(outTokens[7]);
                                    dtth[index] = Double.valueOf(outTokens[8]);
                                    omega_meas[index] = Double.valueOf(outTokens[9]);
                                    omega_pred[index] = Double.valueOf(outTokens[10]);
                                    domega[index] = Double.valueOf(outTokens[11]);
                                    eta_meas[index] = Double.valueOf(outTokens[12]);
                                    eta_pred[index] = Double.valueOf(outTokens[13]);
                                    deta[index] = Double.valueOf(outTokens[14]);
                                    ia[index] = Double.valueOf(outTokens[15]);
                                } else if (nLines - grainLine == 1) {
                                    Integer.valueOf(outTokens[1]).intValue();
                                    Integer.valueOf(outTokens[2]).intValue();
                                    this.currentGrain.add(new GrainInfoModel("gve expected ", outTokens[1]));
                                    this.currentGrain.add(new GrainInfoModel("gve measured ", outTokens[2]));
                                    this.currentGrain.add(new GrainInfoModel("measured once ", outTokens[3]));
                                    this.currentGrain.add(new GrainInfoModel("measured more than once ", outTokens[4]));
                                } else if (nLines - grainLine == 2) {
                                    Double.valueOf(outTokens[1]).doubleValue();
                                    this.currentGrain.add(new GrainInfoModel("Mean IA", outTokens[1]));
                                } else if (nLines - grainLine == 3) {
                                    Double.valueOf(outTokens[0]).doubleValue();
                                    Double.valueOf(outTokens[1]).doubleValue();
                                    Double.valueOf(outTokens[2]).doubleValue();
                                    umatrix = new GrainUMatrixModel("U1", "U2", "U3");
                                    this.currentGrain.add(umatrix);
                                    umatrix.add(new GrainUMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                                } else if (nLines - grainLine == 4) {
                                    Double.valueOf(outTokens[0]).doubleValue();
                                    Double.valueOf(outTokens[1]).doubleValue();
                                    Double.valueOf(outTokens[2]).doubleValue();
                                    umatrix.add(new GrainUMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                                } else if (nLines - grainLine == 5) {
                                    Double.valueOf(outTokens[0]).doubleValue();
                                    Double.valueOf(outTokens[1]).doubleValue();
                                    Double.valueOf(outTokens[2]).doubleValue();
                                    umatrix.add(new GrainUMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                                } else if (nLines - grainLine == 7) {
                                    Double.valueOf(outTokens[0]).doubleValue();
                                    Double.valueOf(outTokens[1]).doubleValue();
                                    Double.valueOf(outTokens[2]).doubleValue();
                                    umatrix = new GrainUBIMatrixModel("UBI1", "UBI2", "UBI3");
                                    umatrix.add(new GrainUBIMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                                    this.currentGrain.add(umatrix);
                                } else if (nLines - grainLine == 8) {
                                    umatrix.add(new GrainUBIMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                                } else if (nLines - grainLine == 9) {
                                    umatrix.add(new GrainUBIMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                                } else if (nLines - grainLine == 11) {
                                    infosModel = new GrainInfoModel("orientation given as a Rodrigues vector");
                                    this.currentGrain.add(infosModel);
                                    infosModel.add(new GrainInfoModel("r1", outTokens[0]));
                                    infosModel.add(new GrainInfoModel("r2", outTokens[1]));
                                    infosModel.add(new GrainInfoModel("r3", outTokens[2]));
                                } else if (nLines - grainLine == 13) {
                                    infosModel = new GrainInfoModel("orientation given as Euler angles");
                                    this.currentGrain.add(infosModel);
                                    infosModel.add(new GrainInfoModel("phi11", outTokens[0]));
                                    infosModel.add(new GrainInfoModel("phi", outTokens[1]));
                                    infosModel.add(new GrainInfoModel("phi2", outTokens[2]));
                                } else if (nLines - grainLine == 15) {
                                    infosModel = new GrainInfoModel("orientation given as a quarternion");
                                    this.currentGrain.add(infosModel);
                                    infosModel.add(new GrainInfoModel("q0", outTokens[0]));
                                    infosModel.add(new GrainInfoModel("qx", outTokens[1]));
                                    infosModel.add(new GrainInfoModel("qy", outTokens[2]));
                                    infosModel.add(new GrainInfoModel("qz", outTokens[3]));
                                }
                            }
                            catch (Exception e) {
                                System.out.println(e.getMessage());
                            }
                        }
                        if (!outTokens[0].equals("Grain")) continue;
                        if (!foundGrain) {
                            grainLine = nLines;
                            this.currentGrain = new GrainSyntaxModel("" + ++nGrain);
                            this.grains.add(this.currentGrain);
                        }
                        foundGrain = true;
                        continue;
                    }
                    int i = 0;
                    while (i < outTokens.length) {
                        ++i;
                    }
                    if (!foundGrain) continue;
                    foundGrain = false;
                    int[] gveIds = new int[nLines - grainLine - 17];
                    infosModel = new GrainInfoModel("g-vectors");
                    this.currentGrain.add(infosModel);
                    int _i = 0;
                    while (_i < gveIds.length) {
                        gveIds[_i] = gVectors[_i];
                        GrainInfoModel gv = new GrainInfoModel("g-vector #" + _i);
                        infosModel.add(gv);
                        gv.add(new GrainInfoModel("id", "" + gVectors[_i]));
                        gv.add(new GrainInfoModel("h k l ", h[_i] + " " + k[_i] + " " + l[_i]));
                        gv.add(new GrainInfoModel("tth_meas", "" + tth_meas[_i]));
                        gv.add(new GrainInfoModel("tth_pred", "" + tth_pred[_i]));
                        gv.add(new GrainInfoModel("dtth", "" + dtth[_i]));
                        gv.add(new GrainInfoModel("omega_pred", "" + omega_pred[_i]));
                        gv.add(new GrainInfoModel("domega", "" + domega[_i]));
                        gv.add(new GrainInfoModel("eta_meas", "" + eta_meas[_i]));
                        gv.add(new GrainInfoModel("eta_pred", "" + eta_pred[_i]));
                        gv.add(new GrainInfoModel("deta", "" + deta[_i]));
                        gv.add(new GrainInfoModel("ia", "" + ia[_i]));
                        ++_i;
                    }
                }
            }
            catch (IOException iOException) {}
        }
    }

    public GrainSyntaxModel getInput() {
        this.grains = new GrainSyntaxModel();
        this.loadLogFile("C:\\Test_files\\PlatON.log");
        return this.grains;
    }
}

