/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.view;

import fable.framework.database.DerbyDatabase;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.modelviewer.GrainInfoModel;
import fable.grainspotter.modelviewer.GrainSyntaxModel;
import fable.grainspotter.modelviewer.GrainUBIMatrixModel;
import fable.grainspotter.modelviewer.GrainUMatrixModel;
import fable.grainspotter.providers.GrainspotterContentProvider;
import fable.grainspotter.providers.GrainspotterLabelProvider;
import fable.grainspotter.rcp.Activator;
import fable.grainspotter.run.GrainSpotter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Scanner;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.part.ViewPart;

public class OutputView
extends ViewPart {
    public static final String ID = "fable.grainspotter.view.outputview";
    public static OutputView view = null;
    Composite parent;
    private TreeViewer viewer;
    private GrainSyntaxModel grains;
    private GrainSyntaxModel currentGrain;
    public GrainSpotter grainSpotter;

    public void createPartControl(Composite _parent) {
        view = this;
        this.parent = _parent;
        this.grainSpotter = GrainSpotter.getInstance();
        this.createTree();
        if (Activator.database != null) {
            this.createDbTables();
        }
    }

    public void setFocus() {
    }

    public void loadLogFile(String logFileName) {
        File f;
        this.grains = new GrainSyntaxModel();
        this.grainSpotter.grainGvectors.clear();
        if (Activator.database != null) {
            this.dropDbTables();
            this.createDbTables();
        }
        if (!(f = new File(logFileName)).exists()) {
            FableMessageConsole.console.displayOut("cannot load grainspotter output log file " + logFileName);
            FableMessageConsole.console.displayOut("are you sure the file exists, did grainspotter run correctly");
        } else {
            FableMessageConsole.console.displayOut("load grainspotter output log file " + logFileName);
            try {
                String line;
                int nLines = 0;
                int nGrain = 0;
                int grainLine = 0;
                int gve_expected = 0;
                int gve_measured = 0;
                double ia_mean = 0.0;
                double u11 = 0.0;
                double u12 = 0.0;
                double u13 = 0.0;
                double u21 = 0.0;
                double u22 = 0.0;
                double u23 = 0.0;
                double u31 = 0.0;
                double u32 = 0.0;
                double u33 = 0.0;
                int[] gVectors = new int[10000];
                int[] peakId = new int[10000];
                int[] h = new int[10000];
                int[] k = new int[10000];
                int[] l = new int[10000];
                double[] h_pred = new double[10000];
                double[] k_pred = new double[10000];
                double[] l_pred = new double[10000];
                double[] dh = new double[10000];
                double[] dl = new double[10000];
                double[] dk = new double[10000];
                double[] tth_meas = new double[10000];
                double[] tth_pred = new double[10000];
                double[] dtth = new double[10000];
                double[] omega_meas = new double[10000];
                double[] omega_pred = new double[10000];
                double[] domega = new double[10000];
                double[] eta_meas = new double[10000];
                double[] eta_pred = new double[10000];
                double[] deta = new double[10000];
                double[] ia = new double[10000];
                boolean foundGrain = false;
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                GrainUMatrixModel umatrix = null;
                GrainInfoModel infosModel = null;
                while ((line = reader.readLine()) != null) {
                    String[] outTokens = line.split("\\s+");
                    if (++nLines != 1 && nLines <= 23) continue;
                    if (line.length() > 0 || nLines - grainLine < 17) {
                        if (foundGrain) {
                            try {
                                if (nLines - grainLine >= 17) {
                                    Scanner scanner = new Scanner(line);
                                    scanner.useDelimiter("\\s+");
                                    scanner.useLocale(Locale.ENGLISH);
                                    int index = nLines - grainLine - 17;
                                    if (scanner.hasNext()) {
                                        scanner.nextInt();
                                        gVectors[index] = scanner.nextInt();
                                        peakId[index] = scanner.nextInt();
                                        h[index] = scanner.nextInt();
                                        k[index] = scanner.nextInt();
                                        l[index] = scanner.nextInt();
                                        h_pred[index] = scanner.nextDouble();
                                        k_pred[index] = scanner.nextDouble();
                                        l_pred[index] = scanner.nextDouble();
                                        dh[index] = scanner.nextDouble();
                                        dk[index] = scanner.nextDouble();
                                        dl[index] = scanner.nextDouble();
                                        tth_meas[index] = scanner.nextDouble();
                                        tth_pred[index] = scanner.nextDouble();
                                        dtth[index] = scanner.nextDouble();
                                        omega_meas[index] = scanner.nextDouble();
                                        omega_pred[index] = scanner.nextDouble();
                                        domega[index] = scanner.nextDouble();
                                        eta_meas[index] = scanner.nextDouble();
                                        eta_pred[index] = scanner.nextDouble();
                                        deta[index] = scanner.nextDouble();
                                        ia[index] = scanner.nextDouble();
                                    }
                                    scanner.close();
                                } else if (nLines - grainLine == 1) {
                                    gve_expected = Integer.valueOf(outTokens[1]);
                                    gve_measured = Integer.valueOf(outTokens[2]);
                                    this.currentGrain.add(new GrainInfoModel("gve expected ", outTokens[1]));
                                    this.currentGrain.add(new GrainInfoModel("gve measured ", outTokens[2]));
                                    this.currentGrain.add(new GrainInfoModel("measured once ", outTokens[3]));
                                    this.currentGrain.add(new GrainInfoModel("measured more than once ", outTokens[4]));
                                } else if (nLines - grainLine == 2) {
                                    ia_mean = Double.valueOf(outTokens[1]);
                                    this.currentGrain.add(new GrainInfoModel("Mean IA", outTokens[1]));
                                } else if (nLines - grainLine == 3) {
                                    u11 = Double.valueOf(outTokens[0]);
                                    u12 = Double.valueOf(outTokens[1]);
                                    u13 = Double.valueOf(outTokens[2]);
                                    umatrix = new GrainUMatrixModel("U1", "U2", "U3");
                                    this.currentGrain.add(umatrix);
                                    umatrix.add(new GrainUMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                                } else if (nLines - grainLine == 4) {
                                    u21 = Double.valueOf(outTokens[0]);
                                    u22 = Double.valueOf(outTokens[1]);
                                    u23 = Double.valueOf(outTokens[2]);
                                    umatrix.add(new GrainUMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                                } else if (nLines - grainLine == 5) {
                                    u31 = Double.valueOf(outTokens[0]);
                                    u32 = Double.valueOf(outTokens[1]);
                                    u33 = Double.valueOf(outTokens[2]);
                                    umatrix.add(new GrainUMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                                } else if (nLines - grainLine == 7) {
                                    Double.valueOf(outTokens[0]).doubleValue();
                                    Double.valueOf(outTokens[1]).doubleValue();
                                    Double.valueOf(outTokens[2]).doubleValue();
                                    umatrix = new GrainUBIMatrixModel("UBI1", "UBI2", "UBI3");
                                    umatrix.add(new GrainUBIMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                                    this.currentGrain.add(umatrix);
                                } else if (nLines - grainLine == 8) {
                                    umatrix.add(new GrainUBIMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                                } else if (nLines - grainLine == 9) {
                                    umatrix.add(new GrainUBIMatrixModel(outTokens[0], outTokens[1], outTokens[2]));
                                } else if (nLines - grainLine == 11) {
                                    infosModel = new GrainInfoModel("orientation given as a Rodrigues vector");
                                    this.currentGrain.add(infosModel);
                                    infosModel.add(new GrainInfoModel("r1", outTokens[0]));
                                    infosModel.add(new GrainInfoModel("r2", outTokens[1]));
                                    infosModel.add(new GrainInfoModel("r3", outTokens[2]));
                                } else if (nLines - grainLine == 13) {
                                    infosModel = new GrainInfoModel("orientation given as Euler angles");
                                    this.currentGrain.add(infosModel);
                                    infosModel.add(new GrainInfoModel("phi11", outTokens[0]));
                                    infosModel.add(new GrainInfoModel("phi", outTokens[1]));
                                    infosModel.add(new GrainInfoModel("phi2", outTokens[2]));
                                } else if (nLines - grainLine == 15) {
                                    infosModel = new GrainInfoModel("orientation given as a quarternion");
                                    this.currentGrain.add(infosModel);
                                    infosModel.add(new GrainInfoModel("q0", outTokens[0]));
                                    infosModel.add(new GrainInfoModel("qx", outTokens[1]));
                                    infosModel.add(new GrainInfoModel("qy", outTokens[2]));
                                    infosModel.add(new GrainInfoModel("qz", outTokens[3]));
                                }
                            }
                            catch (Exception exception) {}
                        }
                        if (!outTokens[0].equals("Grain")) continue;
                        if (!foundGrain) {
                            grainLine = nLines;
                            this.currentGrain = new GrainSyntaxModel("" + ++nGrain);
                            this.grains.add(this.currentGrain);
                        }
                        foundGrain = true;
                        continue;
                    }
                    if (!foundGrain) continue;
                    foundGrain = false;
                    FableMessageConsole.console.displayIn("grain " + nGrain + " found " + (nLines - grainLine - 17) + " g-vectors");
                    int[] gveIds = new int[nLines - grainLine - 17];
                    infosModel = new GrainInfoModel("g-vectors");
                    this.currentGrain.add(infosModel);
                    int _i = 0;
                    while (_i < gveIds.length) {
                        gveIds[_i] = gVectors[_i];
                        GrainInfoModel gv = new GrainInfoModel("g-vector #" + (_i + 1));
                        infosModel.add(gv);
                        gv.add(new GrainInfoModel("gvector_id", "" + gVectors[_i]));
                        gv.add(new GrainInfoModel("peak_id  ", "" + peakId[_i]));
                        gv.add(new GrainInfoModel("h k l ", h[_i] + " " + k[_i] + " " + l[_i]));
                        gv.add(new GrainInfoModel("h_pred k_pred l_pred ", h_pred[_i] + " " + k_pred[_i] + " " + l_pred[_i]));
                        gv.add(new GrainInfoModel("dh dk dl ", dh[_i] + " " + dk[_i] + " " + dl[_i]));
                        gv.add(new GrainInfoModel("tth_meas", "" + tth_meas[_i]));
                        gv.add(new GrainInfoModel("tth_pred", "" + tth_pred[_i]));
                        gv.add(new GrainInfoModel("dtth", "" + dtth[_i]));
                        gv.add(new GrainInfoModel("omega_meas", "" + omega_meas[_i]));
                        gv.add(new GrainInfoModel("omega_pred", "" + omega_pred[_i]));
                        gv.add(new GrainInfoModel("domega", "" + domega[_i]));
                        gv.add(new GrainInfoModel("eta_meas", "" + eta_meas[_i]));
                        gv.add(new GrainInfoModel("eta_pred", "" + eta_pred[_i]));
                        gv.add(new GrainInfoModel("deta", "" + deta[_i]));
                        gv.add(new GrainInfoModel("ia", "" + ia[_i]));
                        if (Activator.database != null) {
                            String values = " (" + nGrain + "," + gVectors[_i] + "," + h[_i] + "," + k[_i] + "," + l[_i] + "," + h_pred[_i] + "," + k_pred[_i] + "," + l_pred[_i] + "," + dh[_i] + "," + dk[_i] + "," + dl[_i] + "," + tth_meas[_i] + "," + tth_pred[_i] + "," + dtth[_i] + "," + omega_meas[_i] + "," + omega_pred[_i] + "," + domega[_i] + "," + eta_meas[_i] + "," + eta_pred[_i] + "," + deta[_i] + "," + ia[_i] + ")";
                            Activator.database.insert("grainfits", values);
                        }
                        ++_i;
                    }
                    this.grainSpotter.grainGvectors.add(gveIds);
                    if (Activator.database == null) continue;
                    Activator.database.insert("grains", " (" + nGrain + "," + gve_expected + "," + gve_measured + "," + ia_mean + "," + u11 + "," + u12 + "," + u13 + "," + u21 + "," + u22 + "," + u23 + "," + u31 + "," + u32 + "," + u33 + ")");
                }
            }
            catch (IOException iOException) {
                FableMessageConsole.console.displayIn("Error while opening or reading log file" + logFileName);
            }
            this.viewer.setInput((Object)this.grains);
            view.setPartName(new File(logFileName).getName());
        }
    }

    private void createTree() {
        this.viewer = new TreeViewer(this.parent, 783);
        this.viewer.getTree().setLinesVisible(true);
        TreeColumn col = new TreeColumn(this.viewer.getTree(), 0x1000000);
        this.viewer.getTree().setHeaderVisible(true);
        col.setText("Text");
        col.setWidth(400);
        TreeColumn col2 = new TreeColumn(this.viewer.getTree(), 0x1000000);
        col2.setText("Values");
        col2.setWidth(100);
        this.viewer.setContentProvider((IContentProvider)new GrainspotterContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new GrainspotterLabelProvider());
    }

    private void createDbTables() {
        Activator.database.createTable("grains (grain int, gve_expected int, gve_measured int, ia double, u11 double, u12 double, u13 double, u21 double, u22 double, u23 double, u31 double, u32 double, u33 double)");
        Activator.database.createTable("grainfits (grain int, gvector int, h int, k int, l int,h_pred double,k_pred double, l_pred double, dh double, dk double, dl double,  tth_meas double, tth_pred double, dtth double, omega_meas double, omega_pred double, domega double, eta_meas double, eta_pred double, deta double, ia double)");
    }

    private void dropDbTables() {
        Statement statement = null;
        try {
            statement = DerbyDatabase.getConnection().createStatement();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        try {
            statement.execute("drop table grains");
            statement.execute("drop table grainfits");
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
    }
}

