/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.view;

import fable.grainspotter.run.GrainSpotter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class Grains3DView
extends ViewPart {
    public static final String ID = "fable.grainspotter.grains3dview";
    public static Grains3DView thisView = null;
    public static GLContext context;
    public static GLU glu;
    private static SceneGrip grip;
    private Button gvectorShowButton;
    private Composite controlsComposite;
    private Composite canvasComposite;
    private Composite xyzControlsComposite;
    private static GLCanvas canvas;
    private static double[] xyz;
    private static int pointSize;
    private static Spinner pointSizeSpinner;
    private static int grains;
    private static Combo grainSelectCombo;
    private static int selectedGrain;
    private Text xoffText;
    private Text yoffText;
    private Text zoffText;
    private Text xrotText;
    private Text yrotText;
    private static Boolean showGVectors;
    private static Boolean allGvectorsListFirst;
    private static int allGvectorsList;
    private static int grainGvectorsList;
    private static int width;
    private static int height;
    private static float aspect;
    private Action infoAction;
    public static GrainSpotter grainSpotter;

    static {
        glu = new GLU();
        xyz = new double[]{1.0, 1.0, 1.0};
        pointSize = 1;
        grains = 1;
        selectedGrain = 1;
        showGVectors = false;
        allGvectorsListFirst = true;
    }

    static void init(GLCanvas canvas) {
        canvas.setCurrent();
        Grains3DView.resize(canvas);
        try {
            GLContext.useContext((Object)canvas);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glHint((int)3152, (int)4354);
        grainGvectorsList = allGvectorsList + 1;
    }

    static void render() {
        try {
            GLContext.useContext((Object)canvas);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        GL11.glClear((int)16640);
        GL11.glClearColor((float)0.1f, (float)0.1f, (float)0.1f, (float)1.0f);
        GL11.glLoadIdentity();
        grip.adjust();
        GL11.glOrtho((double)-1.0, (double)1.0, (double)-1.0, (double)1.0, (double)-1.0, (double)1.0);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glBegin((int)2);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glRasterPos3i((int)1, (int)0, (int)0);
        GL11.glBegin((int)2);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glRasterPos3i((int)0, (int)1, (int)0);
        GL11.glBegin((int)2);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnd();
        GL11.glRasterPos3i((int)0, (int)0, (int)1);
        GL11.glPointSize((float)pointSize);
        GL11.glCallList((int)allGvectorsList);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRasterPos2i((int)1, (int)1);
        GL11.glEnable((int)2896);
    }

    static void resize(GLCanvas canvas) {
        canvas.setCurrent();
        Rectangle rect = canvas.getClientArea();
        width = rect.width;
        height = Math.max(rect.height, 1);
        aspect = (float)width / (float)height;
        try {
            GLContext.useContext((Object)canvas);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
    }

    public void createPartControl(Composite parent) {
        this.makeActions();
        this.contributeToActionBars();
        grainSpotter = GrainSpotter.getInstance();
        thisView = this;
        parent.setLayout((Layout)new GridLayout());
        GridLayout threeColGridLayout = new GridLayout();
        threeColGridLayout.numColumns = 3;
        this.controlsComposite = new Composite(parent, 4);
        this.controlsComposite.setLayout((Layout)threeColGridLayout);
        this.controlsComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        Group gvectorShowGroup = new Group(this.controlsComposite, 0);
        gvectorShowGroup.setText("plot gvectors");
        gvectorShowGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        gvectorShowGroup.setLayout((Layout)new FillLayout());
        this.gvectorShowButton = new Button((Composite)gvectorShowGroup, 32);
        this.gvectorShowButton.setText("show all gvectors");
        this.gvectorShowButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (Grains3DView.this.gvectorShowButton.getSelection()) {
                    showGVectors = true;
                    Grains3DView.drawAllGvectorsList();
                } else {
                    showGVectors = false;
                    Grains3DView.drawAllGvectorsList();
                }
            }
        });
        Group grainSelectGroup = new Group(this.controlsComposite, 0);
        grainSelectGroup.setText("plot grain");
        grainSelectGroup.setLayout((Layout)new FillLayout());
        grainSelectGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        grainSelectCombo = new Combo((Composite)grainSelectGroup, 4);
        grainSelectCombo.add("all grains");
        int i = 0;
        while (i < grains) {
            grainSelectCombo.add(Integer.toString(i + 1));
            ++i;
        }
        grainSelectCombo.select(0);
        grainSelectCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                selectedGrain = grainSelectCombo.getSelectionIndex();
                if (selectedGrain > 0) {
                    Grains3DView.setXyz(grainSpotter.getGrainGveXYZ(selectedGrain - 1));
                } else {
                    Grains3DView.setXyz(grainSpotter.getGrainGveXYZ(0));
                    int i = 1;
                    while (i < grains) {
                        Grains3DView.addXyz(grainSpotter.getGrainGveXYZ(i));
                        ++i;
                    }
                }
                Grains3DView.drawAllGvectorsList();
                Grains3DView.render();
                Grains3DView.resize(canvas);
            }
        });
        Group pointSizeGroup = new Group(this.controlsComposite, 0);
        pointSizeGroup.setText("point size");
        pointSizeGroup.setLayout((Layout)new FillLayout());
        pointSizeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        pointSizeSpinner = new Spinner((Composite)pointSizeGroup, 0x1000004);
        pointSizeSpinner.setMinimum(1);
        pointSizeSpinner.setMaximum(10);
        pointSizeSpinner.setSelection(1);
        pointSizeSpinner.setIncrement(1);
        pointSizeSpinner.setPageIncrement(5);
        pointSizeSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                pointSize = pointSizeSpinner.getSelection();
                Grains3DView.drawAllGvectorsList();
            }
        });
        GLData data = new GLData();
        data.doubleBuffer = true;
        Composite plotComposite = new Composite(parent, 4);
        GridLayout plotGridLayout = new GridLayout();
        plotGridLayout.numColumns = 2;
        plotComposite.setLayout((Layout)plotGridLayout);
        plotComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.canvasComposite = new Composite(plotComposite, 4);
        this.canvasComposite.setLayout((Layout)new GridLayout());
        this.canvasComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        canvas = new GLCanvas(this.canvasComposite, 262144, data);
        canvas.setLayoutData((Object)new GridData(4, 4, true, true));
        canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Grains3DView.resize(canvas);
            }
        });
        this.xyzControlsComposite = new Composite(plotComposite, 4);
        this.xyzControlsComposite.setLayout((Layout)new GridLayout());
        this.xyzControlsComposite.setLayoutData((Object)new GridData(0, 4, false, true));
        Group xoffGroup = new Group(this.xyzControlsComposite, 4);
        xoffGroup.setText("xoff");
        xoffGroup.setLayout((Layout)new FillLayout());
        xoffGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.xoffText = new Text((Composite)xoffGroup, 0x1000004);
        Group yoffGroup = new Group(this.xyzControlsComposite, 4);
        yoffGroup.setText("yoff");
        yoffGroup.setLayout((Layout)new FillLayout());
        yoffGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.yoffText = new Text((Composite)yoffGroup, 0x1000004);
        Group zoffGroup = new Group(this.xyzControlsComposite, 4);
        zoffGroup.setText("zoff");
        zoffGroup.setLayout((Layout)new FillLayout());
        zoffGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.zoffText = new Text((Composite)zoffGroup, 0x1000004);
        Group xrotGroup = new Group(this.xyzControlsComposite, 4);
        xrotGroup.setText("xrot");
        xrotGroup.setLayout((Layout)new FillLayout());
        xrotGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.xrotText = new Text((Composite)xrotGroup, 0x1000004);
        Group yrotGroup = new Group(this.xyzControlsComposite, 4);
        yrotGroup.setText("yrot");
        yrotGroup.setLayout((Layout)new FillLayout());
        yrotGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.yrotText = new Text((Composite)yrotGroup, 0x1000004);
        canvas.setCurrent();
        try {
            GLContext.useContext((Object)canvas);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        Grains3DView.init(canvas);
        grip = new SceneGrip();
        grip.setDefaultView();
        canvas.addMouseListener((MouseListener)grip);
        canvas.addMouseMoveListener((MouseMoveListener)grip);
        canvas.addListener(37, (Listener)grip);
        canvas.addKeyListener((KeyListener)grip);
        new Runnable(){

            @Override
            public void run() {
                if (canvas.isDisposed()) {
                    return;
                }
                Grains3DView.render();
                canvas.swapBuffers();
                canvas.getDisplay().timerExec(100, (Runnable)this);
            }
        }.run();
        parent.pack();
    }

    private static void drawAllGvectorsList() {
        int i_gv;
        if (allGvectorsListFirst.booleanValue()) {
            GL11.glDeleteLists((int)allGvectorsList, (int)1);
            allGvectorsList = GL11.glGenLists((int)1);
        }
        allGvectorsListFirst = false;
        GL11.glNewList((int)allGvectorsList, (int)4864);
        GL11.glPointSize((float)pointSize);
        if (showGVectors.booleanValue()) {
            GL11.glBegin((int)0);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            i_gv = 0;
            while (i_gv < GrainSpotter.gveXYZ.size()) {
                double[] gvector_xyz = GrainSpotter.gveXYZ.get(i_gv);
                GL11.glVertex3d((double)gvector_xyz[0], (double)gvector_xyz[1], (double)gvector_xyz[2]);
                ++i_gv;
            }
            GL11.glEnd();
        }
        GL11.glBegin((int)0);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        i_gv = 0;
        while (i_gv < xyz.length / 3) {
            GL11.glVertex3d((double)xyz[i_gv * 3], (double)xyz[i_gv * 3 + 1], (double)xyz[i_gv * 3 + 2]);
            ++i_gv;
        }
        GL11.glEnd();
        GL11.glEndList();
    }

    private static void drawGrainGvectorsList() {
        GL11.glNewList((int)grainGvectorsList, (int)4864);
        GL11.glPointSize((float)pointSize);
        GL11.glBegin((int)0);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        int i_gv = 0;
        while (i_gv < xyz.length / 3) {
            GL11.glVertex3d((double)xyz[i_gv * 3], (double)xyz[i_gv * 3 + 1], (double)xyz[i_gv * 3 + 2]);
            ++i_gv;
        }
        GL11.glEnd();
        GL11.glEndList();
    }

    public void setFocus() {
        canvas.setFocus();
    }

    public static double[] getXyz() {
        return xyz;
    }

    public static void setXyz(double[] _xyz) {
        xyz = _xyz;
    }

    public static void addXyz(double[] _xyz) {
        double[] xyz2 = new double[xyz.length + _xyz.length];
        int i = 0;
        while (i < xyz.length) {
            xyz2[i] = xyz[i];
            ++i;
        }
        i = 0;
        while (i < _xyz.length) {
            xyz2[i + Grains3DView.xyz.length] = _xyz[i];
            ++i;
        }
        xyz = xyz2;
    }

    public static int getPointSize() {
        return pointSize;
    }

    public static void setPointSize(int pointSize) {
        Grains3DView.pointSize = pointSize;
    }

    public static int getGrains() {
        return grains;
    }

    public static void setGrains(int grains) {
        Grains3DView.grains = grains;
        String[] items = new String[grains + 1];
        items[0] = "all grains";
        int i = 0;
        while (i < grains) {
            items[i + 1] = Integer.toString(i + 1);
            ++i;
        }
        grainSelectCombo.setItems(items);
    }

    public static void plotGrain(int iGrain) {
        grainSelectCombo.select(iGrain);
        Grains3DView.setXyz(grainSpotter.getGrainGveXYZ(iGrain));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.infoAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.infoAction);
    }

    private void makeActions() {
        this.infoAction = new Action(){

            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GraphicsHelpDialog dialog = new GraphicsHelpDialog(Grains3DView.this.getSite().getWorkbenchWindow().getShell());
                        dialog.open();
                    }
                });
            }
        };
        this.infoAction.setText("Graphics Help");
        this.infoAction.setToolTipText("Summary of Graphics Manipulations");
        this.infoAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private static String getGraphicsHelp() {
        String ls = System.getProperty("line.separator");
        String info = "";
        info = String.valueOf(info) + "Button 1: Drag to examine" + ls;
        info = String.valueOf(info) + "Button 2: Drag vertically to zoom" + ls;
        info = String.valueOf(info) + "Button 3: Drag to pan" + ls;
        info = String.valueOf(info) + "Mouse Wheel: Zoom in/out" + ls;
        info = String.valueOf(info) + ls;
        info = String.valueOf(info) + "Up Arrow: Pan up" + ls;
        info = String.valueOf(info) + "Down Arrow: Pan down" + ls;
        info = String.valueOf(info) + "Left Arrow: Pan left" + ls;
        info = String.valueOf(info) + "Right Arrow: Pan right" + ls;
        info = String.valueOf(info) + ls;
        info = String.valueOf(info) + "Ctrl + Up Arrow: Rotate one way about horizontal axis" + ls;
        info = String.valueOf(info) + "Ctrl + Down Arrow: Rotate other way about horizontal axis" + ls;
        info = String.valueOf(info) + "Ctrl + Left Arrow: Rotate one way about about vertical axis" + ls;
        info = String.valueOf(info) + "Ctrl + Right Arrow: Rotate other way about vertical axis" + ls;
        info = String.valueOf(info) + ls;
        info = String.valueOf(info) + "Page Up: Zoom in" + ls;
        info = String.valueOf(info) + "Page Down: Zoom out" + ls;
        info = String.valueOf(info) + ls;
        info = String.valueOf(info) + "Home: Reset" + ls;
        info = String.valueOf(info) + "End: Reset to X-Axis right, Y-axis up, Z-axis out";
        return info;
    }

    public class GraphicsHelpDialog
    extends Dialog {
        public GraphicsHelpDialog(Shell parent) {
            this(parent, 2144);
        }

        public GraphicsHelpDialog(Shell parent, int style) {
            super(parent, style);
        }

        public String open() {
            Shell shell = new Shell(this.getParent(), this.getStyle());
            shell.setText("Graphics Help");
            shell.setImage(Grains3DView.this.getTitleImage());
            this.createContents(shell);
            shell.pack();
            shell.open();
            Display display = this.getParent().getDisplay();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return null;
        }

        private void createContents(final Shell shell) {
            GridLayout grid = new GridLayout();
            grid.numColumns = 1;
            shell.setLayout((Layout)grid);
            Group box = new Group((Composite)shell, 2048);
            box.setText("Graphics Manipulations");
            grid = new GridLayout();
            grid.numColumns = 1;
            box.setLayout((Layout)grid);
            GridData data = new GridData();
            data.horizontalSpan = 1;
            box.setLayoutData((Object)data);
            Text text = new Text((Composite)box, 2);
            text.setEditable(false);
            text.setText(Grains3DView.getGraphicsHelp());
            data = new GridData();
            text.setLayoutData((Object)data);
            Button close = new Button((Composite)shell, 8);
            close.setText("Close");
            data = new GridData(64);
            close.setLayoutData((Object)data);
            close.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    shell.close();
                }
            });
            shell.setDefaultButton(close);
        }
    }

    public class SceneGrip
    extends MouseAdapter
    implements MouseMoveListener,
    Listener,
    KeyListener {
        private float xrot;
        private float yrot;
        private float zoff;
        private float xoff;
        private float yoff;
        private float xcpy;
        private float ycpy;
        private boolean move;
        private boolean zoom;
        private int xdown;
        private int ydown;
        private int ylast;
        private int mouseDown;

        public SceneGrip() {
            this.init();
        }

        protected void init() {
            this.yrot = 0.0f;
            this.xrot = 0.0f;
            this.yoff = 0.0f;
            this.xoff = 0.0f;
            this.zoff = -8.0f;
            Grains3DView.this.xrotText.setText(Float.toString(this.xrot));
            Grains3DView.this.yrotText.setText(Float.toString(this.yrot));
            Grains3DView.this.xoffText.setText(Float.toString(this.xoff));
            Grains3DView.this.yoffText.setText(Float.toString(this.yoff));
            Grains3DView.this.zoffText.setText(Float.toString(this.zoff));
        }

        public void setDefaultView() {
            this.init();
            grip.setOffsets(-0.25f, -0.25f, -5.5f);
            grip.setRotation(45.0f, -30.0f);
        }

        public void mouseDown(MouseEvent e) {
            if (++this.mouseDown == 1) {
                this.move = false;
                this.zoom = false;
                if (e.button == 2) {
                    this.zoom = true;
                } else {
                    this.move = e.button == 3;
                    if (this.move) {
                        this.xcpy = this.xoff;
                        this.ycpy = this.yoff;
                        ((Control)e.widget).setCursor(e.widget.getDisplay().getSystemCursor(21));
                    } else {
                        this.xcpy = this.xrot;
                        this.ycpy = this.yrot;
                        ((Control)e.widget).setCursor(e.widget.getDisplay().getSystemCursor(5));
                    }
                }
                this.xdown = e.x;
                this.ydown = this.ylast = e.y;
            }
        }

        public void mouseUp(MouseEvent e) {
            if (--this.mouseDown == 0) {
                ((Control)e.widget).setCursor(e.widget.getDisplay().getSystemCursor(0));
            }
        }

        public void mouseMove(MouseEvent e) {
            Point p = ((Control)e.widget).getSize();
            if (this.mouseDown > 0) {
                if (this.zoom) {
                    int dy = e.y - this.ylast;
                    this.ylast = e.y;
                    this.zoff += (float)dy / 6.0f;
                } else if (this.move) {
                    int dx = e.x - this.xdown;
                    int dy = e.y - this.ydown;
                    this.yoff = this.ycpy + (this.zoff + 1.0f) * (float)dy / (2.0f * (float)p.y);
                    this.xoff = this.xcpy - (this.zoff + 1.0f) * (float)dx / (2.0f * (float)p.x);
                } else {
                    int dx = e.x - this.xdown;
                    int dy = e.y - this.ydown;
                    this.xrot = this.xcpy + (float)dy / 2.0f;
                    this.yrot = this.ycpy + (float)dx / 2.0f;
                }
            }
        }

        public void handleEvent(Event event) {
            this.zoff += (float)event.count / 6.0f;
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 0x1000001: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.xrot -= 0.5f;
                        break;
                    }
                    this.yoff += 0.05f;
                    break;
                }
                case 0x1000002: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.xrot += 0.5f;
                        break;
                    }
                    this.yoff -= 0.05f;
                    break;
                }
                case 0x1000003: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.yrot -= 0.5f;
                        break;
                    }
                    this.xoff -= 0.05f;
                    break;
                }
                case 0x1000004: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.yrot += 0.5f;
                        break;
                    }
                    this.xoff += 0.05f;
                    break;
                }
                case 0x1000005: {
                    this.zoff += 0.05f;
                    break;
                }
                case 0x1000006: {
                    this.zoff -= 0.05f;
                    break;
                }
                case 0x1000007: {
                    this.setDefaultView();
                    break;
                }
                case 0x1000008: {
                    this.init();
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void updateTextDisplay() {
            DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance();
            nf.applyPattern("0.0");
            Grains3DView.this.xrotText.setText(nf.format(this.xrot));
            Grains3DView.this.yrotText.setText(nf.format(this.yrot));
            Grains3DView.this.xoffText.setText(nf.format(this.xoff));
            Grains3DView.this.yoffText.setText(nf.format(this.yoff));
            Grains3DView.this.zoffText.setText(nf.format(this.zoff));
        }

        public void adjust() {
            try {
                GLContext.useContext((Object)canvas);
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
            GL11.glOrtho((double)(-grip.zoff), (double)grip.zoff, (double)(-grip.zoff / aspect), (double)(grip.zoff / aspect), (double)-100000.0, (double)100000.0);
            GL11.glTranslatef((float)this.xoff, (float)this.yoff, (float)this.zoff);
            GL11.glRotatef((float)this.xrot, (float)0.1f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.yrot, (float)0.0f, (float)0.1f, (float)0.0f);
            this.updateTextDisplay();
        }

        public void setOffsets(float x, float y, float z) {
            this.xoff = x;
            this.yoff = y;
            this.zoff = z;
        }

        public void setRotation(float x, float y) {
            this.xrot = x;
            this.yrot = y;
        }
    }
}

