/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.editors;

import fable.framework.toolbox.FileText;
import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.IntegerText;
import fable.framework.toolbox.LookAndFeel;
import fable.framework.toolbox.StringText;
import fable.framework.toolbox.ToolBox;
import fable.framework.toolbox.TypedText;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.actions.RunAction;
import fable.grainspotter.editors.GrainspotterIniInput;
import fable.grainspotter.editors.GrainspotterTextEditor;
import fable.grainspotter.internal.IVarKeys;
import fable.grainspotter.rcp.Activator;
import fable.grainspotter.run.GrainSpotter;
import fable.grainspotter.run.GrainSpotterException;
import java.io.File;
import java.util.Vector;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.examples.rcp.texteditor.editors.SimpleEditor;
import org.eclipse.ui.part.MultiPageEditorPart;

public class GrainspotterInputEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
IPropertyChangeListener {
    private static final String ID = "fable.grainspotter.editors.GrainspotterInputEditor";
    private SimpleEditor editor;
    private GrainspotterIniInput input;
    private boolean dirty = false;
    private Spinner spaceGroupSpinner;
    private Combo spaceGroupCombo;
    private Combo spaceGroupTypeCombo;
    private Table dsRange;
    private Table tthRange;
    private Table etaRange;
    private Table omegaRange;
    private FileText txtFilegve;
    private StringText txtFilelog;
    private IntegerText cutsMinMeasurement;
    private FloatText cutsMinCompletenessText;
    private FloatText cutsMinUniqueness;
    private FloatText eulerStep;
    private FloatText minfracg;
    private IntegerText random;
    private Button fitpositionYes;
    private Button fitpositionFalse;
    private FloatText sigmaTth;
    private FloatText sigmaEta;
    private FloatText sigmaOmega;
    private FloatText nsigma;
    private int spaceGroup = 1;
    private int spaceGroupType = 0;
    private static String command = "GrainSpotter";
    public static GrainSpotter grainSpotter;
    private static final int numColIniGroup = 2;
    private static final int MAXROWS = 1;
    private Shell shell;
    private Display display;
    private Composite parent;
    private IMemento memento = null;
    private static String initialDirIni;
    private static String initialDirGve;
    private static String initialDirLog;
    protected int activeColumn;
    private FloatText omegaDeltaText;
    private Group tthRangeGroup;
    private Group dsGroup;
    ImageDescriptor deleteDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"images/delete.gif");
    ImageDescriptor addDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"images/add.gif");
    private IntegerText hklRingsText;
    private Button chooseDspacing;
    private Button chooseTthRange;

    static {
        initialDirIni = null;
        initialDirGve = null;
        initialDirLog = null;
    }

    public void doSave(IProgressMonitor arg0) {
        this.save();
    }

    private void save() {
        if (this.setOptions()) {
            this.dirty = false;
            this.firePropertyChange(257);
            this.input.getInputFile().save();
            this.setInput((IEditorInput)this.input);
            this.loadIniFile(this.input.inputFile.iniFileName);
        }
    }

    public void doSaveAs() {
        FileDialog dialog;
        String file;
        if (this.setOptions() && (file = (dialog = new FileDialog(Display.getDefault().getActiveShell(), 8192)).open()) != null) {
            this.input.getInputFile().saveAs(file);
            this.dirty = false;
            this.firePropertyChange(257);
            this.setPageText(0, this.input.getName());
            this.input.getInputFile().setFile(file);
            File newFile = new File(file);
            Path location = new Path(newFile.getAbsolutePath());
            this.input = new GrainspotterIniInput((IPath)location);
            grainSpotter.setInput(this.input);
            this.setInput((IEditorInput)this.input);
            this.setPartName(this.input.getName());
            this.loadIniFile(this.input.inputFile.iniFileName);
            this.setPageText(0, this.input.inputFile.iniFileName);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof GrainspotterIniInput)) {
            throw new PartInitException("Invalid Input: Must be ini file");
        }
        super.init(site, editorInput);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(editorInput);
        this.input = (GrainspotterIniInput)editorInput;
        this.setPartName(this.input.getName());
        this.loadIniFile(this.input.inputFile.iniFileName);
        this.getEditorSite().getActionBars().setGlobalActionHandler("fable.grainspotter.actions.RunAction", (IAction)new RunAction());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public GrainspotterInputEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    void createPage0() {
        this.parent = this.getContainer();
        this.shell = this.parent.getShell();
        this.display = this.parent.getDisplay();
        if (grainSpotter == null) {
            grainSpotter = GrainSpotter.getInstance();
        }
        if (this.memento != null) {
            initialDirIni = this.memento.getString("initialDirIni");
            initialDirGve = this.memento.getString("initialDirGve");
            initialDirLog = this.memento.getString("initialDirLog");
        }
        GridLayout oneColGridLayout = new GridLayout();
        oneColGridLayout.numColumns = 1;
        oneColGridLayout.makeColumnsEqualWidth = true;
        GridLayout twoColGridLayout = new GridLayout();
        twoColGridLayout.numColumns = 2;
        twoColGridLayout.makeColumnsEqualWidth = true;
        GridLayout threeColGridLayout = new GridLayout();
        threeColGridLayout.numColumns = 3;
        threeColGridLayout.makeColumnsEqualWidth = true;
        GridLayout forColGridLayout = new GridLayout();
        forColGridLayout.numColumns = 4;
        forColGridLayout.makeColumnsEqualWidth = true;
        GridLayout sixColGridLayout = new GridLayout();
        sixColGridLayout.numColumns = 6;
        sixColGridLayout.makeColumnsEqualWidth = true;
        ScrolledComposite sc = new ScrolledComposite(this.parent, 768);
        this.parent.setLayout((Layout)oneColGridLayout);
        Composite container = new Composite((Composite)sc, 16);
        sc.setContent((Control)container);
        container.setLayout((Layout)forColGridLayout);
        container.setLayoutData((Object)new GridData(16384, 16, false, false));
        this.createGroupDataSpecs(container);
        this.createGroupSpacegrp(container);
        this.createGroupThree(container);
        this.createGroupCuts(container);
        this.createGroupUncertainties(container);
        Group chooseBetween = new Group(container, 0);
        chooseBetween.setText("");
        chooseBetween.setLayout((Layout)new GridLayout(2, false));
        chooseBetween.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.chooseDspacing = new Button((Composite)chooseBetween, 16);
        this.chooseDspacing.setText("Define d-spacing range");
        this.chooseDspacing.setSelection(true);
        this.chooseTthRange = new Button((Composite)chooseBetween, 16);
        this.chooseTthRange.setText("or tth range");
        this.chooseDspacing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainspotterInputEditor.this.setEnableGroup((Composite)GrainspotterInputEditor.this.dsGroup, ((Button)e.widget).getSelection());
                GrainspotterInputEditor.this.setEnableGroup((Composite)GrainspotterInputEditor.this.tthRangeGroup, !((Button)e.widget).getSelection());
            }
        });
        this.chooseTthRange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainspotterInputEditor.this.setEnableGroup((Composite)GrainspotterInputEditor.this.dsGroup, !((Button)e.widget).getSelection());
                GrainspotterInputEditor.this.setEnableGroup((Composite)GrainspotterInputEditor.this.tthRangeGroup, ((Button)e.widget).getSelection());
            }
        });
        String[] columnsProperties = this.createGroupDsRange((Composite)chooseBetween);
        this.createGroupTthrange((Composite)chooseBetween, columnsProperties);
        this.createGroupEtaRange(container, columnsProperties);
        this.createGroupOmegaRange(container, columnsProperties);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        sc.setMinSize(container.computeSize(-1, -1));
        int index = this.addPage((Control)sc);
        this.setPageText(index, "View");
        this.setEnableGroup((Composite)this.dsGroup, this.chooseDspacing.getSelection());
        this.setEnableGroup((Composite)this.tthRangeGroup, !this.chooseDspacing.getSelection());
    }

    private void createGroupOmegaRange(Composite container, String[] columnsProperties) {
        Group omegaGroup = LookAndFeel.getGroup((Composite)container, (String)"Omegaspecs [-180/180 deg.]", (int)2, (int)1);
        GridData gdForOmega = new GridData(4, 4, true, false);
        omegaGroup.setLayoutData((Object)gdForOmega);
        omegaGroup.setToolTipText("The active interval in the omega angle");
        this.omegaDeltaText = new FloatText((Composite)omegaGroup, 4, "Delta");
        this.omegaDeltaText.setMaxValue(new Float(1.0).floatValue(), true);
        this.omegaDeltaText.setMinValue(new Float(0.0).floatValue(), false);
        this.omegaDeltaText.setToolTipText("omega delta");
        this.omegaDeltaText.set_isRequiredField(false);
        GridData deltaGridData = new GridData(4, 2, false, true, 2, 1);
        this.omegaDeltaText.setLayoutData((Object)deltaGridData);
        this.omegaRange = this.createRangeTable(columnsProperties, omegaGroup);
        this.omegaRange.setToolTipText("You can add several range for omega.");
        TableEditor omegaRangeEditor = new TableEditor(this.omegaRange);
        this.triggerTableSelection(this.omegaRange, omegaRangeEditor);
    }

    private void createGroupEtaRange(Composite container, String[] columnsProperties) {
        Group grp_EtatSpec = LookAndFeel.getGroup((Composite)container, (String)"Eta range [0-360 deg.]", (int)2, (int)1);
        grp_EtatSpec.setLayoutData((Object)new GridData(4, 4, true, false));
        grp_EtatSpec.setToolTipText("etarange [min max], multiple ranges can be specified");
        this.etaRange = this.createRangeTable(columnsProperties, grp_EtatSpec);
        ((GridData)this.etaRange.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)this.etaRange.getLayoutData()).verticalSpan = 2;
        ((GridData)this.etaRange.getLayoutData()).verticalAlignment = 4;
        TableEditor etaRangeEditor = new TableEditor(this.etaRange);
        this.etaRange.setToolTipText("You can add several range for eta.");
        this.triggerTableSelection(this.etaRange, etaRangeEditor);
    }

    public void setEnableGroup(Composite parent, boolean benable) {
        Control[] element = parent.getChildren();
        parent.setEnabled(benable);
        int i = 0;
        while (i < element.length) {
            if (element[i] instanceof Composite) {
                if (element[i] instanceof Group) {
                    this.setEnableGroup((Composite)element[i], benable);
                } else if (benable) {
                    element[i].setBackground(this.display.getSystemColor(1));
                } else {
                    element[i].setBackground(this.display.getSystemColor(22));
                }
            } else {
                element[i].setEnabled(benable);
            }
            ++i;
        }
    }

    private void createGroupTthrange(Composite container, String[] columnsProperties) {
        this.tthRangeGroup = LookAndFeel.getGroup((Composite)container, (String)"tth range [0-360 deg.]", (int)2, (int)1);
        this.tthRangeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tthRangeGroup.setToolTipText("tth range. Multiple ranges can be specified.");
        this.tthRange = this.createRangeTable(columnsProperties, this.tthRangeGroup);
        this.tthRange.setToolTipText("You can add several range for tth.");
        TableEditor tthRangeEditor = new TableEditor(this.tthRange);
        this.triggerTableSelection(this.tthRange, tthRangeEditor);
    }

    private String[] createGroupDsRange(Composite container) {
        this.dsGroup = LookAndFeel.getGroup((Composite)container, (String)"d-spacing in omega", (int)2, (int)1);
        GridData gdfords = new GridData(4, 4, true, false);
        this.dsGroup.setLayoutData((Object)gdfords);
        this.dsGroup.setToolTipText("d-spacing range, multiple ranges can be specified");
        String[] columnsProperties = new String[]{"Minimum", "Maximum"};
        this.dsRange = this.createRangeTable(columnsProperties, this.dsGroup);
        this.dsRange.setToolTipText("You can add several range for d-spacing.");
        TableEditor dsRangeEditor = this.createTableEditor(this.dsRange);
        this.triggerTableSelection(this.dsRange, dsRangeEditor);
        return columnsProperties;
    }

    private void createGroupDataSpecs(Composite container) {
        Group grp_dataSpec = LookAndFeel.getGroup((Composite)container, (String)"Dataspecs", (int)3, (int)2);
        new Label((Composite)grp_dataSpec, 0).setText("gve file");
        this.txtFilegve = new FileText((Composite)grp_dataSpec, 0, "");
        this.txtFilegve.set_isRequiredField(true);
        this.txtFilegve.setLayoutData((Object)new GridData(4, 16, true, false));
        this.txtFilegve.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    String filename = GrainspotterInputEditor.this.txtFilegve.getText();
                    File file = new File(filename);
                    GrainspotterInputEditor.this.loadGve(filename, file.getAbsolutePath());
                }
            }
        });
        Button btnBrowsegve = new Button((Composite)grp_dataSpec, 8);
        btnBrowsegve.setText("Browse");
        btnBrowsegve.setToolTipText("Select or enter a gve file");
        btnBrowsegve.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDlg = new FileDialog(GrainspotterInputEditor.this.shell, 0);
                fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_GVE);
                fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_GVE);
                fileDlg.setFilterPath(initialDirGve);
                fileDlg.setText("Select an existing gve file or enter a new file name");
                String file = fileDlg.open();
                if (file != null) {
                    GrainspotterInputEditor.this.txtFilegve.set_Text(file);
                    GrainspotterInputEditor.this.loadGve(file, fileDlg.getFilterPath());
                }
            }
        });
        new Label((Composite)grp_dataSpec, 0).setText("log file");
        this.txtFilelog = new StringText((Composite)grp_dataSpec, 0, "");
        this.txtFilelog.set_isRequiredField(true);
        this.txtFilelog.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String file = GrainspotterInputEditor.this.txtFilelog.getText();
                File myFile = new File(file);
                String path = "";
                if (myFile != null) {
                    path = myFile.getAbsolutePath();
                }
                GrainspotterInputEditor.this.setLogFile(file, path);
            }
        });
        this.txtFilelog.setLayoutData((Object)new GridData(4, 16, false, false));
        Button btnBrowselog = new Button((Composite)grp_dataSpec, 8);
        btnBrowselog.setText("Browse");
        btnBrowselog.setToolTipText("Select or enter a log file");
        btnBrowselog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDlg = new FileDialog(GrainspotterInputEditor.this.shell, 8192);
                fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_LOG);
                fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_LOG);
                fileDlg.setFilterPath(initialDirLog);
                fileDlg.setText("Select an existing log file or enter a new file name");
                String file = fileDlg.open();
                GrainspotterInputEditor.this.txtFilelog.set_Text(file);
                if (file != null) {
                    GrainspotterInputEditor.this.setLogFile(file, fileDlg.getFilterPath());
                }
            }
        });
    }

    private void setLogFile(String file, String filePath) {
        initialDirLog = filePath;
        grainSpotter.setLogFilePath(initialDirLog);
        GrainspotterInputEditor.synchronizeInitialDirectories(initialDirLog);
        if (!file.endsWith(".log")) {
            file = String.valueOf(file) + ".log";
        }
        this.dirty = true;
        this.firePropertyChange(257);
    }

    private void loadGve(String file, String gveDirectory) {
        initialDirGve = gveDirectory;
        grainSpotter.setGveFilePath(initialDirGve);
        GrainspotterInputEditor.synchronizeInitialDirectories(initialDirGve);
        if (!file.endsWith(".gve")) {
            file = String.valueOf(file) + ".gve";
        }
        this.dirty = true;
        this.firePropertyChange(257);
        this.input.getInputFile().setGveFileName(file);
        grainSpotter.setgVectorFile(file);
        new Thread(GrainSpotter.readgveThread).start();
    }

    private void createGroupSpacegrp(Composite container) {
        Group grp_spaceGroup = LookAndFeel.getGroup((Composite)container, (String)"", (int)6, (int)2);
        grp_spaceGroup.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        grp_spaceGroup.setToolTipText("Spacegroup is needed to calculate the equivalent matrices used in the pseudotwin analysis");
        new Label((Composite)grp_spaceGroup, 0).setText("Crystal system");
        this.spaceGroupTypeCombo = new Combo((Composite)grp_spaceGroup, 28);
        this.spaceGroupTypeCombo.setLayoutData((Object)new GridData(16384, 16, true, false));
        int i = 0;
        while (i < IVarKeys.SPACE_GROUP_TYPES.length) {
            this.spaceGroupTypeCombo.add(IVarKeys.SPACE_GROUP_TYPES[i]);
            ++i;
        }
        this.spaceGroupTypeCombo.select(0);
        this.spaceGroupTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GrainspotterInputEditor.this.spaceGroupType = GrainspotterInputEditor.this.spaceGroupTypeCombo.getSelectionIndex();
                GrainspotterInputEditor.this.spaceGroupCombo.setItems(IVarKeys.SPACE_GROUPS[GrainspotterInputEditor.this.spaceGroupType]);
                GrainspotterInputEditor.this.spaceGroupCombo.select(0);
                GrainspotterInputEditor.this.spaceGroup = IVarKeys.SPACE_GROUP_MINIMUM[GrainspotterInputEditor.this.spaceGroupType];
                GrainspotterInputEditor.this.spaceGroupSpinner.setSelection(GrainspotterInputEditor.this.spaceGroup);
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        new Label((Composite)grp_spaceGroup, 0).setText("Space group");
        this.spaceGroupCombo = new Combo((Composite)grp_spaceGroup, 28);
        this.spaceGroupCombo.setLayoutData((Object)new GridData(4, 16, true, false));
        i = 0;
        while (i < IVarKeys.SPACE_GROUPS[this.spaceGroupType].length) {
            this.spaceGroupCombo.add(IVarKeys.SPACE_GROUPS[this.spaceGroupType][i]);
            ++i;
        }
        this.spaceGroupTypeCombo.select(0);
        this.spaceGroupCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GrainspotterInputEditor.this.spaceGroup = IVarKeys.SPACE_GROUP_MINIMUM[GrainspotterInputEditor.this.spaceGroupType] + GrainspotterInputEditor.this.spaceGroupCombo.getSelectionIndex();
                GrainspotterInputEditor.this.spaceGroupSpinner.setSelection(GrainspotterInputEditor.this.spaceGroup);
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        new Label((Composite)grp_spaceGroup, 0).setText("Number in the IUCr tables");
        this.spaceGroupSpinner = new Spinner((Composite)grp_spaceGroup, 2068);
        this.spaceGroupSpinner.setLayoutData((Object)new GridData(16384, 16, true, false));
        this.spaceGroupSpinner.setMaximum(230);
        this.spaceGroupSpinner.setMinimum(1);
        this.spaceGroupSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GrainspotterInputEditor.this.spaceGroup = GrainspotterInputEditor.this.spaceGroupSpinner.getSelection();
                GrainspotterInputEditor.this.setSpaceGroup(GrainspotterInputEditor.this.spaceGroup);
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
    }

    private void createGroupCuts(Composite container) {
        Group cutseulerComposite = LookAndFeel.getGroup((Composite)container, (String)"Cuts", (int)2, (int)1);
        cutseulerComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        cutseulerComposite.setToolTipText("Minimum requirement for accepting a grain solution");
        new Label((Composite)cutseulerComposite, 0).setText("Min. measurement");
        this.cutsMinMeasurement = new IntegerText((Composite)cutseulerComposite, 4, "");
        this.cutsMinMeasurement.setMinValue(new Integer(3).intValue(), false);
        this.cutsMinMeasurement.setToolTipText("Minimum number of g-vectors assigned to the grain (integer > 3)");
        this.cutsMinMeasurement.set_isRequiredField(false);
        new Label((Composite)cutseulerComposite, 0).setText("Min. completeness");
        this.cutsMinCompletenessText = new FloatText((Composite)cutseulerComposite, 4, "");
        this.cutsMinCompletenessText.setMaxValue(new Float(1.0).floatValue(), true);
        this.cutsMinCompletenessText.setToolTipText("Minimum fraction of expected reflections assigned to the grain (0<min completeness<1)");
        this.cutsMinCompletenessText.set_isRequiredField(false);
        new Label((Composite)cutseulerComposite, 0).setText("Min. uniqueness");
        this.cutsMinUniqueness = new FloatText((Composite)cutseulerComposite, 4, "");
        this.cutsMinUniqueness.setMaxValue(new Float(1.0).floatValue(), true);
        this.cutsMinUniqueness.setToolTipText("Minimum fraction of expected reflections assigned to the grain (0<min completeness<1)");
        this.cutsMinUniqueness.set_isRequiredField(false);
    }

    private void createGroupUncertainties(Composite container) {
        Group uncertGroup = LookAndFeel.getGroup((Composite)container, (String)"Uncertainties (in degrees)", (int)2, (int)2);
        uncertGroup.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        uncertGroup.setToolTipText("Until full error estimation is available on the gvectors in the input gvector file, sigma_tth, sigma_eta and sigma_omega give YOUR estimation on the uncertainties in degrees on eta, omega and tth.");
        new Label((Composite)uncertGroup, 0).setText("Sigma tth");
        this.sigmaTth = new FloatText((Composite)uncertGroup, 0, "");
        this.sigmaTth.setToolTipText("2-theta");
        this.sigmaTth.setMinValue(new Float(0.0).floatValue(), false);
        this.sigmaTth.set_isRequiredField(false);
        new Label((Composite)uncertGroup, 0).setText("Sigma eta");
        this.sigmaEta = new FloatText((Composite)uncertGroup, 0, "");
        this.sigmaEta.setToolTipText("eta uncertainty");
        this.sigmaEta.setMinValue(new Float(0.0).floatValue(), false);
        this.sigmaEta.set_isRequiredField(false);
        new Label((Composite)uncertGroup, 0).setText("sigma omega");
        this.sigmaOmega = new FloatText((Composite)uncertGroup, 0, "");
        this.sigmaOmega.setMinValue(new Float(0.0).floatValue(), false);
        this.sigmaOmega.setToolTipText("omega uncertainty");
        this.sigmaOmega.set_isRequiredField(false);
        new Label((Composite)uncertGroup, 0).setText("Sigmas (maximal deviation)");
        this.nsigma = new FloatText((Composite)uncertGroup, 0, "");
        this.nsigma.setToolTipText("sigma (float >0)");
        this.nsigma.setMinValue(new Float(0.0).floatValue(), false);
        this.nsigma.set_isRequiredField(false);
    }

    private void createGroupThree(Composite container) {
        Group grp = LookAndFeel.getGroup((Composite)container, (String)"", (int)3, (int)2);
        grp.setLayoutData((Object)new GridData(16384, 4, true, false, 1, 1));
        Label l = new Label((Composite)grp, 0);
        l.setText("Step Size in Euler space [0/180 deg.]");
        this.eulerStep = new FloatText((Composite)grp, 0, "", 0.0f, 180.0f);
        this.eulerStep.setToolTipText("Step Size in Euler space");
        this.eulerStep.set_isRequiredField(false);
        this.eulerStep.setLayoutData((Object)new GridData(16384, 2, false, false, 2, 1));
        Label labelHkl = new Label((Composite)grp, 0);
        labelHkl.setText("NHkls : Number hkl families used");
        this.hklRingsText = new IntegerText((Composite)grp, 0, "");
        this.hklRingsText.setMinValue(new Integer(0).intValue(), false);
        this.hklRingsText.setToolTipText("hkl rings (integer > 0)");
        this.hklRingsText.set_isRequiredField(false);
        this.hklRingsText.setLayoutData((Object)new GridData(16384, 2, false, false, 2, 1));
        new Label((Composite)grp, 0).setText("Minfracg");
        this.minfracg = new FloatText((Composite)grp, 0, "");
        this.minfracg.setToolTipText("");
        this.minfracg.set_isRequiredField(false);
        this.minfracg.setLayoutData((Object)new GridData(16384, 2, false, false, 2, 1));
        new Label((Composite)grp, 0).setText("Random : Number of trial orientation");
        this.random = new IntegerText((Composite)grp, 0);
        this.random.setLayoutData((Object)new GridData(16384, 2, false, false, 2, 1));
        new Label((Composite)grp, 0).setText("Fit position ?");
        this.fitpositionFalse = new Button((Composite)grp, 16);
        this.fitpositionFalse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.fitpositionFalse.setText("No");
        this.fitpositionFalse.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.fitpositionYes = new Button((Composite)grp, 16);
        this.fitpositionYes.setText("Yes");
        this.fitpositionYes.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.fitpositionYes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.fitpositionFalse.setSelection(true);
    }

    private Table createRangeTable(String[] columnsProperties, Group dsGroup) {
        Table table = new Table((Composite)dsGroup, 68352);
        table.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 2));
        this.triggerColumnSelectedColumn(table);
        this.createMinMaxColumn(table, columnsProperties);
        this.createRows(table, 1);
        this.createAddButton((Composite)dsGroup, table);
        this.createRemoveItemButton((Composite)dsGroup, table);
        return table;
    }

    private TableEditor createTableEditor(Table table) {
        TableEditor rangeEditor = new TableEditor(table);
        rangeEditor.horizontalAlignment = 16384;
        rangeEditor.grabHorizontal = true;
        rangeEditor.minimumWidth = 50;
        return rangeEditor;
    }

    private void createRows(Table table, int maxrows) {
        int i = 0;
        while (i < maxrows) {
            new TableItem(table, 0);
            ++i;
        }
    }

    private void triggerTableSelection(final Table table, final TableEditor tableEditor) {
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                Control oldEditor = tableEditor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((index = table.getSelectionIndex()) == -1) {
                    return;
                }
                TableItem tableItem = table.getItem(index);
                Text selectedItem = new Text((Composite)table, 0);
                selectedItem.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent arg0) {
                        Text txt = (Text)tableEditor.getEditor();
                        tableEditor.getItem().setText((this).GrainspotterInputEditor.this.activeColumn, txt.getText());
                    }
                });
                tableEditor.setEditor((Control)selectedItem, tableItem, GrainspotterInputEditor.this.activeColumn);
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
                selectedItem.setFocus();
            }
        });
    }

    private void createMinMaxColumn(Table table, String[] columnsProperties) {
        TableColumn columnMin = new TableColumn(table, 0);
        columnMin.setText(columnsProperties[0]);
        columnMin.setWidth(100);
        columnMin.setData("index", (Object)0);
        TableColumn columnMax = new TableColumn(table, 0);
        columnMax.setText(columnsProperties[1]);
        columnMax.setWidth(100);
        columnMax.setData("index", (Object)1);
        table.setHeaderVisible(true);
        columnMin.pack();
        columnMax.pack();
        table.pack();
    }

    private void createRemoveItemButton(Composite container, final Table dsTable) {
        Button removeButton = new Button(container, 8);
        final Image imageremove = this.deleteDescriptor.createImage();
        removeButton.setImage(imageremove);
        removeButton.setLayoutData((Object)new GridData(16384, 1024, false, false));
        removeButton.setToolTipText("remove a range for this option.");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = dsTable.getSelectionIndex();
                if (index != -1) {
                    TableItem tableItem = dsTable.getItem(index);
                    tableItem.dispose();
                }
            }
        });
        removeButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageremove != null && !imageremove.isDisposed()) {
                    imageremove.dispose();
                }
            }
        });
    }

    private void createAddButton(Composite container, final Table dsTable) {
        Button addButton = new Button(container, 8);
        addButton.setLayoutData((Object)new GridData(16384, 1024, false, true));
        final Image imageAdd = this.addDescriptor.createImage();
        addButton.setImage(imageAdd);
        addButton.setToolTipText("Add a new range in table for this option.");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new TableItem(dsTable, 0);
            }
        });
        addButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageAdd != null && !imageAdd.isDisposed()) {
                    imageAdd.dispose();
                }
            }
        });
    }

    public void setFocus() {
        GrainSpotter.getInstance().setInput(this.input);
    }

    public static String getID() {
        return ID;
    }

    public void loadIniFile(String txt) {
        GrainSpotter.getInstance().setInput(this.input);
    }

    private void setModifyListener() {
        this.txtFilelog.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.txtFilegve.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
                String file = GrainspotterInputEditor.this.txtFilegve.getText();
                if (ToolBox.checkIfFileExists((String)file)) {
                    grainSpotter.setgVectorFile(file);
                    GrainspotterInputEditor.this.input.getInputFile().setGveFileName(file);
                    new Thread(GrainSpotter.readgveThread).start();
                }
            }
        });
        this.minfracg.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.omegaDeltaText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.eulerStep.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.cutsMinMeasurement.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.hklRingsText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.cutsMinCompletenessText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
    }

    private void initFields() {
        this.setGveFile(this.input.inputFile.getGveFileName());
        this.setLogFile(this.input.inputFile.getLogFileName());
        this.setSpaceGroup(this.input.inputFile.getSpaceGroup());
        this.setDsRange(this.input.inputFile.getDsRange());
        this.setOmegaRange(this.input.inputFile.getOmegaRange());
        if (!this.input.inputFile.isIgnoreOptionDeltaOmegaSpec()) {
            this.setDeltaOmega(this.input.inputFile.getDeltaOmegaSpecs());
        }
        if (!this.input.inputFile.isIgnoreOptionUncertainties()) {
            this.set_uncertTthText(this.input.inputFile.getTtUncertainties());
            this.set_uncertEtaText(this.input.inputFile.getEtaUncertainties());
            this.set_uncertOmegaText(this.input.inputFile.getOmegaUncertainties());
        }
        this.setTthRange(this.input.inputFile.getTthRange());
        this.setEtaRange(this.input.inputFile.getEtaRange());
        if (!this.input.inputFile.isIgnoreOptionCuts()) {
            this.set_cutsMinCompletenessText(this.input.inputFile.getMinCompletenessCuts());
            this.set_cutsMinMeasurement(this.input.inputFile.getMinMeasurementCuts());
            this.set_cutsMinUniqueness(this.input.inputFile.getMinMeasurementUniqueness());
        }
        if (!this.input.inputFile.isIgnoreOptionEuler()) {
            this.set_eulerStep(this.input.inputFile.getStepEuler());
        }
        if (!this.input.inputFile.isIgnoreOptionNSigma()) {
            this.set_sigmaText(this.input.inputFile.getNSigmas());
        }
        if (!this.input.inputFile.isIgnoreOptionHKL()) {
            this.setNHkls(this.input.inputFile.getNHKLs());
        }
        if (!this.input.inputFile.isIgnoreOptionMinfracg()) {
            this.setMinfracg(this.input.inputFile.getMinfracg());
        }
        if (!this.input.inputFile.isIgnoreOptionRandom()) {
            this.setRandom(this.input.inputFile.getRandom());
        }
        this.setPositionFit(this.input.inputFile.isPositionFit());
        GrainspotterInputEditor.synchronizeInitialDirectories(this.input.inputFile.getIniFilePath());
        grainSpotter.setLogFilePath(initialDirLog);
        grainSpotter.setGveFilePath(initialDirGve);
        this.setPageText(0, this.input.inputFile.iniFileName);
    }

    private void setLogFile(String logFileName) {
        this.txtFilelog.set_Text(logFileName);
    }

    private void setGveFile(String gveFileName) {
        this.txtFilegve.set_Text(gveFileName);
    }

    private void setRandom(int sigmas) {
        this.random.set_Text(String.valueOf(sigmas));
    }

    private void setDeltaOmega(float deltaOmegaSpecs) {
        this.omegaDeltaText.set_Text(String.valueOf(deltaOmegaSpecs));
    }

    private void setPositionFit(boolean positionFit) {
        this.fitpositionYes.setSelection(positionFit);
        this.fitpositionFalse.setSelection(!positionFit);
    }

    private void setDsRange(Vector<float[]> dsRange2) {
        int i = 0;
        while (i < dsRange2.size()) {
            TableItem item = new TableItem(this.dsRange, 0, 0);
            item.setText(0, String.valueOf(dsRange2.elementAt(i)[0]));
            item.setText(1, String.valueOf(dsRange2.elementAt(i)[1]));
            ++i;
        }
    }

    private void setTthRange(Vector<float[]> dsRange2) {
        int i = 0;
        while (i < dsRange2.size()) {
            TableItem item = new TableItem(this.tthRange, 0, 0);
            item.setText(0, String.valueOf(dsRange2.elementAt(i)[0]));
            item.setText(1, String.valueOf(dsRange2.elementAt(i)[1]));
            ++i;
        }
    }

    private void setEtaRange(Vector<float[]> dsRange2) {
        int i = 0;
        while (i < dsRange2.size()) {
            TableItem item = new TableItem(this.etaRange, 0, 0);
            item.setText(0, String.valueOf(dsRange2.elementAt(i)[0]));
            item.setText(1, String.valueOf(dsRange2.elementAt(i)[1]));
            ++i;
        }
    }

    private void setOmegaRange(Vector<float[]> dsRange2) {
        int i = 0;
        while (i < dsRange2.size()) {
            TableItem item = new TableItem(this.omegaRange, 0, 0);
            item.setText(0, String.valueOf(dsRange2.elementAt(i)[0]));
            item.setText(1, String.valueOf(dsRange2.elementAt(i)[1]));
            ++i;
        }
    }

    public boolean setOptions() {
        boolean bok = true;
        try {
            TableItem item;
            this.input.getInputFile().setSpaceGroup(this.spaceGroupSpinner.getSelection());
            if (!this.omegaDeltaText.getText().equals("")) {
                this.input.getInputFile().ignoreOptionDeltaOmegaSpecs(false);
                this.input.getInputFile().set_deltaOmegaSpecs(this.omegaDeltaText.getText());
            } else {
                this.input.getInputFile().ignoreOptionDeltaOmegaSpecs(true);
            }
            this.input.getInputFile().getOmegaRange().removeAllElements();
            int i = 0;
            while (i < this.omegaRange.getItemCount()) {
                item = this.omegaRange.getItem(i);
                if (item.getText(0) != null && !item.getText(0).equals("") && item.getText(1) != null && !item.getText(1).equals("")) {
                    this.input.getInputFile().addOmegaRange(item.getText(0), item.getText(1));
                }
                ++i;
            }
            this.input.getInputFile().getEtaRange().removeAllElements();
            i = 0;
            while (i < this.etaRange.getItemCount()) {
                item = this.etaRange.getItem(i);
                if (item.getText(0) != null && !item.getText(0).equals("") && item.getText(1) != null && !item.getText(1).equals("")) {
                    this.input.getInputFile().addEtaRange(item.getText(0), item.getText(1));
                }
                ++i;
            }
            this.input.getInputFile().getTthRange().removeAllElements();
            i = 0;
            while (this.chooseTthRange.getSelection() && i < this.tthRange.getItemCount()) {
                item = this.tthRange.getItem(i);
                if (item.getText(0) != null && !item.getText(0).equals("") && item.getText(1) != null && !item.getText(1).equals("")) {
                    this.input.getInputFile().addtthRange(item.getText(0), item.getText(1));
                }
                ++i;
            }
            this.input.getInputFile().getDsRange().removeAllElements();
            i = 0;
            while (this.chooseDspacing.getSelection() && i < this.dsRange.getItemCount()) {
                item = this.dsRange.getItem(i);
                if (item.getText(0) != null && !item.getText(0).equals("") && item.getText(1) != null && !item.getText(1).equals("")) {
                    this.input.getInputFile().addDsRange(item.getText(0), item.getText(1));
                }
                ++i;
            }
            if (!(this.cutsMinCompletenessText.getText().trim().equals("") || this.cutsMinMeasurement.getText().trim().equals("") || this.cutsMinUniqueness.getText().trim().equals(""))) {
                this.input.getInputFile().set_minCompletenessCuts(this.cutsMinCompletenessText.getText());
                this.input.getInputFile().set_minMeasurementCuts(this.cutsMinMeasurement.getText());
                this.input.getInputFile().setMinMeasurementUniqueness(this.cutsMinUniqueness.getText());
                this.input.getInputFile().ignoreOptionCuts(false);
            } else {
                this.input.getInputFile().ignoreOptionCuts(true);
            }
            if (!this.eulerStep.getText().trim().equals("")) {
                this.input.getInputFile().set_stepEuler(this.eulerStep.getText());
                this.input.getInputFile().ignoreOptionEuler(false);
            } else {
                this.input.getInputFile().ignoreOptionEuler(true);
            }
            if (!(this.sigmaTth.getText().trim().equals("") || this.sigmaEta.getText().trim().equals("") || this.sigmaOmega.getText().trim().equals(""))) {
                this.input.getInputFile().set_ttUncertanties(this.sigmaTth.getText());
                this.input.getInputFile().set_etaUncertanties(this.sigmaEta.getText());
                this.input.getInputFile().set_omegaUncertanties(this.sigmaOmega.getText());
                this.input.getInputFile().ignoreOptionUncertainties(false);
            } else {
                this.input.getInputFile().ignoreOptionUncertainties(true);
            }
            this.input.getInputFile().setGveFileName(this.txtFilegve.getText());
            grainSpotter.setgVectorFile(this.txtFilegve.getText());
            this.input.getInputFile().setLogFileName(this.txtFilelog.getText());
            if (!this.nsigma.getText().trim().equals("")) {
                this.input.getInputFile().set_nSigmas(this.nsigma.getText());
                this.input.getInputFile().ignoreOptionNSigma(false);
            } else {
                this.input.getInputFile().ignoreOptionNSigma(true);
            }
            if (!this.hklRingsText.getText().trim().equals("")) {
                this.input.getInputFile().set_nHKLs(this.hklRingsText.getText());
                this.input.getInputFile().ignoreOptionHKL(false);
            } else {
                this.input.getInputFile().ignoreOptionHKL(true);
            }
            if (!this.minfracg.getText().trim().equals("")) {
                this.input.getInputFile().setMinfracg(this.minfracg.getText());
                this.input.getInputFile().ignoreOptionMinfracg(false);
            } else {
                this.input.getInputFile().ignoreOptionMinfracg(true);
            }
            if (!this.random.getText().trim().equals("")) {
                this.input.getInputFile().setRandom(this.random.getText());
                this.input.getInputFile().ignoreOptionRandom(false);
            } else {
                this.input.getInputFile().ignoreOptionRandom(true);
            }
            this.input.getInputFile().setPositionFit(this.fitpositionYes.getSelection());
        }
        catch (GrainSpotterException e) {
            FableMessageConsole.console.displayIn(e.get_message());
            bok = false;
        }
        return bok;
    }

    public void setSpaceGroup(int _spaceGroup) {
        int newspaceGroupType = 0;
        this.spaceGroup = _spaceGroup;
        int i = 0;
        while (i < IVarKeys.SPACE_GROUP_MAXIMUM.length) {
            if (this.spaceGroup <= IVarKeys.SPACE_GROUP_MAXIMUM[i]) {
                newspaceGroupType = i;
                break;
            }
            ++i;
        }
        if (newspaceGroupType != this.spaceGroupType) {
            this.spaceGroupCombo.setItems(IVarKeys.SPACE_GROUPS[newspaceGroupType]);
            this.spaceGroupType = newspaceGroupType;
        }
        this.spaceGroupSpinner.setSelection(this.spaceGroup);
        this.spaceGroupTypeCombo.select(this.spaceGroupType);
        this.spaceGroupCombo.select(this.spaceGroup - IVarKeys.SPACE_GROUP_MINIMUM[this.spaceGroupType]);
    }

    private void set_eulerStep(float step) {
        this.eulerStep.set_Text(String.valueOf(step));
    }

    private void set_cutsMinCompletenessText(float f) {
        this.cutsMinCompletenessText.set_Text(String.valueOf(f));
    }

    private void set_cutsMinMeasurement(int minText) {
        this.cutsMinMeasurement.set_Text(String.valueOf(minText));
    }

    private void set_cutsMinUniqueness(float minText) {
        this.cutsMinUniqueness.set_Text(String.valueOf(minText));
    }

    private void set_sigmaText(float text) {
        this.nsigma.set_Text(String.valueOf(text));
    }

    private void set_uncertEtaText(float etaText) {
        this.sigmaEta.set_Text(String.valueOf(etaText));
    }

    private void set_uncertOmegaText(float omegaText) {
        this.sigmaOmega.set_Text(String.valueOf(omegaText));
    }

    private void set_uncertTthText(float thetaText) {
        this.sigmaTth.set_Text(String.valueOf(thetaText));
    }

    public void setNHkls(int hkl) {
        this.hklRingsText.set_Text(String.valueOf(hkl));
    }

    public void setMinfracg(float minfracg) {
        this.minfracg.set_Text(String.valueOf(minfracg));
    }

    private void triggerColumnSelectedColumn(final Table table) {
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int x = 0;
                int i = 0;
                while (i < table.getColumnCount()) {
                    if (e.x <= (x += table.getColumn(i).getWidth())) {
                        GrainspotterInputEditor.this.activeColumn = i;
                        break;
                    }
                    ++i;
                }
            }
        });
    }

    public static void synchronizeInitialDirectories(String dir) {
        if (dir == null) {
            return;
        }
        if (initialDirIni == null) {
            initialDirIni = dir;
        }
        if (initialDirGve == null) {
            initialDirGve = dir;
        }
        if (initialDirLog == null) {
            initialDirLog = dir;
        }
    }

    protected void createPages() {
        this.createPage0();
        this.initFields();
        this.setModifyListener();
        GrainSpotter.getInstance().addPropertyChangeListener(this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        event.getType();
    }

    void createPage1() {
        try {
            this.editor = new GrainspotterTextEditor();
            int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(index, this.editor.getTitle());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        GrainSpotter.getInstance().removePropertyChangeListener(this);
        super.dispose();
    }

    public boolean runGrainSpotter() {
        boolean fieldsOk = true;
        if (this.checkFields(this.parent, true)) {
            FableMessageConsole.console.displayOut("start running grainspotter with command : ");
            FableMessageConsole.console.displayOut(command);
            if (this.isDirty()) {
                this.save();
            } else {
                this.setOptions();
            }
            grainSpotter.run();
        } else {
            fieldsOk = false;
            if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayOut("Fields are not correct ");
                FableMessageConsole.console.activate();
            }
        }
        return fieldsOk;
    }

    private boolean checkFields(Composite parent2, boolean bok) {
        Control[] element = parent2.getChildren();
        int i = 0;
        while (bok && i < element.length) {
            if (element[i] instanceof Composite) {
                if (element[i] instanceof TypedText && !((TypedText)element[i]).is_bValide()) {
                    bok = false;
                    ((TypedText)element[i]).showError();
                    ((TypedText)element[i]).showrequired();
                } else {
                    bok = this.checkFields((Composite)element[i], bok);
                }
            }
            ++i;
        }
        return bok;
    }

    public static String getInitialDirLog() {
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String val;
        if (event.getProperty().equals("grainspotter") && GrainSpotter.getInstance().getInput().equals((Object)this.input) && (val = (String)event.getNewValue()).equals("launch")) {
            this.runGrainSpotter();
        }
    }

    class CellModifier
    implements ICellModifier {
        private TableViewer tableviewer;

        public CellModifier(TableViewer viewer) {
            this.tableviewer = viewer;
        }

        public boolean canModify(Object arg0, String arg1) {
            return true;
        }

        public Object getValue(Object arg0, String arg1) {
            this.tableviewer.getTable().getSelectionIndex();
            return null;
        }

        public void modify(Object element, String property, Object value) {
        }
    }
}

