/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.toolbox.Activator;
import org.eclipse.jface.fieldassist.DecoratedField;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlCreator;
import org.eclipse.jface.fieldassist.TextControlCreator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TypedText
extends Composite {
    protected static final int SPACING = 5;
    protected static final int MARGIN = 1;
    private final String ID_REQUIRED = "required.field";
    private final String ID_FORMAT = "format.field";
    protected boolean _bValide = true;
    protected boolean _isRequiredField;
    protected Label _label;
    protected DecoratedField _txtField;
    protected FieldDecorationRegistry _registry;
    protected Image _imgRequired = Activator.imageDescriptorFromPlugin((String)"fable.framework.toolbox", (String)"images/required_field.gif").createImage();
    protected Image _imgError = Activator.imageDescriptorFromPlugin((String)"fable.framework.toolbox", (String)"images/errorField.gif").createImage();
    protected String _errorMessage = "";
    private String name = "";

    protected TypedText(Composite parent, int style) {
        super(parent, style);
        GridLayout gl = new GridLayout(3, false);
        this.setLayout((Layout)gl);
        this.setLayoutData(new GridData(256, 2, true, true));
        this.createFields();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TypedText.this.controlResize();
            }
        });
        ((Text)this._txtField.getControl()).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TypedText.this._bValide = TypedText.this.checkValue(((Text)e.widget).getText());
                TypedText.this.showError();
                TypedText.this.showrequired();
            }
        });
        ((Text)this._txtField.getControl()).addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                TypedText.this._bValide = TypedText.this.checkValue(((Text)e.widget).getText());
                TypedText.this.showError();
                TypedText.this.showrequired();
            }
        });
    }

    protected TypedText(Composite parent, int style, String LabelText) {
        this(parent, style);
        this._label.setText(LabelText);
        this.name = LabelText;
    }

    public boolean set_Text(String txt) {
        if (txt != null) {
            ((Text)this._txtField.getControl()).setText(txt);
            this._bValide = this.checkValue(txt);
            this.showError();
            this.showrequired();
        }
        return this._bValide;
    }

    public void setBackground(Color color) {
        ((Text)this._txtField.getControl()).setBackground(color);
    }

    public void set_toolTipText(String tipText) {
        ((Text)this._txtField.getControl()).setToolTipText(tipText);
    }

    public Text getTextField() {
        return (Text)this._txtField.getControl();
    }

    public boolean is_bValide() {
        return this._bValide;
    }

    public void set_bValide(boolean valide) {
        this._bValide = valide;
    }

    public String getText() {
        return ((Text)this._txtField.getControl()).getText();
    }

    public boolean is_isRequiredField() {
        return this._isRequiredField;
    }

    public void set_isRequiredField(boolean requiredField) {
        this._isRequiredField = requiredField;
        this._bValide = this.checkValue(this.getText());
    }

    private void controlResize() {
        Point tExtent = ((Text)this._txtField.getControl()).computeSize(-1, -1, false);
        Point lExtend = this._label.computeSize(-1, -1, false);
        this._label.setBounds(1, 1, lExtend.x, lExtend.y);
        ((Text)this._txtField.getControl()).setBounds(tExtent.x + 5, 1, tExtent.x, tExtent.y);
    }

    private void createFields() {
        this._label = new Label((Composite)this, 0);
        this._label.setVisible(true);
        this._txtField = new DecoratedField((Composite)this, 2052, (IControlCreator)new TextControlCreator());
        this._registry = FieldDecorationRegistry.getDefault();
        this._registry.registerFieldDecoration("required.field", "This field is required", this._imgRequired);
        this._registry.registerFieldDecoration("format.field", "This field should contain a typed value", this._imgError);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        this._txtField.getLayoutControl().setLayoutData((Object)gd);
        this.set_Text("");
    }

    protected boolean checkValue(String str) {
        return this.is_isRequiredField();
    }

    public String getErrorMessage() {
        if (this.is_isRequiredField() && (((Text)this._txtField.getControl()).getText() == null || ((Text)this._txtField.getControl()).getText().equals(""))) {
            return "Field is required";
        }
        return this.getErrorFormatDescription();
    }

    public void showError() {
        this._txtField.addFieldDecoration(this._registry.getFieldDecoration("format.field"), 16384, false);
        if (!this.is_bValide()) {
            this._txtField.showDecoration(this._registry.getFieldDecoration("format.field"));
            this._registry.getFieldDecoration("format.field").setDescription(this.getErrorFormatDescription());
            this._txtField.updateDecoration(this._registry.getFieldDecoration("format.field"));
        } else {
            this._txtField.hideDecoration(this._registry.getFieldDecoration("format.field"));
        }
    }

    public void showrequired() {
        if (this.is_isRequiredField() && (((Text)this._txtField.getControl()).getText() == null || ((Text)this._txtField.getControl()).getText().equals(""))) {
            this._txtField.addFieldDecoration(this._registry.getFieldDecoration("required.field"), 16384, false);
            this._txtField.showDecoration(this._registry.getFieldDecoration("required.field"));
        } else {
            this._txtField.hideDecoration(this._registry.getFieldDecoration("required.field"));
        }
    }

    protected String getErrorFormatDescription() {
        return this._registry.getFieldDecoration("format.field").getDescription();
    }

    public void setEnabled(boolean enable) {
        ((Text)this._txtField.getControl()).setEnabled(enable);
    }

    public String toString() {
        String s = "";
        s = this._label != null && !this._label.getText().equals("") ? this._label.getText() : this.name;
        return s;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setLabel(String label) {
        this._label.setText(label);
    }
}

