/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.toolbox.FabioFile;
import fable.framework.toolbox.FabioFileException;
import fable.framework.toolbox.ISampleListener;
import fable.framework.toolbox.SampleEvent;
import fable.framework.toolbox.SampleException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import jep.JepException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class Sample {
    private String _Experiment;
    private String _name;
    private String _directoryPath;
    private String[] currentFiles;
    private static String DEFAULT_SAMPLE_PATH = "\\data\\opid11\\inhouse\\";
    private Vector<FabioFile> fabioFiles = new Vector();
    private Vector<FabioFile> filteredfabiofiles = new Vector();
    private Vector<ISampleListener> listListener = new Vector();
    private String fileFormat = "";
    private boolean bOk = true;
    public boolean headersRead = false;
    private String ndigits = "4";
    private String peaksearchOutStem = "";
    private ArrayList<IPropertyChangeListener> listeners = new ArrayList();
    private String[] keys = null;
    private int last = -1;
    int first = -1;
    private String filter = "";
    private boolean showInNavigator = true;
    private boolean isDirectory = true;
    private HashMap<String, double[]> headerValues = new HashMap();
    private HashMap<String, double[]> headerdiffValues = new HashMap();
    private FabioFile currentFabioFile;
    private boolean isValide = true;

    public Sample(String experimentName, String sampleName, String path, String[] listFiles) throws FabioFileException {
        this.set_name(sampleName);
        this.set_Experiment(experimentName);
        this.set_directoryPath(path);
        this.fabioFiles = new Vector();
        this.filteredfabiofiles = (Vector)this.fabioFiles.clone();
        this.addFabioFiles(listFiles);
    }

    public Sample(String experimentName, String sampleName, String path) {
        this.set_name(sampleName);
        this.set_Experiment(experimentName);
        this.set_directoryPath(path);
    }

    public Sample(String experimentName, String sampleName) {
        this.set_name(sampleName);
        this.set_Experiment(experimentName);
        String path = String.valueOf(DEFAULT_SAMPLE_PATH) + "\\" + experimentName + "\\" + sampleName;
        this.set_directoryPath(path);
    }

    public void addCurrentFiles(String[] newFiles) {
        this.currentFiles = newFiles;
        this.fireSampleHasNewFiles();
    }

    public void addFabioFiles(String[] newFiles) throws FabioFileException {
        int i = 0;
        while (newFiles != null && i < newFiles.length) {
            this.addFabioFile(newFiles[i]);
            ++i;
        }
        this.currentFiles = new String[this.fabioFiles.size()];
        i = 0;
        while (this.fabioFiles != null && i < this.fabioFiles.size()) {
            this.currentFiles[i] = this.fabioFiles.elementAt(i).getFullFilename();
            ++i;
        }
        this.filteredfabiofiles = (Vector)this.fabioFiles.clone();
        this.fireSampleHasNewFiles();
    }

    public void updatefabioFiles(String[] newFiles) throws FabioFileException {
        this.fabioFiles.removeAllElements();
        int i = 0;
        while (newFiles != null && i < newFiles.length) {
            this.addFabioFile(newFiles[i]);
            ++i;
        }
        this.currentFiles = new String[this.fabioFiles.size()];
        i = 0;
        while (this.fabioFiles != null && i < this.fabioFiles.size()) {
            this.currentFiles[i] = this.fabioFiles.elementAt(i).getFullFilename();
            ++i;
        }
        this.applyFilter();
        this.fireUpdatefiles();
    }

    public boolean addFabioFile(String fileName) throws FabioFileException {
        boolean bAdd = true;
        FabioFile f = new FabioFile(fileName);
        this.addPropertyChangeListener(f);
        f.addIndex(this.fabioFiles.size());
        this.fabioFiles.add(f);
        this.filteredfabiofiles.add(f);
        return bAdd;
    }

    public String[] getKeys() throws SampleException {
        if (this.fabioFiles != null && this.fabioFiles.size() > 0) {
            try {
                if (this.currentFabioFile != null) {
                    this.keys = this.currentFabioFile.getKeys();
                }
            }
            catch (FabioFileException fabioFileException) {
                throw new SampleException(this.getClass().getName(), "getKeys", "Header keys cannot be retrieve for current file ");
            }
            catch (JepException jepException) {
                throw new SampleException(this.getClass().getName(), "getKeys", "Header keys cannot be retrieve for current file ");
            }
        }
        return this.keys;
    }

    public boolean isValide() {
        return this.isValide;
    }

    public boolean HasFile() {
        return this.currentFiles != null && this.currentFiles.length > 0;
    }

    public String get_Experiment() {
        return this._Experiment;
    }

    public void set_Experiment(String experiment) {
        if (experiment != null) {
            this._Experiment = experiment;
        }
    }

    public String get_name() {
        return this._name;
    }

    public void set_name(String name) {
        if (name != null) {
            this._name = name;
        }
    }

    public String get_directoryPath() {
        return this._directoryPath;
    }

    public void set_directoryPath(String path) {
        this._directoryPath = path;
    }

    public String toString() {
        return "Experiment : " + this.get_Experiment() + " Sample name: " + this.get_name() + " Directory: " + this.get_directoryPath();
    }

    public String[] getFabioFilesToProcess(boolean flag) {
        Vector<String> filesToGet = new Vector<String>();
        int i = 0;
        while (this.filteredfabiofiles != null && i < this.filteredfabiofiles.size() && this.filteredfabiofiles.elementAt(i).getFlag()) {
            filesToGet.add(this.filteredfabiofiles.elementAt(i).getFullFilename());
            ++i;
        }
        String[] files = new String[filesToGet.size()];
        int i2 = 0;
        while (i2 < filesToGet.size()) {
            files[i2] = (String)filesToGet.elementAt(i2);
            ++i2;
        }
        return files;
    }

    public String[] get_files() {
        return this.currentFiles;
    }

    public void set_files(String[] _files) {
        this.currentFiles = _files;
    }

    public void set_CurrentFilesFromFabio() {
        this.currentFiles = new String[this.fabioFiles.size()];
        int i = 0;
        while (this.fabioFiles != null && i < this.fabioFiles.size()) {
            this.currentFiles[i] = this.fabioFiles.elementAt(i).getFullFilename();
            ++i;
        }
        this.fireSampleHasNewFiles();
    }

    public Vector<FabioFile> getFabioFiles() {
        return this.fabioFiles;
    }

    public Vector<FabioFile> getFilteredfiles() {
        return this.filteredfabiofiles;
    }

    public void setComparator(String Key, int dir) {
        this.fireSetComparator(Key);
        this.fireSetDirection(dir);
    }

    public Vector<FabioFile> getSortedFiles() {
        new Date();
        Collections.sort(this.fabioFiles);
        return this.fabioFiles;
    }

    private void fireSetComparator(String key) {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "comparator", null, (Object)key));
        }
    }

    private void fireSetDirection(int dir) {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "dir", null, (Object)dir));
        }
    }

    private void fireUpdatefiles() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "updatefiles", null, (Object)this));
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyrChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void removeFiles() {
        if (this.HasFile()) {
            this.currentFiles = null;
            this.fabioFiles.removeAllElements();
            this.fireSampleHasChanged();
        }
    }

    public void removeFileAt(int indice) {
        if (this.HasFile()) {
            this.fabioFiles.removeElementAt(indice);
            this.fireSampleHasChanged();
        }
    }

    public void removeFabioFile(FabioFile f) {
        if (this.HasFile() && f != null) {
            this.fabioFiles.removeElement(f);
            if (this.filteredfabiofiles != null && this.filteredfabiofiles.size() > 0) {
                this.filteredfabiofiles.remove(f);
            }
            this.fireSampleHasChanged();
        }
    }

    public void setFilter(String s_filter) {
        this.filter = s_filter;
        this.applyFilter();
    }

    private void applyFilter() {
        this.filteredfabiofiles = (Vector)this.fabioFiles.clone();
        if (this.filter != null && !this.filter.trim().equals("")) {
            for (FabioFile file : this.fabioFiles) {
                String filename = file.getFileName();
                if (!filename.contains(this.filter)) {
                    this.filteredfabiofiles.remove(file);
                    continue;
                }
                int updateIndex = this.filteredfabiofiles.indexOf(file);
                if (updateIndex < 0) continue;
                file.addHeaderInfo("#", String.valueOf(updateIndex));
            }
        } else {
            int i = 0;
            while (i < this.fabioFiles.size()) {
                this.fabioFiles.elementAt(i).addHeaderInfo("#", String.valueOf(i));
                ++i;
            }
        }
    }

    private void fireSampleHasNewFiles() {
        SampleEvent se = new SampleEvent(this);
        Enumeration<ISampleListener> e = this.listListener.elements();
        while (e.hasMoreElements()) {
            e.nextElement().newImages(se);
        }
    }

    private void fireSampleHasChanged() {
        SampleEvent se = new SampleEvent(this);
        Enumeration<ISampleListener> e = this.listListener.elements();
        while (e.hasMoreElements()) {
            e.nextElement().sampleHasChanged(se);
        }
    }

    public void fireSomeHeaderValuesLoaded() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "updateHeaderValues", null, null));
        }
    }

    public void addSampleListener(ISampleListener pl) {
        this.listListener.add(pl);
    }

    public void removeSampleListener(ISampleListener pl) {
        this.listListener.remove(pl);
    }

    public String getStem() {
        String stem = "";
        if (this._name != null && !this._name.equals("")) {
            return this._name;
        }
        return stem;
    }

    public int getFirst() {
        if (this.HasFile() && this.first == -1) {
            try {
                this.first = this.getFileNumber(this.fabioFiles.elementAt(0).getFileName());
            }
            catch (FabioFileException fabioFileException) {
                this.first = 0;
            }
        }
        return this.first;
    }

    public void setFirst(int one) {
        this.first = one;
    }

    public void setlast(int l) {
        this.last = l;
    }

    public int getLast() {
        if (this.HasFile() && this.last == -1) {
            try {
                this.last = this.getFileNumber(this.fabioFiles.lastElement().getFileName());
            }
            catch (FabioFileException fabioFileException) {
                this.last = 0;
            }
        }
        return this.last;
    }

    private int getFileNumber(String filename) throws FabioFileException {
        String first = "";
        int ret = -99;
        if (this.getFileFormat().equals("bruker")) {
            first = filename.substring(filename.lastIndexOf("."));
        } else if ((filename = filename.substring(0, filename.indexOf("."))).length() - 4 > 0) {
            first = filename.substring(filename.length() - 4, filename.length());
        }
        try {
            ret = Integer.valueOf(first);
        }
        catch (Exception exception) {
            throw new FabioFileException(this.getClass().getName(), "getFileNumber", "Sample can not get file number");
        }
        return ret;
    }

    public String getFileFormat() {
        if (this.HasFile() && this.fileFormat.equals("")) {
            String fileName = this.fabioFiles.elementAt(0).getFileName();
            this.fileFormat = fileName.substring(fileName.indexOf("."));
            try {
                Integer.valueOf(this.fileFormat);
                this.fileFormat = "bruker";
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this.fileFormat;
    }

    public void setFileFormat(String format) {
        this.fileFormat = format;
    }

    public void setNDigits(String val) {
        this.ndigits = val;
    }

    public String getNDigits() {
        return this.ndigits;
    }

    public void setPeaksearchOutfile(String outfile) {
        this.peaksearchOutStem = outfile;
    }

    public String getPeaksearchoutStem() {
        return this.peaksearchOutStem;
    }

    public double[] getHeaderValues(final String key) throws SampleException {
        int size = this.filteredfabiofiles.size();
        double[] values = this.headerValues.get(key);
        Job job = new Job("Get values for " + key){

            protected IStatus run(final IProgressMonitor monitor) {
                monitor.beginTask("Wait while getting values for " + key + " in sample " + Sample.this.get_name(), Sample.this.filteredfabiofiles.size());
                if (Sample.this.HasFile()) {
                    int i = 0;
                    Iterator it = Sample.this.filteredfabiofiles.iterator();
                    while (it.hasNext()) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        final FabioFile f = (FabioFile)it.next();
                        if (i >= ((double[])Sample.this.headerValues.get(key)).length) continue;
                        final int j = i++;
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                double[] fillValues = (double[])Sample.this.headerValues.get(key);
                                try {
                                    if (key.toLowerCase().contains("date")) {
                                        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.UK);
                                        try {
                                            Date date = dateFormat.parse(f.getValue(key));
                                            date.getTime();
                                            fillValues[j] = date.getTime();
                                        }
                                        catch (ParseException parseException) {}
                                    } else {
                                        fillValues[j] = Double.valueOf(f.getValue(key));
                                    }
                                    if (j % 10 == 0 && j > 0) {
                                        Sample.this.fireSomeHeaderValuesLoaded();
                                    } else if (j == fillValues.length - 1) {
                                        Sample.this.fireSomeHeaderValuesLoaded();
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    monitor.setCanceled(true);
                                }
                                catch (FabioFileException fabioFileException) {
                                    monitor.setCanceled(true);
                                }
                            }
                        });
                        monitor.worked(1);
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        if (values == null || values.length != size) {
            values = new double[size];
            this.headerValues.put(key, values);
            job.schedule();
        }
        return this.headerValues.get(key);
    }

    public void addHeaderValues(String key, double[] values) {
        this.headerValues.put(key, values);
    }

    public double[] getHeaderValuesDiff(final String key) throws SampleException {
        int size = this.filteredfabiofiles.size();
        double[] values = this.headerdiffValues.get(key);
        Job job = new Job("Get values for " + key){

            protected IStatus run(final IProgressMonitor monitor) {
                monitor.beginTask("Wait while getting values for " + key + " in sample " + Sample.this.get_name(), Sample.this.filteredfabiofiles.size());
                if (Sample.this.HasFile()) {
                    int it = 0;
                    while (it < Sample.this.filteredfabiofiles.size()) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        final FabioFile f = (FabioFile)Sample.this.filteredfabiofiles.elementAt(it);
                        if (it + 1 < Sample.this.filteredfabiofiles.size()) {
                            final FabioFile next = (FabioFile)Sample.this.filteredfabiofiles.elementAt(it + 1);
                            if (it < ((double[])Sample.this.headerdiffValues.get(key)).length) {
                                final int j = it;
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        double[] fillValues = (double[])Sample.this.headerdiffValues.get(key);
                                        try {
                                            double dnext = Double.valueOf(next.getValue(key));
                                            double delem = Double.valueOf(f.getValue(key));
                                            fillValues[j] = dnext - delem;
                                            if (j % 10 == 0 && j > 0) {
                                                Sample.this.fireSomeHeaderValuesLoaded();
                                            } else if (j == fillValues.length - 1) {
                                                Sample.this.fireSomeHeaderValuesLoaded();
                                            }
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            fillValues[j] = 0.0;
                                            if (j % 10 == 0 && j > 0) {
                                                Sample.this.fireSomeHeaderValuesLoaded();
                                            } else if (j == fillValues.length - 1) {
                                                Sample.this.fireSomeHeaderValuesLoaded();
                                            }
                                        }
                                        catch (FabioFileException fabioFileException) {
                                            monitor.setCanceled(true);
                                        }
                                    }
                                });
                                monitor.worked(1);
                            }
                        }
                        ++it;
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        if (values == null || values.length != size) {
            values = new double[size];
            this.headerdiffValues.put(key, values);
            job.schedule();
        }
        return this.headerdiffValues.get(key);
    }

    public void setCurrentFile(FabioFile fabio) {
        this.currentFabioFile = fabio;
    }

    public FabioFile getCurrentFabioFile() {
        return this.currentFabioFile;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void setDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isShowInNavigator() {
        return this.showInNavigator;
    }

    public void setShowInNavigator(boolean showInNavigator) {
        this.showInNavigator = showInNavigator;
    }

    public void setValide(boolean b) {
        this.isValide = b;
    }
}

