/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.toolbox.FabioFile;
import fable.framework.toolbox.FabioFileException;
import fable.framework.toolbox.Peak;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class PeakSearchSpt {
    private int npks = 0;
    private String parentName = "";
    private Vector<Peak> peaks;
    private float treshold = 0.0f;
    float[] tabPeak = null;
    private List<IPropertyChangeListener> listeners = new ArrayList<IPropertyChangeListener>();
    String scannedPeak = "";
    String[] peakKeys;
    private FabioFile imageFile = null;
    private String fabioFileName = "";
    private PeakSearchSpt parent = this;
    protected boolean parsed = false;

    public PeakSearchSpt(String parentFileName) {
        this.peaks = new Vector(this.npks);
        this.parentName = parentFileName;
    }

    public void setNbPeaks(int pks) {
        this.npks = pks;
    }

    public void setTreshold(float t) {
        this.treshold = t;
    }

    public int getNbPeaks() {
        return this.npks;
    }

    public FabioFile getImageFile() {
        return this.imageFile;
    }

    public void initFabioFile(String fullFileName) throws FabioFileException {
        this.imageFile = new FabioFile(fullFileName);
    }

    public float getTreshold() {
        return this.treshold;
    }

    public void addPeak(Peak p) {
        this.peaks.add(p);
        this.addPropertyChangeListener(p);
    }

    public Vector<Peak> getSortedpeaks() {
        if (this.peaks != null && this.peaks.size() > 0) {
            Collections.sort(this.peaks);
        }
        return this.peaks;
    }

    public void setComparator(String Key, int dir) {
        this.fireChangeSorter(Key);
        this.firechangeSortdirection(dir);
    }

    public Peak getPeak(int i) {
        return this.peaks.elementAt(i);
    }

    public int getSize() {
        return this.peaks.size();
    }

    public String getParentFileName() {
        return this.parentName;
    }

    public String getFabioFileName() {
        return this.fabioFileName;
    }

    public Vector<Peak> getChildren() {
        return this.peaks;
    }

    public Vector<Float> getTabChildren() {
        Vector<Float> peaksToDisplay = new Vector<Float>(this.peaks.size());
        if (this.peaks != null) {
            int j = -1;
            int k = 0;
            int i = 0;
            while (i < this.peaks.size()) {
                if (this.getPeak(i).isVisible()) {
                    j = k + 1;
                    peaksToDisplay.add(k, Float.valueOf(this.getPeak(i).getS()));
                    peaksToDisplay.add(j, Float.valueOf(this.getPeak(i).getF()));
                    k += 2;
                }
                peaksToDisplay.setSize(j + 1);
                ++i;
            }
        }
        return peaksToDisplay;
    }

    public String toString() {
        return this.parentName;
    }

    public void setKeys(String listKeys) {
        this.peakKeys = listKeys.split("\\s+");
    }

    public void setKeys(String[] listKeys) {
        this.peakKeys = listKeys;
    }

    public void setPeaks(String blockWithAllPeaks) {
        this.scannedPeak = blockWithAllPeaks;
    }

    public void concatPeaks(String peak) {
        this.scannedPeak = this.scannedPeak.concat(peak);
        this.scannedPeak = String.valueOf(this.scannedPeak) + System.getProperty("line.separator");
    }

    public void parse() {
        Job parseJob = new Job("Getting " + this.npks + " peaks in file " + this.parentName){

            protected IStatus run(IProgressMonitor monitor) {
                if (!PeakSearchSpt.this.parsed) {
                    PeakSearchSpt.this.parsed = true;
                    Scanner scanner = new Scanner(PeakSearchSpt.this.scannedPeak);
                    scanner.useDelimiter("[\n\r]+");
                    monitor.beginTask("Wait while loading peaks", PeakSearchSpt.this.npks);
                    int percentage = 0;
                    int j = 0;
                    while (scanner.hasNext()) {
                        String line = scanner.nextLine();
                        if (line.trim().equals("")) continue;
                        line = String.valueOf(PeakSearchSpt.this.peaks.size()) + " " + line;
                        Peak p = new Peak(PeakSearchSpt.this.peakKeys, line);
                        p.setParent(PeakSearchSpt.this.parent);
                        p.show(true);
                        PeakSearchSpt.this.peaks.add(p);
                        percentage = PeakSearchSpt.this.peaks.size() * 100 / PeakSearchSpt.this.npks;
                        monitor.subTask(String.valueOf(percentage) + "% done");
                        if (j % 250 == 0 && j > 0) {
                            PeakSearchSpt.this.fireSomePeaksLoaded();
                        } else if (j == PeakSearchSpt.this.npks - 1) {
                            PeakSearchSpt.this.fireSomePeaksLoaded();
                        }
                        ++j;
                        monitor.worked(1);
                        if (!monitor.isCanceled()) continue;
                        scanner.close();
                        return Status.CANCEL_STATUS;
                    }
                    scanner.close();
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        parseJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                PeakSearchSpt.this.fireParseCompleted();
            }
        });
        parseJob.setUser(true);
        parseJob.schedule();
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public void setParsed(boolean parsed) {
        this.parsed = parsed;
    }

    private void fireSomePeaksLoaded() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "Parsing_working", null, null));
        }
    }

    private void fireParseCompleted() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "Parsing_completed", null, null));
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireChangeSorter(String comp) {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "comparator", null, (Object)comp));
        }
    }

    public void firechangeSortdirection(int comp) {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "dir", null, (Object)comp));
        }
    }

    public void setParentFileName(String sptFile) {
        this.parentName = sptFile;
    }

    public void setFabioFileName(String filename) {
        this.fabioFileName = filename;
    }

    public void setFabioFile(FabioFile object) {
        this.imageFile = object;
    }
}

