/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.toolbox.FabioFileException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class EdfFile {
    private HashMap<String, String> header;
    private String fileName;
    private Vector<String> vKeysInHeader;
    private byte[] buffer = null;
    private byte[] imageAsByte = null;
    private int[] imageAsInt = null;
    private ImageData imgData;
    private int headerEnd = 0;
    private int skipbytes;
    private int width;
    private int height;
    private double minimum = Double.MAX_VALUE;
    private double maximum = Double.MIN_VALUE;
    ImageLoader loader;
    ImageData[] imageDataArray;

    public EdfFile(String fileName) throws FabioFileException {
        this.header = new HashMap();
        this.vKeysInHeader = new Vector();
        this.fileName = fileName;
        this.loadHeader();
    }

    /*
     * Unable to fully structure code
     */
    private void loadHeader() throws FabioFileException {
        headerLine = null;
        inputStream = null;
        inputFileReader = null;
        EdfHeaderBegin = false;
        try {
            inputFileReader = new FileReader(this.fileName);
            inputStream = new BufferedReader(inputFileReader);
            if (true) ** GOTO lbl24
        }
        catch (IOException e) {
            throw new FabioFileException(this.getClass().getName(), "loadHeader()", e.getMessage());
        }
        {
            do {
                if (headerLine.startsWith("{")) {
                    EdfHeaderBegin = true;
                    continue;
                }
                if (!EdfHeaderBegin || (keyAndValue = headerLine.split("=")).length != 2) continue;
                key = keyAndValue[0].trim();
                value = keyAndValue[1].replaceAll(";", "");
                this.header.put(key, value);
                this.vKeysInHeader.add(key);
                this.skipbytes += headerLine.length();
                ++this.headerEnd;
lbl24:
                // 4 sources

            } while ((headerLine = inputStream.readLine()) != null && !headerLine.contains("}"));
        }
        try {
            inputFileReader.close();
            inputStream.close();
        }
        catch (IOException e) {
            throw new FabioFileException(this.getClass().getName(), "loadHeader()", e.getMessage());
        }
    }

    public String toString() {
        String myString = "{ \\n";
        Set<Map.Entry<String, String>> mySet = this.header.entrySet();
        for (Map.Entry<String, String> entry : mySet) {
            myString = String.valueOf(myString) + entry.getKey() + "=" + entry.getValue() + ";\\n";
        }
        myString = String.valueOf(myString) + "} \\n";
        return myString;
    }

    public String[] getKeys() {
        Set<String> mySet = this.header.keySet();
        return mySet.toArray(new String[mySet.size()]);
    }

    public Vector<String> getKeysAsListedInHeader() {
        return this.vKeysInHeader;
    }

    public String getValue(String key) throws FabioFileException {
        String myValue = "";
        if (!this.header.containsKey(key)) {
            throw new FabioFileException(this.getClass().getName(), "getValue()", "The key " + key + " has not be found in the header for the file ");
        }
        myValue = this.header.get(key);
        return myValue;
    }

    public int getWidth() {
        this.width = 0;
        try {
            this.width = Integer.parseInt(this.getValue("Dim_1").replaceAll("\\p{Space}", ""));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (FabioFileException e) {
            e.printStackTrace();
        }
        return this.width;
    }

    public int getHeight() {
        this.height = 0;
        try {
            this.height = Integer.parseInt(this.getValue("Dim_2").replaceAll("\\p{Space}", ""));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (FabioFileException e) {
            e.printStackTrace();
        }
        return this.height;
    }

    public int getBytesPerPixel() {
        return 2;
    }

    public void readBuffer() {
        RandomAccessFile randomFile = null;
        this.buffer = null;
        try {
            randomFile = new RandomAccessFile(this.fileName, "r");
            try {
                System.out.println("readBuffer(): read buffer");
                int imgSize = this.getHeight() * this.getWidth() * this.getBytesPerPixel();
                this.buffer = new byte[imgSize];
                randomFile.seek(randomFile.length() - (long)imgSize);
                randomFile.readFully(this.buffer);
                randomFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public int[] getImageAsInt() {
        if (this.buffer == null) {
            this.readBuffer();
        }
        if (this.imageAsInt == null) {
            System.out.println("getImageAsInt(): convert buffer to int");
            this.imageAsInt = new int[this.getWidth() * this.getHeight()];
            int i = 0;
            while (i < this.buffer.length / 2) {
                int lsb = 0xFF & this.buffer[i * 2];
                int msb = 0xFF & this.buffer[i * 2 + 1];
                this.imageAsInt[i] = msb * 256 + lsb;
                ++i;
            }
        }
        return this.imageAsInt;
    }

    public double getMinimum() {
        if (this.minimum == Double.MAX_VALUE) {
            this.getImageAsInt();
            int i = 0;
            while (i < this.imageAsInt.length) {
                if ((double)this.imageAsInt[i] < this.minimum) {
                    this.minimum = this.imageAsInt[i];
                }
                ++i;
            }
        }
        return this.minimum;
    }

    public double getMaximum() {
        if (this.maximum == Double.MIN_VALUE) {
            this.getImageAsInt();
            int i = 0;
            while (i < this.imageAsInt.length) {
                if ((double)this.imageAsInt[i] > this.maximum) {
                    this.maximum = this.imageAsInt[i];
                }
                ++i;
            }
        }
        return this.maximum;
    }
}

