/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.status;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public class StatusLineProcess
extends ContributionItem {
    public static final int DEFAULT_CHAR_WIDTH = 40;
    public static final int DEFAULT_CHAR_HEIGHT = 40;
    private CLabel label;
    private Image image;
    private String text = "";
    private int widthHint = -1;
    private int heightHint = -1;
    private Listener listener;
    private int eventType;
    private String tooltip;

    public StatusLineProcess(String id) {
        this(id, 40);
    }

    public StatusLineProcess(String id, int default_char_width2) {
        super(id);
        this.widthHint = default_char_width2;
        this.setVisible(false);
    }

    public void dispose() {
        super.dispose();
    }

    public void fill(Composite parent) {
        Label sep = new Label(parent, 2);
        this.label = new CLabel(parent, 32);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fm = gc.getFontMetrics();
        Point extent = gc.textExtent(this.text);
        int nwidthHint = this.widthHint > 0 ? fm.getAverageCharWidth() * this.widthHint : extent.x;
        this.heightHint = fm.getHeight();
        gc.dispose();
        StatusLineLayoutData statusLineLayoutData = new StatusLineLayoutData();
        statusLineLayoutData.widthHint = nwidthHint;
        statusLineLayoutData.heightHint = this.heightHint;
        this.label.setLayoutData((Object)statusLineLayoutData);
        this.label.setText(this.text);
        this.label.setImage(this.image);
        if (this.listener != null) {
            this.label.addListener(this.eventType, this.listener);
        }
        if (this.tooltip != null) {
            this.label.setToolTipText(this.tooltip);
        }
        statusLineLayoutData = new StatusLineLayoutData();
        statusLineLayoutData.heightHint = this.heightHint * 2;
        sep.setLayoutData((Object)statusLineLayoutData);
    }

    public void setText(String txt) {
        if (txt != null) {
            this.text = txt;
            if (this.label != null && !this.label.isDisposed()) {
                this.label.setText(this.text);
            }
            if (this.text.length() == 0) {
                if (this.isVisible()) {
                    this.setVisible(false);
                    IContributionManager contributionManager = this.getParent();
                    if (contributionManager != null) {
                        contributionManager.update(true);
                    }
                }
            } else if (!this.isVisible()) {
                this.setVisible(true);
                IContributionManager contributionManager = this.getParent();
                if (contributionManager != null) {
                    contributionManager.update(true);
                }
            }
        }
    }

    public void setTooltip(String tooltip) {
        if (tooltip == null) {
            throw new NullPointerException();
        }
        this.tooltip = tooltip;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setToolTipText(this.tooltip);
        }
    }

    public void setImage(Image image) {
        if (image == null) {
            throw new NullPointerException();
        }
        this.image = image;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setImage(this.image);
        }
        if (!this.isVisible()) {
            this.setVisible(true);
            IContributionManager contributionManager = this.getParent();
            if (contributionManager != null) {
                contributionManager.update(true);
            }
        }
    }
}

