/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.preferences;

import fable.framework.toolboxpreferences.StringFieldEditorWithRegex;
import fable.preprocessor.Activator;
import fable.preprocessor.views.SpdView;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SpdPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Composite parent;
    public static final String FILE_DARK = "pref_dark_file";
    public static final String FILE_FLOOD = "pref_flood_file";
    public static final String FILE_DIST = "pref_dist_file";
    public static final String APPLY_DARK = "pref_auto_dark";
    public static final String APPLY_FLOOD = "pref_auto_flood";
    public static final String APPLY_DIST = "pref_auto_dist";
    public static final String DARK_FILE_MODE = "pref_dark_getFileMode";
    public static final String FLOOD_FILE_MODE = "pref_flood_getFileMode";
    public static final String DIST_FILE_MODE = "pref_dist_getFileMode";
    public static final String PREPROCESSOR_MODE_ONOFF = "pref_mode";
    public static final String EXT_COR = "pref_ext_COR";
    public static final String EXT_COR_RADIO = "pref_ext_COR_SELECT";
    public static final String EXT_DARK = "pref_ext_dark";
    public static final String EXT_DIST = "pref_ext_dist";
    public static final String EXT_FLOOD = "pref_ext_flood";
    public static final String CMD_SPD = "pref_cmd_spd";
    public static final String SPD_MODE = "pref_spd_mode";
    public static final String SPD_SERVER = "pref_spd_server";
    public static final String SPD_OTHER_OPTIONS = "pref_spd_otherOptions";
    public static final String ZIP = "pref_zip";
    public static final String ZIP_PROGRAM = "pref_zip_program";
    public static final String TYPE = "pref_type";
    public static final String DVO = "pref_dvo";
    private BooleanFieldEditor bZip;
    private FileFieldEditor bZip_program;
    private BooleanFieldEditor bapplyDark;
    private BooleanFieldEditor bapplyFlood;
    private BooleanFieldEditor bapplyDist;
    private RadioGroupFieldEditor bDarkfileMode;
    private RadioGroupFieldEditor bFloodFileMode;
    private RadioGroupFieldEditor bDistFileMode;
    private RadioGroupFieldEditor spdMode;
    private RadioGroupFieldEditor runMode;
    private RadioGroupFieldEditor modecor_ext;
    private FileFieldEditor fileDark;
    private FileFieldEditor fileFlood;
    private FileFieldEditor filedist;
    private FileFieldEditor spdCommand;
    private StringFieldEditorWithRegex ext_cor;
    private IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
    private StringFieldEditor spdServer;
    private StringFieldEditor spd_other_options;
    private RadioGroupFieldEditor type;
    private StringFieldEditor dvo;

    public SpdPreferences() {
        super(1);
        this.setPreferenceStore(this.preferences);
    }

    protected Control createContents(Composite composite) {
        return super.createContents(composite);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (((FieldEditor)event.getSource()).getPreferenceName().equals(SPD_MODE) && !event.getNewValue().equals(event.getOldValue()) && event.getNewValue().equals("server")) {
            this.preferences.setValue(PREPROCESSOR_MODE_ONOFF, "ON");
            this.runMode.load();
        }
    }

    public void init(IWorkbench workbench) {
    }

    public void performDefaults() {
        this.fileDark.loadDefault();
        this.fileFlood.loadDefault();
        this.filedist.loadDefault();
        this.bapplyDark.loadDefault();
        this.bapplyDist.loadDefault();
        this.bapplyFlood.loadDefault();
        this.spdCommand.loadDefault();
        this.spdMode.loadDefault();
        this.spdServer.loadDefault();
        this.ext_cor.loadDefault();
        this.runMode.loadDefault();
        this.modecor_ext.loadDefault();
        this.spd_other_options.loadDefault();
        this.bDarkfileMode.loadDefault();
        this.bDistFileMode.loadDefault();
        this.bFloodFileMode.loadDefault();
        this.bZip.loadDefault();
        this.bZip_program.loadDefault();
        if (this.type != null) {
            this.type.loadDefault();
        }
        if (this.dvo != null) {
            this.dvo.loadDefault();
        }
    }

    public boolean performOk() {
        boolean bok = super.performOk();
        SpdView myView = SpdView.thisView;
        myView.setPreferencesValues();
        return bok;
    }

    protected void createFieldEditors() {
        String[] ESRFExtFilter = new String[]{"*.edf", "*.*"};
        String[] ESRFsplineFilterExt = new String[]{"*.spd", "*.spline", "*.*"};
        ScrolledComposite scrolledComposite = new ScrolledComposite(this.getFieldEditorParent(), 768){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return new Point(-1, -1);
            }
        };
        Display display = Display.getCurrent();
        scrolledComposite.setMinHeight(display.getPrimaryMonitor().getBounds().height);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setLayout((Layout)new FillLayout());
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        this.parent = new Composite((Composite)scrolledComposite, 4);
        scrolledComposite.setContent((Control)this.parent);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 1;
        this.parent.setLayout((Layout)innerLayout);
        GridData gridData0 = new GridData(1808);
        this.parent.setLayoutData((Object)gridData0);
        this.spdMode = new RadioGroupFieldEditor(SPD_MODE, "Spd mode", 2, (String[][])new String[][]{{"Command line", "OFF"}, {"Device server", "server"}}, this.parent, true);
        this.addField((FieldEditor)this.spdMode);
        this.spdMode.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String server_mode = (String)event.getNewValue();
                if (server_mode.equals("server")) {
                    Control radio = SpdPreferences.this.runMode.getRadioBoxControl(SpdPreferences.this.parent).getChildren()[0];
                    ((Button)radio).setSelection(true);
                }
            }
        });
        this.spdCommand = new FileFieldEditor(CMD_SPD, "Command", this.parent);
        this.spdCommand.setErrorMessage("Command not found");
        this.spdCommand.setValidateStrategy(1);
        this.addField((FieldEditor)this.spdCommand);
        this.spdServer = new StringFieldEditor(SPD_SERVER, "Spd device server", this.parent);
        this.addField((FieldEditor)this.spdServer);
        Composite outExtensionComposite = new Composite(this.parent, 4);
        GridLayout outExtensionLayout = new GridLayout();
        outExtensionLayout.numColumns = 2;
        outExtensionComposite.setLayout((Layout)outExtensionLayout);
        this.modecor_ext = new RadioGroupFieldEditor(EXT_COR_RADIO, "output extension", 2, (String[][])new String[][]{{"Default .cor", "Default"}, {"Other ", "Other"}}, this.parent, true);
        this.addField((FieldEditor)this.modecor_ext);
        this.ext_cor = new StringFieldEditorWithRegex(EXT_COR, "Extension", this.modecor_ext.getRadioBoxControl(this.parent));
        this.ext_cor.set_regex("\\p{Punct}|\\p{Space}", "Punctuation and spaces are not allowed");
        this.addField((FieldEditor)this.ext_cor);
        this.bZip = new BooleanFieldEditor(ZIP, "Compress files", this.parent);
        this.bZip.setLabelText("Compress files after processing");
        this.addField((FieldEditor)this.bZip);
        this.bZip_program = new FileFieldEditor(ZIP_PROGRAM, "Select GZip", this.parent);
        this.bZip_program.setLabelText("Set gzip program here");
        this.addField((FieldEditor)this.bZip_program);
        if (System.getProperty("os.name").toLowerCase().contains("linux") && System.getProperty("os.arch").contains("64")) {
            this.type = new RadioGroupFieldEditor(TYPE, "Output file format", 2, (String[][])new String[][]{{"Unsigned Integer", "type_int"}, {"Float ", "type_float"}}, this.parent, true);
            this.addField((FieldEditor)this.type);
            this.dvo = new StringFieldEditor(DVO, "Data value offset", this.parent);
            this.addField((FieldEditor)this.dvo);
        }
        this.bapplyDark = new BooleanFieldEditor(APPLY_DARK, "Apply dark", this.parent);
        this.addField((FieldEditor)this.bapplyDark);
        this.bDarkfileMode = new RadioGroupFieldEditor(DARK_FILE_MODE, "File option", 3, (String[][])new String[][]{{"None", "darkfileNoneRadio"}, {"From header ", "darkHeaderRadio"}, {"File ", "darkFromFileRadio"}}, this.parent, true);
        this.addField((FieldEditor)this.bDarkfileMode);
        this.fileDark = new FileFieldEditor(FILE_DARK, "Dark file", this.parent);
        this.fileDark.setFileExtensions(ESRFExtFilter);
        this.addField((FieldEditor)this.fileDark);
        this.bapplyFlood = new BooleanFieldEditor(APPLY_FLOOD, "Apply flood", this.parent);
        this.addField((FieldEditor)this.bapplyFlood);
        this.bFloodFileMode = new RadioGroupFieldEditor(FLOOD_FILE_MODE, "File option", 3, (String[][])new String[][]{{"None", "floodfileNoneRadio"}, {"From header ", "floodHeaderRadio"}, {"File ", "floodFromFileRadio"}}, this.parent, true);
        this.addField((FieldEditor)this.bFloodFileMode);
        this.fileFlood = new FileFieldEditor(FILE_FLOOD, "Flood file", this.parent);
        this.fileFlood.setFileExtensions(ESRFExtFilter);
        this.addField((FieldEditor)this.fileFlood);
        this.bapplyDist = new BooleanFieldEditor(APPLY_DIST, "Apply spatial distortion", this.parent);
        this.addField((FieldEditor)this.bapplyDist);
        this.bDistFileMode = new RadioGroupFieldEditor(DIST_FILE_MODE, "File option", 3, (String[][])new String[][]{{"None", "distfileNoneRadio"}, {"From header ", "distHeaderRadio"}, {"File ", "distFromFileRadio"}}, this.parent, true);
        this.addField((FieldEditor)this.bDistFileMode);
        this.filedist = new FileFieldEditor(FILE_DIST, "Spatial distortion file", this.parent);
        this.filedist.setFileExtensions(ESRFsplineFilterExt);
        this.addField((FieldEditor)this.filedist);
        this.spd_other_options = new StringFieldEditor(SPD_OTHER_OPTIONS, "Other options for spd", this.parent);
        this.addField((FieldEditor)this.spd_other_options);
        this.runMode = new RadioGroupFieldEditor(PREPROCESSOR_MODE_ONOFF, "Run mode", 2, (String[][])new String[][]{{"On line", "ON"}, {"Off Line", "OFF"}}, this.parent, true);
        this.addField((FieldEditor)this.runMode);
    }

    public boolean isValid() {
        boolean bIsvalid = super.isValid();
        if (!bIsvalid) {
            this.getErrorMessage();
        } else {
            this.setErrorMessage(null);
        }
        return bIsvalid;
    }

    public boolean okToLeave() {
        return super.okToLeave();
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
    }
}

