/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.preferences;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.Bundle;

public class PreferenceInitializerGrainSpotter
extends AbstractPreferenceInitializer {
    static String grainSpotterVersion = "0.3.1";
    public static PreferenceInitializerGrainSpotter prefDefault = null;

    public void initializeDefaultPreferences() {
        IEclipsePreferences defaults = new DefaultScope().getNode("fable.grainspotter");
        defaults.putInt("pref_SpaceGroup", 100);
        defaults.putFloat("pref_etaspec_min", 0.0f);
        defaults.putFloat("pref_etaspec_max", 360.0f);
        defaults.putFloat("pref_omegaspec_min", -180.0f);
        defaults.putFloat("pref_omegaspec_max", 180.0f);
        defaults.putFloat("pref_omegaspec_delta", 0.25f);
        defaults.putInt("pref_cuts_minMesurement", 5);
        defaults.putFloat("pref_cuts_completeness", 0.2f);
        defaults.putFloat("pref_sigma_tth", 0.2f);
        defaults.putFloat("pref_sigma_omega", 0.4f);
        defaults.putFloat("pref_sigma_eta", 0.4f);
        defaults.putFloat("pref_sigmas", 2.0f);
        defaults.putInt("pref_nhkl", 15);
        defaults.putFloat("pref_eulerStep", 6.0f);
        defaults.put("pref_cmd_grainspotter", "GrainSpotter");
        defaults.put("pref_cmd_grainspotter", PreferenceInitializerGrainSpotter.getGrainSpotterPath(PreferenceInitializerGrainSpotter.getPluginPath()));
    }

    public static String getPluginPath() {
        Bundle bundle = Platform.getBundle((String)"fable.grainspotter");
        Path path = new Path("/");
        String pluginPath = ".";
        try {
            URL grainspotterURL = Platform.resolve((URL)FileLocator.find((Bundle)bundle, (IPath)path, null));
            pluginPath = grainspotterURL.getPath();
            pluginPath = pluginPath.substring(0, pluginPath.lastIndexOf("fable.grainspotter"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return pluginPath;
    }

    public static String getGrainSpotterPath(String pluginPath) {
        String grainspotterPath = "";
        grainspotterPath = pluginPath;
        String os = System.getProperty("os.name");
        if (os.equalsIgnoreCase("linux")) {
            grainspotterPath = grainspotterPath.startsWith("file:") ? String.valueOf(grainspotterPath.substring(5)) + "grainspotter_" + grainSpotterVersion + "/bin" : String.valueOf(grainspotterPath) + "grainspotter/bin";
            grainspotterPath = String.valueOf(grainspotterPath) + "/linux/GrainSpotter";
        } else if (os.toLowerCase().contains("windows")) {
            grainspotterPath = (grainspotterPath = grainspotterPath.replace('/', File.separatorChar)).startsWith("file:") ? String.valueOf(grainspotterPath.substring(5)) + "grainspotter_" + grainSpotterVersion + "\\bin" : String.valueOf(grainspotterPath.substring(1)) + "grainspotter\\bin";
            grainspotterPath = String.valueOf(grainspotterPath) + "\\win32\\GrainSpotter.exe";
        } else {
            grainspotterPath = grainspotterPath.startsWith("file:") ? String.valueOf(grainspotterPath.substring(5)) + "grainspotter_" + grainSpotterVersion + "/bin" : String.valueOf(grainspotterPath) + "grainspotter/bin";
            grainspotterPath = String.valueOf(grainspotterPath) + "/macosx/GrainSpotter";
        }
        return grainspotterPath;
    }
}

