/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.actions;

import fable.grainspotter.editors.GrainspotterIniInput;
import fable.grainspotter.editors.GrainspotterInputEditor;
import fable.grainspotter.internal.IVarKeys;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class OpenIniFileAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private IEditorInput input;

    public void dispose() {
    }

    public void init(IWorkbenchWindow arg0) {
        this.window = arg0;
    }

    public void run(IAction arg0) {
        if (this.window != null) {
            try {
                FileDialog fileDlg = new FileDialog(new Shell(), 4096);
                fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_INI);
                fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_INI);
                fileDlg.setText("Select an existing ini file or enter a new file name");
                String file = fileDlg.open();
                if (file != null) {
                    fileDlg.getFilterPath();
                    if (!file.endsWith(".ini")) {
                        file = String.valueOf(file) + ".ini";
                    }
                    this.input = this.createEditorInput(new File(file));
                    String editorId = GrainspotterInputEditor.getID();
                    this.window.getActivePage().openEditor(this.input, editorId);
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening ini file:" + e.getMessage()));
            }
        }
    }

    public void selectionChanged(IAction arg0, ISelection arg1) {
    }

    private GrainspotterIniInput createEditorInput(File file) {
        Path location = new Path(file.getAbsolutePath());
        GrainspotterIniInput input = new GrainspotterIniInput((IPath)location);
        return input;
    }
}

