/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TacoApi;

import fr.esrf.TacoApi.NethostConnection;
import fr.esrf.TacoApi.ServerListener;
import fr.esrf.TacoApi.TacoCommand;
import fr.esrf.TacoApi.TacoException;
import fr.esrf.TacoApi.xdr.XdrClientData;
import fr.esrf.TacoApi.xdr.XdrDCClientData;
import fr.esrf.TacoApi.xdr.XdrDCInfo;
import fr.esrf.TacoApi.xdr.XdrDCServerData;
import fr.esrf.TacoApi.xdr.XdrFreeIn;
import fr.esrf.TacoApi.xdr.XdrFreeOut;
import fr.esrf.TacoApi.xdr.XdrImportIn;
import fr.esrf.TacoApi.xdr.XdrImportOut;
import fr.esrf.TacoApi.xdr.XdrQueryIn;
import fr.esrf.TacoApi.xdr.XdrQueryOut;
import fr.esrf.TacoApi.xdr.XdrServerData;
import fr.esrf.TacoApi.xdr.XdrVarArguments;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTcpClient;
import org.acplt.oncrpc.OncRpcUdpClient;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrString;
import org.acplt.oncrpc.XdrVoid;

class ServerConnection {
    static final int serverTimeout = 3000;
    private static final int adminTimeout = 4000;
    private static final int connectionUdpTimeout = 100;
    private String hostName;
    private int protocol;
    private long lastConnection;
    private int progNumber;
    private Vector serverListener;
    private String fullName;
    private InetAddress hostIp;
    private OncRpcClient client;
    private static Object serverMonitor = new Object();
    private static Vector serverList = new Vector();
    private static final int RPC_DEV_IMPORT = 1;
    private static final int RPC_DEV_FREE = 2;
    private static final int RPC_DEV_PUTGET = 3;
    private static final int RPC_DEV_PUT = 4;
    private static final int RPC_DEV_CMD_QUERY = 5;
    private static final int RPC_DC_DEVGET = 4;
    private static final int RPC_DC_DEVINFO = 6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServerConnection connectServer(String string, String string2, int n, int n2, int n3, ServerListener serverListener) throws TacoException {
        ServerConnection serverConnection;
        String string3 = ServerConnection.createKeyString(string2, n, n3, string);
        Object object = serverMonitor;
        synchronized (object) {
            serverConnection = ServerConnection.getFromStringKey(string3);
            if (serverConnection == null) {
                serverConnection = new ServerConnection(string2, n, n2, n3, string3);
                serverList.add(serverConnection);
            }
            if (serverListener != null) {
                serverConnection.registerListener(serverListener);
            }
        }
        return serverConnection;
    }

    XdrImportOut importDevice(String string, int n, int n2, int n3) throws TacoException {
        XdrImportIn xdrImportIn = new XdrImportIn();
        xdrImportIn.devName = string;
        xdrImportIn.secAccessRight = n;
        xdrImportIn.secClientId = n2;
        xdrImportIn.secConnId = n3;
        xdrImportIn.vArgs = new XdrVarArguments();
        XdrImportOut xdrImportOut = new XdrImportOut();
        this.rpcCall(1, xdrImportIn, xdrImportOut, 4000);
        if (xdrImportOut.status < 0) {
            throw new TacoException("RpcDevImport(" + string + ") failed with error:", xdrImportOut.error);
        }
        return xdrImportOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeDevice(int n, boolean bl, int n2, int n3, ServerListener serverListener) throws TacoException {
        Object object;
        if (bl) {
            object = new XdrFreeIn();
            ((XdrFreeIn)object).dsId = n;
            ((XdrFreeIn)object).secAccessRight = n2;
            ((XdrFreeIn)object).secClientId = n3;
            ((XdrFreeIn)object).vArgs = new XdrVarArguments();
            XdrFreeOut xdrFreeOut = new XdrFreeOut();
            this.rpcCall(2, (XdrAble)object, xdrFreeOut, 4000);
            if (xdrFreeOut.status < 0) {
                throw new TacoException(xdrFreeOut.error);
            }
        }
        object = this;
        synchronized (object) {
            this.serverListener.remove(serverListener);
            if (this.serverListener.size() == 0) {
                this.destroy(0);
            }
        }
    }

    TacoCommand[] commandQuery(int n, NethostConnection nethostConnection) throws TacoException {
        TacoCommand[] tacoCommandArray;
        block6: {
            int n2;
            int n3;
            block5: {
                XdrQueryIn xdrQueryIn = new XdrQueryIn();
                XdrQueryOut xdrQueryOut = new XdrQueryOut();
                xdrQueryIn.dsId = n;
                xdrQueryIn.vArgs = new XdrVarArguments();
                this.rpcCall(5, xdrQueryIn, xdrQueryOut, 4000);
                if (xdrQueryOut.status < 0) {
                    throw new TacoException(xdrQueryOut.error);
                }
                n3 = xdrQueryOut.cmds.value.length;
                tacoCommandArray = new TacoCommand[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    tacoCommandArray[n2] = new TacoCommand();
                    tacoCommandArray[n2].cmdCode = xdrQueryOut.cmds.value[n2].cmdCode;
                    tacoCommandArray[n2].inType = xdrQueryOut.cmds.value[n2].inType;
                    tacoCommandArray[n2].outType = xdrQueryOut.cmds.value[n2].outType;
                }
                if (xdrQueryOut.vArgs.value.length != n3) break block5;
                for (n2 = 0; n2 < n3; ++n2) {
                    XdrString xdrString = (XdrString)xdrQueryOut.vArgs.value[n2].vArg;
                    tacoCommandArray[n2].cmdName = xdrString.stringValue();
                }
                break block6;
            }
            if (nethostConnection == null) break block6;
            Integer[] integerArray = new Integer[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                integerArray[n2] = new Integer(tacoCommandArray[n2].cmdCode);
            }
            String[] stringArray = nethostConnection.getCommandNames(integerArray);
            for (n2 = 0; n2 < n3; ++n2) {
                tacoCommandArray[n2].cmdName = stringArray[n2];
            }
        }
        return tacoCommandArray;
    }

    XdrClientData putGet(XdrServerData xdrServerData, int n) throws TacoException {
        XdrClientData xdrClientData = new XdrClientData();
        this.rpcCall(3, xdrServerData, xdrClientData, n);
        if (xdrClientData.status < 0) {
            if (xdrClientData.vArgs.value.length == 1) {
                String string = ((XdrString)xdrClientData.vArgs.value[0].vArg).stringValue();
                throw new TacoException(string);
            }
            throw new TacoException(xdrClientData.error);
        }
        return xdrClientData;
    }

    XdrDCClientData dcPutGet(XdrDCServerData xdrDCServerData, int n) throws TacoException {
        XdrDCClientData xdrDCClientData = new XdrDCClientData();
        xdrDCClientData.type = xdrDCServerData.argoutType;
        this.rpcCall(4, xdrDCServerData, xdrDCClientData, n);
        if (xdrDCClientData.error != 0) {
            throw new TacoException(xdrDCClientData.error);
        }
        return xdrDCClientData;
    }

    TacoCommand[] commandQueryDC(String string, NethostConnection nethostConnection) throws TacoException {
        int n;
        XdrDCInfo xdrDCInfo = new XdrDCInfo();
        this.rpcCall(6, new XdrString(string), xdrDCInfo, 4000);
        if (xdrDCInfo.errCode != 0) {
            throw new TacoException(xdrDCInfo.errCode);
        }
        int n2 = xdrDCInfo.cmdInfo.value.length;
        TacoCommand[] tacoCommandArray = new TacoCommand[n2];
        for (n = 0; n < n2; ++n) {
            tacoCommandArray[n] = new TacoCommand();
            tacoCommandArray[n].cmdCode = xdrDCInfo.cmdInfo.value[n].cmdCode;
            tacoCommandArray[n].inType = 0;
            tacoCommandArray[n].outType = xdrDCInfo.cmdInfo.value[n].outType;
            tacoCommandArray[n].hasCache = true;
        }
        if (nethostConnection != null) {
            Integer[] integerArray = new Integer[n2];
            for (n = 0; n < n2; ++n) {
                integerArray[n] = new Integer(tacoCommandArray[n].cmdCode);
            }
            String[] stringArray = nethostConnection.getCommandNames(integerArray);
            for (n = 0; n < n2; ++n) {
                tacoCommandArray[n].cmdName = stringArray[n];
            }
        }
        return tacoCommandArray;
    }

    void destroy() {
        try {
            this.destroy(0);
        }
        catch (TacoException tacoException) {
            // empty catch block
        }
    }

    String getHostName() {
        return this.hostName;
    }

    int getProgNumber() {
        return this.progNumber;
    }

    private ServerConnection(String string, int n, int n2, int n3, String string2) throws TacoException {
        this.hostName = string;
        this.protocol = n3;
        this.lastConnection = 0L;
        this.serverListener = new Vector();
        this.progNumber = n;
        this.fullName = string2;
        try {
            this.hostIp = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new TacoException("Cannot resolve server hostname : " + string + "\n" + unknownHostException.getMessage());
        }
        try {
            switch (n3) {
                case 0: {
                    this.client = new OncRpcUdpClient(this.hostIp, n, n2, 0);
                    break;
                }
                case 1: {
                    this.client = new OncRpcTcpClient(this.hostIp, n, n2, 0);
                }
            }
            if (n3 == 0) {
                this.setTimeout(100);
                this.client.call(0, new XdrVoid(), new XdrVoid());
            } else {
                this.setTimeout(4000);
                this.client.call(0, new XdrVoid(), new XdrVoid());
            }
        }
        catch (Exception exception) {
            throw new TacoException(12);
        }
        this.lastConnection = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(int n) throws TacoException {
        Object object = serverMonitor;
        synchronized (object) {
            for (int i = 0; i < this.serverListener.size(); ++i) {
                ((ServerListener)this.serverListener.get(i)).disconnectFromServer(this);
            }
            this.client = null;
            serverList.remove(this);
        }
        if (n != 0) {
            throw new TacoException(n);
        }
    }

    private void registerListener(ServerListener serverListener) {
        this.serverListener.add(serverListener);
    }

    private void setTimeout(int n) {
        this.client.setTimeout(n);
        switch (this.protocol) {
            case 0: {
                ((OncRpcUdpClient)this.client).setRetransmissionTimeout(n);
                break;
            }
            case 1: {
                ((OncRpcTcpClient)this.client).setTransmissionTimeout(n);
            }
        }
    }

    private synchronized void rpcCall(int n, XdrAble xdrAble, XdrAble xdrAble2, int n2) throws TacoException {
        if (this.client == null) {
            throw new TacoException(12);
        }
        try {
            this.setTimeout(n2);
            this.client.call(n, xdrAble, xdrAble2);
            this.lastConnection = System.currentTimeMillis();
        }
        catch (OncRpcException oncRpcException) {
            switch (oncRpcException.getReason()) {
                case 1: 
                case 11: 
                case 42: 
                case 43: {
                    throw new TacoException(23);
                }
                case 6: {
                    throw new TacoException("RPC server version number mismatch");
                }
                case 5: {
                    if (this.protocol == 0) {
                        this.destroy(2);
                        break;
                    }
                    throw new TacoException(2);
                }
            }
            this.destroy(12);
        }
    }

    private static String createKeyString(String string, int n, int n2, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Integer.toString(n)).append("/");
        stringBuffer.append(string).append("/");
        stringBuffer.append(Integer.toString(n2)).append("/");
        stringBuffer.append(string2);
        return stringBuffer.toString().toLowerCase();
    }

    private static ServerConnection getFromStringKey(String string) {
        int n = serverList.size();
        for (int i = 0; i < n; ++i) {
            ServerConnection serverConnection = (ServerConnection)serverList.get(i);
            if (!string.equals(serverConnection.fullName)) continue;
            return serverConnection;
        }
        return null;
    }
}

