/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.NoTranslationException;
import org.jacorb.notification.filter.ComponentName;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.RuntimeVariable;
import org.jacorb.notification.interfaces.AbstractPoolable;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.ORB;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;

public abstract class AbstractMessage
extends AbstractPoolable {
    int x;
    static final ORB sOrb = ORB.init();
    protected boolean proxyConsumerFiltered_;
    protected boolean supplierAdminFiltered_;
    protected boolean consumerAdminFiltered_;
    protected boolean proxySupplierFiltered_;
    private FilterStage currentFilterStage_;
    protected int referenced_ = 0;

    public abstract String getConstraintKey();

    public abstract Any toAny();

    public abstract Property[] toTypedEvent() throws NoTranslationException;

    public abstract StructuredEvent toStructuredEvent();

    public abstract int getType();

    public void reset() {
        this.referenced_ = 0;
        this.currentFilterStage_ = null;
    }

    public synchronized void addReference() {
        ++this.referenced_;
    }

    protected synchronized void removeReference() {
        if (this.referenced_ > 0) {
            --this.referenced_;
        }
        if (this.referenced_ == 0) {
            super.dispose();
        }
    }

    public void setFilterStage(FilterStage filterStage) {
        this.currentFilterStage_ = filterStage;
    }

    public FilterStage getFilterStage() {
        return this.currentFilterStage_;
    }

    public EvaluationResult extractValue(EvaluationContext evaluationContext, ComponentName componentName, RuntimeVariable runtimeVariable) throws EvaluationException {
        EvaluationResult evaluationResult = null;
        String string = componentName.getComponentName();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("extractValue: " + string);
            this.logger_.debug("runtimeVariable=" + runtimeVariable);
        }
        if ((evaluationResult = evaluationContext.lookupResult(string)) == null) {
            evaluationResult = runtimeVariable.evaluate(evaluationContext);
            evaluationResult = evaluationContext.extractFromMessage(this, evaluationResult, componentName, runtimeVariable);
            evaluationContext.storeResult(string, evaluationResult);
        }
        if (evaluationResult == null) {
            throw new EvaluationException("Could not resolve " + string);
        }
        return evaluationResult;
    }

    public abstract EvaluationResult extractFilterableData(EvaluationContext var1, ComponentName var2, String var3) throws EvaluationException;

    public abstract EvaluationResult extractVariableHeader(EvaluationContext var1, ComponentName var2, String var3) throws EvaluationException;

    public EvaluationResult extractValue(EvaluationContext evaluationContext, ComponentName componentName) throws EvaluationException {
        EvaluationResult evaluationResult = null;
        String string = componentName.getComponentName();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("extractValue path: " + componentName.toStringTree() + "\n\tcomplete Expression=" + string);
        }
        evaluationResult = evaluationContext.lookupResult(string);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Cache READ: " + evaluationResult);
        }
        if (evaluationResult == null) {
            this.logger_.debug("Cache MISS");
            evaluationResult = evaluationContext.extractFromMessage(this, componentName);
            if (evaluationResult != null) {
                if (this.logger_.isDebugEnabled()) {
                    this.logger_.debug("Cache WRITE: " + string + " => " + evaluationResult);
                }
                evaluationContext.storeResult(string, evaluationResult);
            }
        }
        if (evaluationResult == null) {
            throw new EvaluationException("Could not resolve " + string);
        }
        return evaluationResult;
    }

    public Message getHandle() {
        return new MessageHandle();
    }

    public abstract boolean hasStartTime();

    public abstract Date getStartTime();

    public abstract boolean hasStopTime();

    public abstract Date getStopTime();

    public abstract boolean hasTimeout();

    public abstract long getTimeout();

    public abstract int getPriority();

    public abstract boolean match(Filter var1) throws UnsupportedFilterableData;

    public boolean match(FilterStage filterStage) {
        List list = filterStage.getFilters();
        if (list.isEmpty()) {
            return true;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                Filter filter = (Filter)iterator.next();
                if (!this.match(filter)) continue;
                return true;
            }
            catch (UnsupportedFilterableData unsupportedFilterableData) {
                this.logger_.info("unsupported filterable data. match result defaults to false.", unsupportedFilterableData);
            }
        }
        return false;
    }

    public abstract boolean match(MappingFilter var1, AnyHolder var2) throws UnsupportedFilterableData;

    class MessageHandle
    implements Message,
    Disposable {
        private Message.MessageStateListener eventStateListener_;
        private boolean isInvalid_ = false;
        private boolean isDisposed_ = false;
        private boolean isPrioritySet_ = false;
        private int priority_;
        private boolean isTimeoutSet_ = false;
        private long timeOut_;

        MessageHandle() {
            AbstractMessage.this.addReference();
        }

        private MessageHandle(int n, boolean bl, long l, boolean bl2) {
            AbstractMessage.this.addReference();
            this.priority_ = n;
            this.isPrioritySet_ = bl;
            this.timeOut_ = l;
            this.isTimeoutSet_ = bl2;
        }

        public void setInitialFilterStage(FilterStage filterStage) {
            AbstractMessage.this.setFilterStage(filterStage);
        }

        public FilterStage getInitialFilterStage() {
            return AbstractMessage.this.getFilterStage();
        }

        public String getConstraintKey() {
            return AbstractMessage.this.getConstraintKey();
        }

        public Any toAny() {
            return AbstractMessage.this.toAny();
        }

        public Property[] toTypedEvent() throws NoTranslationException {
            return AbstractMessage.this.toTypedEvent();
        }

        public StructuredEvent toStructuredEvent() {
            return AbstractMessage.this.toStructuredEvent();
        }

        public int getType() {
            return AbstractMessage.this.getType();
        }

        public EvaluationResult extractValue(EvaluationContext evaluationContext, ComponentName componentName, RuntimeVariable runtimeVariable) throws EvaluationException {
            return AbstractMessage.this.extractValue(evaluationContext, componentName, runtimeVariable);
        }

        public EvaluationResult extractValue(EvaluationContext evaluationContext, ComponentName componentName) throws EvaluationException {
            return AbstractMessage.this.extractValue(evaluationContext, componentName);
        }

        public EvaluationResult extractFilterableData(EvaluationContext evaluationContext, ComponentName componentName, String string) throws EvaluationException {
            return AbstractMessage.this.extractFilterableData(evaluationContext, componentName, string);
        }

        public EvaluationResult extractVariableHeader(EvaluationContext evaluationContext, ComponentName componentName, String string) throws EvaluationException {
            return AbstractMessage.this.extractVariableHeader(evaluationContext, componentName, string);
        }

        public boolean hasStartTime() {
            return AbstractMessage.this.hasStartTime();
        }

        public Date getStartTime() {
            return AbstractMessage.this.getStartTime();
        }

        public boolean hasStopTime() {
            return AbstractMessage.this.hasStopTime();
        }

        public Date getStopTime() {
            return AbstractMessage.this.getStopTime();
        }

        public boolean hasTimeout() {
            return this.isTimeoutSet_ || AbstractMessage.this.hasTimeout();
        }

        public long getTimeout() {
            if (this.isTimeoutSet_) {
                return this.timeOut_;
            }
            return AbstractMessage.this.getTimeout();
        }

        public void setTimeout(long l) {
            this.timeOut_ = l;
            this.isTimeoutSet_ = true;
            if (this.eventStateListener_ != null) {
                this.eventStateListener_.actionLifetimeChanged(l);
            }
        }

        public void setPriority(int n) {
            this.isPrioritySet_ = true;
            this.priority_ = n;
        }

        public int getPriority() {
            if (this.isPrioritySet_) {
                return this.priority_;
            }
            return AbstractMessage.this.getPriority();
        }

        public boolean match(FilterStage filterStage) {
            return AbstractMessage.this.match(filterStage);
        }

        public boolean match(MappingFilter mappingFilter, AnyHolder anyHolder) throws UnsupportedFilterableData {
            return AbstractMessage.this.match(mappingFilter, anyHolder);
        }

        public Object clone() {
            try {
                this.checkInvalid();
                return new MessageHandle(this.priority_, this.isPrioritySet_, this.timeOut_, this.isTimeoutSet_);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        public void dispose() {
            AbstractMessage.this.removeReference();
        }

        public synchronized boolean isInvalid() {
            return this.isInvalid_;
        }

        public void setMessageStateListener(Message.MessageStateListener messageStateListener) {
            this.eventStateListener_ = messageStateListener;
        }

        public Message.MessageStateListener removeMessageStateListener() {
            Message.MessageStateListener messageStateListener = this.eventStateListener_;
            this.eventStateListener_ = null;
            return messageStateListener;
        }

        public synchronized void actionTimeout() {
            this.isInvalid_ = true;
        }

        public String toString() {
            return "[Message/" + AbstractMessage.this + "]";
        }

        private void checkInvalid() throws IllegalArgumentException {
            if (this.isInvalid()) {
                throw new IllegalArgumentException("This Notification has been invalidated");
            }
        }
    }
}

