/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttributeDim;
import fr.esrf.Tango.AttributeValue_3;
import fr.esrf.Tango.DevAttrHistory;
import fr.esrf.Tango.DevAttrHistory_3;
import fr.esrf.Tango.DevBooleanHelper;
import fr.esrf.Tango.DevCmdHistory;
import fr.esrf.Tango.DevDoubleHelper;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevFloatHelper;
import fr.esrf.Tango.DevLongHelper;
import fr.esrf.Tango.DevShortHelper;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevStateHelper;
import fr.esrf.Tango.DevStringHelper;
import fr.esrf.Tango.DevULongHelper;
import fr.esrf.Tango.DevUShortHelper;
import fr.esrf.Tango.DevVarBooleanArrayHelper;
import fr.esrf.Tango.DevVarCharArrayHelper;
import fr.esrf.Tango.DevVarDoubleArrayHelper;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarDoubleStringArrayHelper;
import fr.esrf.Tango.DevVarFloatArrayHelper;
import fr.esrf.Tango.DevVarLongArrayHelper;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.DevVarLongStringArrayHelper;
import fr.esrf.Tango.DevVarShortArrayHelper;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.DevVarULongArrayHelper;
import fr.esrf.Tango.DevVarUShortArrayHelper;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoDs.Except;
import org.omg.CORBA.Any;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;

public class DeviceDataHistory {
    private Any any;
    private DevCmdHistory cmd_histo;
    private AttributeValue_3 attrval;
    private TimeVal tval;
    public static final int COMMAND = 0;
    public static final int ATTRIBUTE = 1;
    public int source;
    public String name;
    public boolean failed;
    public DevError[] errors;

    public DeviceDataHistory(String string, DevCmdHistory devCmdHistory) throws DevFailed {
        this.any = devCmdHistory.value;
        this.source = 0;
        this.cmd_histo = devCmdHistory;
        this.name = string;
        this.tval = this.cmd_histo.time;
        this.failed = this.cmd_histo.cmd_failed;
        this.errors = this.cmd_histo.errors;
    }

    public DeviceDataHistory(DevAttrHistory devAttrHistory) throws DevFailed {
        this.any = devAttrHistory.value.value;
        this.source = 1;
        this.attrval = new AttributeValue_3(this.any, devAttrHistory.value.quality, devAttrHistory.value.time, devAttrHistory.value.name, new AttributeDim(devAttrHistory.value.dim_x, devAttrHistory.value.dim_y), new AttributeDim(0, 0), devAttrHistory.errors);
        this.name = devAttrHistory.value.name;
        this.tval = devAttrHistory.value.time;
        this.failed = devAttrHistory.attr_failed;
        this.errors = devAttrHistory.errors;
    }

    public DeviceDataHistory(DevAttrHistory_3 devAttrHistory_3) throws DevFailed {
        this.any = devAttrHistory_3.value.value;
        this.source = 1;
        this.attrval = devAttrHistory_3.value;
        this.name = devAttrHistory_3.value.name;
        this.tval = devAttrHistory_3.value.time;
        this.failed = devAttrHistory_3.attr_failed;
        this.errors = devAttrHistory_3.value.err_list;
    }

    public TimeVal getTimeVal() {
        return this.tval;
    }

    public long getTimeValSec() {
        return this.tval.tv_sec;
    }

    public long getTime() {
        return (long)this.tval.tv_sec * 1000L + (long)(this.tval.tv_usec / 1000);
    }

    public AttrQuality getAttrQuality() throws DevFailed {
        if (this.source == 0) {
            Except.throw_non_supported_exception("TangoApi_NOT_AVAILABLE", "Method not avalaible for command", "DeviceDataHistory.getAttrQuality()");
        }
        return this.attrval.quality;
    }

    public int getDimX() throws DevFailed {
        if (this.source == 0) {
            Except.throw_non_supported_exception("TangoApi_NOT_AVAILABLE", "Method not avalaible for command", "DeviceDataHistory.getDimX()");
        }
        return this.attrval.r_dim.dim_x;
    }

    public int getDimY() throws DevFailed {
        if (this.source == 0) {
            Except.throw_non_supported_exception("TangoApi_NOT_AVAILABLE", "Method not avalaible for command", "DeviceDataHistory.getDimY()");
        }
        return this.attrval.r_dim.dim_y;
    }

    public Any extractAny() {
        return this.any;
    }

    public boolean extractBoolean() {
        return DevBooleanHelper.extract(this.any);
    }

    public short extractShort() {
        if (this.source == 1) {
            short[] sArray = this.extractShortArray();
            return sArray[0];
        }
        return DevShortHelper.extract(this.any);
    }

    public short extractUShort() {
        return DevUShortHelper.extract(this.any);
    }

    public int extractLong() {
        if (this.source == 1) {
            int[] nArray = this.extractLongArray();
            return nArray[0];
        }
        return DevLongHelper.extract(this.any);
    }

    public int extractULong() {
        return DevULongHelper.extract(this.any);
    }

    public float extractFloat() {
        return DevFloatHelper.extract(this.any);
    }

    public double extractDouble() {
        if (this.source == 1) {
            double[] dArray = this.extractDoubleArray();
            return dArray[0];
        }
        return DevDoubleHelper.extract(this.any);
    }

    public String extractString() {
        if (this.source == 1) {
            String[] stringArray = this.extractStringArray();
            return stringArray[0];
        }
        return DevStringHelper.extract(this.any);
    }

    public DevState extractDevState() {
        return DevStateHelper.extract(this.any);
    }

    public boolean[] extractBooleanArray() {
        return DevVarBooleanArrayHelper.extract(this.any);
    }

    public byte[] extractByteArray() {
        return DevVarCharArrayHelper.extract(this.any);
    }

    public short[] extractShortArray() {
        return DevVarShortArrayHelper.extract(this.any);
    }

    public short[] extractUShortArray() {
        return DevVarUShortArrayHelper.extract(this.any);
    }

    public int[] extractLongArray() {
        return DevVarLongArrayHelper.extract(this.any);
    }

    public int[] extractULongArray() {
        return DevVarULongArrayHelper.extract(this.any);
    }

    public float[] extractFloatArray() {
        return DevVarFloatArrayHelper.extract(this.any);
    }

    public double[] extractDoubleArray() {
        return DevVarDoubleArrayHelper.extract(this.any);
    }

    public String[] extractStringArray() {
        if (this.any == null) {
            System.out.println("any = null !!");
        }
        return DevVarStringArrayHelper.extract(this.any);
    }

    public DevVarLongStringArray extractLongStringArray() {
        return DevVarLongStringArrayHelper.extract(this.any);
    }

    public DevVarDoubleStringArray extractDoubleStringArray() {
        return DevVarDoubleStringArrayHelper.extract(this.any);
    }

    public DevError[] getErrStack() {
        return this.attrval.err_list;
    }

    public TypeCode type() {
        return this.any.type();
    }

    public String getName() {
        return this.attrval.name;
    }

    private int DIM_MINI(int n) {
        return n == 0 ? 1 : n;
    }

    public int getNbRead() {
        return this.attrval.r_dim.dim_x * this.DIM_MINI(this.attrval.r_dim.dim_y);
    }

    public int getNbWritten() {
        return this.attrval.w_dim.dim_x * this.DIM_MINI(this.attrval.w_dim.dim_y);
    }

    public int getWrittenDimX() {
        return this.attrval.w_dim.dim_x;
    }

    public int getWrittenDimY() {
        return this.attrval.w_dim.dim_y;
    }

    public int getType() throws DevFailed {
        int n = -1;
        try {
            TypeCode typeCode = this.attrval.value.type();
            if (typeCode.kind().value() == 17) {
                return 19;
            }
            TypeCode typeCode2 = typeCode.content_type();
            TypeCode typeCode3 = typeCode2.content_type();
            TCKind tCKind = typeCode3.kind();
            switch (tCKind.value()) {
                case 1: {
                    n = 0;
                    break;
                }
                case 8: {
                    n = 1;
                    break;
                }
                case 9: {
                    n = 21;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 4: {
                    n = 6;
                    break;
                }
                case 3: {
                    n = 3;
                    break;
                }
                case 5: {
                    n = 7;
                    break;
                }
                case 6: {
                    n = 4;
                    break;
                }
                case 7: {
                    n = 5;
                    break;
                }
                case 18: {
                    n = 8;
                }
            }
        }
        catch (BadKind badKind) {
            Except.throw_exception("Api_TypeCodePackage.BadKind", "Bad or unknown type ", "DeviceDataHistory.getType()");
        }
        return n;
    }
}

