/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.views;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.ChiFile;
import fable.framework.toolbox.ToolBox;
import fable.framework.views.FableMessageConsole;
import java.io.OutputStream;
import java.io.PrintStream;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.part.ViewPart;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class chiPlotView
extends ViewPart {
    public FableMessageConsole console;
    public static final String ID = "fable.framework.ui.views.chiPlotView";
    public static chiPlotView thisView = null;
    public static GLContext context = null;
    private static SceneGrip grip = null;
    private static GLCanvas canvas = null;
    private Spinner minimumSpinner;
    private Spinner maximumSpinner;
    private Button freezeButton;
    private Button autoscaleButton;
    private static boolean freeze = false;
    private static boolean autoscale = true;
    private Button updateButton;
    private Button resetButton;
    private static float[] blue = new float[]{1.0f, 0.333f, 0.666f, 0.999f, 0.833f, 0.666f, 0.5f, 0.333f, 0.166f, 0.0f, 0.0f};
    private static float[] green = new float[]{1.0f, 0.0f, 0.111f, 0.222f, 0.333f, 0.666f, 0.999f, 0.666f, 0.333f, 0.0f, 0.0f};
    private static float[] red = new float[]{1.0f, 0.0f, 0.055f, 0.11f, 0.165f, 0.22f, 0.275f, 0.333f, 0.666f, 0.999f, 1.0f};
    private static int COLOR_INDEX_MAX = 10;
    private float scaleMinimum;
    private float scaleMaximum;
    private static int pointSize = 4;
    private static float scale = 1.0f;
    private static float[] image = null;
    private static int imageWidth = 0;
    private static int imageHeight = 0;
    private static float zcenter;
    private float[] dots = null;
    private float minimum;
    private float maximum;
    private float mean;
    private String fileName;
    private float size;
    private static int canvasWidth;
    private static int canvasHeight;
    private static float zscale;
    private static boolean reliefListFirst;
    private static int reliefList;
    private static Logger logger;
    static boolean firstImage;

    static {
        canvasWidth = 0;
        canvasHeight = 0;
        reliefListFirst = true;
        firstImage = true;
    }

    public void createPartControl(Composite parent) {
        logger = FableLogger.getLogger();
        this.console = new FableMessageConsole("Peaksearch console");
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
        this.console.displayOut("Welcome to chiplotview " + ToolBox.getPluginVersion((String)"fable.framework.ui"));
        IOConsoleOutputStream stream = this.console.newOutputStream();
        System.setOut(new PrintStream((OutputStream)stream, true));
        System.setErr(new PrintStream((OutputStream)stream));
        thisView = this;
        parent.setLayout((Layout)new GridLayout());
        Composite controlPanelComposite = new Composite(parent, 0);
        GridLayout controlGridLayout = new GridLayout();
        controlGridLayout.numColumns = 8;
        controlPanelComposite.setLayout((Layout)controlGridLayout);
        controlPanelComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.freezeButton = new Button(controlPanelComposite, 32);
        this.freezeButton.setText("Freeze");
        this.freezeButton.setToolTipText("freeze 3d relief, disable rotation");
        this.freezeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (chiPlotView.this.freezeButton.getSelection()) {
                    freeze = true;
                } else {
                    freeze = false;
                }
            }
        });
        this.resetButton = new Button(controlPanelComposite, 0);
        this.resetButton.setText("Reset");
        this.resetButton.setToolTipText("reset 3d projection to be flat and fill the canvas");
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                grip.init();
            }
        });
        this.autoscaleButton = new Button(controlPanelComposite, 32);
        this.autoscaleButton.setText("Autoscale");
        this.autoscaleButton.setToolTipText("autoscale 3d relief between minimum and mean");
        this.autoscaleButton.setSelection(true);
        this.autoscaleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (chiPlotView.this.autoscaleButton.getSelection()) {
                    if (!autoscale) {
                        autoscale = true;
                        chiPlotView.this.scaleImage();
                        chiPlotView.drawReliefList();
                    }
                    chiPlotView.this.minimumSpinner.setEnabled(false);
                    chiPlotView.this.maximumSpinner.setEnabled(false);
                } else {
                    if (autoscale) {
                        autoscale = false;
                        chiPlotView.this.scaleImage();
                        chiPlotView.drawReliefList();
                    }
                    chiPlotView.this.minimumSpinner.setEnabled(true);
                    chiPlotView.this.maximumSpinner.setEnabled(true);
                }
            }
        });
        Label minLabel = new Label(controlPanelComposite, 0);
        minLabel.setText("Minimum");
        this.minimumSpinner = new Spinner(controlPanelComposite, 0);
        this.minimumSpinner.setLayoutData((Object)new GridData(4, 0, true, false));
        this.minimumSpinner.setMinimum(0);
        this.minimumSpinner.setMaximum(Integer.MAX_VALUE);
        this.minimumSpinner.setEnabled(false);
        Label maxLabel = new Label(controlPanelComposite, 0);
        maxLabel.setText("Maximum");
        this.maximumSpinner = new Spinner(controlPanelComposite, 0);
        this.maximumSpinner.setLayoutData((Object)new GridData(4, 0, true, false));
        this.maximumSpinner.setMinimum(0);
        this.maximumSpinner.setMaximum(Integer.MAX_VALUE);
        this.maximumSpinner.setEnabled(false);
        this.updateButton = new Button(controlPanelComposite, 0);
        this.updateButton.setText("Update");
        this.updateButton.setToolTipText("redraw 3d relief plot");
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                chiPlotView.this.scaleImage();
                chiPlotView.drawReliefList();
                chiPlotView.drawRelief();
            }
        });
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        comp.setLayout((Layout)new FillLayout());
        GLData data = new GLData();
        data.doubleBuffer = true;
        canvas = new GLCanvas(comp, 0, data);
        canvas.setSize(comp.getSize());
        canvas.setCurrent();
        canvas.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle bounds = canvas.getBounds();
                canvas.setCurrent();
                try {
                    GLContext.useContext((Object)canvas);
                }
                catch (LWJGLException e) {
                    e.printStackTrace();
                }
                GL11.glViewport((int)0, (int)0, (int)bounds.width, (int)bounds.height);
                GL11.glMatrixMode((int)5889);
                GL11.glLoadIdentity();
                chiPlotView.drawRelief();
                canvas.swapBuffers();
            }
        });
        try {
            GLContext.useContext((Object)canvas);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)-1.0, (double)1.0);
        grip = new SceneGrip();
        canvas.addMouseListener((MouseListener)grip);
        canvas.addMouseMoveListener((MouseMoveListener)grip);
        canvas.addListener(37, (Listener)grip);
        canvas.addKeyListener((KeyListener)grip);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!canvas.isDisposed()) {
                    canvas.setCurrent();
                    chiPlotView.drawRelief();
                    canvas.swapBuffers();
                }
            }
        });
    }

    static void drawRelief() {
        canvas.setCurrent();
        try {
            GLContext.useContext((Object)canvas);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        GL11.glClear((int)16640);
        if (!freeze) {
            grip.adjust();
        }
        if (image != null) {
            GL11.glClear((int)16640);
            GL11.glDisable((int)2896);
            GL11.glCallList((int)reliefList);
            GL11.glEnable((int)2896);
        }
    }

    private static void testDraw() {
        if (canvas != null && context != null) {
            System.out.println("testDraw()");
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClear((int)16384);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glOrtho((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)-1.0, (double)1.0);
            GL11.glBegin((int)9);
            GL11.glVertex3f((float)0.25f, (float)0.25f, (float)0.0f);
            GL11.glVertex3f((float)0.75f, (float)0.25f, (float)0.0f);
            GL11.glVertex3f((float)0.75f, (float)0.75f, (float)0.0f);
            GL11.glVertex3f((float)0.25f, (float)0.75f, (float)0.0f);
            GL11.glEnd();
            GL11.glFlush();
        }
    }

    private static void drawReliefList() {
        if (!reliefListFirst) {
            GL11.glDeleteLists((int)reliefList, (int)1);
        }
        reliefListFirst = false;
        reliefList = GL11.glGenLists((int)1);
        GL11.glNewList((int)reliefList, (int)4864);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPointSize((float)pointSize);
        int i = 0;
        while (i < imageWidth - 1) {
            GL11.glBegin((int)3);
            int j = i + 1;
            int color_index = (int)image[i];
            if (color_index < 0) {
                color_index = 0;
            }
            if (color_index > COLOR_INDEX_MAX) {
                color_index = COLOR_INDEX_MAX;
            }
            GL11.glColor3f((float)red[color_index], (float)green[color_index], (float)blue[color_index]);
            GL11.glVertex3f((float)i, (float)image[i], (float)image[j]);
            GL11.glEnd();
            ++i;
        }
        GL11.glEndList();
        GL11.glFlush();
    }

    public void plot(float[] listdots, int _width, int _height, float _minimum, float _maximum, float _mean, String _fileName) {
        this.dots = listdots;
        image = new float[_width * _height];
        imageWidth = _width;
        imageHeight = _height;
        this.minimum = _minimum;
        this.maximum = _maximum;
        this.mean = _mean;
        if (autoscale) {
            this.scaleMinimum = _minimum;
            this.scaleMaximum = _mean;
        }
        this.fileName = _fileName;
        this.size = (imageWidth + imageHeight) / 2;
        this.setPartName("Plot " + this.fileName);
        if (firstImage) {
            grip.init();
            firstImage = false;
        }
        this.scaleImage();
        chiPlotView.drawReliefList();
    }

    public void scaleImage() {
        if (autoscale) {
            this.scaleMinimum = this.minimum;
            this.scaleMaximum = this.mean;
            this.minimumSpinner.setSelection((int)this.scaleMinimum);
            this.maximumSpinner.setSelection((int)this.scaleMaximum);
        } else {
            this.scaleMinimum = this.minimumSpinner.getSelection();
            this.scaleMaximum = this.maximumSpinner.getSelection();
        }
        if (this.scaleMinimum == this.scaleMaximum) {
            this.scaleMaximum = this.scaleMinimum + 1.0f;
        }
        zscale = 10.0f / (2.0f * (this.scaleMaximum - this.scaleMinimum));
        int i = 0;
        while (i < imageWidth) {
            float imageValue = this.dots[i];
            chiPlotView.image[i] = (imageValue - this.scaleMinimum) * zscale;
            ++i;
        }
    }

    public void setFocus() {
    }

    public void openFile(String filename2) {
        try {
            ChiFile chifile = new ChiFile();
            chifile.loadfile(filename2);
            chifile.getlist();
        }
        catch (JepException e) {
            e.printStackTrace();
        }
    }

    public class SceneGrip
    extends MouseAdapter
    implements MouseMoveListener,
    Listener,
    KeyListener {
        private float xrot;
        private float yrot;
        private float zoff;
        private float xoff;
        private float yoff;
        private float xcpy;
        private float ycpy;
        private float xscale;
        private float yscale;
        private boolean move;
        private int xdown;
        private int ydown;
        private int mouseDown;

        public SceneGrip() {
            this.init();
        }

        protected void init() {
            canvas.setCurrent();
            Rectangle bounds = canvas.getBounds();
            canvasWidth = bounds.width;
            canvasHeight = bounds.height;
            this.yrot = 0.0f;
            this.xrot = 0.0f;
            this.yoff = 0.0f;
            this.xoff = 0.0f;
            if (imageWidth != 0) {
                this.xscale = canvasWidth / imageWidth;
            }
            if (imageHeight != 0) {
                this.yscale = canvasHeight / imageHeight;
            }
            this.zoff = 1.0f;
            this.zoff = this.xscale < this.yscale ? this.xscale : this.yscale;
        }

        public void mouseDown(MouseEvent e) {
            if (++this.mouseDown == 1) {
                this.move = e.button == 3;
                if (this.move) {
                    this.xcpy = this.xoff;
                    this.ycpy = this.yoff;
                    ((Control)e.widget).setCursor(e.widget.getDisplay().getSystemCursor(21));
                } else {
                    this.xcpy = this.xrot;
                    this.ycpy = this.yrot;
                    ((Control)e.widget).setCursor(e.widget.getDisplay().getSystemCursor(5));
                }
                this.xdown = e.x;
                this.ydown = e.y;
            }
        }

        public void mouseUp(MouseEvent e) {
            if (--this.mouseDown == 0) {
                ((Control)e.widget).setCursor(e.widget.getDisplay().getSystemCursor(0));
            }
        }

        public void mouseMove(MouseEvent e) {
            Point p = ((Control)e.widget).getSize();
            if (this.mouseDown > 0) {
                int dx = e.x - this.xdown;
                int dy = e.y - this.ydown;
                if (this.move) {
                    this.yoff = this.ycpy + (float)canvasHeight / 2.0f * (float)dy / (2.0f * (float)p.y);
                    this.xoff = this.xcpy + (float)canvasWidth / 2.0f * (float)dx / (2.0f * (float)p.x);
                } else {
                    this.xrot = this.xcpy + (float)dy / 2.0f;
                    this.yrot = this.ycpy + (float)dx / 2.0f;
                }
            }
        }

        public void handleEvent(Event event) {
            this.zoff *= 1.1f;
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 0x1000001: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.xrot -= 5.0f;
                        break;
                    }
                    this.yoff -= (float)canvasHeight / 10.0f;
                    break;
                }
                case 0x1000002: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.xrot += 5.0f;
                        break;
                    }
                    this.yoff += (float)canvasHeight / 10.0f;
                    break;
                }
                case 0x1000003: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.yrot -= 5.0f;
                        break;
                    }
                    this.xoff -= (float)canvasWidth / 10.0f;
                    break;
                }
                case 0x1000004: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.yrot += 5.0f;
                        break;
                    }
                    this.xoff += (float)canvasWidth / 10.0f;
                    break;
                }
                case 0x1000005: {
                    this.zoff *= 1.05f;
                    break;
                }
                case 0x1000006: {
                    this.zoff *= 0.95f;
                    break;
                }
                case 0x1000007: {
                    this.init();
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void adjust() {
            try {
                GLContext.useContext((Object)canvas);
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)canvasWidth, (double)canvasHeight, (double)0.0, (double)-100000.0, (double)100000.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)((float)(canvasWidth / 2) + this.xoff), (float)((float)(canvasHeight / 2) + this.yoff), (float)0.0f);
            GL11.glScalef((float)this.zoff, (float)this.zoff, (float)this.zoff);
            GL11.glRotatef((float)this.xrot, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.yrot, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)(-imageWidth / 2), (float)(-imageHeight / 2), (float)0.0f);
        }

        public void setOffsets(float x, float y, float z) {
            this.xoff = x;
            this.yoff = y;
            this.zoff = z;
        }

        public void setRotation(float x, float y) {
            this.xrot = x;
            this.yrot = y;
        }
    }
}

