/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.editors;

import fable.framework.toolbox.ColumnFile;
import fable.framework.ui.editors.ColumnFileEditorInput;
import fable.framework.ui.rcp.Activator;
import fable.framework.ui.views.ColFileXYPlot;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ColumnFilePlotEditor
extends EditorPart
implements ISelectionListener,
IPropertyChangeListener {
    private ColFileXYPlot xyplot;
    private static final String ID = "fable.framework.ui.ColumnFilePlotEditor";
    private JLDataView current_dataView = null;
    private Vector<ColumnFile> array_columns = new Vector();
    private HashMap<String, JLDataView> dataToPlot = new HashMap();
    private ColumnFileEditorInput columnInput;
    private boolean dirty = false;
    private Action saveasAction;
    private ImageDescriptor saveAs = Activator.imageDescriptorFromPlugin((String)"fable.framework.ui", (String)"images/saveas.gif");

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.columnInput = (ColumnFileEditorInput)input;
        this.setPartName(this.columnInput.getName());
        this.columnInput.getColumn().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.xyplot = new ColFileXYPlot(parent, "", "X", "Y");
        this.xyplot.addColumnFile(this.columnInput.getColumn());
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.makeActions();
        this.contributeToActionBars();
    }

    public void setFocus() {
    }

    public ColFileXYPlot getxyPlot() {
        return this.xyplot;
    }

    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.columnInput.getColumn().removePropertyrChangeListener((IPropertyChangeListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != this && selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Object first = sSelection.getFirstElement();
            Object[] list = sSelection.toArray();
            if (first instanceof float[]) {
                float[] r = (float[])first;
                double[] indices = null;
                if (this.columnInput.getColumn() != null) {
                    int indexColumnId = this.columnInput.getColumn().getColumnIDIndex();
                    if (list.length > 1 && indexColumnId >= 0) {
                        indices = new double[list.length];
                        int j = 0;
                        while (j < list.length) {
                            indices[j] = ((float[])list[j])[indexColumnId];
                            ++j;
                        }
                    } else if (indexColumnId >= 0) {
                        indices = new double[]{r[indexColumnId]};
                    }
                    if (indices != null && indices.length > 0) {
                        this.xyplot.markSelectedRows(indices, this.columnInput.getColumn().getColumnfileId());
                    }
                }
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.columnInput.getColumn().saveColumnFile(this.columnInput.getColumn().getFileName());
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
        if (this.columnInput.saveAs()) {
            this.dirty = false;
            this.firePropertyChange(257);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return this.dirty;
    }

    public static String getId() {
        return ID;
    }

    private void contributeToActionBars() {
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.saveasAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.saveasAction);
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    private void makeActions() {
        this.saveasAction = new Action(){

            public void run() {
                ColumnFilePlotEditor.this.doSaveAs();
            }
        };
        this.saveasAction.setToolTipText("Save this column file as ... ");
        this.saveasAction.setImageDescriptor(this.saveAs);
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        if (arg0.getProperty().equals("updateColumn")) {
            this.dirty = true;
            this.firePropertyChange(257);
            this.xyplot.updateChart();
        } else if (arg0.getProperty().equals("propdirty")) {
            this.dirty = (Boolean)arg0.getNewValue();
            this.firePropertyChange(257);
        } else if (arg0.getProperty().equals("AddColumn")) {
            this.xyplot.addColumnFile(this.columnInput.getColumn());
        }
    }
}

