/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.LoopedStreams;

public class ConsoleTextArea
extends JTextArea {
    public ConsoleTextArea(InputStream[] inputStreamArray) {
        for (int i = 0; i < inputStreamArray.length; ++i) {
            this.startConsoleReaderThread(inputStreamArray[i]);
        }
    }

    public ConsoleTextArea() throws IOException {
        LoopedStreams loopedStreams = new LoopedStreams();
        String string = System.getProperty("JmolConsole");
        if (string == null || string.equals("true")) {
            PrintStream printStream = new PrintStream(loopedStreams.getOutputStream());
            System.setOut(printStream);
            System.setErr(printStream);
        }
        this.startConsoleReaderThread(loopedStreams.getInputStream());
    }

    private void startConsoleReaderThread(InputStream inputStream) {
        final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        new Thread(new Runnable(){

            public void run() {
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    Document document = ConsoleTextArea.this.getDocument();
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        boolean bl = false;
                        bl = ConsoleTextArea.this.getCaretPosition() == document.getLength();
                        stringBuffer.setLength(0);
                        ConsoleTextArea.this.append(stringBuffer.append(string).append('\n').toString());
                        if (bl) {
                            ConsoleTextArea.this.setCaretPosition(document.getLength());
                        }
                        string = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, GT._("Error reading from BufferedReader: {0}", iOException.getMessage()));
                    System.exit(1);
                }
            }
        }).start();
    }
}

