/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter;

import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.parser.JavadocParser;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatter;
import org.eclipse.jdt.internal.formatter.FormatJavadoc;
import org.eclipse.jdt.internal.formatter.FormatJavadocBlock;
import org.eclipse.jdt.internal.formatter.FormatJavadocNode;
import org.eclipse.jdt.internal.formatter.FormatJavadocReference;
import org.eclipse.jdt.internal.formatter.FormatJavadocText;
import org.eclipse.jdt.internal.formatter.comment.IJavaDocTagConstants;

public class FormatterCommentParser
extends JavadocParser
implements IJavaDocTagConstants {
    char[][] htmlTags;
    int htmlTagsPtr = -1;
    private boolean invalidTagName;

    public FormatterCommentParser(long sourceLevel) {
        super(null);
        this.kind = 288;
        this.reportProblems = false;
        this.checkDocComment = true;
        this.sourceLevel = sourceLevel;
    }

    public boolean parse(int start, int end) {
        this.javadocStart = start;
        this.javadocEnd = end;
        this.firstTagPosition = this.javadocStart;
        boolean valid = this.commentParse();
        return valid && this.docComment != null;
    }

    protected Object createArgumentReference(char[] name, int dim, boolean isVarargs, Object ref, long[] dimPositions, long argNamePos) throws InvalidInputException {
        FormatJavadocReference typeRef = (FormatJavadocReference)ref;
        if (dim > 0) {
            typeRef.sourceEnd = (int)dimPositions[dim - 1];
        }
        if (argNamePos >= 0L) {
            typeRef.sourceEnd = (int)argNamePos;
        }
        return ref;
    }

    protected Object createFieldReference(Object receiver) throws InvalidInputException {
        int start = receiver == null ? this.memberStart : ((FormatJavadocReference)receiver).sourceStart;
        int lineStart = this.scanner.getLineNumber(start);
        return new FormatJavadocReference(start, (int)this.identifierPositionStack[0], lineStart);
    }

    protected Object createMethodReference(Object receiver, List arguments) throws InvalidInputException {
        int start = receiver == null ? this.memberStart : ((FormatJavadocReference)receiver).sourceStart;
        int lineStart = this.scanner.getLineNumber(start);
        return new FormatJavadocReference(start, this.scanner.getCurrentTokenEndPosition(), lineStart);
    }

    protected void createTag() {
        int lineStart = this.scanner.getLineNumber(this.tagSourceStart);
        if (this.inlineTagStarted) {
            FormatJavadocBlock block = new FormatJavadocBlock(this.inlineTagStart, this.tagSourceEnd, lineStart, this.tagValue);
            FormatJavadocBlock previousBlock = null;
            if (this.astPtr == -1) {
                previousBlock = new FormatJavadocBlock(this.inlineTagStart, this.tagSourceEnd, lineStart, 0);
                this.pushOnAstStack(previousBlock, true);
            } else {
                previousBlock = (FormatJavadocBlock)this.astStack[this.astPtr];
            }
            previousBlock.addBlock(block, this.htmlTagsPtr == -1 ? 0 : this.htmlTagsPtr);
        } else {
            FormatJavadocBlock block = new FormatJavadocBlock(this.tagSourceStart, this.tagSourceEnd, lineStart, this.tagValue);
            this.pushOnAstStack(block, true);
        }
    }

    protected Object createTypeReference(int primitiveToken) {
        int size = this.identifierLengthStack[this.identifierLengthPtr];
        if (size == 0) {
            return null;
        }
        int start = (int)(this.identifierPositionStack[this.identifierPtr] >>> 32);
        int lineStart = this.scanner.getLineNumber(start);
        if (size == 1) {
            return new FormatJavadocReference(this.identifierPositionStack[this.identifierPtr], lineStart);
        }
        long[] positions = new long[size];
        System.arraycopy(this.identifierPositionStack, this.identifierPtr - size + 1, positions, 0, size);
        return new FormatJavadocReference((int)(positions[0] >>> 32), (int)positions[positions.length - 1], lineStart);
    }

    private int getHtmlTagIndex(char[] htmlTag) {
        int length = htmlTag == null ? 0 : htmlTag.length;
        int tagId = 0;
        if (length > 0) {
            char[] tag;
            int i = 0;
            int max = JAVADOC_SPECIAL_TAGS.length;
            while (i < max) {
                tag = JAVADOC_SPECIAL_TAGS[i];
                if (length == tag.length && CharOperation.equals(htmlTag, tag, false)) {
                    tagId = 131072;
                    break;
                }
                ++i;
            }
            i = 0;
            max = JAVADOC_SINGLE_BREAK_TAG.length;
            while (i < max) {
                tag = JAVADOC_SINGLE_BREAK_TAG[i];
                if (length == tag.length && CharOperation.equals(htmlTag, tag, false)) {
                    return (tagId | 0x100) + i;
                }
                ++i;
            }
            i = 0;
            max = JAVADOC_CODE_TAGS.length;
            while (i < max) {
                tag = JAVADOC_CODE_TAGS[i];
                if (length == tag.length && CharOperation.equals(htmlTag, tag, false)) {
                    return (tagId | 0x200) + i;
                }
                ++i;
            }
            i = 0;
            max = JAVADOC_BREAK_TAGS.length;
            while (i < max) {
                tag = JAVADOC_BREAK_TAGS[i];
                if (length == tag.length && CharOperation.equals(htmlTag, tag, false)) {
                    return (tagId | 0x400) + i;
                }
                ++i;
            }
            i = 0;
            max = JAVADOC_IMMUTABLE_TAGS.length;
            while (i < max) {
                tag = JAVADOC_IMMUTABLE_TAGS[i];
                if (length == tag.length && CharOperation.equals(htmlTag, tag, false)) {
                    return (tagId | 0x800) + i;
                }
                ++i;
            }
            i = 0;
            max = JAVADOC_SEPARATOR_TAGS.length;
            while (i < max) {
                tag = JAVADOC_SEPARATOR_TAGS[i];
                if (length == tag.length && CharOperation.equals(htmlTag, tag, false)) {
                    return (tagId | 0x1000) + i;
                }
                ++i;
            }
        }
        return 65280;
    }

    protected char[] getTagName(int previousPosition, int currentPosition) {
        this.invalidTagName = false;
        if (currentPosition != this.scanner.startPosition) {
            this.invalidTagName = true;
            return null;
        }
        if (this.index >= this.scanner.eofPosition) {
            this.invalidTagName = true;
            return null;
        }
        this.tagSourceStart = previousPosition;
        this.tagSourceEnd = this.scanner.getCurrentTokenEndPosition();
        char[] tagName = this.scanner.getCurrentIdentifierSource();
        return tagName;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected boolean parseHtmlTag(int previousPosition, int endTextPosition) throws InvalidInputException {
        closing = false;
        valid = false;
        incremented = false;
        start = this.scanner.currentPosition;
        htmlPtr = this.htmlTagsPtr--;
        try {
            block24: {
                token = this.readTokenAndConsume();
                switch (token) {
                    case 26: {
                        htmlTag = this.scanner.getCurrentIdentifierSource();
                        htmlIndex = this.getHtmlTagIndex(htmlTag);
                        if (htmlIndex == 65280) lbl-1000:
                        // 10 sources

                        {
                            return false;
                        }
                        if (htmlPtr < 0 || ((lastHtmlTagIndex = this.getHtmlTagIndex(this.htmlTags[htmlPtr])) & 65280) != 2048) ** GOTO lbl26
                        if ((htmlIndex & 65280) != 512) ** GOTO lbl-1000
                        lastNode /* !! */  = parentNode = (previousBlock = (FormatJavadocBlock)this.astStack[this.astPtr]);
                        while (lastNode /* !! */ .getLastNode() != null) {
                            parentNode = lastNode /* !! */ ;
                            lastNode /* !! */  = lastNode /* !! */ .getLastNode();
                        }
                        if (!lastNode /* !! */ .isText()) ** GOTO lbl-1000
                        text = (FormatJavadocText)lastNode /* !! */ ;
                        if (text.separatorsPtr != -1) ** GOTO lbl-1000
                        break;
lbl26:
                        // 1 sources

                        if ((htmlIndex & 65280) <= 256 || this.htmlTagsPtr != -1 && CharOperation.equals(this.htmlTags[this.htmlTagsPtr], htmlTag, false)) break;
                        if (++this.htmlTagsPtr == 0) {
                            this.htmlTags = new char[10][];
                        } else if (this.htmlTagsPtr == this.htmlTags.length) {
                            v0 = new char[this.htmlTags.length + 10][];
                            this.htmlTags = v0;
                            System.arraycopy(this.htmlTags, 0, v0, 0, this.htmlTagsPtr);
                        }
                        this.htmlTags[this.htmlTagsPtr] = htmlTag;
                        incremented = true;
                        break;
                    }
                    case 6: {
                        if (this.htmlTagsPtr == -1) ** GOTO lbl-1000
                        htmlTag = this.htmlTags[this.htmlTagsPtr];
                        token = this.readTokenAndConsume();
                        if (token != 26 || (htmlIndex = this.getHtmlTagIndex(identifier = this.scanner.getCurrentIdentifierSource())) == 65280) ** GOTO lbl-1000
                        ptr = this.htmlTagsPtr;
                        while (!CharOperation.equals(htmlTag, identifier, false)) {
                            if (this.htmlTagsPtr > 0) ** GOTO lbl47
                            this.htmlTagsPtr = ptr;
                            ** GOTO lbl-1000
lbl47:
                            // 1 sources

                            --this.htmlTagsPtr;
                            htmlTag = this.htmlTags[this.htmlTagsPtr];
                        }
                        htmlIndex |= 65536;
                        closing = true;
                        break;
                    }
                    default: {
                        ** GOTO lbl-1000
                    }
                }
                token = this.readTokenAndConsume();
                if (token == 13) break block24;
                if ((htmlIndex & 131072) != 131072) ** GOTO lbl-1000
                while (token != 13) {
                    token = this.readTokenAndConsume();
                    if (token != 68) ** break;
                    ** continue;
                }
            }
            if (this.lineStarted && this.textStart != -1 && this.textStart < endTextPosition) {
                this.pushText(this.textStart, endTextPosition, -1, htmlPtr == -1 ? 0 : htmlPtr);
            }
            this.pushText(previousPosition, this.index, htmlIndex, this.htmlTagsPtr);
            this.textStart = -1;
            valid = true;
        }
        finally {
            if (valid) {
                if (closing) {
                    // empty if block
                }
            } else if (!this.abort) {
                if (incremented) {
                    --this.htmlTagsPtr;
                    if (this.htmlTagsPtr == -1) {
                        this.htmlTags = null;
                    }
                }
                this.scanner.resetTo(start, this.scanner.eofPosition - 1);
                this.index = start;
            }
        }
        return valid;
    }

    protected boolean parseParam() throws InvalidInputException {
        boolean valid = super.parseParam();
        if (!valid) {
            this.scanner.resetTo(this.tagSourceEnd + 1, this.javadocEnd);
            this.index = this.tagSourceEnd + 1;
            char ch = this.peekChar();
            if (ch == ' ' || ScannerHelper.isWhitespace(ch)) {
                int token = this.scanner.getNextToken();
                if (token == 26 && ((ch = this.peekChar()) == ' ' || ScannerHelper.isWhitespace(ch))) {
                    this.pushIdentifier(true, false);
                    this.pushParamName(false);
                    this.index = this.scanner.currentPosition;
                    valid = true;
                }
                this.scanner.resetTo(this.tagSourceEnd + 1, this.javadocEnd);
            }
        }
        return valid;
    }

    protected boolean parseReference() throws InvalidInputException {
        boolean valid = super.parseReference();
        if (!valid) {
            this.scanner.resetTo(this.tagSourceEnd + 1, this.javadocEnd);
            this.index = this.tagSourceEnd + 1;
        }
        return valid;
    }

    protected boolean parseReturn() {
        this.createTag();
        return true;
    }

    protected boolean parseTag(int previousPosition) throws InvalidInputException {
        int ptr = this.astPtr;
        boolean valid = super.parseTag(previousPosition);
        this.textStart = -1;
        this.consumeToken();
        if (valid) {
            switch (this.tagValue) {
                case 1: 
                case 9: {
                    this.createTag();
                }
            }
        } else if (this.invalidTagName) {
            this.textStart = previousPosition;
        } else if (this.astPtr == ptr) {
            this.tagValue = 100;
            this.createTag();
        }
        return true;
    }

    protected boolean parseThrows() {
        boolean valid = super.parseThrows();
        if (!valid) {
            this.scanner.resetTo(this.tagSourceEnd + 1, this.javadocEnd);
            this.index = this.tagSourceEnd + 1;
        }
        return valid;
    }

    protected boolean pushParamName(boolean isTypeParam) {
        FormatJavadocReference reference;
        int lineTagStart = this.scanner.getLineNumber(this.tagSourceStart);
        FormatJavadocBlock block = new FormatJavadocBlock(this.tagSourceStart, this.tagSourceEnd, lineTagStart, 2);
        int start = (int)(this.identifierPositionStack[0] >>> 32);
        int lineStart = this.scanner.getLineNumber(start);
        block.reference = reference = new FormatJavadocReference(start, (int)this.identifierPositionStack[isTypeParam ? 2 : 0], lineStart);
        block.sourceEnd = reference.sourceEnd;
        this.pushOnAstStack(block, true);
        return true;
    }

    protected boolean pushSeeRef(Object statement) {
        FormatJavadocReference reference = (FormatJavadocReference)statement;
        int lineTagStart = this.scanner.getLineNumber(this.tagSourceStart);
        FormatJavadocBlock block = new FormatJavadocBlock(this.tagSourceStart, this.tagSourceEnd, lineTagStart, this.tagValue);
        block.reference = reference;
        block.sourceEnd = reference.sourceEnd;
        if (this.inlineTagStarted) {
            block.sourceStart = this.inlineTagStart;
            FormatJavadocBlock previousBlock = null;
            if (this.astPtr == -1) {
                int lineStart = this.scanner.getLineNumber(this.inlineTagStart);
                previousBlock = new FormatJavadocBlock(this.inlineTagStart, this.tagSourceEnd, lineStart, 0);
                previousBlock.sourceEnd = reference.sourceEnd;
                this.pushOnAstStack(previousBlock, true);
            } else {
                previousBlock = (FormatJavadocBlock)this.astStack[this.astPtr];
            }
            previousBlock.addBlock(block, this.htmlTagsPtr == -1 ? 0 : this.htmlTagsPtr);
            block.flags |= 1;
        } else {
            this.pushOnAstStack(block, true);
        }
        return true;
    }

    protected void pushText(int start, int end) {
        this.pushText(start, end, -1, this.htmlTagsPtr == -1 ? 0 : this.htmlTagsPtr);
    }

    private void pushText(int start, int end, int htmlIndex, int htmlDepth) {
        FormatJavadocBlock previousBlock = null;
        int previousStart = start;
        int lineStart = this.scanner.getLineNumber(start);
        if (this.astPtr == -1) {
            previousBlock = new FormatJavadocBlock(start, start, lineStart, 0);
            this.pushOnAstStack(previousBlock, true);
        } else {
            previousBlock = (FormatJavadocBlock)this.astStack[this.astPtr];
            previousStart = previousBlock.sourceStart;
        }
        if (this.inlineTagStarted && previousBlock.nodes != null) {
            FormatJavadocNode lastNode = previousBlock.nodes[previousBlock.nodesPtr];
            while (lastNode != null && lastNode.isText()) {
                lastNode = lastNode.getLastNode();
            }
            if (lastNode != null) {
                previousBlock = (FormatJavadocBlock)lastNode;
                previousStart = previousBlock.sourceStart;
            }
        }
        int textEnd = end;
        if (this.javadocTextEnd > 0 && end >= this.javadocTextEnd) {
            int restart = this.spacePosition == -1 ? start : this.spacePosition;
            this.scanner.resetTo(restart, end - 1);
            try {
                if (this.scanner.getNextToken() == 68) {
                    textEnd = this.spacePosition;
                }
            }
            catch (InvalidInputException invalidInputException) {}
        }
        FormatJavadocText text = new FormatJavadocText(start, textEnd - 1, lineStart, htmlIndex, htmlDepth);
        previousBlock.addText(text);
        previousBlock.sourceStart = previousStart;
        if (lineStart == previousBlock.lineStart) {
            previousBlock.flags |= 8;
        }
        this.textStart = -1;
    }

    protected boolean pushThrowName(Object typeRef) {
        int lineStart = this.scanner.getLineNumber(this.tagSourceStart);
        FormatJavadocBlock block = new FormatJavadocBlock(this.tagSourceStart, this.tagSourceEnd, lineStart, this.tagValue);
        block.reference = (FormatJavadocReference)typeRef;
        block.sourceEnd = block.reference.sourceEnd;
        this.pushOnAstStack(block, true);
        return true;
    }

    protected void refreshInlineTagPosition(int previousPosition) {
        if (this.astPtr != -1) {
            FormatJavadocNode previousBlock = (FormatJavadocNode)this.astStack[this.astPtr];
            if (this.inlineTagStarted) {
                FormatJavadocNode lastNode = previousBlock;
                while (lastNode != null) {
                    lastNode.sourceEnd = previousPosition;
                    lastNode = lastNode.getLastNode();
                }
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("FormatterCommentParser\n");
        buffer.append(super.toString());
        return buffer.toString();
    }

    public String toDebugString() {
        if (this.docComment == null) {
            return "No javadoc!";
        }
        return ((FormatJavadoc)this.docComment).toDebugString(this.source);
    }

    protected void updateDocComment() {
        int length = this.astPtr + 1;
        FormatJavadoc formatJavadoc = new FormatJavadoc(this.javadocStart, this.javadocEnd, length);
        if (length > 0) {
            formatJavadoc.blocks = new FormatJavadocBlock[length];
            int i = 0;
            while (i < length) {
                FormatJavadocBlock block = (FormatJavadocBlock)this.astStack[i];
                block.clean();
                int blockEnd = this.scanner.getLineNumber(block.sourceEnd);
                if (block.lineStart == blockEnd) {
                    block.flags |= 0x10;
                }
                formatJavadoc.blocks[i] = block;
                if (i == 0) {
                    block.flags |= 2;
                }
                ++i;
            }
        }
        formatJavadoc.textStart = this.javadocTextStart;
        formatJavadoc.textEnd = this.javadocTextEnd;
        formatJavadoc.lineStart = this.scanner.getLineNumber(this.javadocTextStart);
        formatJavadoc.lineEnd = this.scanner.getLineNumber(this.javadocTextEnd);
        FormatJavadocBlock firstBlock = formatJavadoc.getFirstBlock();
        if (firstBlock != null) {
            firstBlock.setHeaderLine(formatJavadoc.lineStart);
        }
        this.docComment = formatJavadoc;
        if (DefaultCodeFormatter.DEBUG) {
            System.out.println(this.toDebugString());
        }
    }

    protected boolean verifyEndLine(int textPosition) {
        int endPosition;
        block7: {
            endPosition = this.scanner.currentPosition;
            this.scanner.resetTo(textPosition, this.javadocEnd);
            boolean tokenizeWhiteSpace = this.scanner.tokenizeWhiteSpace;
            this.scanner.tokenizeWhiteSpace = true;
            try {
                try {
                    int token = this.scanner.getNextToken();
                    int startPosition = textPosition;
                    if (token == 1000) {
                        while (this.scanner.currentCharacter == '*' || ScannerHelper.isWhitespace(this.scanner.currentCharacter)) {
                            token = this.scanner.getNextToken();
                        }
                        startPosition = this.scanner.currentPosition;
                    }
                    this.createTag();
                    this.pushText(startPosition, endPosition);
                }
                catch (InvalidInputException invalidInputException) {
                    this.scanner.tokenizeWhiteSpace = tokenizeWhiteSpace;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.scanner.tokenizeWhiteSpace = tokenizeWhiteSpace;
                throw throwable;
            }
            this.scanner.tokenizeWhiteSpace = tokenizeWhiteSpace;
        }
        this.scanner.resetTo(endPosition, this.javadocEnd);
        this.index = endPosition;
        return true;
    }

    protected boolean verifySpaceOrEndComment() {
        return true;
    }
}

