/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class LineView
extends ViewPart {
    public static final String ID = "fable.imageviewer.views.LineView";
    private JLDataView dataView = null;
    private JLChart chart;
    public static LineView view;
    private String title = "Zoom Line Plot";
    private Composite swtAwtComponent;
    public SampleController controller = SampleController.getController();
    private Frame chartFrame;
    private JApplet chartContainer;
    Logger logger;
    Composite parent;

    public void createPartControl(Composite parent) {
        view = this;
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout());
        this.createChartFrame(parent);
        this.createChart();
        this.logger = FableLogger.getLogger(LineView.class);
    }

    public void setFocus() {
    }

    private void createChartFrame(Composite parent) {
        this.swtAwtComponent = new Composite(parent, 0x1040000);
        this.swtAwtComponent.setLayout((Layout)new GridLayout());
        this.swtAwtComponent.setLayoutData((Object)new GridData(1808));
        this.chartFrame = SWT_AWT.new_Frame((Composite)this.swtAwtComponent);
        this.chartContainer = new JApplet();
        this.chartFrame.add(this.chartContainer);
    }

    public void createChart() {
        this.chart = new JLChart();
        this.chart.setHeader(this.title);
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.getY1Axis().setName("intensity");
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.getXAxis().setAutoScale(true);
        this.chart.getXAxis().setName("pixel");
        this.chart.getXAxis().setGridVisible(true);
        this.chart.getXAxis().setSubGridVisible(true);
        this.chart.getXAxis().setAnnotation(2);
        this.chart.getY1Axis().setGridVisible(true);
        this.chart.getY1Axis().setSubGridVisible(true);
        this.chartContainer.add((Component)this.chart);
        this.dataView = new JLDataView();
        this.dataView.setName("intensity");
        this.chart.getY1Axis().addDataView(this.dataView);
    }

    public void setData(String title, String xTitle, int[] pixel, String yTitle, float[] intensity) {
        double[] x = new double[pixel.length];
        double[] y = new double[pixel.length];
        int i = 0;
        while (i < pixel.length) {
            x[i] = pixel[i];
            y[i] = intensity[i];
            ++i;
        }
        this.dataView.setData(x, y);
        this.chart.setHeader(title);
        this.chart.getXAxis().setName(xTitle);
        this.chart.getY1Axis().setName(yTitle);
        Dimension chartSize = this.chartContainer.getSize();
        this.chart.setSize(chartSize);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LineView.this.chartContainer.repaint();
            }
        });
    }
}

