/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.actions;

import fable.framework.toolbox.FabioFile;
import fable.framework.toolbox.FabioFileException;
import fable.imageviewer.views.ImageView;
import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenImageAction
extends Action {
    private final IWorkbenchWindow window;
    private final String viewId;
    private static final String CMD_OPEN_IMAGE = "fable.imageviewer.openImageAction";
    private static String previousDirectory = null;
    private Logger logger = Logger.getLogger(OpenImageAction.class);

    public OpenImageAction(IWorkbenchWindow _window, String label, String viewId, String path) {
        this.window = _window;
        this.viewId = viewId;
        this.setText(label);
        this.setId(CMD_OPEN_IMAGE);
        this.setActionDefinitionId(CMD_OPEN_IMAGE);
        previousDirectory = path;
    }

    public void run() {
        if (this.window != null) {
            String file;
            FileDialog dialog = new FileDialog(this.window.getShell(), 4);
            dialog.setText("Choose Image");
            if (previousDirectory != null) {
                dialog.setFilterPath(previousDirectory);
            }
            if ((file = dialog.open()) != null) {
                if (previousDirectory == null) {
                    previousDirectory = new File(file).getAbsolutePath();
                }
                try {
                    FabioFile fabio = new FabioFile(file);
                    System.out.println(file);
                    this.loadAndShowImage(fabio);
                }
                catch (FabioFileException e) {
                    this.logger.error((Object)e.getMessage());
                }
            }
        }
    }

    public void loadAndShowImage(FabioFile f_fabio) {
        try {
            ImageView imageView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "0", 1);
            if (imageView != null) {
                imageView.loadFile(f_fabio);
                imageView.displayImage();
            }
        }
        catch (PartInitException partInitException) {}
    }
}

