/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.view;

import fable.framework.toolbox.FileText;
import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.IntegerText;
import fable.framework.toolbox.StringText;
import fable.framework.toolbox.TypedText;
import fable.framework.views.FableMessageConsole;
import fable.framework.xmlparser.object.Xmloption;
import fable.peaksearch.Activator;
import fable.peaksearch.object.Peaksearch;
import fable.peaksearch.object.PeaksearchException;
import java.util.Vector;
import jep.JepException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.part.ViewPart;

public class Xmlview
extends ViewPart {
    public static final String ID = "fable.peaksearch.view.Xmlview";
    Display display;
    public Xmlview view;
    private Composite mainComposite;
    private Vector<Group> listGroup;
    private Vector<Xmloption> options;
    private Group global;
    private ImageDescriptor imagePause = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/stop.gif");
    private ImageDescriptor imagePlay = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/e_forward.gif");
    private Peaksearch peaksearch;
    FableMessageConsole console;

    public Xmlview() {
        try {
            this.console = new FableMessageConsole("Peaksearch console");
            this.peaksearch = Peaksearch.getPeaksearch();
        }
        catch (PeaksearchException e) {
            this.console.displayIn(e.getMessage());
        }
        catch (JepException e) {
            this.console.displayIn(e.getMessage());
        }
    }

    public void createPartControl(Composite parent) {
        this.view = this;
        this.display = Display.getCurrent();
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        this.mainComposite = new Composite((Composite)sc, 20);
        sc.setContent((Control)this.mainComposite);
        GridLayout grdLayout = new GridLayout();
        GridData gridDataGlobal = new GridData(16, 20, false, false);
        this.mainComposite.setLayout((Layout)grdLayout);
        this.mainComposite.setLayoutData((Object)gridDataGlobal);
        this.mainComposite.pack();
        this.listGroup = new Vector();
        if (this.peaksearch != null) {
            this.options = this.peaksearch.getOptions();
            this.global = new Group(this.mainComposite, 20);
            this.global.setLayout((Layout)new GridLayout(3, false));
            this.global.setLayoutData((Object)new GridData(20, 16, true, false));
            this.global.setText("Program options from xmlReader");
            int i = 0;
            while (this.options != null && i < this.options.size()) {
                FileText txt;
                Xmloption opt = this.options.elementAt(i);
                String type = opt.getType();
                GridData gdforTypedText = new GridData(4, 0x1000000, true, false);
                gdforTypedText.horizontalSpan = 3;
                GridData gdforText = new GridData(4, 0x1000000, true, false);
                String labelName = opt.getOption().toLowerCase();
                labelName = String.valueOf(String.valueOf(labelName.charAt(0)).toUpperCase()) + labelName.substring(1, labelName.length());
                if (type.equals("file")) {
                    txt = new FileText((Composite)this.global, 0, labelName);
                    txt.setToolTipText(this.options.elementAt(i).getHelp());
                    txt.set_Text(this.options.elementAt(i).getDefault_value());
                    gdforText.horizontalSpan = 2;
                    txt.setLayout((Layout)new GridLayout(3, true));
                    txt.setLayoutData((Object)gdforTypedText);
                    txt.setData((Object)opt);
                    if (opt.isRequired()) {
                        txt.set_isRequiredField(true);
                    }
                    Button btn_browse = new Button((Composite)this.global, 8);
                    btn_browse.setLayoutData((Object)gdforTypedText);
                    btn_browse.setText("Browse...");
                    btn_browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            FileDialog dlg = new FileDialog(((Button)e.widget).getParent().getShell(), 64);
                            String sFile = dlg.open();
                            if (sFile != null) {
                                txt.set_Text(sFile);
                            }
                        }
                    });
                } else if (type.equals("string")) {
                    txt = new StringText((Composite)this.global, 0, labelName);
                    txt.setLayout((Layout)new GridLayout(3, true));
                    txt.set_toolTipText(opt.getHelp());
                    txt.setBackground(Display.getCurrent().getSystemColor(7));
                    if (opt.isRequired()) {
                        txt.set_isRequiredField(true);
                    }
                    txt.setLayoutData((Object)gdforTypedText);
                    txt.set_Text(opt.getDefault_value());
                    txt.setData((Object)opt);
                } else if (type.equals("int")) {
                    txt = new IntegerText((Composite)this.global, 0, labelName);
                    txt.setLayout((Layout)new GridLayout(3, true));
                    if (opt.isRequired()) {
                        txt.set_isRequiredField(true);
                    }
                    txt.set_toolTipText(opt.getHelp());
                    txt.setLayoutData((Object)gdforTypedText);
                    txt.setBackground(Display.getCurrent().getSystemColor(13));
                    try {
                        txt.set_Text(opt.getDefault_value());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    txt.setData((Object)opt);
                } else if (type.equals("float")) {
                    txt = new FloatText((Composite)this.global, 0, labelName);
                    txt.setBackground(Display.getCurrent().getSystemColor(5));
                    txt.setLayout((Layout)new GridLayout(3, true));
                    txt.set_toolTipText(opt.getHelp());
                    txt.setLayoutData((Object)gdforTypedText);
                    try {
                        txt.set_Text(opt.getDefault_value());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    txt.setData((Object)opt);
                } else if (type.equals("choice")) {
                    String choices = opt.getChoices().replaceAll("[()]", "");
                    String[] listchoice = choices.split(",");
                    GridData gdForCbo = new GridData(4, 2, true, false);
                    gdForCbo.horizontalSpan = 3;
                    if (listchoice.length > 1) {
                        int nb;
                        if (listchoice.length < 4) {
                            Group radioGroup = new Group((Composite)this.global, 0);
                            radioGroup.setText(labelName);
                            radioGroup.setToolTipText(opt.getHelp());
                            radioGroup.setLayout((Layout)new GridLayout(listchoice.length, false));
                            radioGroup.setLayoutData((Object)gdForCbo);
                            nb = 0;
                            while (nb < listchoice.length) {
                                Button btn_rd = new Button((Composite)radioGroup, 16);
                                btn_rd.setText(listchoice[nb].trim());
                                btn_rd.setLayoutData((Object)new GridData());
                                btn_rd.setSelection(opt.getDefault_value().equals(listchoice[nb].replaceAll(" ", "")));
                                btn_rd.setData(listchoice[nb], (Object)listchoice[nb]);
                                ++nb;
                            }
                            radioGroup.setData((Object)opt);
                        } else {
                            Combo cbo = new Combo((Composite)this.global, 12);
                            cbo.setLayoutData((Object)gdForCbo);
                            cbo.setToolTipText(opt.getHelp());
                            cbo.setText(labelName);
                            nb = 0;
                            while (nb < listchoice.length) {
                                cbo.add(listchoice[nb]);
                                cbo.setData(listchoice[nb], (Object)listchoice[nb]);
                                ++nb;
                            }
                            cbo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    System.out.println("Test de la selection:" + ((Combo)e.widget).getData(((Combo)e.widget).getText()));
                                }
                            });
                            cbo.setData((Object)opt);
                        }
                    } else {
                        System.out.println("In input xml, choices values should coontain at least 2 values");
                    }
                } else {
                    Composite cmpToAlignToTypeText = new Composite((Composite)this.global, 0);
                    GridLayout gl = new GridLayout(3, false);
                    cmpToAlignToTypeText.setLayout((Layout)gl);
                    cmpToAlignToTypeText.setLayoutData((Object)new GridData(20, 2, true, true));
                    Label lbl = new Label(cmpToAlignToTypeText, 0);
                    lbl.setText(labelName);
                    gdforText.horizontalSpan = 2;
                    Text txt2 = new Text(cmpToAlignToTypeText, 2048);
                    txt2.setToolTipText(this.options.elementAt(i).getHelp());
                    txt2.setText(this.options.elementAt(i).getDefault_value());
                    txt2.setLayoutData((Object)gdforText);
                    txt2.setData((Object)this.options.elementAt(i));
                }
                this.listGroup.add(this.global);
                ++i;
            }
            Button btn = new Button((Composite)this.global, 2048);
            btn.setLayoutData((Object)new GridData(128, 8, false, false));
            final Image imgplay = this.imagePlay.createImage();
            final Image imgPause = this.imagePause.createImage();
            btn.setImage(imgplay);
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (Xmlview.this.checkFields(Xmlview.this.mainComposite, true)) {
                        Xmlview.this.setOptions(Xmlview.this.global.getChildren(), new Xmloption());
                        Xmlview.this.peaksearch.run();
                    }
                }
            });
            btn.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    imgplay.dispose();
                    imgPause.dispose();
                }
            });
        }
        sc.setMinHeight(this.display.getPrimaryMonitor().getBounds().height);
        sc.setMinWidth(this.display.getPrimaryMonitor().getBounds().width);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        sc.setMinSize(this.mainComposite.computeSize(-1, -1));
        this.console.displayOut("Welcome on peaksearch 1.0.0!");
    }

    public void setFocus() {
    }

    public boolean checkFields(Composite parent, boolean bok) {
        Control[] element = parent.getChildren();
        int i = 0;
        while (i < element.length) {
            if (element[i] instanceof Composite) {
                if (element[i] instanceof TypedText && !((TypedText)element[i]).is_bValide()) {
                    bok = false;
                } else {
                    this.checkFields((Composite)element[i], bok);
                }
            }
            ++i;
        }
        return bok;
    }

    public void setOptions(Control[] element, Xmloption opt) {
        int i = 0;
        while (i < element.length) {
            if (element[i] instanceof Group) {
                opt = (Xmloption)((Group)element[i]).getData();
                this.setOptions(((Group)element[i]).getChildren(), opt);
            } else if (element[i] instanceof TypedText) {
                opt = (Xmloption)((TypedText)element[i]).getData();
                opt.setValue(((TypedText)element[i]).getText());
            } else if (element[i] instanceof Button) {
                Button btn = (Button)element[i];
                if (btn.getSelection()) {
                    opt.setValue((String)btn.getData(btn.getText()));
                }
            } else if (element[i] instanceof Combo) {
                Combo cb = (Combo)element[i];
                opt.setValue((String)cb.getData(cb.getText()));
            }
            ++i;
        }
    }
}

