/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.object;

import fable.framework.toolbox.FabioFile;
import fable.peaksearch.object.Peak;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeakSearchSpt {
    private int npks = 0;
    private String fileName;
    private Vector<Peak> peaks;
    private float treshold = 0.0f;
    private FabioFile fabio = null;
    float[] tabPeak = null;
    private List<IPropertyChangeListener> listeners = new ArrayList<IPropertyChangeListener>();
    String scannedPeak = "";
    String[] peakKeys;

    public PeakSearchSpt(String Filename) {
        this.fileName = Filename;
        this.peaks = new Vector(this.npks);
    }

    public void setNbPeaks(int pks) {
        this.npks = pks;
    }

    public void setTreshold(float t) {
        this.treshold = t;
    }

    public int getNbPeaks() {
        return this.npks;
    }

    public void setFabioFile(FabioFile f) {
        this.fabio = f;
    }

    public FabioFile getFabio() {
        return this.fabio;
    }

    public float getTreshold() {
        return this.treshold;
    }

    public void addPeak(Peak p) {
        this.peaks.add(p);
        this.addPropertyChangeListener(p);
    }

    public Vector<Peak> getSortedpeaks() {
        if (this.peaks != null && this.peaks.size() > 0) {
            Collections.sort(this.peaks);
        }
        return this.peaks;
    }

    public void setComparator(String Key, int dir) {
        this.fireChangeSorter(Key);
        this.firechangeSortdirection(dir);
    }

    public Peak getPeak(int i) {
        return this.peaks.elementAt(i);
    }

    public int getSize() {
        return this.peaks.size();
    }

    public String getFileName() {
        return this.fileName;
    }

    public Vector<Peak> getChildren() {
        return this.peaks;
    }

    public float[] getTabChildren() {
        if (this.peaks != null) {
            int max_tab = this.peaks.size() * 2;
            this.tabPeak = new float[max_tab];
            int k = 0;
            int i = 0;
            while (i < this.peaks.size()) {
                if (this.getPeak(i).isVisible()) {
                    int j = k + 1;
                    this.tabPeak[k] = Float.valueOf(this.getPeak(i).getS()).floatValue();
                    this.tabPeak[j] = Float.valueOf(this.getPeak(i).getF()).floatValue();
                    k += 2;
                }
                ++i;
            }
        }
        return this.tabPeak;
    }

    public String toString() {
        return this.fileName;
    }

    public void setKeys(String listKeys) {
        this.peakKeys = listKeys.split("\\s+");
    }

    public void setKeys(String[] listKeys) {
        this.peakKeys = listKeys;
    }

    public void setPeaks(String blockWithAllPeaks) {
        this.scannedPeak = blockWithAllPeaks;
    }

    public void concatPeaks(String peak) {
        this.scannedPeak = this.scannedPeak.concat(peak);
        this.scannedPeak = String.valueOf(this.scannedPeak) + System.getProperty("line.separator");
    }

    public void parse() {
        Job parseJob = new Job("Getting " + this.npks + " peaks in file " + this.fileName){

            protected IStatus run(IProgressMonitor monitor) {
                if (PeakSearchSpt.this.peaks.size() == 0) {
                    Scanner scanner = new Scanner(PeakSearchSpt.this.scannedPeak);
                    scanner.useDelimiter("[\n\r]+");
                    monitor.beginTask("Wait while loading peaks", PeakSearchSpt.this.npks);
                    int j = 0;
                    while (scanner.hasNext()) {
                        String line = scanner.nextLine();
                        if (line.trim().equals("")) continue;
                        line = String.valueOf(PeakSearchSpt.this.peaks.size()) + " " + line;
                        Peak p = new Peak(PeakSearchSpt.this.peakKeys, line);
                        PeakSearchSpt.this.peaks.add(p);
                        int cfr_ignored_0 = PeakSearchSpt.this.peaks.size() * 100 / PeakSearchSpt.this.npks;
                        monitor.subTask("% done");
                        PeakSearchSpt.this.addPropertyChangeListener(p);
                        if (j % 250 == 0 && j > 0) {
                            PeakSearchSpt.this.fireSomePeaksLoaded();
                        } else if (j == PeakSearchSpt.this.npks - 1) {
                            PeakSearchSpt.this.fireSomePeaksLoaded();
                        }
                        ++j;
                        monitor.worked(1);
                        if (!monitor.isCanceled()) continue;
                        scanner.close();
                        return Status.CANCEL_STATUS;
                    }
                    scanner.close();
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        parseJob.setUser(true);
        parseJob.schedule();
    }

    private void fireSomePeaksLoaded() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "addPeaks", null, null));
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireChangeSorter(String comp) {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "comparator", null, (Object)comp));
        }
    }

    public void firechangeSortdirection(int comp) {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "dir", null, (Object)comp));
        }
    }
}

