/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.TableRowModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class JTableRow
extends JPanel
implements ActionListener,
MouseListener {
    public static final int PRINT_BIG = 0;
    public static final int PRINT_MEDIUM = 1;
    public static final int PRINT_SMALL = 2;
    private int wT;
    private int hT;
    private boolean editable = false;
    private Font theFont;
    private File currentFile = null;
    private JScrollPane tableView;
    private JTable theTable = null;
    private TableRowModel dm;
    private Object[][] theData;
    private String[] colName = null;
    private JPanel rowPanel;
    private JPanel cornerPanel;
    private JTable rowTable = null;
    private TableModel dmr;
    private Object[][] rowData = null;
    private Point menuLocation;
    private JPopupMenu tableMenu;
    private JMenuItem selectAllMenuItem;
    private JMenuItem selectNoneMenuItem;
    private JMenuItem selectColumnMenuItem;
    private JMenuItem selectRowMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem print1MenuItem;
    private JMenuItem print2MenuItem;
    private JMenuItem print3MenuItem;
    private static final JLabel noDataLabel = new JLabel("No Data");

    public JTableRow() {
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        this.theData = null;
        this.rowData = null;
        this.theFont = ATKConstant.labelFont;
        this.wT = 0;
        this.hT = 0;
        this.dm = new TableRowModel();
        this.tableView = new JScrollPane();
        this.tableView.setPreferredSize(new Dimension(640, 480));
        this.tableView.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                JTableRow.this.placeComponent();
            }
        });
        this.add((Component)this.tableView, "Center");
        this.rowPanel = new JPanel();
        this.rowPanel.setBorder(null);
        this.rowPanel.setLayout(null);
        this.rowPanel.setPreferredSize(new Dimension(45, 0));
        this.add((Component)this.rowPanel, "West");
        this.rowData = null;
        this.dmr = new TableModel(){

            public void addTableModelListener(TableModelListener l) {
            }

            public void removeTableModelListener(TableModelListener l) {
            }

            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            }

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            public boolean isCellEditable(int row, int col) {
                return false;
            }

            public String getColumnName(int column) {
                return "";
            }

            public int getRowCount() {
                return JTableRow.this.hT;
            }

            public int getColumnCount() {
                return 1;
            }

            public Object getValueAt(int row, int column) {
                if (JTableRow.this.rowData != null) {
                    return JTableRow.this.rowData[row][column];
                }
                return "";
            }
        };
        this.cornerPanel = new JPanel();
        this.cornerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.rowPanel.add(this.cornerPanel);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
                JTableRow.this.placeComponent();
            }

            public void componentShown(ComponentEvent e) {
                JTableRow.this.placeComponent();
            }
        });
        this.tableMenu = new JPopupMenu();
        this.menuLocation = new Point(0, 0);
        this.selectNoneMenuItem = new JMenuItem("Clear selection");
        this.selectNoneMenuItem.addActionListener(this);
        this.selectAllMenuItem = new JMenuItem("Select All");
        this.selectAllMenuItem.addActionListener(this);
        this.selectRowMenuItem = new JMenuItem("Select current row");
        this.selectRowMenuItem.addActionListener(this);
        this.selectColumnMenuItem = new JMenuItem("Select current column");
        this.selectColumnMenuItem.addActionListener(this);
        this.copyMenuItem = new JMenuItem("Copy selection to clipboard");
        this.copyMenuItem.addActionListener(this);
        this.saveMenuItem = new JMenuItem("Save selection");
        this.saveMenuItem.addActionListener(this);
        this.print1MenuItem = new JMenuItem("Print table (Big size)");
        this.print1MenuItem.addActionListener(this);
        this.print2MenuItem = new JMenuItem("Print table (Medium size)");
        this.print2MenuItem.addActionListener(this);
        this.print3MenuItem = new JMenuItem("Print table (Small size)");
        this.print3MenuItem.addActionListener(this);
        this.tableMenu.add(this.selectNoneMenuItem);
        this.tableMenu.add(this.selectAllMenuItem);
        this.tableMenu.add(this.selectRowMenuItem);
        this.tableMenu.add(this.selectColumnMenuItem);
        this.tableMenu.add(new JSeparator());
        this.tableMenu.add(this.copyMenuItem);
        this.tableMenu.add(this.saveMenuItem);
        this.tableMenu.add(new JSeparator());
        this.tableMenu.add(this.print1MenuItem);
        this.tableMenu.add(this.print2MenuItem);
        this.tableMenu.add(this.print3MenuItem);
    }

    public void setEditable(boolean b) {
        this.editable = b;
        this.dm.setEditable(this.editable);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setData(Object[][] data, int startLabelX, int startLabelY) {
        if (data == null) {
            this.clearData();
            return;
        }
        int nhT = data.length;
        if (nhT == 0) {
            this.clearData();
            return;
        }
        int nwT = data[0].length;
        if (nwT == 0) {
            this.clearData();
            return;
        }
        String[] nColName = new String[nwT];
        int i = 0;
        while (i < nwT) {
            nColName[i] = Integer.toString(startLabelX + i);
            ++i;
        }
        Object[][] nRowData = new Object[nhT][1];
        i = 0;
        while (i < nhT) {
            nRowData[i][0] = Integer.toString(startLabelY + i);
            ++i;
        }
        this.theData = data;
        this.rowData = nRowData;
        this.colName = nColName;
        this.updateTables(nhT, nwT);
    }

    public void setData(Object[][] data, String[] columnNames) {
        int nhT;
        if (columnNames != null) {
            this.colName = columnNames;
        }
        int nwT = (nhT = data == null ? 0 : data.length) == 0 ? (columnNames == null ? 0 : columnNames.length) : data[0].length;
        if (nwT == 0) {
            this.clearData();
            return;
        }
        this.remove(this.rowPanel);
        this.theData = data;
        this.rowData = null;
        this.updateTables(nhT, nwT);
    }

    private void updateTables(int nhT, int nwT) {
        boolean structureChanged = false;
        if (this.dm.getData() == null || this.theData == null) {
            structureChanged = true;
        } else if (this.theData.length != this.dm.getData().length) {
            structureChanged = true;
        } else if (this.theData.length > 0) {
            if (this.theData[0] == null) {
                if (this.dm.getData()[0] != null) {
                    structureChanged = true;
                }
            } else if (this.theData[0].length != this.dm.getData()[0].length) {
                structureChanged = true;
            }
        }
        this.dm.setData(this.theData);
        String[] dmColName = this.dm.getColName();
        if (dmColName == null || this.colName == null || dmColName.length != this.colName.length) {
            structureChanged = true;
        } else {
            int i = 0;
            while (i < dmColName.length) {
                if (this.colName[i] == null || !this.colName[i].equals(dmColName[i])) {
                    structureChanged = true;
                    break;
                }
                ++i;
            }
        }
        this.dm.setColName(this.colName);
        this.wT = nwT;
        this.hT = nhT;
        if (this.theTable == null) {
            this.createTable();
            this.placeComponent();
        } else {
            if (structureChanged) {
                this.dm.fireTableStructureChanged();
            } else if (this.dm.getRowCount() > 0) {
                this.dm.fireTableRowsUpdated(0, this.dm.getRowCount() - 1);
            }
            if (this.rowTable != null) {
                TableModelEvent e2 = new TableModelEvent(this.dmr, 0, this.hT - 1);
                this.rowTable.tableChanged(e2);
            }
        }
        if (structureChanged) {
            this.adjustColumnSize();
        }
        this.updateViewPortView();
    }

    public Object getObjectAt(int row, int column) {
        if (this.theData != null) {
            return this.theData[row][column];
        }
        return null;
    }

    public void clearData() {
        this.theData = null;
        this.rowData = null;
        this.updateTables(0, 0);
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.theFont = f;
        noDataLabel.setFont(f);
        noDataLabel.revalidate();
        if (this.theTable != null) {
            if (this.rowTable != null) {
                this.rowTable.setFont(f);
            }
            this.theTable.setFont(f);
            this.tableView.revalidate();
            this.placeComponent();
        }
    }

    public Font getFont() {
        return this.theFont;
    }

    public void adjustSize() {
        if (this.theTable == null) {
            return;
        }
        Dimension ts = this.theTable.getPreferredSize();
        ts.width += 4;
        ts.height += this.theTable.getRowHeight() + 4;
        this.tableView.setPreferredSize(ts);
    }

    public void adjustColumnSize() {
        if (this.theTable == null) {
            return;
        }
        int[] widths = this.measureColumns(this.theFont);
        int i = 0;
        while (i < widths.length) {
            this.theTable.getColumnModel().getColumn(i).setPreferredWidth(widths[i] + 16);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.copyMenuItem) {
            StringSelection stringSelection = new StringSelection(this.makeTabbedString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        } else if (src == this.selectAllMenuItem) {
            this.theTable.selectAll();
        } else if (src == this.selectNoneMenuItem) {
            this.theTable.clearSelection();
        } else if (src == this.selectRowMenuItem) {
            this.theTable.clearSelection();
            int r = this.theTable.rowAtPoint(this.menuLocation);
            this.theTable.setRowSelectionInterval(r, r);
            this.theTable.setColumnSelectionInterval(0, this.wT - 1);
        } else if (src == this.selectColumnMenuItem) {
            this.theTable.clearSelection();
            int r = this.theTable.columnAtPoint(this.menuLocation);
            this.theTable.setColumnSelectionInterval(r, r);
            this.theTable.setRowSelectionInterval(0, this.hT - 1);
        } else if (src == this.print1MenuItem) {
            this.printTable(0);
        } else if (src == this.print2MenuItem) {
            this.printTable(1);
        } else if (src == this.print3MenuItem) {
            this.printTable(2);
        } else if (src == this.saveMenuItem) {
            int status;
            JFileChooser fc = new JFileChooser(".");
            if (this.currentFile != null) {
                fc.setSelectedFile(this.currentFile);
            }
            if ((status = fc.showSaveDialog(this)) == 0) {
                this.currentFile = fc.getSelectedFile();
                try {
                    FileWriter f = new FileWriter(this.currentFile);
                    f.write(this.makeTabbedString());
                    f.close();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, ex, "Error while saving data", 0);
                }
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3) {
            this.menuLocation.x = e.getX();
            this.menuLocation.y = e.getY();
            this.tableMenu.show(this.theTable, e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private void createTable() {
        if (this.theTable != null) {
            this.theTable.removeMouseListener(this);
            if (this.rowTable != null) {
                this.rowPanel.remove(this.rowTable);
            }
        }
        this.theTable = new JTable(this.dm);
        this.theTable.setFont(this.theFont);
        this.theTable.setRowSelectionAllowed(true);
        this.theTable.setColumnSelectionAllowed(true);
        this.theTable.setAutoResizeMode(0);
        this.theTable.addMouseListener(this);
        noDataLabel.setFont(this.theFont);
        if (this.rowData != null) {
            this.rowTable = new JTable(this.dmr);
            this.rowTable.setFont(this.theFont);
            this.rowTable.setAutoResizeMode(0);
            this.rowTable.setBackground(this.getBackground());
            this.rowTable.setEnabled(false);
            this.rowPanel.add(this.rowTable);
        }
    }

    private void updateViewPortView() {
        if (this.wT == 0 && this.hT == 0) {
            if (this.tableView.getViewport().getView() != noDataLabel) {
                this.tableView.setViewportView(noDataLabel);
            }
        } else if (this.tableView.getViewport().getView() != this.theTable) {
            this.tableView.setViewportView(this.theTable);
        }
    }

    private void placeComponent() {
        if (this.rowData != null) {
            Dimension d = this.getSize();
            int hFont = 17;
            this.cornerPanel.setBounds(-5, -5, 54, hFont + 5);
            Rectangle r = this.tableView.getViewport().getViewRect();
            this.rowTable.setBounds(0, -r.y + hFont, 45, r.y + (int)d.getHeight());
            this.rowTable.revalidate();
        }
    }

    private String makeTabbedString() {
        int[] cols = this.theTable.getSelectedColumns();
        int[] rows = this.theTable.getSelectedRows();
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < cols.length) {
            str.append(this.theTable.getColumnName(cols[i]));
            if (i < cols.length - 1) {
                str.append('\t');
            }
            ++i;
        }
        str.append('\n');
        int j = 0;
        while (j < rows.length) {
            int i2 = 0;
            while (i2 < cols.length) {
                str.append(this.theData[rows[j]][cols[i2]]);
                if (i2 < cols.length - 1) {
                    str.append('\t');
                }
                ++i2;
            }
            str.append('\n');
            ++j;
        }
        return str.toString();
    }

    private int[] measureColumns(Font f) {
        if (this.theData == null) {
            return new int[0];
        }
        int[] colWidths = new int[this.wT];
        int i = 0;
        while (i < this.wT) {
            Dimension d = ATKGraphicsUtils.measureString(this.colName[i], f);
            colWidths[i] = d.width;
            ++i;
        }
        i = 0;
        while (i < this.wT) {
            int j = 0;
            while (j < this.hT) {
                String value = this.theData[j][i].toString();
                Dimension d = ATKGraphicsUtils.measureString(value, f);
                if (d.width > colWidths[i]) {
                    colWidths[i] = d.width;
                }
                ++j;
            }
            ++i;
        }
        return colWidths;
    }

    public void printTable(int printSize) {
        PrintJob printJob;
        Font prFont;
        int printerRes = 140;
        int halfRes = printerRes / 2;
        if (this.theData == null) {
            return;
        }
        switch (printSize) {
            case 0: {
                prFont = new Font("Dialog", 0, 16);
                break;
            }
            case 1: {
                prFont = new Font("Dialog", 0, 12);
                break;
            }
            default: {
                prFont = new Font("Dialog", 0, 8);
            }
        }
        int[] colWidths = this.measureColumns(prFont);
        int[] colNameWidths = new int[this.wT];
        int ascent = (int)(ATKGraphicsUtils.getLineMetrics("Page 000", prFont).getAscent() + 0.5f);
        Dimension pDim = ATKGraphicsUtils.measureString("Page 000", prFont);
        int hFont = pDim.height;
        int i = 0;
        while (i < this.wT) {
            Dimension d = ATKGraphicsUtils.measureString(this.colName[i], prFont);
            colNameWidths[i] = d.width;
            ++i;
        }
        double A4Height = 11.69291338582677 * (double)(printerRes - 1) - 3.0 * (double)hFont;
        int nbPage = (int)((double)((hFont + 4) * this.hT) / A4Height) + 1;
        PageAttributes pa = new PageAttributes();
        JobAttributes ja = new JobAttributes();
        pa.setPrintQuality(PageAttributes.PrintQualityType.HIGH);
        pa.setColor(PageAttributes.ColorType.COLOR);
        pa.setMedia(PageAttributes.MediaType.A4);
        pa.setOrientationRequested(PageAttributes.OrientationRequestedType.PORTRAIT);
        pa.setPrinterResolution(printerRes);
        ja.setMaxPage(nbPage);
        ja.setMinPage(1);
        ja.setPageRanges(new int[][]{{1, nbPage}});
        ja.setDialog(JobAttributes.DialogType.NATIVE);
        Window parent = ATKGraphicsUtils.getWindowForComponent(this);
        if (parent instanceof Frame) {
            printJob = Toolkit.getDefaultToolkit().getPrintJob((Frame)parent, "Print table", ja, pa);
        } else {
            Frame dummy = new Frame();
            printJob = Toolkit.getDefaultToolkit().getPrintJob(dummy, "Print table", ja, pa);
        }
        if (printJob != null) {
            try {
                int wp = printJob.getPageDimension().width - printerRes;
                int hp = printJob.getPageDimension().height - printerRes;
                nbPage = 1;
                int j = 0;
                int nbI = (hp - (hFont + 4) * 3) / (hFont + 4);
                int nbP = this.hT / nbI + 1;
                while (j < this.hT) {
                    int x = 0;
                    int y = 0;
                    Graphics g = printJob.getGraphics();
                    g.translate(halfRes, halfRes);
                    g.setFont(prFont);
                    i = 0;
                    while (i < this.wT) {
                        int xpos = (colWidths[i] - colNameWidths[i]) / 2;
                        g.setColor(Color.LIGHT_GRAY);
                        g.fillRect(x, y, colWidths[i] + 6, hFont + 2);
                        g.setColor(Color.BLACK);
                        g.drawString(this.colName[i], (x += 3) + xpos, y + ascent);
                        x += colWidths[i] + 3;
                        if (i < this.wT - 1) {
                            g.drawLine(x, y, x, y + hFont);
                        }
                        ++i;
                    }
                    g.drawLine(0, y += hFont + 2, x, y);
                    g.drawLine(0, y + 1, x, y + 1);
                    y += 2;
                    g.setColor(Color.BLACK);
                    int j2 = 0;
                    while (j < this.hT && j2 < nbI) {
                        x = 0;
                        i = 0;
                        while (i < this.wT) {
                            i = 0;
                            while (i < this.wT) {
                                g.drawString(this.theData[j][i].toString(), x += 3, y + ascent);
                                x += colWidths[i] + 3;
                                if (i < this.wT - 1) {
                                    g.drawLine(x, y, x, y + hFont);
                                }
                                ++i;
                            }
                            ++i;
                        }
                        g.drawLine(0, y += hFont + 2, x, y);
                        y += 2;
                        ++j;
                        ++j2;
                    }
                    g.drawLine(0, 0, x, 0);
                    g.drawLine(x, 0, x, y -= 2);
                    g.drawLine(0, y, 0, 0);
                    g.drawString("Page " + nbPage + "/" + nbP, wp - pDim.width, hp - hFont + ascent);
                    g.dispose();
                    ++nbPage;
                }
                printJob.finalize();
                printJob = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(parent, "Exception occured while printing\n" + e.getMessage(), "Print table", 0);
            }
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        String[] cols = new String[6];
        Object[][] data = new Object[200][6];
        int i = 0;
        while (i < cols.length) {
            int j;
            if (i == 0) {
                cols[i] = "Index";
                j = 0;
                while (j < data.length) {
                    data[j][i] = new Double(j);
                    ++j;
                }
            } else {
                cols[i] = "Column " + i;
                j = 0;
                while (j < data.length) {
                    data[j][i] = new Double(Math.random());
                    ++j;
                }
            }
            ++i;
        }
        JTableRow t = new JTableRow();
        t.setData(data, cols);
        t.adjustColumnSize();
        f.setContentPane(t);
        ATKGraphicsUtils.centerFrameOnScreen(f);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
    }
}

