package fable.framework.xmlparser.internal;


import java.util.Vector;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import fable.framework.xmlparser.object.XmlParserException;
import fable.framework.xmlparser.object.Xmloption;

/**
 * 
 * @author SUCHET
 * @description this interface is used for extension point
 */
public interface IOptions {
	/**
	 * This method is responsible for looping through fields created dynamically
	 * in the view. It checks if fields and their values are ok before being 
	 * sent to the main program.
	 * 
	 * @return boolean
	 */
	public boolean validateView();
	public void setOptions();
	public void create(Composite parent) throws XmlParserException;
	public boolean launch();
	public void stop();
	public void addListener(IPropertyChangeListener i);
	public void removeListener(IPropertyChangeListener i);
	public boolean updateFields(Control[] c, String KeyOption,  String value); //the name of the option
	public boolean updateFields( String KeyOption,  String value);
	public boolean loadOptions(Xmloption options);
	public boolean loadOptions(Control[] c,Xmloption options);
	public void setCurrentPath(String currentSamplePath);
	public String getdefaultValue(String option);
	public void resetFields();
	/**
	 * return all XmlOption that are in this view with their label and values.
	 * @return Vector<Xmloption>
	 */
	public Vector<Xmloption> getOptions();
	
	
}
