/*
 * Decompiled with CFR 0.152.
 */
package fable.transformtion.object;

import fable.framework.jep.FableJep;
import fable.framework.jep.JavaToJepTools;
import fable.framework.jep.StdoutRead;
import fable.framework.toolbox.ColumnFile;
import fable.framework.ui.views.ColumnFilePlotView;
import fable.transformation.Activator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import jep.Jep;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class Transform {
    Logger logger;
    float[] tth;
    float[] tthteory;
    private String fileteredFile;
    private String parametersFile;
    private String[] keys;
    private String[] filteredfilecoltitles;
    private String currentProjectPath;
    private HashMap<String, Boolean> possvary;
    private HashMap<String, Object> pars = new HashMap();
    private HashMap<String, String> pars_help = new HashMap();
    private HashMap<String, double[]> filtered = new HashMap();
    private Vector<String> vars;
    private FableJep fableJep;
    private static Transform transform = null;
    private ArrayList<IPropertyChangeListener> listeners = new ArrayList();
    private ColumnFile columns;
    public StdoutRead stdout;
    private int nVaryList;

    public static Transform getTransformer() {
        if (transform == null) {
            transform = new Transform();
        }
        return transform;
    }

    private Transform() {
        this.logger = Logger.getLogger(Transform.class);
        try {
            this.fableJep = FableJep.getFableJep();
            FableJep.jepImportSpecificDefinition((Jep)this.fableJep.getJep(), (String)"ImageD11", (String)"transformer");
            FableJep.jepImportModules((Jep)this.fableJep.getJep(), (String)"numpy");
            this.fableJep.eval("t=transformer.transformer()");
            try {
                File stdout_filename = File.createTempFile("transformer", ".stdout");
                stdout_filename.deleteOnExit();
                this.logger.debug((Object)("tempFile = " + stdout_filename.getAbsolutePath()));
                this.fableJep.redirectStdout(stdout_filename.getAbsolutePath());
                this.stdout = new StdoutRead(stdout_filename.getAbsolutePath());
                this.stdout.start();
                this.fableJep.flushStdout();
            }
            catch (IOException iOException) {
                this.logger.debug((Object)"Unable to start reading transformer output");
            }
            this.loadFileParameters(Activator.getDefault().getPreferenceStore().getString("pref_parameters_file"));
            this.columns = new ColumnFile();
            if (this.columns.getFileName() != null) {
                this.loadFiltered(this.columns.getFileName());
            }
        }
        catch (JepException e) {
            this.logger.error((Object)("can not create jep : " + e.getMessage()));
        }
    }

    public void loadFileParameters(String filename) {
        this.parametersFile = filename;
        try {
            this.fableJep.set("filename", this.parametersFile);
            this.fableJep.eval("t.loadfileparameters(filename)");
            int index = this.parametersFile.lastIndexOf(System.getProperty("file.separator"));
            this.currentProjectPath = index > 0 ? this.parametersFile.substring(0, index) : this.parametersFile;
            this.fireCurrentProjectPath();
        }
        catch (JepException e) {
            this.logger.error((Object)("Load file parameters: " + this.parametersFile + "-" + e.getMessage()));
        }
    }

    public void editParameters() {
        try {
            String key;
            this.fableJep.eval("t.updateparameters()");
            this.fableJep.eval("pars=t.pars");
            this.fableJep.eval("vars=t.getvars()");
            this.fableJep.eval("possvars=t.get_variable_list()");
            this.fableJep.eval("print possvars");
            this.fableJep.eval("keys = pars.keys()");
            this.fableJep.eval("vals = pars.values()");
            this.fableJep.eval("res = len(keys)");
            int lenpars = (Integer)this.fableJep.getValue("res");
            this.keys = new String[lenpars];
            int i = 0;
            while (i < lenpars) {
                this.fableJep.set("i", i);
                Object val = this.fableJep.getValue("vals[i]");
                key = (String)this.fableJep.getValue("keys[i]");
                this.pars.put(key, val);
                this.fableJep.set("parname", key);
                this.pars_help.put(key, (String)this.fableJep.getValue("t.parameterobj.par_objs[parname].helpstring"));
                this.keys[i] = key;
                ++i;
            }
            int lenvars = (Integer)this.fableJep.getValue("len(vars)");
            this.vars = new Vector();
            int i2 = 0;
            while (i2 < lenvars) {
                this.fableJep.set("i", i2);
                key = (String)this.fableJep.getValue("vars[i]");
                this.vars.add(key);
                ++i2;
            }
            int lenpossvars = (Integer)this.fableJep.getValue("len(possvars)");
            this.possvary = new HashMap();
            int i3 = 0;
            while (i3 < lenpossvars) {
                this.fableJep.set("i", i3);
                String key2 = (String)this.fableJep.getValue("possvars[i]");
                Boolean b = new Boolean(this.vars.contains(key2));
                this.possvary.put(key2, b);
                ++i3;
            }
            this.nVaryList = this.vars.size();
        }
        catch (JepException e) {
            this.logger.error((Object)("can not create loadfileparameters : " + e.getMessage()));
        }
        this.fireEditParameters();
    }

    public HashMap<String, String> getparsHelp() {
        return this.pars_help;
    }

    public HashMap<String, Object> getpars() {
        return this.pars;
    }

    public HashMap<String, Boolean> getPossVary() {
        return this.possvary;
    }

    public String[] get_filteredfilecoltitles() {
        return this.filteredfilecoltitles;
    }

    public void setColumnObject() {
        boolean bColumnexists = true;
        try {
            this.fableJep.eval("column_object=t.colfile");
            if (this.columns == null) {
                this.columns = new ColumnFile();
                bColumnexists = false;
            }
            this.columns.setPythonObject(this.fableJep);
            ColumnFilePlotView.view.setColumnFile(this.columns);
            String filename = (String)this.fableJep.getValue("column_object.filename");
            this.columns.setFileName(filename);
            this.columns.loadRows();
            if (bColumnexists) {
                this.columns.fireRemoveAll();
            }
            this.columns.fireAddColumnFile();
        }
        catch (JepException e) {
            this.logger.error((Object)("can not set column_object with transformer: " + e.getMessage()));
        }
    }

    public boolean compute_tth_eta() {
        boolean bok = true;
        if (this.fileteredFile != null && !this.fileteredFile.equals("")) {
            try {
                this.filtered = new HashMap();
                this.fableJep.eval("t.compute_tth_eta()");
                int stth = (Integer)this.fableJep.getValue("len(t.colfile.tth)");
                this.tth = new float[stth];
                this.tth = this.fableJep.getValue_floatarray("t.colfile.tth.astype(numpy.float32).tostring()");
                this.columns.loadRows();
                this.columns.update();
                String[] xyLabel = new String[]{"tth", "eta"};
                this.columns.displayComputedData(xyLabel);
            }
            catch (JepException e) {
                bok = false;
                this.logger.error((Object)("can not create compute_tth_eta : " + e.getMessage()));
            }
        }
        return bok;
    }

    public HashMap<String, double[]> getColumnstoPlot() {
        try {
            int numcols = (Integer)this.fableJep.getValue("t.colfile.ncols");
            if (this.filteredfilecoltitles == null) {
                this.filteredfilecoltitles = new String[numcols];
            } else if (this.filteredfilecoltitles.length != numcols) {
                this.filteredfilecoltitles = new String[numcols];
            }
            int i = 0;
            while (i < numcols) {
                this.fableJep.set("i", i);
                this.filteredfilecoltitles[i] = (String)this.fableJep.getValue("t.getcols()[i]");
                this.fableJep.set("name", this.filteredfilecoltitles[i]);
                this.fableJep.eval("filteredValues=t.getcolumn(name)");
                float[] myData = this.fableJep.getValue_floatarray("filteredValues.astype(numpy.float32).tostring()");
                double[] myDoubleToplot = new double[myData.length];
                int j = 0;
                while (j < myData.length) {
                    myDoubleToplot[j] = myData[j];
                    ++j;
                }
                this.filtered.put(this.filteredfilecoltitles[i], myDoubleToplot);
                ++i;
            }
        }
        catch (JepException e) {
            this.logger.error((Object)("Can't plot : " + e.getMessage()));
        }
        return this.filtered;
    }

    public boolean fit(float tthmin, float tthmax) {
        if (this.tth != null && this.tthteory != null) {
            try {
                this.fableJep.flushStdout();
                this.fableJep.set("tthmin", tthmin);
                this.fableJep.set("tthmax", tthmax);
                this.fableJep.eval("t.fit(tthmin, tthmax)");
                this.fableJep.flushStdout();
                this.editParameters();
            }
            catch (JepException e1) {
                this.logger.debug((Object)e1.getMessage());
            }
        }
        return true;
    }

    public boolean compute_tth_histo() {
        boolean bok = true;
        try {
            this.fableJep.eval("t.compute_tth_histo()");
            this.columns.loadRows();
            this.columns.update();
            String[] xyLabel = new String[]{"tth_hist_prob", "eta"};
            this.columns.displayComputedData(xyLabel);
        }
        catch (JepException e) {
            bok = false;
            this.logger.error((Object)("can compute_tth_histo : " + e.getMessage()));
        }
        return bok;
    }

    public boolean loadFiltered(String f_name) {
        this.fileteredFile = f_name;
        boolean bok = false;
        try {
            this.fableJep.set("filename", this.fileteredFile);
            bok = this.fableJep.eval("t.loadfiltered(filename)");
            this.fableJep.flushStdout();
            this.setColumnObject();
            int index = this.fileteredFile.lastIndexOf(System.getProperty("file.separator"));
            if (index < 0) {
                index = 0;
            }
            this.currentProjectPath = this.fileteredFile.substring(0, index);
            this.tth = null;
            this.tthteory = null;
        }
        catch (JepException e) {
            this.logger.error((Object)("Unable to load filtered peak : " + e.getMessage()));
        }
        return bok;
    }

    public String getParamFileName() {
        if (this.parametersFile == null || this.parametersFile.equals("")) {
            return "parameters from python code";
        }
        return this.parametersFile;
    }

    public boolean addUnitCellPeaks() {
        boolean bok = true;
        if (this.fileteredFile != null && !this.fileteredFile.equals("")) {
            try {
                this.fableJep.eval("t.addcellpeaks()");
                this.fableJep.eval("mytth=t.theorytth");
                int stth = (Integer)this.fableJep.getValue("len(t.theorytth)");
                this.tthteory = new float[stth];
                this.tthteory = this.fableJep.getValue_floatarray("mytth.astype(numpy.float32).tostring()");
                this.columns.loadRows();
                this.columns.update();
                this.columns.AddUnitCell(this.tthteory);
            }
            catch (JepException e) {
                bok = false;
                System.out.println("Can not addUnitCellPeaks: " + e.getMessage());
                this.logger.error((Object)("Can not addUnitCellPeaks: " + e.getMessage()));
            }
        }
        return bok;
    }

    public boolean set_parameters(Object[] varylist, HashMap<String, Object> parameters) {
        boolean bok = false;
        try {
            JavaToJepTools.javaHashMapToPyDictionary((Jep)this.fableJep.getJep(), parameters);
            this.fableJep.eval("t.parameterobj.set_parameters(dictionary)");
            JavaToJepTools.javaTabToPythonList((Jep)this.fableJep.getJep(), (Object[])varylist);
            this.fableJep.eval("t.parameterobj.set_varylist(list)");
            this.nVaryList = (Integer)this.fableJep.getValue("len(t.parameterobj.varylist)");
            this.fireVaryList();
            this.fireEditParameters();
            bok = true;
        }
        catch (JepException e) {
            bok = false;
            this.logger.error((Object)("Can not set_parameters: " + e.getMessage()));
            return bok;
        }
        return bok;
    }

    public void saveParameters(String fileName) {
        try {
            this.fableJep.set("filename", fileName);
            this.fableJep.eval("t.saveparameters(filename)");
            this.parametersFile = fileName;
        }
        catch (JepException e) {
            this.logger.error((Object)("Can not saveParameters: " + e.getMessage()));
        }
    }

    public boolean computegv() {
        boolean bok = true;
        try {
            if (this.fileteredFile != null && !this.fileteredFile.equals("")) {
                if (this.tth == null) {
                    this.compute_tth_eta();
                }
                this.fableJep.eval("t.computegv()");
                this.columns.loadRows();
                this.columns.update();
            }
        }
        catch (JepException e) {
            bok = false;
            this.logger.error((Object)("Can not compute g-vectors: " + e.getMessage()));
        }
        return bok;
    }

    public boolean savegv(String name) {
        boolean bok = false;
        if (!name.trim().equals("")) {
            try {
                if (this.fileteredFile != null && !this.fileteredFile.equals("")) {
                    this.fableJep.set("filename", name);
                    bok = this.fableJep.eval("t.savegv(filename)");
                    this.logger.info((Object)("g-vectors done : " + name));
                }
            }
            catch (JepException e) {
                this.logger.error((Object)("Can not computegv: " + e.getMessage()));
            }
        }
        return bok;
    }

    public boolean saveFilteredPeaks(String name) {
        boolean returnValue = false;
        if (!name.trim().equals("")) {
            try {
                if (this.fileteredFile != null && !this.fileteredFile.equals("")) {
                    this.fableJep.set("filename", name);
                    returnValue = this.fableJep.eval("t.write_colfile(filename)");
                    this.logger.info((Object)("write col file done  : " + name));
                }
            }
            catch (JepException e) {
                this.logger.error((Object)("Can not computegv: " + e.getMessage()));
            }
        }
        return returnValue;
    }

    public float[] getTth() throws JepException {
        float[] returnValue = null;
        if (this.fableJep.eval("t.colfile!=None") && !this.fableJep.eval("t.colfile.tth!=None")) {
            returnValue = this.fableJep.getValue_floatarray("t.colfile.tth.astype(numpy.float32).tostring()");
        }
        return returnValue;
    }

    public float[] getTheoryTth() throws JepException {
        float[] returnValue = null;
        if (this.fableJep.eval("t.colfile!=None") && !this.fableJep.eval("t.colfile.theorytth!=None")) {
            returnValue = this.fableJep.getValue_floatarray("t.colfile.theorytth.astype(numpy.float32).tostring()");
        }
        return returnValue;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireEditParameters() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "refresh", null, this.pars));
        }
    }

    public void fireVaryList() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "varyList", null, (Object)this.nVaryList));
        }
    }

    public int getvaryList() {
        return this.nVaryList;
    }

    public ColumnFile getColumnfile() {
        return this.columns;
    }

    public void fireCurrentProjectPath() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "currentProjectPath", null, (Object)this.currentProjectPath));
        }
    }

    public void fireUpdateView() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "updateFields", null, null));
        }
    }
}

