/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.ide.dialogs.AbstractEncodingFieldEditor;
import org.eclipse.ui.ide.dialogs.EncodingFieldEditor;
import org.eclipse.ui.ide.dialogs.ResourceEncodingFieldEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MessageDialogPage;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextEditorMessages;

public class ChangeEncodingAction
extends TextEditorAction {
    private static final int APPLY_ID = 2;
    private String fDialogTitle;
    private static final String ENCODING_PREF_KEY = "encoding";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ChangeEncodingAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        String key = "dialog.title";
        if (prefix != null && prefix.length() > 0) {
            key = String.valueOf(prefix) + key;
        }
        this.fDialogTitle = ChangeEncodingAction.getString((ResourceBundle)bundle, (String)key, null);
    }

    public void run() {
        final IResource resource = this.getResource();
        Shell parentShell = this.getTextEditor().getSite().getShell();
        final IEncodingSupport encodingSupport = this.getEncodingSupport();
        if (resource == null && encodingSupport == null) {
            MessageDialog.openInformation((Shell)parentShell, (String)this.fDialogTitle, (String)TextEditorMessages.ChangeEncodingAction_message_noEncodingSupport);
            return;
        }
        Dialog dialog = new Dialog(parentShell){
            private AbstractEncodingFieldEditor fEncodingEditor;
            private IPreferenceStore store = null;

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText(ChangeEncodingAction.this.fDialogTitle);
            }

            protected Control createDialogArea(Composite parent) {
                Control composite = super.createDialogArea(parent);
                if (!(composite instanceof Composite)) {
                    composite.dispose();
                    composite = new Composite(parent, 0);
                }
                GridLayout layout = new GridLayout();
                layout.marginHeight = this.convertVerticalDLUsToPixels(7);
                layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
                layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
                layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
                parent.setLayout((Layout)layout);
                GridData data = new GridData(1808);
                composite.setLayoutData((Object)data);
                composite.setFont(parent.getFont());
                MessageDialogPage page = new MessageDialogPage(this, (Composite)composite){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void setErrorMessage(String newMessage) {
                        super.setErrorMessage(newMessage);
                        this.setButtonEnabledState(0, newMessage == null);
                        this.setButtonEnabledState(2, newMessage == null);
                    }

                    private void setButtonEnabledState(int id, boolean state) {
                        Button button = 1.access$0(this.this$1, id);
                        if (button != null) {
                            button.setEnabled(state);
                        }
                    }
                };
                if (resource != null) {
                    this.fEncodingEditor = new ResourceEncodingFieldEditor("", (Composite)composite, resource);
                    this.fEncodingEditor.setPage((DialogPage)page);
                    this.fEncodingEditor.load();
                } else {
                    this.fEncodingEditor = new EncodingFieldEditor(ChangeEncodingAction.ENCODING_PREF_KEY, "", (Composite)composite);
                    this.store = new PreferenceStore();
                    String defaultEncoding = encodingSupport.getDefaultEncoding();
                    this.store.setDefault(ChangeEncodingAction.ENCODING_PREF_KEY, defaultEncoding);
                    String encoding = encodingSupport.getEncoding();
                    if (encoding != null) {
                        this.store.setValue(ChangeEncodingAction.ENCODING_PREF_KEY, encoding);
                    }
                    this.fEncodingEditor.setPreferenceStore(this.store);
                    this.fEncodingEditor.setPage((DialogPage)page);
                    this.fEncodingEditor.load();
                    if (encoding == null || encoding.equals(defaultEncoding) || encoding.length() == 0) {
                        this.fEncodingEditor.loadDefault();
                    }
                }
                return composite;
            }

            protected void createButtonsForButtonBar(Composite parent) {
                this.createButton(parent, 2, TextEditorMessages.ChangeEncodingAction_button_apply_label, false);
                super.createButtonsForButtonBar(parent);
            }

            protected void buttonPressed(int buttonId) {
                if (buttonId == 2) {
                    this.apply();
                } else {
                    super.buttonPressed(buttonId);
                }
            }

            protected void okPressed() {
                this.apply();
                super.okPressed();
            }

            private void apply() {
                this.fEncodingEditor.store();
                if (resource == null) {
                    String encoding = this.fEncodingEditor.getPreferenceStore().getString(this.fEncodingEditor.getPreferenceName());
                    encodingSupport.setEncoding(encoding);
                }
            }

            static /* synthetic */ Button access$0(1 var0, int n) {
                return var0.getButton(n);
            }
        };
        dialog.open();
    }

    public void update() {
        this.setEnabled((this.getResource() != null || this.getEncodingSupport() != null) && !this.getTextEditor().isDirty());
    }

    private IResource getResource() {
        if (this.getTextEditor() != null && this.getTextEditor().getEditorInput() != null) {
            IEditorInput iEditorInput = this.getTextEditor().getEditorInput();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iEditorInput.getAdapter((Class)clazz);
        }
        return null;
    }

    private IEncodingSupport getEncodingSupport() {
        if (this.getTextEditor() != null) {
            ITextEditor iTextEditor = this.getTextEditor();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.editors.text.IEncodingSupport");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IEncodingSupport)iTextEditor.getAdapter((Class)clazz);
        }
        return null;
    }
}

