/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.views;

import fable.framework.contentProvider.SampleTableContentProvider;
import fable.framework.labelProvider.SampleTablelabelProvider;
import fable.framework.toolbox.Experiment;
import fable.framework.toolbox.FabioFile;
import fable.framework.toolbox.FabioFileException;
import fable.framework.toolbox.ISampleListener;
import fable.framework.toolbox.LookAndFeel;
import fable.framework.toolbox.Sample;
import fable.framework.toolbox.SampleEvent;
import fable.framework.toolbox.StringText;
import fable.framework.toolbox.ToolBox;
import fable.framework.views.FableMessageConsole;
import fable.imageviewer.views.ImageView;
import fable.preprocessor.Activator;
import fable.preprocessor.console.PreprocessorConsole;
import fable.preprocessor.process.IPreprocessorListener;
import fable.preprocessor.process.Preprocessor;
import fable.preprocessor.process.PreprocessorEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Pattern;
import jep.JepException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ProcessingView
extends ViewPart
implements IPropertyChangeListener,
Preferences.IPropertyChangeListener {
    public static final String ID = "fable.preprocessor.views.processing";
    public static ProcessingView view;
    private String[] files;
    private String fileDescription;
    private String[] selectedSamples;
    private String[] currentSelectedFiles;
    private String[] list;
    private String experimentName = "NA";
    private String sampleName = "NA";
    private String sSampleDirectory;
    private String currentExtension = ".cor";
    private Vector<String> titles = new Vector();
    Vector<String> listFiles = null;
    String regularExpressionForExtension;
    private int numberFiles;
    private int columnIndexSelected = -1;
    private Color descriptionColor;
    private int currentIndexSample = 0;
    public Preprocessor spdProcessor = Preprocessor.getDefault();
    boolean bAdded = false;
    private ImageDescriptor GifDelete = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/delete.gif");
    private ImageDescriptor GifRemove = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/subtract.gif");
    private ImageDescriptor GifAdd = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/add.gif");
    private ImageDescriptor gifViewimage = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/ImageView.gif");
    private ImageDescriptor gifbrowncross = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/brownCross.gif");
    private ImageDescriptor gifUpdate = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/refresh.gif");
    private final Image imgDelete;
    private final Image imgadd;
    private final Image imgRemove;
    private final Image imgUpdate;
    private Image imgMenuRemove;
    private Image imgMenuView;
    private final Color light_blue = new Color((Device)Display.getCurrent(), 228, 247, 248);
    private final Color light_Red = new Color((Device)Display.getCurrent(), 249, 172, 168);
    private final Color light_Green = new Color((Device)Display.getCurrent(), 168, 249, 200);
    private Button btnRemoveSelect;
    private Button btnRemoveDirectory;
    private Button addKeyInTab;
    private Button removeKeyInTable;
    private TableColumn columnSelected;
    private StringText stextSampleDirectory;
    private PreprocessorConsole console;
    private ArrayList<IPropertyChangeListener> array = new ArrayList();
    private IPropertyChangeListener preferencesListener;
    private Listener sortListener;
    private SampleListener sampleListener;
    private Sample sample;
    Sample singleSample = null;
    private Vector<Sample> listOfSamples;
    private Job job;
    private Table table;
    private TableViewer directoryTable;
    private SashForm sash;
    private List listKeys;
    private Button chkProcessPrevious;
    private FabioFile f_fabio;
    private Button selectFilesButton;
    private Shell shell;
    private Display display;
    private Vector<FabioFile> sort;
    IStatus job_status;
    private PreprocessListener preprocessorListener;

    public ProcessingView() {
        this.imgDelete = this.GifDelete.createImage();
        this.imgadd = this.GifAdd.createImage();
        this.imgRemove = this.GifRemove.createImage();
        this.imgUpdate = this.gifUpdate.createImage();
        this.listOfSamples = new Vector();
        this.sampleListener = new SampleListener();
        this.preprocessorListener = new PreprocessListener();
        this.spdProcessor.addPreprocessorListener(this.preprocessorListener);
        this.spdProcessor.addPropertyChangeListener(this);
        this.console = PreprocessorConsole.thisConsole;
        this.preferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("pref_sampleNavigator_type")) {
                    System.out.println("Property change event from navigator preferences");
                    ProcessingView.this.regularExpressionForExtension = fable.framework.navigator.Activator.getDefault().getPreferenceStore().getString("pref_sampleNavigator_type");
                    ProcessingView.this.selectFilesButton.setToolTipText("Files loaded with extension (See Preferences/Fabio files) : " + ProcessingView.this.regularExpressionForExtension);
                }
            }
        };
        fable.framework.navigator.Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferencesListener);
        this.regularExpressionForExtension = fable.framework.navigator.Activator.getDefault().getPreferenceStore().getString("pref_sampleNavigator_type");
        this.sortListener = new Listener(){

            public void handleEvent(Event e) {
                TableColumn sortColumn = ProcessingView.this.table.getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = ProcessingView.this.table.getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    ProcessingView.this.table.setSortColumn(currentColumn);
                    dir = 1024;
                }
                TableColumn[] cols = ProcessingView.this.table.getColumns();
                ProcessingView.this.table.getItems();
                final TableColumn column = (TableColumn)e.widget;
                ProcessingView.this.columnSelected = (TableColumn)e.widget;
                boolean columnIndexFound = false;
                int n = 0;
                while (!columnIndexFound && cols != null && n < cols.length) {
                    if (ProcessingView.this.columnSelected == cols[n]) {
                        ProcessingView.this.columnIndexSelected = n;
                        columnIndexFound = true;
                    }
                    ++n;
                }
                ProcessingView.this.sample.setComparator((String)ProcessingView.this.columnSelected.getData("key"), dir);
                if (ProcessingView.this.columnIndexSelected > 1) {
                    ProcessingView.this.removeKeyInTable.setEnabled(true);
                } else {
                    ProcessingView.this.removeKeyInTable.setEnabled(false);
                }
                final int dirForThread = dir;
                new Thread(new Runnable(){

                    public void run() {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                ProcessingView.this.sort = ProcessingView.this.sample.getSortedFiles();
                                ProcessingView.this.setSelectedFiles();
                                ProcessingView.this.table.setSortDirection(dirForThread);
                                ProcessingView.this.table.setSortColumn(column);
                                int n = 0;
                                while (n < ProcessingView.this.table.getItemCount()) {
                                    ProcessingView.this.table.getItem(n).setBackground(n % 2 == 0 ? Display.getCurrent().getSystemColor(1) : ProcessingView.this.light_blue);
                                    ++n;
                                }
                            }
                        });
                    }
                }).run();
            }
        };
    }

    public void createPartControl(Composite parent) {
        this.shell = parent.getShell();
        this.display = Display.getCurrent();
        view = this;
        view.setContentDescription("Select files to process here");
        this.titles.add(0, "#");
        this.titles.add(1, "name");
        GridLayout gdL = new GridLayout(1, true);
        parent.setLayout((Layout)gdL);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("pref_ext_COR")) {
                    ProcessingView.this.currentExtension = "." + Activator.getDefault().getPreferenceStore().getString("pref_ext_COR");
                }
            }
        });
        String ext = "." + Activator.getDefault().getPreferenceStore().getString("pref_ext_COR");
        String string = this.currentExtension = ext.trim().equals("\\.") ? ".cor" : this.currentExtension;
        if (Activator.getDefault().getPreferenceStore().getBoolean("pref_zip")) {
            this.currentExtension = String.valueOf(this.currentExtension) + ".gz";
        }
        this.chkProcessPrevious = new Button(parent, 32);
        this.chkProcessPrevious.setSelection(true);
        this.spdProcessor.processAll = this.chkProcessPrevious.getSelection();
        this.chkProcessPrevious.setText("Process files previously scanned");
        this.chkProcessPrevious.setToolTipText("Online mode only: if checked, process current sample files scanned before launching preprocessessor.");
        this.chkProcessPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessingView.this.spdProcessor.processAll = ((Button)e.widget).getSelection();
            }
        });
        this.createInfoExperiment(parent);
        this.createTabListe(parent);
        this.enableGroupExperiment(!this.spdProcessor.isOnLine());
    }

    private void createInfoExperiment(Composite parent) {
        Group experimentInfo = LookAndFeel.getGroup((Composite)parent, (String)"Image browser", (int)4, (int)1);
        GridData gd3 = new GridData(4, 16, true, false);
        gd3.horizontalSpan = 3;
        this.stextSampleDirectory = new StringText((Composite)experimentInfo, 4, "Directory");
        this.stextSampleDirectory.set_isRequiredField(true);
        this.stextSampleDirectory.setLayoutData((Object)gd3);
        this.selectFilesButton = new Button((Composite)experimentInfo, 28);
        this.selectFilesButton.setText("Select files...");
        this.selectFilesButton.setEnabled(true);
        this.selectFilesButton.setToolTipText("Files loaded with extension (See Preferences/Fabio files) : " + this.regularExpressionForExtension);
        this.selectFilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Activator.log("ProcessingView :click on selectFilesButton");
                DirectoryDialog dialog = new DirectoryDialog(ProcessingView.this.shell);
                dialog.setFilterPath(ProcessingView.this.stextSampleDirectory.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    ProcessingView.this.addDirectory(selectedDirectory);
                }
            }
        });
    }

    public void addDirectory(final String Directory) {
        this.setExperimentAndSampleName(Directory);
        this.job = new Job("Loading directory " + this.sampleName){

            protected IStatus run(final IProgressMonitor monitor) {
                if (ProcessingView.this.listOfSamples == null) {
                    ProcessingView.this.listOfSamples = new Vector();
                }
                final String[] filesInDir = ProcessingView.this.loadSample(Directory);
                monitor.beginTask(ProcessingView.this.sampleName, filesInDir.length);
                ProcessingView.this.job_status = Status.OK_STATUS;
                final Sample spl = new Sample(ProcessingView.this.experimentName, ProcessingView.this.sampleName, Directory);
                ProcessingView.this.listOfSamples.add(spl);
                if (ProcessingView.this.sort == null) {
                    ProcessingView.this.sort = new Vector();
                }
                ProcessingView.this.sort = spl.getFabioFiles();
                if (monitor.isCanceled()) {
                    ProcessingView.this.listOfSamples.remove(spl);
                    return Status.CANCEL_STATUS;
                }
                int i = 0;
                while (ProcessingView.this.job_status == Status.OK_STATUS && i < filesInDir.length) {
                    final int j = i;
                    ProcessingView.this.display.syncExec(new Runnable(){

                        public void run() {
                            try {
                                (this).ProcessingView.this.bAdded = ((Sample)ProcessingView.this.listOfSamples.lastElement()).addFabioFile(filesInDir[j]);
                                if (monitor.isCanceled()) {
                                    ProcessingView.this.listOfSamples.remove(spl);
                                    (this).ProcessingView.this.job_status = Status.CANCEL_STATUS;
                                }
                            }
                            catch (FabioFileException e) {
                                ProcessingView.this.console.displayIn(e.getMessage());
                            }
                        }
                    });
                    if (ProcessingView.this.bAdded && ProcessingView.this.job_status == Status.OK_STATUS) {
                        int percentage = (j + 1) * 100 / filesInDir.length;
                        monitor.subTask(String.valueOf(percentage) + "% done:" + filesInDir[j] + " added");
                    } else if (ProcessingView.this.job_status == Status.CANCEL_STATUS) {
                        return ProcessingView.this.job_status;
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        ProcessingView.this.listOfSamples.remove(spl);
                        return Status.CANCEL_STATUS;
                    }
                    ++i;
                }
                if (monitor.isCanceled()) {
                    ProcessingView.this.listOfSamples.remove(spl);
                    return Status.CANCEL_STATUS;
                }
                ((Sample)ProcessingView.this.listOfSamples.lastElement()).set_CurrentFilesFromFabio();
                monitor.done();
                monitor.beginTask("Files are stored. Show them in table now", filesInDir.length);
                ProcessingView.this.display.asyncExec(new Runnable(){

                    public void run() {
                        ProcessingView.this.populateTreeSample();
                    }
                });
                if (monitor.isCanceled()) {
                    ProcessingView.this.listOfSamples.remove(spl);
                    return Status.CANCEL_STATUS;
                }
                ProcessingView.this.display.asyncExec(new Runnable(){

                    public void run() {
                        ProcessingView.this.currentIndexSample = ProcessingView.this.listOfSamples.size() - 1;
                        ProcessingView.this.setCurrentSample(ProcessingView.this.currentIndexSample);
                    }
                });
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        this.job.setUser(true);
        this.job.schedule();
        this.job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    ProcessingView.this.console.displayOut("Job completed successfully");
                } else {
                    ProcessingView.this.console.displayIn("Job did not complete successfully");
                }
            }
        });
    }

    private void setCurrentSample(int i) {
        if (this.listOfSamples != null && this.listOfSamples.size() > 0) {
            this.sample = this.listOfSamples.elementAt(i);
            this.stextSampleDirectory.set_Text(this.sample.get_directoryPath());
            if (this.directoryTable.getTable().getItemCount() > 0) {
                this.directoryTable.getTable().setSelection(this.directoryTable.getTable().getItem(i));
                this.directoryTable.getTable().notifyListeners(13, new Event());
                if (this.sample.HasFile()) {
                    this.sample.setCurrentFile((FabioFile)this.sample.getFabioFiles().elementAt(0));
                    this.f_fabio = this.sample.getCurrentFabioFile();
                }
            }
        } else {
            this.clearAll();
        }
    }

    private void createTabListe(Composite parent) {
        int explorerHorizontalSpan = 4;
        Group grpListe = LookAndFeel.getGroup((Composite)parent, (String)"Files", (int)explorerHorizontalSpan, (int)1);
        GridData gd2 = new GridData(4, 4, true, true);
        grpListe.setLayoutData((Object)gd2);
        Composite container = new Composite((Composite)grpListe, 0);
        container.setLayout((Layout)new GridLayout(explorerHorizontalSpan, false));
        container.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ((GridData)container.getLayoutData()).horizontalSpan = explorerHorizontalSpan;
        Label lblKey = new Label(container, 0);
        lblKey.setText("Header Key");
        this.listKeys = new List(container, 2560);
        GridData gdlist = new GridData(4, 2, true, false);
        gdlist.verticalSpan = 1;
        gdlist.horizontalSpan = 1;
        int listHeigth = this.listKeys.getItemHeight() * explorerHorizontalSpan;
        Rectangle trim = this.listKeys.computeTrim(0, 0, 0, listHeigth);
        gdlist.heightHint = trim.height;
        this.listKeys.setLayoutData((Object)gdlist);
        this.listKeys.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ProcessingView.this.addColumn();
            }
        });
        this.listKeys.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    ProcessingView.this.addColumn();
                }
            }
        });
        this.addKeyInTab = new Button(container, 8);
        this.addKeyInTab.setImage(this.imgadd);
        this.addKeyInTab.setToolTipText("Add selected key in table");
        this.addKeyInTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessingView.this.addColumn();
            }
        });
        this.addKeyInTab.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ProcessingView.this.imgadd != null) {
                    ProcessingView.this.imgadd.dispose();
                }
            }
        });
        this.removeKeyInTable = new Button(container, 8);
        this.removeKeyInTable.setImage(this.imgRemove);
        this.removeKeyInTable.setToolTipText("Remove selected column");
        this.removeKeyInTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessingView.this.removeColumn();
            }
        });
        this.removeKeyInTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ProcessingView.this.imgRemove != null) {
                    ProcessingView.this.imgRemove.dispose();
                }
            }
        });
        this.removeKeyInTable.setEnabled(false);
        this.sash = new SashForm((Composite)grpListe, 256);
        GridData gdExplorer = new GridData(4, 4, true, true);
        gdExplorer.horizontalAlignment = 4;
        gdExplorer.verticalAlignment = 4;
        gdExplorer.horizontalSpan = explorerHorizontalSpan;
        this.sash.setLayoutData((Object)gdExplorer);
        GridData gdTree = new GridData(4, 4, true, true);
        gdTree.horizontalSpan = 1;
        this.directoryTable = new TableViewer((Composite)this.sash, 2048);
        this.directoryTable.setContentProvider((IContentProvider)new SampleTableContentProvider());
        this.directoryTable.setLabelProvider((IBaseLabelProvider)new SampleTablelabelProvider());
        this.directoryTable.getTable().setHeaderVisible(true);
        this.directoryTable.getTable().setLinesVisible(true);
        this.directoryTable.getTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 3) {
                    Menu menu = new Menu((Decorations)Display.getCurrent().getActiveShell(), 8);
                    MenuItem mitemRemove = new MenuItem(menu, 8);
                    ProcessingView.this.imgMenuRemove = ProcessingView.this.GifDelete.createImage();
                    mitemRemove.setImage(ProcessingView.this.imgMenuRemove);
                    mitemRemove.setText("Remove from list");
                    mitemRemove.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            ProcessingView.this.btnRemoveDirectory.notifyListeners(13, new Event());
                        }
                    });
                    menu.setVisible(true);
                    while (!menu.isDisposed() && menu.isVisible()) {
                        if (Display.getCurrent().readAndDispatch()) continue;
                        Display.getCurrent().sleep();
                    }
                    menu.dispose();
                    mitemRemove.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            if (ProcessingView.this.imgMenuRemove != null) {
                                ProcessingView.this.imgMenuRemove.dispose();
                            }
                        }
                    });
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.directoryTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] ti = ((Table)e.widget).getSelection();
                if (ti != null && ti.length > 0) {
                    ProcessingView.this.sample = (Sample)ti[0].getData();
                    ProcessingView.this.stextSampleDirectory.set_Text(ProcessingView.this.sample.get_directoryPath());
                    if (ProcessingView.this.sample.HasFile()) {
                        ProcessingView.this.currentSelectedFiles = ProcessingView.this.sample.get_files();
                        ProcessingView.this.sort = ProcessingView.this.sample.getFabioFiles();
                        ProcessingView.this.setSelectedFiles();
                        if (ProcessingView.this.sample.HasFile()) {
                            ProcessingView.this.sample.setCurrentFile((FabioFile)ProcessingView.this.sample.getFabioFiles().elementAt(0));
                            ProcessingView.this.f_fabio = ProcessingView.this.sample.getCurrentFabioFile();
                            ProcessingView.this.table.setSelection(1);
                        }
                    } else {
                        ProcessingView.this.currentSelectedFiles = null;
                        ProcessingView.this.populateFileTable("No files to process found in sample", null);
                    }
                    ProcessingView.this.populateCombo();
                    ProcessingView.this.spdProcessor.fireCurrentSampleHasChanged(ProcessingView.this.stextSampleDirectory.getText(), ProcessingView.this.sampleName);
                }
            }
        });
        this.table = new Table((Composite)this.sash, 268503042);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData gd4 = new GridData(4, 4, true, true);
        gd4.horizontalSpan = 3;
        gd4.verticalIndent = 10;
        this.table.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                int index = event.index;
                int i = index - 1;
                try {
                    FabioFile fabio = (FabioFile)ProcessingView.this.sort.elementAt(i);
                    item.setData((Object)fabio);
                    item.setText(0, "" + i);
                    item.setText(1, fabio.getFileName());
                    int j = 2;
                    while (j < ProcessingView.this.titles.size()) {
                        try {
                            item.setText(j, fabio.getValue((String)ProcessingView.this.titles.elementAt(j)));
                        }
                        catch (FabioFileException e) {
                            item.setText(j, "NA");
                            ProcessingView.this.console.displayIn("Processing View : " + e.getMessage() + item.getText(1));
                            Activator.log("Error while populate table in ProcessingView", 4, (Exception)((Object)e));
                        }
                        ++j;
                    }
                    item.setBackground(i % 2 == 0 ? Display.getCurrent().getSystemColor(1) : ProcessingView.this.light_blue);
                    if (!fabio.getFlag()) {
                        item.setImage(0, ProcessingView.this.gifbrowncross.createImage());
                    }
                }
                catch (IndexOutOfBoundsException ie) {
                    Activator.log("An error occured in processing view while trying to populate file table", 4, ie);
                    ProcessingView.this.console.displayIn("Processing View : " + ie.getMessage());
                }
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 3 && ProcessingView.this.table.getSelectionIndex() > 0) {
                    Menu menu = new Menu((Decorations)Display.getCurrent().getActiveShell(), 8);
                    MenuItem mitemRemove = new MenuItem(menu, 0);
                    new MenuItem(menu, 2);
                    Menu menu_viewer = new Menu(menu);
                    MenuItem mitem_ViewImage = new MenuItem(menu, 64);
                    mitem_ViewImage.setText("Open image...");
                    ImageData imageData = ProcessingView.this.gifViewimage.createImage().getImageData();
                    ProcessingView.this.imgMenuView = new Image((Device)ProcessingView.this.shell.getDisplay(), imageData.scaledTo(imageData.width / 7, imageData.height / 7));
                    mitem_ViewImage.setImage(ProcessingView.this.imgMenuView);
                    mitem_ViewImage.setMenu(menu_viewer);
                    mitem_ViewImage.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            if (ProcessingView.this.imgMenuView != null) {
                                ProcessingView.this.imgMenuView.dispose();
                            }
                        }
                    });
                    MenuItem mitemView = new MenuItem(menu_viewer, 0);
                    mitemView.setText("View image");
                    mitemRemove.setText("Remove from list");
                    ProcessingView.this.imgMenuRemove = ProcessingView.this.GifDelete.createImage();
                    mitemRemove.setImage(ProcessingView.this.imgMenuRemove);
                    mitemRemove.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            ProcessingView.this.btnRemoveSelect.notifyListeners(13, new Event());
                        }
                    });
                    mitemView.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            if (ProcessingView.this.f_fabio == null) {
                                ProcessingView.this.f_fabio = (FabioFile)ProcessingView.this.table.getItem(ProcessingView.this.table.getSelectionIndex()).getData();
                            }
                            try {
                                ImageView imageView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "0", 1);
                                if (imageView != null) {
                                    imageView.loadFile(ProcessingView.this.f_fabio);
                                    imageView.displayImage();
                                }
                            }
                            catch (PartInitException e) {
                                ProcessingView.this.console.displayIn("View can not be opened ");
                                Activator.log("Error opening Sample view  from preprocessor.", 4, (Exception)((Object)e));
                            }
                        }
                    });
                    MenuItem mitemViewCor = new MenuItem(menu_viewer, 0);
                    mitemViewCor.setText("View its current corrected image:" + ProcessingView.this.currentExtension);
                    mitemViewCor.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            if (ProcessingView.this.f_fabio == null) {
                                TableItem it = ProcessingView.this.table.getItem(ProcessingView.this.table.getSelectionIndex());
                                it.getText(1);
                                String fileName = it.getText(1);
                                int index = fileName.lastIndexOf(46);
                                if (index > 0) {
                                    String stem = String.valueOf(ProcessingView.this.sample.get_directoryPath()) + System.getProperty("file.separator") + fileName.substring(0, index);
                                    try {
                                        ProcessingView.this.f_fabio = new FabioFile(String.valueOf(stem) + ProcessingView.this.currentExtension);
                                        try {
                                            ImageView imageView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "1", 1);
                                            if (imageView != null) {
                                                imageView.loadFile(ProcessingView.this.f_fabio);
                                                imageView.displayImage();
                                            }
                                        }
                                        catch (PartInitException e) {
                                            ProcessingView.this.console.displayIn("View can not be opened ");
                                            Activator.log("Error opening Sample view  from preprocessor.", 4, (Exception)((Object)e));
                                        }
                                    }
                                    catch (FabioFileException fabioFileException) {
                                        ProcessingView.this.console.displayIn("File " + stem + ProcessingView.this.currentExtension + "  not found");
                                    }
                                }
                            }
                        }
                    });
                    menu.setVisible(true);
                    while (!menu.isDisposed() && menu.isVisible()) {
                        if (Display.getCurrent().readAndDispatch()) continue;
                        Display.getCurrent().sleep();
                    }
                    menu.dispose();
                    menu_viewer.dispose();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] item = ProcessingView.this.table.getSelection();
                if (item != null && item.length > 0) {
                    ProcessingView.this.f_fabio = (FabioFile)item[0].getData();
                    ProcessingView.this.populateCombo();
                }
            }
        });
        this.initColumn();
        this.descriptionColor = this.display.getSystemColor(1);
        this.btnRemoveDirectory = new Button((Composite)grpListe, 8);
        GridData gdBtn_s = new GridData(1, 0, true, false);
        gdBtn_s.horizontalSpan = 1;
        this.btnRemoveDirectory.setLayoutData((Object)gdBtn_s);
        this.btnRemoveDirectory.setImage(this.imgDelete);
        this.btnRemoveDirectory.setText("Remove directory");
        this.btnRemoveDirectory.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ProcessingView.this.imgDelete != null) {
                    ProcessingView.this.imgDelete.dispose();
                }
            }
        });
        Button btnUpdate = new Button((Composite)grpListe, 8);
        GridData gdBtn_update = new GridData(1, 0, true, false);
        gdBtn_update.horizontalSpan = 1;
        btnUpdate.setLayoutData((Object)gdBtn_s);
        btnUpdate.setImage(this.imgUpdate);
        btnUpdate.setText("Update directory");
        btnUpdate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessingView.this.updateDirectory();
                int n = ProcessingView.this.sort.size() + 1;
                ProcessingView.this.table.setItemCount(n);
            }
        });
        btnUpdate.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ProcessingView.this.imgUpdate != null && !ProcessingView.this.imgUpdate.isDisposed()) {
                    ProcessingView.this.imgUpdate.dispose();
                }
            }
        });
        this.btnRemoveDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessingView.this.removeSelectedSample(ProcessingView.this.sample);
                int i = ProcessingView.this.listOfSamples.size() > 0 ? ProcessingView.this.listOfSamples.size() - 1 : 0;
                ProcessingView.this.currentIndexSample = i;
                ProcessingView.this.setCurrentSample(i);
            }
        });
        this.btnRemoveSelect = new Button((Composite)grpListe, 8);
        GridData gdBtn = new GridData(0x1000008, 0, true, false);
        gdBtn.horizontalSpan = 1;
        this.btnRemoveSelect.setLayoutData((Object)gdBtn);
        this.btnRemoveSelect.setImage(this.imgDelete);
        this.btnRemoveSelect.setText("Remove files");
        this.btnRemoveSelect.setToolTipText("Remove selected files");
        this.btnRemoveSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessingView.this.removeSelectedFiles();
            }
        });
        this.btnRemoveSelect.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ProcessingView.this.imgDelete != null) {
                    ProcessingView.this.imgDelete.dispose();
                }
            }
        });
        this.sash.setWeights(new int[]{20, 50});
    }

    private void removeColumn() {
        if (this.columnSelected != null && this.columnIndexSelected > 1 && this.columnIndexSelected < this.table.getColumnCount()) {
            this.columnSelected.dispose();
            this.titles.removeElementAt(this.columnIndexSelected);
            int i = 0;
            while (i < this.titles.size()) {
                this.table.getColumn(i).pack();
                ++i;
            }
        }
    }

    private void removeAllColumnsAdded() {
        int j = 2;
        while (this.table.getColumnCount() > 2) {
            this.table.getColumn(j).dispose();
            this.titles.removeElementAt(j);
        }
        int i = 0;
        while (i < this.titles.size()) {
            this.table.getColumn(i).pack();
            ++i;
        }
    }

    private void addColumn() {
        int index = this.listKeys.getSelectionIndex();
        if (index == -1) {
            index = 0;
        }
        String newHeader = this.listKeys.getItem(index);
        this.titles.add(newHeader);
        TableColumn column = new TableColumn(this.table, this.table.getStyle());
        column.setText(this.titles.lastElement());
        column.addListener(13, this.sortListener);
        column.setData("key", (Object)this.titles.lastElement());
        column.setData("index", (Object)(this.titles.size() - 1));
        Job job_addColumn = new Job("Wait while getting " + newHeader + " stored in file header"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("get " + (String)ProcessingView.this.titles.lastElement(), ProcessingView.this.sample.get_files().length);
                if (monitor.isCanceled()) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                ProcessingView.this.display.syncExec(new Runnable(){

                    public void run() {
                        ProcessingView.this.titles.size();
                        if (ProcessingView.this.table.getItemCount() > ProcessingView.this.titles.size()) {
                            ProcessingView.this.table.getItem(ProcessingView.this.titles.size());
                        } else {
                            new TableItem(ProcessingView.this.table, 0);
                        }
                        ProcessingView.this.setSelectedFiles();
                    }
                });
                ProcessingView.this.display.syncExec(new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < ProcessingView.this.titles.size()) {
                            ProcessingView.this.table.getColumn(i).pack();
                            ++i;
                        }
                    }
                });
                monitor.worked(100);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job_addColumn.setUser(true);
        job_addColumn.schedule();
    }

    private void initColumn() {
        int i = 0;
        while (i < this.titles.size()) {
            int style = 0;
            TableColumn column = new TableColumn(this.table, style);
            column.setText(this.titles.elementAt(i));
            column.addListener(13, this.sortListener);
            column.setData("key", (Object)this.titles.elementAt(i));
            column.setData("index", (Object)i);
            ++i;
        }
        new TableItem(this.table, 0);
        this.clearFiles();
        i = 0;
        while (i < this.titles.size()) {
            this.table.getColumn(i).pack();
            ++i;
        }
        this.table.setSortColumn(this.table.getColumn(1));
        this.table.setSortDirection(1024);
    }

    private void populateCombo() {
        if (this.sample != null && this.sample.HasFile()) {
            this.listKeys.setEnabled(true);
            this.addKeyInTab.setEnabled(true);
            this.display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        if (ProcessingView.this.f_fabio != null) {
                            ProcessingView.this.list = ProcessingView.this.f_fabio.getKeys();
                            ToolBox.quicksort((String[])ProcessingView.this.list, (int)0, (int)ProcessingView.this.list.length);
                            ProcessingView.this.listKeys.removeAll();
                            ProcessingView.this.listKeys.setData("HEADER_KEYS", (Object)ProcessingView.this.list);
                            int i = 0;
                            while (i < ProcessingView.this.list.length) {
                                ProcessingView.this.listKeys.add(ProcessingView.this.list[i]);
                                ++i;
                            }
                            ProcessingView.this.listKeys.select(0);
                        }
                    }
                    catch (FabioFileException e2) {
                        ProcessingView.this.console.displayIn(e2.getMessage());
                    }
                    catch (JepException e) {
                        ProcessingView.this.console.displayIn(e.getMessage());
                    }
                }
            });
        } else {
            this.listKeys.removeAll();
            this.listKeys.setEnabled(false);
            this.addKeyInTab.setEnabled(false);
        }
    }

    public static ProcessingView getDefault() {
        return view;
    }

    public void setFocus() {
    }

    private void populateTreeSample() {
        this.directoryTable.setInput((Object)new Experiment(this.listOfSamples));
        this.updatePreprocessor();
    }

    private void setSelectedFiles() {
        this.descriptionColor = this.light_Green;
        if (this.sample.HasFile()) {
            this.populateFileTable("files to process", null);
        }
    }

    public void setProcessingFiles(String[] newFiles) {
        this.descriptionColor = this.light_Red;
        if (newFiles != null) {
            this.updateDirectory();
            int n = this.sort.size() + 1;
            this.table.setItemCount(n);
            this.populateFileTable("files being processed", newFiles);
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.array.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.array.remove(listener);
    }

    private void updatePreprocessor() {
        Preprocessor preprocessor = Preprocessor.getDefault();
        preprocessor.set_Samples(this.listOfSamples);
        this.spdProcessor.fireExperimentInfoChange(this.selectedSamples, this.experimentName);
    }

    private void populateFileTable(final String description, final String[] newFiles) {
        if (!this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    ProcessingView.this.table.clearAll();
                    ProcessingView.this.fileDescription = description;
                    ProcessingView.this.files = newFiles;
                    if (ProcessingView.this.sample.HasFile()) {
                        ProcessingView.this.table.setItemCount(ProcessingView.this.sample.getFabioFiles().size() + 1);
                    } else {
                        ProcessingView.this.table.setItemCount(1);
                    }
                    TableItem item = ProcessingView.this.table.getItemCount() > 0 ? ProcessingView.this.table.getItem(0) : new TableItem(ProcessingView.this.table, 0);
                    item.setText(0, String.valueOf(ProcessingView.this.sample.getFabioFiles().size()));
                    item.setText(1, ProcessingView.this.fileDescription);
                    item.setBackground(ProcessingView.this.descriptionColor);
                    int i = 0;
                    while (i < ProcessingView.this.table.getColumnCount()) {
                        ProcessingView.this.table.getColumn(i).pack();
                        ++i;
                    }
                }
            });
        }
    }

    public void setDescription(int number, String description, final int backgroundColor) {
        if (backgroundColor == 3) {
            this.descriptionColor = this.light_Red;
        } else if (backgroundColor == 5) {
            this.descriptionColor = this.light_Green;
        } else {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ProcessingView.this.descriptionColor = ProcessingView.this.display.getSystemColor(backgroundColor);
                }
            });
        }
        this.setDescription(number, description);
    }

    public void setDescription(int number, String description) {
        this.numberFiles = number;
        this.fileDescription = description;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                TableItem item = ProcessingView.this.table.getItemCount() > 0 ? ProcessingView.this.table.getItem(0) : new TableItem(ProcessingView.this.table, 0);
                item.setText(0, Integer.toString(ProcessingView.this.numberFiles));
                item.setText(1, ProcessingView.this.fileDescription);
                item.setBackground(ProcessingView.this.descriptionColor);
            }
        });
    }

    public void clearFiles() {
        this.fileDescription = "please select file(s) or start online mode";
        this.files = null;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ProcessingView.this.descriptionColor = Display.getCurrent().getSystemColor(1);
                ProcessingView.this.table.removeAll();
                TableItem item = ProcessingView.this.table.getItemCount() > 0 ? ProcessingView.this.table.getItem(0) : new TableItem(ProcessingView.this.table, 0);
                item.setText(0, "0");
                item.setText(1, ProcessingView.this.fileDescription);
            }
        });
    }

    private void resetExperimentInfos() {
        this.sample = null;
        this.stextSampleDirectory.set_Text("");
        this.resetCombo();
        this.removeAllColumnsAdded();
        this.updatePreprocessor();
    }

    private void resetCombo() {
        this.listKeys.removeAll();
    }

    private void removeSelectedSample(Sample s) {
        this.listOfSamples.remove(s);
        this.populateTreeSample();
    }

    private void removeSelectedFiles() {
        this.fileDescription = "selected files";
        this.files = null;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ProcessingView.this.descriptionColor = Display.getCurrent().getSystemColor(1);
                TableItem[] itemSelected = ProcessingView.this.table.getSelection();
                int sel = 0;
                while (sel < itemSelected.length) {
                    if ((FabioFile)itemSelected[sel].getData() != null) {
                        ProcessingView.this.sample.removeFabioFile((FabioFile)itemSelected[sel].getData());
                    }
                    ++sel;
                }
                ProcessingView.this.setSelectedFiles();
                if (ProcessingView.this.sample.getFabioFiles().size() == 0) {
                    ProcessingView.this.clearFiles();
                    ProcessingView.this.removeSelectedSample(ProcessingView.this.sample);
                    ProcessingView.this.resetExperimentInfos();
                }
                ProcessingView.this.table.deselectAll();
            }
        });
    }

    private void clearAll() {
        if (this.listOfSamples != null) {
            this.listOfSamples.removeAllElements();
        }
        this.currentSelectedFiles = null;
        this.directoryTable.getTable().removeAll();
        this.directoryTable.getTable().clearAll();
        this.table.removeAll();
        this.table.clearAll();
        this.resetExperimentInfos();
    }

    private void enableGroupExperiment(final boolean bEnable) {
        if (!this.display.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    if (bEnable) {
                        ProcessingView.this.stextSampleDirectory.setBackground(ProcessingView.this.display.getSystemColor(1));
                    } else {
                        ProcessingView.this.stextSampleDirectory.setBackground(ProcessingView.this.display.getSystemColor(22));
                    }
                    ProcessingView.this.stextSampleDirectory.setEnabled(bEnable);
                    ProcessingView.this.selectFilesButton.setEnabled(bEnable);
                    ProcessingView.this.btnRemoveSelect.setEnabled(bEnable);
                    ProcessingView.this.btnRemoveDirectory.setEnabled(bEnable);
                }
            });
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("SpdView_showRequired")) {
            this.stextSampleDirectory.showrequired();
        }
        if (event.getProperty().equals("SpdView_correctedExtension")) {
            this.currentExtension = (String)event.getNewValue();
        }
        if (event.getProperty().equals("SpdView_ShowFilesInError")) {
            this.setCurrentSample(this.currentIndexSample);
            this.directoryTable.setInput((Object)new Experiment(this.listOfSamples));
        }
    }

    public String[] loadSample(String dir) {
        if (dir != null && !dir.equals("")) {
            String[] split = dir.split("[\\\\/]");
            if (split.length > 1) {
                this.experimentName = split[split.length - 2];
                this.sampleName = split[split.length - 1];
            } else {
                this.sampleName = split[split.length - 1];
                this.experimentName = "NA";
            }
            this.files = this.getFiles(dir);
        }
        return this.files;
    }

    private void setExperimentAndSampleName(String dir) {
        File fileObj;
        if (dir != null && (fileObj = new File(dir)) != null && fileObj.isDirectory()) {
            this.sampleName = fileObj.getName();
            String parent = fileObj.getParent();
            if (parent != null) {
                this.experimentName = new File(parent).getName();
            }
        }
    }

    public void updateDirectory() {
        block3: {
            if (this.sample != null) {
                try {
                    String[] fabiofiles = this.getFiles(this.sample.get_directoryPath());
                    this.sample.updatefabioFiles(fabiofiles);
                    this.sort = this.sample.getFabioFiles();
                }
                catch (FabioFileException fabioFileException) {
                    if (FableMessageConsole.console == null) break block3;
                    FableMessageConsole.console.displayError("An error occured while updating the directory");
                }
            }
        }
    }

    private String[] getFiles(String dir) {
        String[] rFile = null;
        if (this.regularExpressionForExtension.toLowerCase().contains("bruker")) {
            Pattern p = Pattern.compile("\\.*bruker\\.*", 2);
            p.matcher(this.regularExpressionForExtension).matches();
            this.regularExpressionForExtension = p.matcher(this.regularExpressionForExtension).replaceAll("\\\\\\d+");
        }
        String expression = ".+\\.(" + this.regularExpressionForExtension + ")";
        rFile = ToolBox.getFilesByEntireRegex((String)dir, (String)expression, (boolean)true);
        ToolBox.quicksort((String[])rFile, (int)0, (int)rFile.length);
        String sep = System.getProperty("file.separator");
        int i = 0;
        while (i < rFile.length) {
            rFile[i] = String.valueOf(dir) + sep + rFile[i];
            ++i;
        }
        return rFile;
    }

    public void dispose() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferencesListener);
        if (this.light_blue != null && !this.light_blue.isDisposed()) {
            this.light_blue.dispose();
        }
        if (this.light_Red != null && !this.light_Red.isDisposed()) {
            this.light_Red.dispose();
        }
        if (this.light_Green != null && !this.light_Green.isDisposed()) {
            this.light_Green.dispose();
        }
        this.spdProcessor.removePreprocessorListener(this.preprocessorListener);
        this.spdProcessor.removePropertyChangeListener(this);
        super.dispose();
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
    }

    public static String getID() {
        return ID;
    }

    class PreprocessListener
    implements IPreprocessorListener {
        PreprocessListener() {
        }

        public void preprocessorChanged(PreprocessorEvent pe) {
            if (!ProcessingView.this.display.isDisposed()) {
                ProcessingView.this.display.syncExec(new Runnable(){

                    public void run() {
                        ProcessingView.this.listOfSamples = ((PreprocessListener)PreprocessListener.this).ProcessingView.this.spdProcessor.get_Samples();
                        if (!ProcessingView.this.stextSampleDirectory.getText().equals(((PreprocessListener)PreprocessListener.this).ProcessingView.this.spdProcessor.getCurrentSample().get_directoryPath())) {
                            ProcessingView.this.stextSampleDirectory.set_Text(((PreprocessListener)PreprocessListener.this).ProcessingView.this.spdProcessor.getCurrentSample().get_directoryPath());
                        }
                    }
                });
            }
        }

        public void preprocessorModeChange(PreprocessorEvent pe) {
            final Preprocessor p = (Preprocessor)pe.getSource();
            if (!ProcessingView.this.display.isDisposed()) {
                ProcessingView.this.display.syncExec(new Runnable(){

                    public void run() {
                        if (p.isOnLine()) {
                            ProcessingView.this.clearAll();
                        }
                        ProcessingView.this.chkProcessPrevious.setEnabled(p.isOnLine());
                        ProcessingView.this.enableGroupExperiment(!p.isOnLine());
                    }
                });
            }
        }

        public void preprocessorNewMessage(PreprocessorEvent pe) {
        }

        public void preprocessorStateChange(PreprocessorEvent pe) {
            final Preprocessor p = (Preprocessor)pe.getSource();
            if (!ProcessingView.this.display.isDisposed()) {
                ProcessingView.this.display.syncExec(new Runnable(){

                    public void run() {
                        if (p.isOnLine()) {
                            ProcessingView.this.clearAll();
                        }
                        ProcessingView.this.chkProcessPrevious.setEnabled(p.isOnLine() && !p.isM_bStatusProcessing());
                    }
                });
            }
        }

        public void preprocessorNewSample(PreprocessorEvent pe) {
            ProcessingView.this.sample = ProcessingView.this.spdProcessor.getCurrentSample();
            ProcessingView.this.sample.addSampleListener((ISampleListener)ProcessingView.this.sampleListener);
            ProcessingView.this.listOfSamples.removeAllElements();
            ProcessingView.this.listOfSamples.add(ProcessingView.this.sample);
            if (!ProcessingView.this.display.isDisposed()) {
                ProcessingView.this.display.syncExec(new Runnable(){

                    public void run() {
                        ProcessingView.this.populateTreeSample();
                        ProcessingView.this.stextSampleDirectory.set_Text(ProcessingView.this.sample.get_directoryPath());
                    }
                });
            }
        }
    }

    class SampleListener
    implements ISampleListener {
        SampleListener() {
        }

        public void newImages(SampleEvent se) {
            ProcessingView.this.setProcessingFiles(((Sample)se.getSource()).get_files());
        }

        public void newSample(SampleEvent se) {
        }

        public void sampleHasChanged(SampleEvent se) {
        }
    }
}

