/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.process;

import fable.framework.toolbox.FabioFile;
import fable.framework.toolbox.FabioFileException;
import fable.framework.toolbox.Sample;
import fable.framework.toolbox.ToolBox;
import fable.preprocessor.Activator;
import fable.preprocessor.process.IPreprocessorListener;
import fable.preprocessor.process.PreprocessorEvent;
import fable.preprocessor.toolBox.PreprocessorMessage;
import fable.preprocessor.views.ProcessingView;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preprocessor
implements Runnable {
    public static Preprocessor preprocessor;
    private String m_mode;
    private String darkStem;
    private String darkFile;
    private String floodFile;
    private String distFile;
    private int distortionAction;
    private boolean applyDarkCorrection;
    private boolean applyFloodCorrection;
    private boolean applyDistCorrection;
    private String spdCommand;
    private String extFlood;
    private String extDist;
    private String extCor;
    private String modeImage;
    private String modeText;
    private String otherOptions;
    private PreprocessorMessage logMessage;
    private boolean m_bStatusProcessing;
    private Vector<IPreprocessorListener> listListener = new Vector();
    private Sample sample;
    private ProcessThread _threadProcess = null;
    private String extTypeRegex;
    private boolean clearCommandOption;
    private String srcExt;
    private String corExt;
    private String inpConst;
    private String inpExp;
    private String inpFactor;
    private String saveDark;
    private String dark_const;
    private String darkExt;
    public String spdMode;
    public static int numberImages;
    private String spdServer = null;
    private DeviceProxy spdProxy = null;
    private Vector<Sample> v_Samples = new Vector();
    public boolean processAll = false;
    private boolean bSizeIsOk = true;
    private String reffileDim1 = "";
    private String reffileDim2 = "";
    private boolean zip;
    private String zipCmd;
    private String typeoutfile;
    private String dvo;
    private ArrayList<IPropertyChangeListener> viewsListeners = new ArrayList();

    private Preprocessor() {
        this.logMessage = new PreprocessorMessage();
    }

    public boolean isOnLine() {
        boolean bOnLine = false;
        if (this.getM_mode() != null) {
            bOnLine = this.getM_mode().equals("ON");
        }
        return bOnLine;
    }

    public boolean isOffLine() {
        boolean bOffLine = false;
        if (this.getM_mode() != null) {
            bOffLine = this.getM_mode().equals("OFF");
        }
        return bOffLine;
    }

    public void removeAllNewTypeOfFiles() {
        this.extTypeRegex = "";
    }

    public void addNewTypeOfFiles(String type) {
        if (this.extTypeRegex == null) {
            this.extTypeRegex = "";
        }
        this.extTypeRegex = String.valueOf(this.extTypeRegex) + "(" + type + ")?";
    }

    public void RemoveAllNewTypeOfFiles(String type) {
        this.extTypeRegex = "";
    }

    public static Preprocessor getDefault() {
        if (preprocessor == null) {
            preprocessor = new Preprocessor();
        }
        return preprocessor;
    }

    public void addPreprocessorListener(IPreprocessorListener pl) {
        this.listListener.add(pl);
    }

    public void removePreprocessorListener(IPreprocessorListener pl) {
        this.listListener.remove(pl);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.viewsListeners.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.viewsListeners.remove(listener);
    }

    public void fireExperimentInfoChange(String[] selectedSamples, String experimentName) {
        for (IPropertyChangeListener element : this.viewsListeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_selectedFiles", null, (Object)selectedSamples));
            element.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_experiment", null, (Object)experimentName));
        }
    }

    public void fireCurrentSampleHasChanged(String stextSampleDirectory, String sampleName) {
        for (IPropertyChangeListener element : this.viewsListeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_directory", null, (Object)stextSampleDirectory));
            element.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_sample", null, (Object)sampleName));
        }
    }

    public void fireShowRequiredFields() {
        for (IPropertyChangeListener element : this.viewsListeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "SpdView_showRequired", null, (Object)true));
        }
    }

    public void fireCurrentCorrectedExtensionHasChanged(String val) {
        for (IPropertyChangeListener element : this.viewsListeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "SpdView_correctedExtension", null, (Object)val));
        }
    }

    public void fireShowFlag() {
        for (IPropertyChangeListener element : this.viewsListeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "SpdView_ShowFilesInError", null, null));
        }
    }

    private void firePreprocessorChange() {
        PreprocessorEvent pe = new PreprocessorEvent(this);
        Enumeration<IPreprocessorListener> e = this.listListener.elements();
        while (e.hasMoreElements()) {
            e.nextElement().preprocessorChanged(pe);
        }
    }

    private void firePreprocessorModeChange() {
        PreprocessorEvent pe = new PreprocessorEvent(this);
        Enumeration<IPreprocessorListener> e = this.listListener.elements();
        while (e.hasMoreElements()) {
            e.nextElement().preprocessorModeChange(pe);
        }
    }

    private void firePreprocessorStateChange() {
        PreprocessorEvent pe = new PreprocessorEvent(this);
        Enumeration<IPreprocessorListener> e = this.listListener.elements();
        while (e.hasMoreElements()) {
            e.nextElement().preprocessorStateChange(pe);
        }
    }

    private void firePreprocessorNewMessage() {
        PreprocessorEvent pe = new PreprocessorEvent(this);
        Enumeration<IPreprocessorListener> e = this.listListener.elements();
        while (e.hasMoreElements()) {
            e.nextElement().preprocessorNewMessage(pe);
        }
    }

    public void fireSampleHasChanged() {
        PreprocessorEvent pe = new PreprocessorEvent(this);
        Enumeration<IPreprocessorListener> e = this.listListener.elements();
        while (e.hasMoreElements()) {
            e.nextElement().preprocessorNewSample(pe);
        }
        if (this.isOnLine() && this.isM_bStatusProcessing()) {
            this.run();
        }
    }

    @Override
    public void run() {
        Vector<Sample> samples = this.get_Samples();
        if (samples != null && this._threadProcess != null && this._threadProcess.process != null) {
            try {
                if (this._threadProcess.process.waitFor() == 0) {
                    this.stop();
                }
            }
            catch (InterruptedException e) {
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An error occured " + this._threadProcess.threadSampleName + " :" + e.getMessage(), 0));
            }
        }
        numberImages = 0;
        int i = 0;
        while (i < samples.size()) {
            this._threadProcess = new ProcessThread(samples.elementAt(i), this.isM_applyDarkCorrection(), this.isM_applyFloodCorrection(), this.isM_applyDistCorrection(), this.getM_mode(), this.get_src_ext());
            Activator.log("New thread for new sample : " + samples.elementAt(i).toString());
            if (this.isM_bStatusProcessing()) {
                this._threadProcess.start();
            }
            ++i;
        }
    }

    public void stop() {
        if (this._threadProcess != null) {
            this._threadProcess.notifyEnd();
        }
    }

    public String getCommand() {
        String osName = System.getProperty("os.name").toLowerCase();
        String addInFrontOfCommand = "";
        String avoidErrorWithSpaces = "";
        if (osName.contains("windows")) {
            addInFrontOfCommand = "cmd /C ";
        }
        String myString = String.valueOf(addInFrontOfCommand) + avoidErrorWithSpaces + this.get_Command() + avoidErrorWithSpaces + " ";
        if (!this.get_cor_ext().equals("")) {
            myString = String.valueOf(myString) + " cor_ext=" + this.get_cor_ext();
        }
        if (!this.get_src_ext().equals("")) {
            myString = String.valueOf(myString) + " src_ext=" + this.get_src_ext();
        }
        if (this.isM_applyDarkCorrection()) {
            if (!this.darkFile.equals("")) {
                myString = String.valueOf(myString) + " dark_file=" + this.darkFile;
            }
            if (this.get_dark_const() != null && !this.get_dark_const().equals("")) {
                myString = String.valueOf(myString) + " dark_const=" + this.get_dark_const();
            }
            if (this.get_dark_ext() != null && !this.get_dark_ext().equals("")) {
                myString = String.valueOf(myString) + " dark_ext=" + this.get_dark_ext();
            }
            if (this.get_inp_const() != null && !this.get_inp_const().equals("")) {
                myString = String.valueOf(myString) + " inp_const=" + this.get_inp_const();
            }
            if (this.get_inp_factor() != null && !this.get_inp_factor().equals("")) {
                myString = String.valueOf(myString) + " inp_factor=" + this.get_inp_factor();
            }
            if (this.get_inp_exp() != null && !this.get_inp_exp().equals("")) {
                myString = String.valueOf(myString) + " inp_exp=" + this.get_inp_exp();
            }
            if (this.get_save_dark() != null && !this.get_inp_const().equals("")) {
                myString = String.valueOf(myString) + " save_dark=" + this.get_save_dark();
            }
        }
        if (this.isM_applyFloodCorrection() && !this.floodFile.equals("")) {
            myString = String.valueOf(myString) + " flood_file=" + this.floodFile;
        }
        if (this.isM_applyDistCorrection()) {
            if (!this.distFile.equals("")) {
                myString = String.valueOf(myString) + " distortion_file=" + this.distFile;
            }
            myString = String.valueOf(myString) + " do_distortion=" + this.getDistortionAction() + " flat_distortion=1";
        } else {
            myString = String.valueOf(myString) + " do_distortion=0 ";
        }
        myString = String.valueOf(myString) + " pass=1";
        if (System.getProperty("os.name").toLowerCase().contains("linux") && System.getProperty("os.arch").contains("64")) {
            myString = String.valueOf(myString) + " dvo=" + this.dvo + " type=" + this.typeoutfile;
        }
        myString = String.valueOf(myString) + " " + this.otherOptions;
        return String.valueOf(myString) + " ";
    }

    public static void incrementImagesCorrected() {
        ProcessingView.getDefault().setDescription(--numberImages, "files left to process", 3);
        if (numberImages < 1 && preprocessor.isOffLine()) {
            Preprocessor.getDefault().setM_bStatusProcessing(false);
        }
    }

    public boolean isM_bStatusProcessing() {
        return this.m_bStatusProcessing;
    }

    public void setM_bStatusProcessing(boolean statusProcessing) {
        if (this.m_bStatusProcessing != statusProcessing) {
            this.m_bStatusProcessing = statusProcessing;
            if (this.m_bStatusProcessing) {
                Activator.log("Processor Status is running");
            } else {
                Activator.log("Processor Status is stopped");
            }
            this.firePreprocessorStateChange();
            this.firePreprocessorChange();
        }
    }

    public int getDistortionAction() {
        return this.distortionAction;
    }

    public void setDistortionAction(int action) {
        this.distortionAction = action;
    }

    public String get_Command() {
        return this.spdCommand;
    }

    public String getZipCmd() {
        return this.zipCmd;
    }

    public void setZipCmd(String cmd) {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            cmd = "\"" + cmd + "\"";
        }
        this.zipCmd = cmd;
    }

    public void setCommand(String newCommand) {
        System.getProperties();
        this.spdCommand = ToolBox.addQuotesForSpacesInName((String)newCommand, (String)"[\\\\/]", (String)System.getProperty("file.separator"));
    }

    public Vector<Sample> get_Samples() {
        return this.v_Samples;
    }

    public Sample getCurrentSample() {
        return this.sample;
    }

    public boolean set_Samples(Vector<Sample> listOfSamples) {
        this.v_Samples = (Vector)listOfSamples.clone();
        if (this.v_Samples.size() > 0) {
            this.sample = this.v_Samples.elementAt(0);
        }
        return true;
    }

    public boolean setSample(Sample spl) {
        Sample oldsample = null;
        if (this.v_Samples.size() > 0) {
            oldsample = this.v_Samples.elementAt(0);
        }
        boolean bnewsample = false;
        if (oldsample != null) {
            if (!(oldsample.get_Experiment().equals(spl.get_Experiment()) && oldsample.get_name().equals(spl.get_name()) && oldsample.get_directoryPath().equals(spl.get_directoryPath()))) {
                Activator.log("Sample has changed. New Sample: " + spl + " .Old Sample:" + oldsample);
                bnewsample = true;
            }
        } else {
            Activator.log("Set sample: " + spl);
            bnewsample = true;
        }
        if (bnewsample) {
            this.v_Samples.removeAllElements();
            this.v_Samples.setSize(1);
            this.v_Samples.set(0, spl);
            this.sample = spl;
            this.fireSampleHasChanged();
            this.firePreprocessorChange();
        }
        return bnewsample;
    }

    public boolean isM_applyDarkCorrection() {
        return this.applyDarkCorrection;
    }

    public void setM_applyDarkCorrection(boolean darkCorrection) {
        if (this.applyDarkCorrection != darkCorrection) {
            this.applyDarkCorrection = darkCorrection;
            if (darkCorrection) {
                this.logMessage.setM_Message("Dark correction will be made while image processing.");
                this.logMessage.setM_Type(1);
            } else {
                this.logMessage.setM_Message("Dark correction will not be made while image processing.");
                this.logMessage.setM_Type(2);
            }
            this.firePreprocessorChange();
        }
    }

    public boolean isM_applyDistCorrection() {
        return this.applyDistCorrection;
    }

    public void setM_applyDistCorrection(boolean distCorrection) {
        if (this.applyDistCorrection != distCorrection) {
            this.applyDistCorrection = distCorrection;
            if (distCorrection) {
                this.logMessage.setM_Message("Spatial distortion will be made while image processing.");
                this.logMessage.setM_Type(1);
            } else {
                this.logMessage.setM_Message("Spatial distortion will not be made while image processing.");
                this.logMessage.setM_Type(2);
            }
            this.firePreprocessorChange();
        }
    }

    public boolean isM_applyFloodCorrection() {
        return this.applyFloodCorrection;
    }

    public void setM_applyFloodCorrection(boolean floodCorrection) {
        if (this.applyFloodCorrection != floodCorrection) {
            this.applyFloodCorrection = floodCorrection;
            if (floodCorrection) {
                this.logMessage.setM_Message("Flood correction will be made while image processing.");
                this.logMessage.setM_Type(1);
            } else {
                this.logMessage.setM_Message("Flood correction will not be made while image processing.");
                this.logMessage.setM_Type(2);
            }
            this.firePreprocessorChange();
        }
    }

    public String getM_darkStem() {
        return this.darkStem;
    }

    public void setM_darkStem(String file) {
        if (file != null && !file.equals(this.getM_darkStem())) {
            this.darkStem = file;
            this.logMessage.setM_Message("Dark file has been updated.");
            this.logMessage.setM_Type(1);
            this.firePreprocessorChange();
        }
    }

    public String getM_darkFile() {
        return this.darkFile;
    }

    public void setM_darkFile(String file) {
        if (file != null && !file.equals(this.darkFile)) {
            this.darkFile = file;
            this.logMessage.setM_Message("Dark file has been updated.");
            this.logMessage.setM_Type(1);
            this.firePreprocessorChange();
        }
    }

    public String getM_distFile() {
        return this.distFile;
    }

    public void setM_distFile(String file) {
        if (file != null && !file.equals(this.getM_distFile())) {
            this.distFile = file;
            this.logMessage.setM_Message("Spatial Distortion file has been updated.");
            this.logMessage.setM_Type(1);
            this.firePreprocessorChange();
        }
    }

    public void setOtherOptions(String spdOptions) {
        this.otherOptions = spdOptions;
    }

    public String getM_floodFile() {
        return this.floodFile;
    }

    public void setM_floodFile(String file) {
        if (file != null && !file.equals(this.getM_floodFile())) {
            this.floodFile = file;
            this.logMessage.setM_Message("Flood file has been updated.");
            this.logMessage.setM_Type(1);
            this.firePreprocessorChange();
        }
    }

    public void setCompress(boolean compress, String cmd) {
        this.setZipCmd(cmd);
        this.zip = compress;
    }

    public String getM_mode() {
        return this.m_mode;
    }

    public void setM_mode(String mode) {
        if (mode != null && !mode.equals(this.m_mode)) {
            this.m_mode = mode;
            if (this.m_mode.compareTo("OFF") == 0) {
                this.setM_modeImage("images/offline.gif");
                this.setM_modeText("Off line");
            } else {
                this.setM_modeImage("images/online.gif");
                this.setM_modeText("On line");
            }
            this.logMessage.setM_Message("Preprocessor mode is " + this.getM_modeText());
            this.logMessage.setM_Type(1);
            Activator.log("Preprocessor mode is : " + this.getM_modeText());
            this.firePreprocessorModeChange();
        }
    }

    public String getSpdMode() {
        return this.spdMode;
    }

    public void setSpdMode(String mode) {
        this.spdMode = mode;
    }

    public void set_DarkCommand(String cmd) {
    }

    public void set_SpatialDistcommand(String cmd) {
    }

    public void set_FloodCommand(String cmd) {
    }

    private void setSpdServer(String name) {
        this.spdServer = name;
    }

    public void set_cor_ext(String corrExt) {
        this.corExt = corrExt;
    }

    public String get_cor_ext() {
        if (this.corExt == null) {
            this.corExt = "cor";
        }
        return this.corExt;
    }

    public void set_src_ext(String corrExt) {
        this.srcExt = corrExt;
    }

    public String get_src_ext() {
        if (this.srcExt == null) {
            this.srcExt = "";
        }
        return this.srcExt;
    }

    public void set_clearCommand(boolean bClear) {
        this.clearCommandOption = bClear;
    }

    public boolean get_clearOption() {
        return this.clearCommandOption;
    }

    public String get_inp_const() {
        return this.inpConst;
    }

    public String get_dark_const() {
        return this.dark_const;
    }

    public void set_dark_const(String darkconst) {
        this.dark_const = darkconst;
    }

    public String get_dark_ext() {
        return this.darkExt;
    }

    public void set_dark_ext(String _dark_ext) {
        this.darkExt = _dark_ext;
    }

    public void set_inp_const(String inpconst) {
        this.inpConst = inpconst;
    }

    public String get_inp_exp() {
        return this.inpExp;
    }

    public void set_inp_exp(String inp_exp) {
        this.inpExp = inp_exp;
    }

    public String get_inp_factor() {
        return this.inpFactor;
    }

    public void set_inp_factor(String inpfactor) {
        this.inpFactor = inpfactor;
    }

    public String get_save_dark() {
        return this.saveDark;
    }

    public void set_save_dark(String savedark) {
        this.saveDark = savedark;
    }

    public String get_extDist() {
        return this.extDist;
    }

    public void set_extDist(String dist) {
        this.extDist = dist;
    }

    public String get_extFlood() {
        return this.extFlood;
    }

    public void set_extFlood(String flood) {
        this.extFlood = flood;
    }

    public String getM_modeImage() {
        return this.modeImage;
    }

    private void setM_modeImage(String image) {
        this.modeImage = image;
    }

    public String getM_modeText() {
        return this.modeText;
    }

    private void setM_modeText(String text) {
        this.modeText = text;
    }

    public PreprocessorMessage getLogMessage() {
        return this.logMessage;
    }

    public void setLogMessage(PreprocessorMessage msg) {
        this.logMessage = msg;
        this.firePreprocessorNewMessage();
    }

    public boolean checkSize(FabioFile file) {
        this.bSizeIsOk = true;
        final String fileName = file.getFileName();
        try {
            this.reffileDim1 = file.getValue("Dim_1").replaceAll("\\p{Space}", "");
            this.reffileDim2 = file.getValue("Dim_2").replaceAll("\\p{Space}", "");
        }
        catch (FabioFileException e1) {
            Activator.log("SpdView.checkSize:" + e1.getMessage(), 4, (Exception)((Object)e1));
            System.out.println(e1.getMessage());
            Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An error occured while comparing image dimension :" + e1.getMessage(), 0));
        }
        Job j = new Job("CheckSize"){

            protected IStatus run(IProgressMonitor monitor) {
                Vector<Sample> spls = Preprocessor.this.get_Samples();
                int n = 0;
                while (spls != null && n < spls.size()) {
                    final Sample sp = spls.elementAt(n);
                    if (sp != null && sp.HasFile()) {
                        int maxSize = sp.getFabioFiles().size();
                        monitor.beginTask("Compare " + fileName + " and " + sp.get_name(), maxSize);
                        int indice = 0;
                        while (indice < maxSize) {
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            final FabioFile sampleFile = (FabioFile)sp.getFabioFiles().elementAt(indice);
                            final String sampleFilename = sampleFile.getFileName();
                            monitor.subTask(sampleFilename);
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    try {
                                        String dim_1 = sampleFile.getValue("Dim_1").replaceAll("\\p{Space}", "");
                                        String dim_2 = sampleFile.getValue("Dim_2").replaceAll("\\p{Space}", "");
                                        if (!dim_1.equals(Preprocessor.this.reffileDim1) || !dim_2.equals(Preprocessor.this.reffileDim2)) {
                                            Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("WARNING " + sp.get_name() + ":File " + sampleFilename + "(Dim_1=" + dim_1 + ",Dim_2=" + dim_2 + ")  and " + fileName + "(Dim_1=" + Preprocessor.this.reffileDim1 + ",Dim_2=" + Preprocessor.this.reffileDim2 + ") don't have the same dimensions. This file will not be processed", 2));
                                            sampleFile.setFlag(false);
                                            Preprocessor.this.bSizeIsOk = false;
                                        } else {
                                            sampleFile.setFlag(true);
                                        }
                                    }
                                    catch (FabioFileException e) {
                                        Preprocessor.this.bSizeIsOk = false;
                                        Activator.log("SpdView.checkSize:" + e.getMessage(), 4, (Exception)((Object)e));
                                        System.out.println(e.getMessage());
                                        Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An error occured while comparing image dimension :" + e.getMessage(), 0));
                                    }
                                }
                            });
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            monitor.worked(indice);
                            ++indice;
                        }
                    }
                    ++n;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        j.setPriority(20);
        j.setUser(true);
        j.schedule();
        try {
            j.join();
        }
        catch (InterruptedException e) {
            Preprocessor.getDefault().setLogMessage(new PreprocessorMessage(e.getMessage(), 0));
        }
        return this.bSizeIsOk;
    }

    private boolean checkSize(final String[] filesToProcessOnLine) {
        this.bSizeIsOk = true;
        if (this.applyDarkCorrection && this.darkFile != null && !this.darkFile.equals("")) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        if (Preprocessor.this.sample.getFabioFiles().size() < 1) {
                            Preprocessor.this.sample.addFabioFiles(filesToProcessOnLine);
                        }
                        Preprocessor.this.bSizeIsOk = Preprocessor.this.checkSize(new FabioFile(Preprocessor.this.darkFile));
                    }
                    catch (FabioFileException e) {
                        Preprocessor.this.bSizeIsOk = false;
                        Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An error occured while comparing image dimension :" + e.getMessage(), 0));
                    }
                }
            });
        } else if (this.bSizeIsOk && this.applyFloodCorrection && this.floodFile != null && !this.floodFile.equals("")) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        if (Preprocessor.this.sample.getFabioFiles().size() < 1) {
                            Preprocessor.this.sample.addFabioFiles(filesToProcessOnLine);
                        }
                        FabioFile fabio = new FabioFile(Preprocessor.this.floodFile);
                        Preprocessor.this.bSizeIsOk = Preprocessor.this.checkSize(fabio);
                    }
                    catch (FabioFileException e) {
                        Preprocessor.this.bSizeIsOk = false;
                        Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An error occured while comparing image dimension :" + e.getMessage(), 0));
                    }
                }
            });
        }
        return this.bSizeIsOk;
    }

    public void setCorrectionType(String data) {
        if (data != null) {
            this.typeoutfile = data;
        }
    }

    public void setDataValueOffset(String text) {
        if (text != null) {
            this.dvo = text;
        }
    }

    class ProcessThread
    extends Thread {
        private Boolean applyDark;
        private Boolean applyFlood;
        private Boolean applySpatial;
        private String markNewFileFlag;
        private boolean stopProcessing;
        private boolean onLineMode;
        private long threadTimer;
        private String fileFilter;
        private String threadSampleDirectory;
        private Sample threadSample;
        private String threadSampleName;
        private Process process = null;
        private int nFilesToProcess;

        public ProcessThread(Sample newsample, boolean doDark, boolean doFlood, boolean doDist, String mode, String typeFilter) {
            this.threadSample = newsample;
            this.threadSampleDirectory = newsample.get_directoryPath();
            char sep = this.threadSampleDirectory.contains("\\") ? (char)'\\' : '/';
            this.threadSampleDirectory = String.valueOf(this.threadSampleDirectory) + sep;
            this.applyDark = doDark;
            this.applyFlood = doFlood;
            this.applySpatial = doDist;
            this.stopProcessing = false;
            this.threadSampleName = newsample.get_name();
            this.fileFilter = typeFilter;
            this.onLineMode = !mode.equals("OFF");
            this.markNewFileFlag = Preprocessor.getDefault().get_cor_ext();
        }

        public void run() {
            this.threadTimer = System.currentTimeMillis();
            Activator.log("Preprocessor Thread start for " + this.toString());
            if (this.onLineMode) {
                Activator.log("Waiting for new files in sample:" + this.threadSampleName);
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Waiting for new files in sample: " + this.threadSampleName + ".... ", 1));
            }
            while (!this.stopProcessing) {
                Object[] files = null;
                if (preprocessor.getM_mode().equals("OFF")) {
                    files = this.threadSample.getFabioFilesToProcess(true);
                } else {
                    files = this.getNewFiles(this.markNewFileFlag);
                    Preprocessor.this.sample.addCurrentFiles((String[])files);
                }
                if (files != null && files.length != 0) {
                    numberImages += files.length;
                    this.nFilesToProcess = files.length;
                } else {
                    numberImages += 0;
                }
                int i = 0;
                if ((this.applyDark.booleanValue() || this.applyFlood.booleanValue() || this.applySpatial.booleanValue()) && !files.equals("")) {
                    if (Preprocessor.this.spdMode.equals("server")) {
                        this.sendCommandToServer(preprocessor.getCommand(), (String[])files);
                    } else {
                        int lenCommand = preprocessor.getCommand().length() + files.toString().length();
                        if (System.getProperty("os.name").toLowerCase().equals("linux")) {
                            String newCmd = preprocessor.getCommand();
                            if (lenCommand > 131072) {
                                ArrayList<Object> splitF = new ArrayList<Object>();
                                if (files != null) {
                                    int n = 0;
                                    while (n < files.length) {
                                        int len = newCmd.length() + ((String)files[n]).length();
                                        if (len < 131072) {
                                            splitF.add(files[n]);
                                        } else {
                                            this.processCmd(newCmd, splitF.toArray());
                                            splitF.clear();
                                        }
                                        ++n;
                                    }
                                }
                            } else {
                                this.processCmd(newCmd, files);
                            }
                        } else {
                            this.processCmd(preprocessor.getCommand(), files);
                        }
                    }
                }
                if (!this.onLineMode) {
                    if (this.stopProcessing && i - 1 < files.length) {
                        Integer rest = files.length - i;
                        Activator.log("Process has been stopped. Number of files to treat : " + rest.toString());
                        Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Process has been stopped. Number of files to treat : " + rest.toString(), 1));
                    }
                    this.stopProcessing = true;
                    continue;
                }
                if (i <= 0) continue;
                Activator.log("Waiting for new files in sample:" + this.threadSampleName);
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Waiting for new files in sample: " + this.threadSampleName + ".... ", 1));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.interrupt();
            Activator.log("Process ends for sample:" + this.threadSampleName);
            Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Process ends for sample:" + this.threadSampleName, 1));
            if (!this.onLineMode) {
                if (numberImages == 0) {
                    Preprocessor.getDefault().setM_bStatusProcessing(false);
                    ProcessingView.getDefault().setDescription(numberImages, "finished processing files", 1);
                    ProcessingView.getDefault().updateDirectory();
                }
            } else {
                ProcessingView.getDefault().setDescription(numberImages, "finished processing files", 1);
            }
        }

        private void importSpdServer() {
            if (Preprocessor.this.spdProxy == null) {
                try {
                    Preprocessor.this.spdProxy = new DeviceProxy(Preprocessor.this.spdServer);
                    Preprocessor.this.spdProxy.set_rpc_protocol(1);
                    Preprocessor.this.spdProxy.set_timeout_millis(60000);
                }
                catch (DevFailed e) {
                    Activator.log("Error new Device Proxy", 4, (Exception)((Object)e));
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("ERROR importing device " + Preprocessor.this.spdServer, 0));
                }
            }
        }

        private void sendCommandToServer(String command, String[] files) {
            String[] s_arr;
            DeviceData in;
            if (Preprocessor.this.spdProxy == null) {
                this.importSpdServer();
            }
            String[] commands = command.split("\\s+");
            int i = 0;
            while (i < commands.length) {
                try {
                    in = new DeviceData();
                    s_arr = new String[]{commands[i]};
                    in.insert(s_arr);
                    Preprocessor.this.spdProxy.command_inout("SpdExecute", in);
                }
                catch (DevFailed e) {
                    Activator.log("Error sending command " + commands[i] + " to spd server", 4, (Exception)((Object)e));
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Error sending command " + commands[i] + " to spd server", 0));
                }
                ++i;
            }
            i = 0;
            while (i < files.length) {
                try {
                    in = new DeviceData();
                    s_arr = new String[]{files[i]};
                    in.insert(s_arr);
                    long before = System.currentTimeMillis();
                    Preprocessor.this.spdProxy.command_inout("SpdExecute", in);
                    long elapsed = System.currentTimeMillis() - before;
                    Preprocessor.incrementImagesCorrected();
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Processed file " + files[i] + " took " + elapsed + " ms", 1));
                }
                catch (DevFailed e) {
                    Activator.log("Error sending file " + files[i] + " to spd server", 4, (Exception)((Object)e));
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Error sending file " + files[i] + " to spd server", 0));
                }
                ++i;
            }
        }

        public String[] getNewFiles(String flagForNewFiles) {
            String ProcessedFileRegex = String.valueOf(this.threadSampleName) + "(\\d+)?\\.(\\w+)?" + flagForNewFiles;
            String[] listImagesProcessed = ToolBox.getFilesByEntireRegex((String)this.threadSampleDirectory, (String)ProcessedFileRegex, (boolean)true);
            String sampleRegex = String.valueOf(this.threadSampleName) + "(\\d+)?\\." + this.fileFilter;
            String[] listAllOriginalImagesInDir = Preprocessor.this.processAll ? ToolBox.getFilesByEntireRegex((String)this.threadSampleDirectory, (String)sampleRegex, (boolean)true) : ToolBox.getFilesByEntireRegexAndTime((String)this.threadSampleDirectory, (String)sampleRegex, (boolean)true, (long)this.threadTimer);
            String[] newFiles = null;
            if (listAllOriginalImagesInDir != null && listAllOriginalImagesInDir.length > 0) {
                int max_length = listAllOriginalImagesInDir.length;
                int i = 0;
                while (i < listImagesProcessed.length) {
                    int j = 0;
                    boolean bfound = false;
                    while (!bfound && j < max_length) {
                        int len1 = listAllOriginalImagesInDir[j].split("\\.").length;
                        int len2 = listImagesProcessed[i].split("\\.").length;
                        if (len1 == 2 && len2 == 2) {
                            String myFileProcessed;
                            String myOriginalFile = listAllOriginalImagesInDir[j].split("\\.")[0];
                            if (myOriginalFile.compareTo(myFileProcessed = listImagesProcessed[i].split("\\.")[0]) == 0) {
                                if (max_length > 1) {
                                    String temp = listAllOriginalImagesInDir[max_length - 1];
                                    listAllOriginalImagesInDir[max_length - 1] = listAllOriginalImagesInDir[j];
                                    listAllOriginalImagesInDir[j] = temp;
                                }
                                bfound = true;
                                --max_length;
                                continue;
                            }
                            ++j;
                            continue;
                        }
                        Activator.log("Error while getting new Files in preprocesor ; getNewFiles ;  listAllOriginalImagesInDir[j]=" + listAllOriginalImagesInDir[j] + " listImagesProcessed[i]=" + listImagesProcessed[i], 4, null);
                        if (max_length > 1) {
                            String temp = listAllOriginalImagesInDir[max_length - 1];
                            listAllOriginalImagesInDir[max_length - 1] = listAllOriginalImagesInDir[j];
                            listAllOriginalImagesInDir[j] = temp;
                        }
                        --max_length;
                    }
                    ++i;
                }
                newFiles = new String[max_length];
                int n = 0;
                while (n < max_length) {
                    newFiles[n] = String.valueOf(this.threadSampleDirectory) + listAllOriginalImagesInDir[n];
                    Activator.log("New file detected :" + newFiles[n]);
                    ++n;
                }
                if (!Preprocessor.this.checkSize(newFiles)) {
                    newFiles = Preprocessor.this.sample.getFabioFilesToProcess(true);
                    Preprocessor.this.sample.getFabioFiles().removeAllElements();
                }
                if (newFiles != null) {
                    ToolBox.quicksort((String[])newFiles, (int)0, (int)newFiles.length);
                }
            }
            return newFiles;
        }

        public void notifyEnd() {
            this.stopProcessing = true;
            if (this.process != null) {
                try {
                    this.process.getOutputStream().close();
                    this.process.getInputStream().close();
                    this.process.getErrorStream().close();
                }
                catch (IOException e) {
                    Activator.log("notifyEnd", 1, e);
                }
                this.process.destroy();
                Activator.log("notifyEnd", 1, null);
            }
        }

        private String getCorrectedFile(String file, String correctedExtension) {
            String correctedFiles = "";
            int index = file.lastIndexOf(".");
            if (index > 0 && index + 1 < file.length()) {
                correctedFiles = file.subSequence(0, index + 1) + correctedExtension;
                System.out.println("corrected files" + correctedFiles);
            }
            return correctedFiles;
        }

        private void processCmd(String myCommand, Object[] files) {
            String file = "";
            String filesToCompress = "";
            int i = 0;
            while (files != null && i < files.length) {
                myCommand = String.valueOf(myCommand) + " " + ToolBox.addQuotesForSpacesInName((String)((String)files[i]), (String)"[\\\\/]", (String)System.getProperty("file.separator"));
                if (Preprocessor.this.zip) {
                    String correctedFile = this.getCorrectedFile((String)files[i], preprocessor.get_cor_ext());
                    if (correctedFile != null && !correctedFile.equals("") && System.getProperty("os.name").toLowerCase().contains("window")) {
                        correctedFile = "\"" + correctedFile + "\"";
                    }
                    if (System.getProperty("os.name").toLowerCase().contains("window")) {
                        files[i] = "\"" + files[i] + "\"";
                    }
                    filesToCompress = String.valueOf(filesToCompress) + files[i] + "  " + correctedFile + " ";
                }
                ++i;
            }
            Runtime runtime = Runtime.getRuntime();
            Preprocessor.getDefault().setLogMessage(new PreprocessorMessage(myCommand, 1));
            try {
                this.process = runtime.exec(myCommand);
                StreamReaderThread outThread = new StreamReaderThread(this.process.getInputStream());
                StreamReaderThread errThread = new StreamReaderThread(this.process.getErrorStream());
                outThread.start();
                errThread.start();
                this.process.waitFor();
                outThread.join();
                errThread.join();
                if (this.process.waitFor() == 0) {
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Process finished for file " + file, 1));
                    Activator.log("End of process for file:" + file);
                    if (preprocessor.zip) {
                        String command = String.valueOf(preprocessor.getZipCmd()) + " " + filesToCompress;
                        this.process = System.getProperty("os.name").toLowerCase().contains("window") ? runtime.exec(command) : runtime.exec(command);
                        System.out.println("launching " + command);
                        this.process.waitFor();
                        outThread.join();
                        errThread.join();
                        if (this.process.waitFor() == 0) {
                            Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Compression done for files " + file, 1));
                        } else {
                            Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Unable to zip files " + file, 0));
                        }
                    }
                } else {
                    Activator.log("Process for command : " + myCommand + " has not finished properly :  " + this.process.waitFor(), 4, null);
                    Preprocessor.getDefault().setM_bStatusProcessing(false);
                    this.stopProcessing = true;
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Processor has stopped before ending", 0));
                }
            }
            catch (InterruptedException e) {
                Preprocessor.getDefault().setM_bStatusProcessing(false);
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An Error occured while waiting for the process to finish (Interrupted exception)", 0));
                Activator.log("An Interrupted exception occured while trying to execute command ( processCmd) on file " + file, 4, e);
                e.printStackTrace();
            }
            catch (IOException e) {
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An Error occured while trying to execute command (IOException exception)", 0));
                Activator.log("An Error occured while trying to execute command (IOException exception launched in processCmd) on file " + file, 4, e);
                e.printStackTrace();
                preprocessor.stop();
                preprocessor.setM_bStatusProcessing(false);
            }
        }

        public String getInfo() {
            Date timer = new Date(this.threadTimer);
            String myString = "Thread preprocessor for sample: " + this.threadSampleName;
            myString = String.valueOf(myString) + "\n";
            myString = String.valueOf(myString) + "Thread time begin:" + timer.toString();
            myString = this.onLineMode ? String.valueOf(myString) + "Thread preprocessor mode is On Line. \n" : String.valueOf(myString) + "Thread Preprocessor mode is Off Line. \n : ";
            myString = String.valueOf(myString) + " \n";
            if (this.applyDark.booleanValue()) {
                myString = String.valueOf(myString) + " Dark subtraction will be made.\n ";
            }
            if (this.applySpatial.booleanValue()) {
                myString = String.valueOf(myString) + " Spatial distortion correction will be made.\n ";
            }
            if (this.applyFlood.booleanValue()) {
                myString = String.valueOf(myString) + " Flood correction  will be made.\n ";
            }
            return myString;
        }
    }

    public class StreamReaderThread
    extends Thread {
        String outputMessage;
        InputStream inStream;

        public StreamReaderThread(InputStream in) {
            this.inStream = in;
        }

        public void run() {
            BufferedReader outputread = new BufferedReader(new InputStreamReader(this.inStream));
            try {
                while ((this.outputMessage = outputread.readLine()) != null) {
                    if (this.outputMessage.indexOf("Correcting") >= 0) {
                        Preprocessor.incrementImagesCorrected();
                    }
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage(this.outputMessage, 1));
                }
            }
            catch (IOException e) {
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An error occured " + Preprocessor.this._threadProcess.threadSampleName + " " + e.getMessage(), 0));
            }
        }
    }
}

