/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.api.JmolAdapter;
import org.jmol.modelset.ModelLoader;
import org.jmol.modelset.ModelSet;
import org.jmol.viewer.Viewer;

class ModelManager {
    private final Viewer viewer;
    private ModelLoader modelLoader;
    private String fullPathName;
    private String fileName;

    ModelManager(Viewer viewer) {
        this.viewer = viewer;
    }

    ModelSet clear() {
        this.fileName = null;
        this.fullPathName = null;
        this.modelLoader = null;
        return null;
    }

    ModelSet zap() {
        this.clear();
        this.fullPathName = this.fileName;
        this.modelLoader = new ModelLoader(this.viewer, "empty");
        return this.modelLoader;
    }

    String getModelSetFileName() {
        return this.fileName == null ? "zapped" : this.fileName;
    }

    String getModelSetPathName() {
        return this.fullPathName;
    }

    ModelSet merge(JmolAdapter jmolAdapter, Object object) {
        this.modelLoader = new ModelLoader(this.viewer, jmolAdapter, object, this.modelLoader, "merge");
        if (this.modelLoader.getAtomCount() == 0) {
            this.zap();
        }
        return this.modelLoader;
    }

    ModelSet setClientFile(String string, String string2, JmolAdapter jmolAdapter, Object object) {
        if (object == null) {
            this.clear();
            return null;
        }
        this.fullPathName = string;
        this.fileName = string2;
        String string3 = jmolAdapter.getAtomSetCollectionName(object);
        if (string3 != null && (string3 = string3.trim()).length() == 0) {
            string3 = null;
        }
        if (string3 == null) {
            string3 = ModelManager.reduceFilename(string2);
        }
        this.modelLoader = new ModelLoader(this.viewer, jmolAdapter, object, null, string3);
        if (this.modelLoader.getAtomCount() == 0) {
            this.zap();
        }
        return this.modelLoader;
    }

    private static String reduceFilename(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        if (string.length() > 24) {
            string = string.substring(0, 20) + " ...";
        }
        return string;
    }
}

