/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.etf;

import org.apache.avalon.framework.configuration.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.TaggedComponentList;
import org.omg.CORBA.BAD_PARAM;
import org.omg.ETF.Profile;
import org.omg.ETF._ProfileLocalBase;
import org.omg.GIOP.Version;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;

public abstract class ProfileBase
extends _ProfileLocalBase
implements Cloneable,
Configurable {
    protected Version version = null;
    protected byte[] objectKey = null;
    protected TaggedComponentList components = null;
    protected Configuration configuration;
    protected String corbalocStr = null;

    public void set_object_key(byte[] byArray) {
        this.objectKey = byArray;
    }

    public byte[] get_object_key() {
        return this.objectKey;
    }

    public Version version() {
        return this.version;
    }

    public abstract int tag();

    public void marshal(TaggedProfileHolder taggedProfileHolder, TaggedComponentSeqHolder taggedComponentSeqHolder) {
        if (this.encapsulation() != 0) {
            throw new Error("We can only marshal big endian stylee profiles !!");
        }
        CDROutputStream cDROutputStream = new CDROutputStream();
        cDROutputStream.beginEncapsulatedArray();
        this.writeAddressProfile(cDROutputStream);
        cDROutputStream.write_long(this.objectKey.length);
        cDROutputStream.write_octet_array(this.objectKey, 0, this.objectKey.length);
        switch (this.version.minor) {
            case 0: {
                break;
            }
            default: {
                int n;
                if (taggedComponentSeqHolder == null) {
                    taggedComponentSeqHolder = new TaggedComponentSeqHolder(new TaggedComponent[0]);
                }
                cDROutputStream.write_long(this.components.size() + taggedComponentSeqHolder.value.length);
                for (n = 0; n < this.components.asArray().length; ++n) {
                    TaggedComponentHelper.write(cDROutputStream, this.components.asArray()[n]);
                }
                for (n = 0; n < taggedComponentSeqHolder.value.length; ++n) {
                    TaggedComponentHelper.write(cDROutputStream, taggedComponentSeqHolder.value[n]);
                }
            }
        }
        taggedProfileHolder.value = new TaggedProfile(this.tag(), cDROutputStream.getBufferCopy());
    }

    public void demarshal(TaggedProfileHolder taggedProfileHolder, TaggedComponentSeqHolder taggedComponentSeqHolder) {
        if (taggedProfileHolder.value.tag != this.tag()) {
            throw new BAD_PARAM("Wrong tag for Transport, tag: " + taggedProfileHolder.value.tag);
        }
        this.initFromProfileData(taggedProfileHolder.value.profile_data);
        taggedComponentSeqHolder.value = this.getComponents().asArray();
    }

    public short encapsulation() {
        return 0;
    }

    public abstract void writeAddressProfile(CDROutputStream var1);

    public abstract void readAddressProfile(CDRInputStream var1);

    public TaggedComponentList getComponents() {
        return this.components;
    }

    public Object getComponent(int n, Class clazz) {
        return this.components.getComponent(n, clazz);
    }

    public void addComponent(int n, Object object, Class clazz) {
        this.components.addComponent(n, object, clazz);
    }

    public void addComponent(int n, byte[] byArray) {
        this.components.addComponent(n, byArray);
    }

    public TaggedProfile asTaggedProfile() {
        TaggedProfileHolder taggedProfileHolder = new TaggedProfileHolder();
        this.marshal(taggedProfileHolder, null);
        return taggedProfileHolder.value;
    }

    public Profile copy() {
        try {
            return (Profile)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("error cloning profile: " + cloneNotSupportedException);
        }
    }

    protected void initFromProfileData(byte[] byArray) {
        CDRInputStream cDRInputStream = new CDRInputStream(null, byArray);
        cDRInputStream.openEncapsulatedArray();
        this.readAddressProfile(cDRInputStream);
        int n = cDRInputStream.read_ulong();
        this.objectKey = new byte[n];
        cDRInputStream.read_octet_array(this.objectKey, 0, n);
        this.components = this.version != null && this.version.minor > 0 ? new TaggedComponentList(cDRInputStream) : new TaggedComponentList();
    }
}

