/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.util.PropertySet;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.PropertyError;
import org.omg.CosNotification.PropertyRange;
import org.omg.CosNotification.QoSError_code;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.TimeBase.TimeTHelper;

public class QoSPropertySet
extends PropertySet {
    public static final int CHANNEL_QOS = 0;
    public static final int ADMIN_QOS = 1;
    public static final int PROXY_QOS = 2;
    private Property[] defaultChannelQoS_;
    private Property[] defaultAdminQoS_;
    private static final HashSet sValidChannelQoSNames_;
    private static final HashSet sValidAdminQoSNames_;
    private static final HashSet sValidProxyQoSNames_;
    private static final HashSet sValidMessageQoSNames_;
    static final Any connectionReliabilityLow_;
    static final Any connectionReliabilityHigh_;
    static final Any eventReliabilityLow_;
    static final Any eventReliabilityHigh_;
    static Any orderPolicyLow_;
    Any orderPolicyDefault_;
    static Any orderPolicyHigh_;
    static Any discardPolicyLow_;
    static Any discardPolicyHigh_;
    static Any priorityLow_;
    static Any priorityDefault_;
    static Any priorityHigh_;
    Any maxEventsPerConsumerLow_;
    Any maxEventsPerConsumerDefault_;
    Any maxEventsPerConsumerHigh_;
    Any timeoutHigh_;
    Any timeoutDefault_;
    Any timeoutLow_;
    private static final Any trueAny;
    private static final Any falseAny;
    private HashSet validNames_;

    private void configure(Configuration configuration) {
        int n = configuration.getAttributeAsInteger("jacorb.notification.max_events_per_consumer", 100);
        this.maxEventsPerConsumerDefault_ = sORB.create_any();
        this.maxEventsPerConsumerDefault_.insert_long(n);
        this.maxEventsPerConsumerHigh_ = sORB.create_any();
        this.maxEventsPerConsumerLow_ = sORB.create_any();
        this.maxEventsPerConsumerLow_.insert_long(0);
        this.maxEventsPerConsumerHigh_.insert_long(Integer.MAX_VALUE);
        String string = configuration.getAttribute("jacorb.notification.order_policy", "PriorityOrder");
        String string2 = configuration.getAttribute("jacorb.notification.discard_policy", "PriorityOrder");
        this.timeoutDefault_ = sORB.create_any();
        TimeTHelper.insert(this.timeoutDefault_, 0L);
        Any any = sORB.create_any();
        boolean bl = configuration.getAttribute("jacorb.notification.start_time_supported", "on").equals("on");
        any.insert_boolean(bl);
        Any any2 = sORB.create_any();
        boolean bl2 = configuration.getAttribute("jacorb.notification.stop_time_supported", "on").equals("on");
        any2.insert_boolean(bl2);
        int n2 = configuration.getAttributeAsInteger("jacorb.notification.max_batch_size", 1);
        Any any3 = sORB.create_any();
        any3.insert_long(n2);
        this.defaultChannelQoS_ = new Property[]{new Property("EventReliability", eventReliabilityLow_), new Property("ConnectionReliability", connectionReliabilityLow_), new Property("Priority", priorityDefault_), new Property("MaxEventsPerConsumer", this.maxEventsPerConsumerDefault_), new Property("Timeout", this.timeoutDefault_), new Property("StartTimeSupported", any), new Property("StopTimeSupported", any), new Property("MaximumBatchSize", any3)};
        this.defaultAdminQoS_ = new Property[]{new Property("ConnectionReliability", connectionReliabilityLow_), new Property("Priority", priorityDefault_), new Property("MaxEventsPerConsumer", this.maxEventsPerConsumerDefault_), new Property("Timeout", this.timeoutDefault_), new Property("StartTimeSupported", any), new Property("StopTimeSupported", any), new Property("MaximumBatchSize", any3)};
    }

    public QoSPropertySet(Configuration configuration, int n) {
        this.configure(configuration);
        this.init(n);
    }

    private void init(int n) {
        switch (n) {
            case 0: {
                this.validNames_ = sValidChannelQoSNames_;
                this.set_qos(this.defaultChannelQoS_);
                break;
            }
            case 1: {
                this.validNames_ = sValidAdminQoSNames_;
                this.set_qos(this.defaultAdminQoS_);
                break;
            }
            case 2: {
                this.validNames_ = sValidProxyQoSNames_;
                break;
            }
            default: {
                throw new IllegalArgumentException("Type " + n + " is invalid");
            }
        }
    }

    HashSet getValidNames() {
        return this.validNames_;
    }

    public void set_qos(Property[] propertyArray) {
        this.set_properties(propertyArray);
    }

    public Property[] get_qos() {
        return this.toArray();
    }

    public void validate_qos(Property[] propertyArray, NamedPropertyRangeSeqHolder namedPropertyRangeSeqHolder) throws UnsupportedQoS {
        ArrayList arrayList = new ArrayList();
        this.checkPropertyExistence(propertyArray, arrayList);
        if (!arrayList.isEmpty()) {
            throw new UnsupportedQoS(arrayList.toArray(PROPERTY_ERROR_ARRAY_TEMPLATE));
        }
        this.checkPropertyValues(propertyArray, arrayList);
        if (!arrayList.isEmpty()) {
            throw new UnsupportedQoS(arrayList.toArray(PROPERTY_ERROR_ARRAY_TEMPLATE));
        }
    }

    private short checkIsShort(String string, Any any, List list) throws BAD_OPERATION {
        try {
            return any.extract_short();
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            list.add(this.badType(string));
            throw bAD_OPERATION;
        }
    }

    private void logError(List list, QoSError_code qoSError_code, String string, Any any, Any any2, Any any3) {
        list.add(new PropertyError(qoSError_code, string, new PropertyRange(any2, any3)));
    }

    private void checkPropertyValues(Property[] propertyArray, List list) {
        for (int i = 0; i < propertyArray.length; ++i) {
            String string = propertyArray[i].name;
            Any any = propertyArray[i].value;
            try {
                if ("ConnectionReliability".equals(string)) {
                    short s = this.checkIsShort(string, any, list);
                    switch (s) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        default: {
                            this.logError(list, QoSError_code.BAD_VALUE, string, any, connectionReliabilityLow_, connectionReliabilityHigh_);
                            break;
                        }
                    }
                    continue;
                }
                if ("EventReliability".equals(string)) {
                    short s = this.checkIsShort(string, any, list);
                    switch (s) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        default: {
                            this.logError(list, QoSError_code.BAD_VALUE, string, any, eventReliabilityLow_, eventReliabilityHigh_);
                            break;
                        }
                    }
                    continue;
                }
                if ("OrderPolicy".equals(string)) {
                    short s = this.checkIsShort(string, any, list);
                    switch (propertyArray[i].value.extract_short()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            this.logError(list, QoSError_code.BAD_VALUE, string, any, orderPolicyLow_, orderPolicyHigh_);
                            break;
                        }
                    }
                    continue;
                }
                if (!"DiscardPolicy".equals(string)) continue;
                short s = this.checkIsShort(string, any, list);
                switch (s) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        this.logError(list, QoSError_code.BAD_VALUE, string, any, discardPolicyLow_, discardPolicyHigh_);
                    }
                }
                continue;
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                // empty catch block
            }
        }
    }

    static {
        trueAny = sORB.create_any();
        falseAny = sORB.create_any();
        trueAny.insert_boolean(true);
        falseAny.insert_boolean(false);
        sValidChannelQoSNames_ = new HashSet();
        sValidChannelQoSNames_.add("EventReliability");
        sValidChannelQoSNames_.add("ConnectionReliability");
        sValidChannelQoSNames_.add("Priority");
        sValidChannelQoSNames_.add("Timeout");
        sValidChannelQoSNames_.add("StartTimeSupported");
        sValidChannelQoSNames_.add("StopTimeSupported");
        sValidChannelQoSNames_.add("MaxEventsPerConsumer");
        sValidChannelQoSNames_.add("OrderPolicy");
        sValidChannelQoSNames_.add("DiscardPolicy");
        sValidChannelQoSNames_.add("MaximumBatchSize");
        sValidChannelQoSNames_.add("PacingInterval");
        sValidAdminQoSNames_ = new HashSet(sValidChannelQoSNames_);
        sValidAdminQoSNames_.remove("EventReliability");
        sValidProxyQoSNames_ = new HashSet(sValidAdminQoSNames_);
        sValidMessageQoSNames_ = new HashSet();
        sValidMessageQoSNames_.add("EventReliability");
        sValidMessageQoSNames_.add("Priority");
        sValidMessageQoSNames_.add("StartTime");
        sValidMessageQoSNames_.add("StopTime");
        sValidMessageQoSNames_.add("Timeout");
        connectionReliabilityHigh_ = sORB.create_any();
        connectionReliabilityHigh_.insert_short((short)1);
        connectionReliabilityLow_ = sORB.create_any();
        connectionReliabilityLow_.insert_short((short)0);
        eventReliabilityLow_ = sORB.create_any();
        eventReliabilityLow_.insert_short((short)0);
        eventReliabilityHigh_ = sORB.create_any();
        eventReliabilityHigh_.insert_short((short)0);
        orderPolicyLow_ = sORB.create_any();
        orderPolicyLow_.insert_short((short)0);
        orderPolicyHigh_ = sORB.create_any();
        orderPolicyHigh_.insert_short((short)3);
        discardPolicyLow_ = sORB.create_any();
        discardPolicyLow_.insert_short((short)0);
        discardPolicyHigh_ = sORB.create_any();
        discardPolicyHigh_.insert_short((short)3);
        priorityLow_ = sORB.create_any();
        priorityLow_.insert_short((short)Short.MIN_VALUE);
        priorityDefault_ = sORB.create_any();
        priorityDefault_.insert_short((short)0);
        priorityHigh_ = sORB.create_any();
        priorityHigh_.insert_short((short)Short.MAX_VALUE);
    }
}

