/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.dnd;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.dnd.CommonDropAdapterDescriptor;
import org.eclipse.ui.internal.navigator.dnd.CommonDropDescriptorManager;
import org.eclipse.ui.internal.navigator.extensions.CommonDragAssistantDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorViewerDescriptor;
import org.eclipse.ui.navigator.CommonDragAdapterAssistant;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.navigator.INavigatorDnDService;

public class NavigatorDnDService
implements INavigatorDnDService {
    private static final CommonDropAdapterAssistant[] NO_ASSISTANTS = new CommonDropAdapterAssistant[0];
    private NavigatorContentService contentService;
    private CommonDragAdapterAssistant[] dragAssistants;
    private final Map dropAssistants = new HashMap();

    public NavigatorDnDService(NavigatorContentService aContentService) {
        this.contentService = aContentService;
    }

    public synchronized CommonDragAdapterAssistant[] getCommonDragAssistants() {
        if (this.dragAssistants == null) {
            this.initializeDragAssistants();
        }
        return this.dragAssistants;
    }

    private void initializeDragAssistants() {
        int i = 0;
        Set dragDescriptors = ((NavigatorViewerDescriptor)this.contentService.getViewerDescriptor()).getDragAssistants();
        this.dragAssistants = new CommonDragAdapterAssistant[dragDescriptors.size()];
        Iterator iter = dragDescriptors.iterator();
        while (iter.hasNext()) {
            CommonDragAssistantDescriptor descriptor = (CommonDragAssistantDescriptor)iter.next();
            this.dragAssistants[i++] = descriptor.createDragAssistant();
        }
    }

    public synchronized void bindDragAssistant(CommonDragAdapterAssistant anAssistant) {
        if (this.dragAssistants == null) {
            this.initializeDragAssistants();
        }
        CommonDragAdapterAssistant[] newDragAssistants = new CommonDragAdapterAssistant[this.dragAssistants.length + 1];
        System.arraycopy(this.dragAssistants, 0, newDragAssistants, 0, this.dragAssistants.length);
        newDragAssistants[this.dragAssistants.length] = anAssistant;
        this.dragAssistants = newDragAssistants;
    }

    public CommonDropAdapterAssistant[] findCommonDropAdapterAssistants(Object aDropTarget, TransferData aTransferType) {
        CommonDropAdapterDescriptor[] descriptors = CommonDropDescriptorManager.getInstance().findCommonDropAdapterAssistants(aDropTarget, this.contentService);
        if (descriptors.length == 0) {
            return NO_ASSISTANTS;
        }
        if (LocalSelectionTransfer.getTransfer().isSupportedType(aTransferType) && LocalSelectionTransfer.getTransfer().getSelection() instanceof IStructuredSelection) {
            return this.getAssistantsBySelection(descriptors, (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection());
        }
        return this.getAssistantsByTransferData(descriptors, aTransferType);
    }

    public CommonDropAdapterAssistant[] findCommonDropAdapterAssistants(Object aDropTarget, IStructuredSelection theDragSelection) {
        CommonDropAdapterDescriptor[] descriptors = CommonDropDescriptorManager.getInstance().findCommonDropAdapterAssistants(aDropTarget, this.contentService);
        if (descriptors.length == 0) {
            return NO_ASSISTANTS;
        }
        return this.getAssistantsBySelection(descriptors, theDragSelection);
    }

    private CommonDropAdapterAssistant[] getAssistantsByTransferData(CommonDropAdapterDescriptor[] descriptors, TransferData aTransferType) {
        LinkedHashSet<CommonDropAdapterAssistant> assistants = new LinkedHashSet<CommonDropAdapterAssistant>();
        int i = 0;
        while (i < descriptors.length) {
            CommonDropAdapterAssistant asst = this.getAssistant(descriptors[i]);
            if (asst.isSupportedType(aTransferType)) {
                assistants.add(asst);
            }
            ++i;
        }
        return assistants.toArray(new CommonDropAdapterAssistant[assistants.size()]);
    }

    private CommonDropAdapterAssistant[] getAssistantsBySelection(CommonDropAdapterDescriptor[] descriptors, IStructuredSelection aSelection) {
        LinkedHashSet<CommonDropAdapterAssistant> assistants = new LinkedHashSet<CommonDropAdapterAssistant>();
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].areDragElementsSupported(aSelection)) {
                assistants.add(this.getAssistant(descriptors[i]));
            }
            ++i;
        }
        return assistants.toArray(new CommonDropAdapterAssistant[assistants.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommonDropAdapterAssistant getAssistant(CommonDropAdapterDescriptor descriptor) {
        CommonDropAdapterAssistant asst = (CommonDropAdapterAssistant)this.dropAssistants.get(descriptor);
        if (asst != null) {
            return asst;
        }
        Map map = this.dropAssistants;
        synchronized (map) {
            asst = (CommonDropAdapterAssistant)this.dropAssistants.get(descriptor);
            if (asst == null) {
                asst = descriptor.createDropAssistant();
                this.dropAssistants.put(descriptor, asst);
                asst.init(this.contentService);
            }
        }
        return asst;
    }
}

