/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.internal;

import fable.framework.ui.actions.UpdateAction;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class MainMenuBar
extends ActionBarAdvisor {
    public MenuManager windowMenu;
    public MenuManager helpMenu;
    public MenuManager menuEdit;
    public MenuManager menuFile;
    private ActionFactory.IWorkbenchAction newAction;
    private ActionFactory.IWorkbenchAction exitAction;
    private ActionFactory.IWorkbenchAction newWorkbenchAction;
    private ActionFactory.IWorkbenchAction preferencesAction;
    private ActionFactory.IWorkbenchAction perspectiveResetAction;
    private ActionFactory.IWorkbenchAction helpAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private IContributionItem viewsShortList;
    private UpdateAction updateAction;

    public MainMenuBar(IActionBarConfigurer configurer) {
        super(configurer);
    }

    public void makeActions(IWorkbenchWindow window) {
        this.newAction = ActionFactory.NEW.create(window);
        this.register((IAction)this.newAction);
        this.exitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.exitAction);
        this.newWorkbenchAction = ActionFactory.OPEN_NEW_WINDOW.create(window);
        this.register((IAction)this.newWorkbenchAction);
        this.viewsShortList = ContributionItemFactory.VIEWS_SHORTLIST.create(window);
        this.perspectiveResetAction = ActionFactory.RESET_PERSPECTIVE.create(window);
        this.register((IAction)this.perspectiveResetAction);
        this.preferencesAction = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.preferencesAction);
        this.helpAction = ActionFactory.HELP_CONTENTS.create(window);
        this.register((IAction)this.helpAction);
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.register((IAction)this.aboutAction);
        this.updateAction = new UpdateAction(window);
        this.register(this.updateAction);
        this.registerAsGlobal((IAction)ActionFactory.SAVE.create(window));
        this.registerAsGlobal((IAction)ActionFactory.SAVE_AS.create(window));
        this.registerAsGlobal((IAction)ActionFactory.ABOUT.create(window));
        this.registerAsGlobal((IAction)ActionFactory.SAVE_ALL.create(window));
        this.registerAsGlobal((IAction)ActionFactory.UNDO.create(window));
        this.registerAsGlobal((IAction)ActionFactory.REDO.create(window));
        this.registerAsGlobal((IAction)ActionFactory.CUT.create(window));
        this.registerAsGlobal((IAction)ActionFactory.COPY.create(window));
        this.registerAsGlobal((IAction)ActionFactory.PASTE.create(window));
        this.registerAsGlobal((IAction)ActionFactory.SELECT_ALL.create(window));
        this.registerAsGlobal((IAction)ActionFactory.FIND.create(window));
        this.registerAsGlobal((IAction)ActionFactory.CLOSE.create(window));
        this.registerAsGlobal((IAction)ActionFactory.CLOSE_ALL.create(window));
        this.registerAsGlobal((IAction)ActionFactory.CLOSE_ALL_SAVED.create(window));
        this.registerAsGlobal((IAction)ActionFactory.REVERT.create(window));
        this.registerAsGlobal((IAction)ActionFactory.QUIT.create(window));
    }

    public void fillMenuBar(IMenuManager menuBar) {
        this.createMenuFile();
        menuBar.add((IContributionItem)this.menuFile);
        this.createMenuEdit();
        menuBar.add((IContributionItem)this.menuEdit);
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        this.createMenuWindows();
        menuBar.add((IContributionItem)this.windowMenu);
        menuBar.add((IContributionItem)new GroupMarker("help"));
        this.createMenuHelp();
        menuBar.add((IContributionItem)this.helpMenu);
    }

    protected void fillCoolBar(ICoolBarManager cbManager) {
        cbManager.add((IContributionItem)new GroupMarker("group.file"));
        ToolBarManager fileToolBar = new ToolBarManager(cbManager.getStyle());
        fileToolBar.add((IContributionItem)new Separator("new.group"));
        fileToolBar.add((IContributionItem)new GroupMarker("open.ext"));
        fileToolBar.add((IContributionItem)new GroupMarker("save.group"));
        fileToolBar.add(this.getAction(ActionFactory.SAVE.getId()));
        fileToolBar.add((IContributionItem)new Separator("additions"));
        cbManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)fileToolBar, "org.eclipse.ui.workbench.file"));
        cbManager.add((IContributionItem)new GroupMarker("additions"));
        cbManager.add((IContributionItem)new GroupMarker("group.editor"));
    }

    private void registerAsGlobal(IAction action) {
        this.getActionBarConfigurer().registerGlobalAction(action);
        this.register(action);
    }

    private void createMenuFile() {
        this.menuFile = new MenuManager("&File", "file");
        this.menuFile.add((IAction)this.newAction);
        this.menuFile.add((IContributionItem)new GroupMarker("fileStart"));
        this.menuFile.add((IContributionItem)new GroupMarker("new.ext"));
        this.menuFile.add(this.getAction(ActionFactory.CLOSE.getId()));
        this.menuFile.add(this.getAction(ActionFactory.CLOSE_ALL.getId()));
        this.menuFile.add((IContributionItem)new GroupMarker("close.ext"));
        this.menuFile.add((IContributionItem)new Separator());
        this.menuFile.add(this.getAction(ActionFactory.SAVE.getId()));
        this.menuFile.add(this.getAction(ActionFactory.SAVE_AS.getId()));
        this.menuFile.add(this.getAction(ActionFactory.SAVE_ALL.getId()));
        this.menuFile.add(this.getAction(ActionFactory.REVERT.getId()));
        this.menuFile.add(ContributionItemFactory.REOPEN_EDITORS.create(this.getActionBarConfigurer().getWindowConfigurer().getWindow()));
        this.menuFile.add((IContributionItem)new GroupMarker("mru"));
        this.menuFile.add((IContributionItem)new Separator());
        this.menuFile.add(this.getAction(ActionFactory.QUIT.getId()));
        this.menuFile.add((IContributionItem)new GroupMarker("fileEnd"));
    }

    private void createMenuEdit() {
        this.menuEdit = new MenuManager("&Edit", "edit");
        this.menuEdit.add((IContributionItem)new GroupMarker("editStart"));
        this.menuEdit.add(this.getAction(ActionFactory.UNDO.getId()));
        this.menuEdit.add(this.getAction(ActionFactory.REDO.getId()));
        this.menuEdit.add((IContributionItem)new GroupMarker("undo.ext"));
        this.menuEdit.add(this.getAction(ActionFactory.CUT.getId()));
        this.menuEdit.add(this.getAction(ActionFactory.COPY.getId()));
        this.menuEdit.add(this.getAction(ActionFactory.PASTE.getId()));
        this.menuEdit.add((IContributionItem)new GroupMarker("cut.ext"));
        this.menuEdit.add(this.getAction(ActionFactory.SELECT_ALL.getId()));
        this.menuEdit.add((IContributionItem)new Separator());
        this.menuEdit.add(this.getAction(ActionFactory.FIND.getId()));
        this.menuEdit.add((IContributionItem)new GroupMarker("find.ext"));
        this.menuEdit.add((IContributionItem)new GroupMarker("add.ext"));
        this.menuEdit.add((IContributionItem)new GroupMarker("editEnd"));
        this.menuEdit.add((IContributionItem)new Separator("additions"));
    }

    private void createMenuWindows() {
        this.windowMenu = new MenuManager("&Windows", "window");
        this.windowMenu.add((IAction)this.newWorkbenchAction);
        this.windowMenu.add(this.viewsShortList);
        this.windowMenu.add((IAction)this.perspectiveResetAction);
        this.windowMenu.add((IAction)this.preferencesAction);
    }

    private void createMenuHelp() {
        this.helpMenu = new MenuManager("&Help", "help");
        this.menuEdit.add((IContributionItem)new Separator());
        this.helpMenu.add((IAction)this.helpAction);
        this.helpMenu.add((IAction)this.updateAction);
        this.menuEdit.add((IContributionItem)new Separator());
        this.helpMenu.add((IAction)this.aboutAction);
    }

    public void dispose() {
        super.dispose();
        this.aboutAction.dispose();
        this.exitAction.dispose();
        this.helpAction.dispose();
        this.newAction.dispose();
        this.newWorkbenchAction.dispose();
        this.perspectiveResetAction.dispose();
        this.preferencesAction.dispose();
    }
}

