/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.logging.FableLogger;
import fable.imageviewer.views.ImageView;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.part.ViewPart;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class ReliefView
extends ViewPart {
    public static final String ID = "fable.imageviewer.views.ReliefView";
    public static ReliefView thisView = null;
    public static GLContext context;
    public static GLU glu;
    private static SceneGrip grip;
    private static GLCanvas canvas;
    private Spinner minimumSpinner;
    private Spinner maximumSpinner;
    private Button freezeButton;
    private Button autoscaleButton;
    private static boolean freeze;
    private static boolean autoscale;
    private Button updateButton;
    private Button resetButton;
    private static float[] blue;
    private static float[] green;
    private static float[] red;
    private static int colorIndexMax;
    private float scaleMinimum;
    private float scaleMaximum;
    private static int pointSize;
    private static float scale;
    private static float[] image;
    private static int imageWidth;
    private static int imageHeight;
    private static float zcenter;
    private float[] imageAsFloat = null;
    private float minimum;
    private float maximum;
    private float mean;
    private String fileName;
    private float size;
    private static int canvasWidth;
    private static int canvasHeight;
    private static float zscale;
    private static boolean reliefListFirst;
    private static int reliefList;
    private static Logger logger;
    protected float aspect;
    static boolean firstImage;

    static {
        glu = new GLU();
        freeze = false;
        autoscale = true;
        blue = new float[]{1.0f, 0.333f, 0.666f, 0.999f, 0.833f, 0.666f, 0.5f, 0.333f, 0.166f, 0.0f, 0.0f};
        green = new float[]{1.0f, 0.0f, 0.111f, 0.222f, 0.333f, 0.666f, 0.999f, 0.666f, 0.333f, 0.0f, 0.0f};
        red = new float[]{1.0f, 0.0f, 0.055f, 0.11f, 0.165f, 0.22f, 0.275f, 0.333f, 0.666f, 0.999f, 1.0f};
        colorIndexMax = 10;
        pointSize = 4;
        scale = 1.0f;
        image = null;
        imageWidth = 0;
        imageHeight = 0;
        canvasWidth = 0;
        canvasHeight = 0;
        reliefListFirst = true;
        firstImage = true;
    }

    static void drawRelief() {
        canvas.setCurrent();
        try {
            GLContext.useContext((Object)canvas);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        GL11.glClear((int)16640);
        if (!freeze) {
            grip.adjust();
        }
        if (image != null) {
            GL11.glClear((int)16640);
            GL11.glDisable((int)2896);
            GL11.glCallList((int)reliefList);
            GL11.glEnable((int)2896);
        }
    }

    private static void drawReliefList() {
        int color_index;
        int j;
        long started = System.currentTimeMillis();
        if (!reliefListFirst) {
            GL11.glDeleteLists((int)reliefList, (int)1);
        }
        reliefListFirst = false;
        reliefList = GL11.glGenLists((int)1);
        GL11.glNewList((int)reliefList, (int)4864);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPointSize((float)pointSize);
        int i = 0;
        while (i < imageWidth) {
            GL11.glBegin((int)3);
            j = 0;
            while (j < imageHeight) {
                color_index = (int)image[j * imageWidth + i];
                if (color_index < 0) {
                    color_index = 0;
                }
                if (color_index > colorIndexMax) {
                    color_index = colorIndexMax;
                }
                GL11.glColor3f((float)red[color_index], (float)green[color_index], (float)blue[color_index]);
                GL11.glVertex3f((float)i, (float)j, (float)image[j * imageWidth + i]);
                ++j;
            }
            GL11.glEnd();
            ++i;
        }
        i = 0;
        while (i < imageHeight) {
            GL11.glBegin((int)3);
            j = 0;
            while (j < imageWidth) {
                color_index = (int)image[i * imageWidth + j];
                if (color_index < 0) {
                    color_index = 0;
                }
                if (color_index > colorIndexMax) {
                    color_index = colorIndexMax;
                }
                GL11.glColor3f((float)red[color_index], (float)green[color_index], (float)blue[color_index]);
                GL11.glVertex3f((float)j, (float)i, (float)image[i * imageWidth + j]);
                ++j;
            }
            GL11.glEnd();
            ++i;
        }
        GL11.glEndList();
        System.currentTimeMillis();
    }

    public void setImageAsFloat(float[] _imageAsFloat, int _width, int _height, float _minimum, float _maximum, float _mean, String _fileName) {
        this.imageAsFloat = _imageAsFloat;
        image = new float[_width * _height];
        imageWidth = _width;
        imageHeight = _height;
        this.minimum = _minimum;
        this.maximum = _maximum;
        this.mean = _mean;
        if (autoscale) {
            this.scaleMinimum = _minimum;
            this.scaleMaximum = _mean;
        }
        this.fileName = _fileName;
        this.size = (imageWidth + imageHeight) / 2;
        this.aspect = (float)imageWidth / (float)imageHeight;
        this.setPartName("Relief " + this.fileName);
        if (firstImage) {
            grip.init();
            firstImage = false;
        }
        this.scaleImage();
        ReliefView.drawReliefList();
        ReliefView.drawRelief();
    }

    public void scaleImage() {
        if (autoscale) {
            this.scaleMinimum = this.minimum;
            this.scaleMaximum = this.mean;
            this.minimumSpinner.setSelection((int)this.scaleMinimum);
            this.maximumSpinner.setSelection((int)this.scaleMaximum);
        } else {
            this.scaleMinimum = this.minimumSpinner.getSelection();
            this.scaleMaximum = this.maximumSpinner.getSelection();
        }
        if (this.scaleMinimum == this.scaleMaximum) {
            this.scaleMaximum = this.scaleMinimum + 1.0f;
        }
        zscale = 10.0f / (2.0f * (this.scaleMaximum - this.scaleMinimum));
        int i = 0;
        while (i < imageWidth) {
            int j = 0;
            while (j < imageHeight) {
                int imageIndex = j * imageWidth + i;
                float imageValue = this.imageAsFloat[j * imageWidth + i];
                ReliefView.image[imageIndex] = (imageValue - this.scaleMinimum) * zscale;
                ++j;
            }
            ++i;
        }
    }

    public void createPartControl(Composite parent) {
        logger = FableLogger.getLogger(ImageView.class);
        thisView = this;
        parent.setLayout((Layout)new GridLayout());
        Composite controlPanelComposite = new Composite(parent, 0);
        GridLayout controlGridLayout = new GridLayout();
        controlGridLayout.numColumns = 8;
        controlPanelComposite.setLayout((Layout)controlGridLayout);
        controlPanelComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.freezeButton = new Button(controlPanelComposite, 32);
        this.freezeButton.setText("Freeze");
        this.freezeButton.setToolTipText("freeze 3d relief, disable rotation");
        this.freezeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReliefView.this.freezeButton.getSelection()) {
                    freeze = true;
                } else {
                    freeze = false;
                }
            }
        });
        this.resetButton = new Button(controlPanelComposite, 0);
        this.resetButton.setText("Reset");
        this.resetButton.setToolTipText("reset 3d projection to be flat and fill the canvas");
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                grip.init();
            }
        });
        this.autoscaleButton = new Button(controlPanelComposite, 32);
        this.autoscaleButton.setText("Autoscale");
        this.autoscaleButton.setToolTipText("autoscale 3d relief between minimum and mean");
        this.autoscaleButton.setSelection(true);
        this.autoscaleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReliefView.this.autoscaleButton.getSelection()) {
                    if (!autoscale) {
                        autoscale = true;
                        ReliefView.this.scaleImage();
                        ReliefView.drawReliefList();
                    }
                    ReliefView.this.minimumSpinner.setEnabled(false);
                    ReliefView.this.maximumSpinner.setEnabled(false);
                } else {
                    if (autoscale) {
                        autoscale = false;
                        ReliefView.this.scaleImage();
                        ReliefView.drawReliefList();
                    }
                    ReliefView.this.minimumSpinner.setEnabled(true);
                    ReliefView.this.maximumSpinner.setEnabled(true);
                }
            }
        });
        Label minLabel = new Label(controlPanelComposite, 0);
        minLabel.setText("Minimum");
        this.minimumSpinner = new Spinner(controlPanelComposite, 0);
        this.minimumSpinner.setLayoutData((Object)new GridData(4, 0, true, false));
        this.minimumSpinner.setMinimum(0);
        this.minimumSpinner.setMaximum(Integer.MAX_VALUE);
        this.minimumSpinner.setEnabled(false);
        Label maxLabel = new Label(controlPanelComposite, 0);
        maxLabel.setText("Maximum");
        this.maximumSpinner = new Spinner(controlPanelComposite, 0);
        this.maximumSpinner.setLayoutData((Object)new GridData(4, 0, true, false));
        this.maximumSpinner.setMinimum(0);
        this.maximumSpinner.setMaximum(Integer.MAX_VALUE);
        this.maximumSpinner.setEnabled(false);
        this.updateButton = new Button(controlPanelComposite, 0);
        this.updateButton.setText("Update");
        this.updateButton.setToolTipText("redraw 3d relief plot");
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReliefView.this.scaleImage();
                ReliefView.drawReliefList();
                ReliefView.drawRelief();
            }
        });
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        comp.setLayout((Layout)new FillLayout());
        GLData data = new GLData();
        data.doubleBuffer = true;
        canvas = new GLCanvas(comp, 0, data);
        canvas.setSize(comp.getSize());
        canvas.setCurrent();
        try {
            GLContext.useContext((Object)canvas);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        canvas.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle bounds = canvas.getBounds();
                int cfr_ignored_0 = bounds.width;
                int cfr_ignored_1 = bounds.height;
                canvas.setCurrent();
                try {
                    GLContext.useContext((Object)canvas);
                }
                catch (LWJGLException e) {
                    e.printStackTrace();
                }
                GL11.glViewport((int)0, (int)0, (int)bounds.width, (int)bounds.height);
                GL11.glMatrixMode((int)5889);
                GL11.glLoadIdentity();
                new GLU();
                ReliefView.this.aspect = (float)imageWidth / (float)imageHeight;
                GL11.glMatrixMode((int)5888);
                GL11.glLoadIdentity();
                ReliefView.drawRelief();
                canvas.swapBuffers();
            }
        });
        canvas.setCurrent();
        try {
            GLContext.useContext((Object)canvas);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glHint((int)3152, (int)4354);
        GL11.glClearDepth((double)1.0);
        GL11.glLineWidth((float)2.0f);
        GL11.glEnable((int)2929);
        grip = new SceneGrip();
        canvas.addMouseListener((MouseListener)grip);
        canvas.addMouseMoveListener((MouseMoveListener)grip);
        canvas.addListener(37, (Listener)grip);
        canvas.addKeyListener((KeyListener)grip);
        Display.getCurrent().asyncExec(new Runnable(){
            int rot = 0;

            @Override
            public void run() {
                if (!canvas.isDisposed()) {
                    canvas.setCurrent();
                    Rectangle bounds = canvas.getBounds();
                    canvasWidth = bounds.width;
                    canvasHeight = bounds.height;
                    canvas.setCurrent();
                    try {
                        GLContext.useContext((Object)canvas);
                    }
                    catch (LWJGLException e) {
                        e.printStackTrace();
                    }
                    GL11.glClear((int)16640);
                    GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    ReliefView.drawRelief();
                    canvas.swapBuffers();
                    Display.getCurrent().timerExec(200, (Runnable)this);
                }
            }
        });
    }

    public void setFocus() {
    }

    public class SceneGrip
    extends MouseAdapter
    implements MouseMoveListener,
    Listener,
    KeyListener {
        private float xrot;
        private float yrot;
        private float zoff;
        private float xoff;
        private float yoff;
        private float xcpy;
        private float ycpy;
        private float xscale;
        private float yscale;
        private boolean move;
        private int xdown;
        private int ydown;
        private int mouseDown;

        public SceneGrip() {
            this.init();
        }

        protected void init() {
            canvas.setCurrent();
            Rectangle bounds = canvas.getBounds();
            canvasWidth = bounds.width;
            canvasHeight = bounds.height;
            this.yrot = 0.0f;
            this.xrot = 0.0f;
            this.yoff = 0.0f;
            this.xoff = 0.0f;
            if (imageWidth != 0) {
                this.xscale = canvasWidth / imageWidth;
            }
            if (imageHeight != 0) {
                this.yscale = canvasHeight / imageHeight;
            }
            this.zoff = 1.0f;
            this.zoff = this.xscale < this.yscale ? this.xscale : this.yscale;
        }

        public void mouseDown(MouseEvent e) {
            if (++this.mouseDown == 1) {
                this.move = e.button == 3;
                if (this.move) {
                    this.xcpy = this.xoff;
                    this.ycpy = this.yoff;
                    ((Control)e.widget).setCursor(e.widget.getDisplay().getSystemCursor(21));
                } else {
                    this.xcpy = this.xrot;
                    this.ycpy = this.yrot;
                    ((Control)e.widget).setCursor(e.widget.getDisplay().getSystemCursor(5));
                }
                this.xdown = e.x;
                this.ydown = e.y;
            }
        }

        public void mouseUp(MouseEvent e) {
            if (--this.mouseDown == 0) {
                ((Control)e.widget).setCursor(e.widget.getDisplay().getSystemCursor(0));
            }
        }

        public void mouseMove(MouseEvent e) {
            Point p = ((Control)e.widget).getSize();
            if (this.mouseDown > 0) {
                int dx = e.x - this.xdown;
                int dy = e.y - this.ydown;
                if (this.move) {
                    this.yoff = this.ycpy + (float)canvasHeight / 2.0f * (float)dy / (2.0f * (float)p.y);
                    this.xoff = this.xcpy + (float)canvasWidth / 2.0f * (float)dx / (2.0f * (float)p.x);
                } else {
                    this.xrot = this.xcpy + (float)dy / 2.0f;
                    this.yrot = this.ycpy + (float)dx / 2.0f;
                }
            }
        }

        public void handleEvent(Event event) {
            this.zoff *= 1.1f;
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 0x1000001: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.xrot -= 5.0f;
                        break;
                    }
                    this.yoff -= (float)canvasHeight / 10.0f;
                    break;
                }
                case 0x1000002: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.xrot += 5.0f;
                        break;
                    }
                    this.yoff += (float)canvasHeight / 10.0f;
                    break;
                }
                case 0x1000003: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.yrot -= 5.0f;
                        break;
                    }
                    this.xoff -= (float)canvasWidth / 10.0f;
                    break;
                }
                case 0x1000004: {
                    if ((e.stateMask & 0x40000) != 0) {
                        this.yrot += 5.0f;
                        break;
                    }
                    this.xoff += (float)canvasWidth / 10.0f;
                    break;
                }
                case 0x1000005: {
                    this.zoff *= 1.05f;
                    break;
                }
                case 0x1000006: {
                    this.zoff *= 0.95f;
                    break;
                }
                case 0x1000007: {
                    this.init();
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void adjust() {
            canvas.setCurrent();
            try {
                GLContext.useContext((Object)canvas);
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)canvasWidth, (double)canvasHeight, (double)0.0, (double)-100000.0, (double)100000.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)((float)(canvasWidth / 2) + this.xoff), (float)((float)(canvasHeight / 2) + this.yoff), (float)0.0f);
            GL11.glScalef((float)this.zoff, (float)this.zoff, (float)this.zoff);
            GL11.glRotatef((float)this.xrot, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.yrot, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)(-imageWidth / 2), (float)(-imageHeight / 2), (float)0.0f);
        }

        public void setOffsets(float x, float y, float z) {
            this.xoff = x;
            this.yoff = y;
            this.zoff = z;
        }

        public void setRotation(float x, float y) {
            this.xrot = x;
            this.yrot = y;
        }
    }
}

